/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib.config;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.taglib.config.AvailabilityCondition;
import com.ibm.ws.jsp.taglib.config.AvailabilityConditionType;
import com.ibm.ws.jsp.taglib.config.GlobalTagLibConfig;
import com.ibm.ws.jsp.taglib.config.ImplicitTagLibConfig;
import com.ibm.ws.jsp.taglib.config.TldPathConfig;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagLibCacheConfigParser
extends DefaultHandler {
    public static final String DTD_PUBLIC_ID = "http://www.ibm.com/xml/ns/TagLibCacheConfig.xsd";
    public static final String DTD_RESOURCE_PATH = "/com/ibm/ws/jsp/tablib/config/TagLibCacheConfig.xsd";
    protected SAXParser saxParser = null;
    protected StringBuffer chars = null;
    protected String uri = null;
    protected String prefix = null;
    protected String location = null;
    protected String jarName = null;
    protected String type = null;
    protected String webinfFileName = null;
    protected String servletClassName = null;
    protected List implicitTagLibList = new ArrayList();
    protected List globalTagLibList = new ArrayList();
    protected ImplicitTagLibConfig implicitTagLibConfig = null;
    protected GlobalTagLibConfig globalTagLibConfig = null;
    protected TldPathConfig tldPathConfig = null;
    protected AvailabilityCondition availabilityCondition = null;

    public TagLibCacheConfigParser() throws JspCoreException {
        try {
            this.saxParser = ParserFactory.newSAXParser(false, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JspCoreException(sAXException);
        }
    }

    public void parse(InputStream inputStream) throws JspCoreException {
        this.reset();
        try {
            ParserFactory.parseDocument(this.saxParser, inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getCause() != null) {
                throw new JspCoreException(sAXException.getCause());
            }
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            throw new JspCoreException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars = new StringBuffer();
        if (string3.equals("global-taglib")) {
            this.globalTagLibConfig = new GlobalTagLibConfig();
        } else if (string3.equals("tld-path")) {
            this.tldPathConfig = new TldPathConfig(attributes.getValue("path"), attributes.getValue("uri"), attributes.getValue("contains-listener-defs"));
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        for (int i = 0; i < n2; ++i) {
            if (this.chars == null) continue;
            this.chars.append(cArray[n + i]);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("uri")) {
            this.uri = this.chars.toString().trim();
        } else if (string3.equals("prefix")) {
            this.prefix = this.chars.toString().trim();
        } else if (string3.equals("location")) {
            this.location = this.chars.toString().trim();
        } else if (string3.equals("jar-name")) {
            this.jarName = this.chars.toString().trim();
        } else if (string3.equals("type")) {
            this.type = this.chars.toString().trim();
        } else if (string3.equals("webinf-filename")) {
            this.webinfFileName = this.chars.toString().trim();
        } else if (string3.equals("servlet-classname")) {
            this.servletClassName = this.chars.toString().trim();
        } else if (string3.equals("implict-taglib")) {
            this.implicitTagLibConfig = new ImplicitTagLibConfig(this.uri, this.prefix, this.location);
            this.implicitTagLibList.add(this.implicitTagLibConfig);
            this.implicitTagLibConfig = null;
        } else if (string3.equals("global-taglib")) {
            this.globalTagLibConfig.setJarName(this.jarName);
            this.globalTagLibList.add(this.globalTagLibConfig);
            this.globalTagLibConfig = null;
        } else if (string3.equals("tld-path")) {
            this.globalTagLibConfig.getTldPathList().add(this.tldPathConfig);
            this.tldPathConfig = null;
        } else if (string3.equals("availability-condition")) {
            AvailabilityConditionType availabilityConditionType = null;
            String string4 = null;
            if (this.type.equalsIgnoreCase("WEBINF-FILE")) {
                availabilityConditionType = AvailabilityConditionType.webinfFileType;
                string4 = this.webinfFileName;
            } else if (this.type.equalsIgnoreCase("SERVLET-CLASSNAME")) {
                availabilityConditionType = AvailabilityConditionType.servletClassNameType;
                string4 = this.servletClassName;
            }
            this.availabilityCondition = new AvailabilityCondition(availabilityConditionType, string4);
            this.tldPathConfig.getAvailabilityConditionList().add(this.availabilityCondition);
            this.availabilityCondition = null;
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        String string3 = null;
        if (string.equals(DTD_PUBLIC_ID)) {
            string3 = DTD_RESOURCE_PATH;
        }
        if (string3 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (inputStream == null) {
                throw new SAXException("jsp.error.internal.dtd.not.found");
            }
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }

    public List getGlobalTagLibList() {
        return this.globalTagLibList;
    }

    public List getImplicitTagLibList() {
        return this.implicitTagLibList;
    }

    private void reset() {
        this.uri = null;
        this.prefix = null;
        this.location = null;
        this.jarName = null;
        this.type = null;
        this.webinfFileName = null;
        this.servletClassName = null;
        this.implicitTagLibList = new ArrayList();
        this.globalTagLibList = new ArrayList();
        this.implicitTagLibConfig = null;
        this.globalTagLibConfig = null;
        this.tldPathConfig = null;
        this.availabilityCondition = null;
    }
}

