/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.translator.compiler.JDTCompilerFactory;
import com.ibm.ws.jsp.translator.compiler.JspCompilerFactoryImpl;
import com.ibm.ws.jsp.translator.resource.JspResourcesFactoryImpl;
import com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils;
import com.ibm.wsspi.jsp.compiler.JspCompilerFactory;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationEnvironment;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import com.ibm.wsspi.jsp.resource.translation.JspResourcesFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileBasedJspContext
implements JspTranslationContext {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.FileBasedJspContext";
    private String docRoot = "";
    private boolean searchClasspathForResources = false;
    private ExtendedDocumentRootUtils edru;
    private URL contextURL = null;
    private JspResourcesFactory jspResourcesFactory = null;
    private JspInputSourceFactory jspInputSourceFactory = null;
    private JspClassloaderContext jspClassloaderContext = null;
    private JspCompilerFactory jspCompilerFactory = null;

    public FileBasedJspContext(String string, JspOptions jspOptions, String string2, ClassLoader classLoader, JspClassloaderContext jspClassloaderContext, boolean bl) {
        this.docRoot = string;
        this.searchClasspathForResources = bl;
        if (string2 != null) {
            File file = new File(string);
            file = file.getParentFile();
            this.edru = new ExtendedDocumentRootUtils(file.toString(), string2);
        }
        try {
            this.contextURL = new URL("file", null, this.getRealPath("/"));
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.WARNING, CLASS_NAME, "FileBasedJspContext", "Failed to create context URL for docRoot: " + string, malformedURLException);
        }
        this.jspResourcesFactory = new JspResourcesFactoryImpl(jspOptions, this);
        this.jspInputSourceFactory = new JspInputSourceFactoryImpl(this.contextURL, this.edru, this.searchClasspathForResources, classLoader);
        this.jspClassloaderContext = jspClassloaderContext;
        this.jspCompilerFactory = jspOptions.isUseJDKCompiler() ? new JspCompilerFactoryImpl(this.getRealPath("/"), jspClassloaderContext, jspOptions) : new JDTCompilerFactory(jspClassloaderContext.getClassLoader(), jspOptions);
    }

    public String getRealPath(String string) {
        return this.getRealPath(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRealPath(String string, boolean bl) {
        String string2 = "";
        string2 = string.startsWith("/") ? this.docRoot + string : this.docRoot + "/" + string;
        if (bl && !new File(string2).exists() && this.edru != null && this.edru.searchPathExists()) {
            try {
                ExtendedDocumentRootUtils extendedDocumentRootUtils = this.edru;
                synchronized (extendedDocumentRootUtils) {
                    this.edru.handleExtendedDocumentRoots(string);
                    File file = this.edru.getMatchedFile();
                    if (file != null) {
                        string2 = file.toString();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public Set getResourcePaths(String string) {
        File[] fileArray;
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(this.docRoot + string);
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getPath();
                string2 = string2.substring(this.docRoot.length());
                string2 = string2.replace('\\', '/');
                if (fileArray[i].isDirectory() && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public JspResourcesFactory getJspResourcesFactory() {
        return this.jspResourcesFactory;
    }

    public JspInputSourceFactory getJspInputSourceFactory() {
        return this.jspInputSourceFactory;
    }

    public JspClassloaderContext getJspClassloaderContext() {
        return this.jspClassloaderContext;
    }

    public JspCompilerFactory getJspCompilerFactory() {
        return this.jspCompilerFactory;
    }

    public void setJspTranslationEnviroment(JspTranslationEnvironment jspTranslationEnvironment) {
    }
}

