/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.ws.classloader.Handler;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.tools.JspBatchCBase;
import com.ibm.ws.jsp.tools.JspFileUtils;
import com.ibm.ws.jsp.utils.TagLibraryCacheInformation;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ComponentManagerFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

public class JspBatchCompiler
extends JspBatchCBase {
    private boolean compileToWebInf = true;
    private Map variables = new HashMap();
    private ServerEntry serverEntry = null;
    private String configRoot = null;
    private String configRootHidden = null;
    private String cell = null;
    private String cellHidden = null;
    private String node = null;
    private String nodeHidden = null;
    private String process = null;
    private String enterpriseApp = null;
    private String wasInstallRoot = null;
    private String appInstallRoot = null;
    private String userInstallRoot = null;
    private String wasTempDirectory = null;
    private String logLevel = null;
    private CommonarchiveFactory impl = null;
    protected ApplicationServer applicationServer = null;
    private Server serverProcess = null;
    private ApplicationDeployment appDeployment = null;
    private String earPath = null;
    private String warPath = null;
    private String extractToDirectoryBase = null;
    private String extractToDirectoryComplete = null;
    private File extractToDir = null;
    private String compileToDirectory = null;
    private String responseFile = null;
    private boolean compileInPlace = false;
    private String configURL = null;
    private String binariesURL = null;
    static final int EARFILE_TYPE = 1;
    static final int WARFILE_TYPE = 2;
    private static final String VARIABLE_CONFIG = "variables.xml";
    private static final String SERVERINDEX = "serverindex.xml";
    private String looseAppURL = null;
    protected static final String LOOSE_CONFIG_PROPERTY_NAME = "was.loose.config";

    public JspBatchCompiler(String[] stringArray) {
        this.cmdArgs = stringArray;
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        try {
            ServiceReference[] serviceReferenceArray = bundleContext.getServiceReferences(URLStreamHandlerService.class.getName(), "(url.handler.protocol=wsjar)");
            if (serviceReferenceArray == null) {
                Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
                hashtable.put("url.handler.protocol", new String[]{"wsjar"});
                bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new Handler(), hashtable);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            invalidSyntaxException.printStackTrace();
        }
    }

    public boolean startup() {
        if (!this.parseCmdLine(this.cmdArgs)) {
            this.usage();
            return false;
        }
        if (this.initialize() > 0) {
            return false;
        }
        if (this.earPath != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, "JspBatchCompiler", "startup", "about to run JspBatchCompiler for " + this.earPath);
            }
            if (this.runEarCompiler() > 0) {
                this.returnCode = 1;
            }
        } else if (this.warPath != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, "JspBatchCompiler", "startup", "about to run JspBatchCompiler for " + this.warPath);
            }
            if (this.runWarCompiler() > 0) {
                this.returnCode = 1;
            }
        } else if (this.enterpriseApp != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, "JspBatchCompiler", "startup", "about to run JspBatchCompiler for " + this.enterpriseApp);
            }
            try {
                if (this.runBatchCompiler() > 0) {
                    this.returnCode = 1;
                }
            }
            catch (ComponentDisabledException componentDisabledException) {
                componentDisabledException.printStackTrace();
                this.returnCode = 1;
            }
        }
        if (this.returnCode == 0) {
            logger.logp(Level.CONFIG, "JspBatchCompiler", "startup", "jsp.batchcompiler.successfully.exiting");
        } else {
            logger.logp(Level.CONFIG, "JspBatchCompiler", "startup", "jsp.batchcompiler.exiting.with.errors");
        }
        return this.returnCode == 0;
    }

    protected int initialize() {
        int n;
        if (super.initialize() > 0) {
            this.returnCode = 1;
            return this.returnCode;
        }
        if (this.warPath != null || this.earPath != null) {
            this.impl = CommonarchiveFactoryImpl.getActiveFactory();
            if (this.extractToDirectoryBase == null) {
                this.compileInPlace = true;
                this.extractToDirectoryBase = System.getProperty("java.io.tmpdir");
            }
        } else if (this.enterpriseApp != null && (n = this.enterpriseApp.lastIndexOf(".ear/")) > 1) {
            this.enterpriseApp = this.enterpriseApp.substring(0, n);
        }
        return this.returnCode;
    }

    private int runBatchCompiler() throws ComponentDisabledException {
        boolean bl = false;
        logger.logp(Level.CONFIG, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.initializing.server");
        BeanContextServiceProvider beanContextServiceProvider = (BeanContextServiceProvider)RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)this.cell, (String)this.node, (String)this.process);
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "repository: " + beanContextServiceProvider);
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "BeanContextServices: " + beanContextServicesSupport);
        beanContextServicesSupport.addService(Repository.class, beanContextServiceProvider);
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added repository service ");
        com.ibm.ws.runtime.service.VariableMap variableMap = VariableMapFactory.createVariableMap();
        beanContextServicesSupport.add(variableMap);
        try {
            variableMap.initialize((Object)beanContextServicesSupport);
        }
        catch (ComponentDisabledException componentDisabledException) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.initializing.batchcompiler.service", componentDisabledException);
            bl = true;
        }
        catch (ConfigurationWarning configurationWarning) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.initializing.batchcompiler.service", configurationWarning);
        }
        catch (ConfigurationError configurationError) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.initializing.batchcompiler.service", configurationError);
            bl = true;
        }
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added variableMap service ");
        this.readConfig((Repository)beanContextServiceProvider);
        this.getApplicationServer((Repository)beanContextServiceProvider);
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "read config " + this.serverProcess);
        if (!bl && this.serverProcess != null) {
            ComponentManager componentManager = null;
            try {
                componentManager = ComponentManagerFactory.createComponentManager((String)"META-INF/ws-server-components.xml", (ClassLoader)Thread.currentThread().getContextClassLoader());
                beanContextServicesSupport.addService(ComponentManager.class, (BeanContextServiceProvider)componentManager);
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added componentmanager " + componentManager);
            }
            catch (ConfigurationError configurationError) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.adding.componentmanager.service", configurationError);
                bl = true;
            }
            if (componentManager != null) {
                beanContextServicesSupport.add(this.serverProcess);
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added o " + this.serverProcess);
                beanContextServicesSupport.add(this);
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added batchC component ");
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "about to initialize batchC component ");
                this.initialize();
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "about to run JspBatchCompiler ");
                if (this.batchCompile() > 0) {
                    bl = true;
                }
            }
        } else {
            bl = true;
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.unable.to.initialize.server");
        }
        if (bl) {
            this.returnCode = 1;
        }
        return this.returnCode;
    }

    private int runEarCompiler() {
        if (this.returnCode == 1) {
            return this.returnCode;
        }
        if (this.extractArchiveFile(this.earPath, (ModuleFile)this.earFile, 1) > 0) {
            this.returnCode = 1;
            return this.returnCode;
        }
        try {
            this.earFile = this.impl.openEARFile(this.extractToDirectoryComplete);
        }
        catch (OpenFailureException openFailureException) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runEarCompiler", "jsp.batchcompiler.exception.caught.opening.earfile", openFailureException);
            this.returnCode = 1;
            return this.returnCode;
        }
        try {
            this.warFileList = this.earFile.getWARFiles();
            if (this.warFileList != null && this.warFileList.size() <= 0 && logger.isLoggable(Level.CONFIG)) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "runEarCompiler", "No web modules found for EAR File " + this.earFile.getName());
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runEarCompiler", "jsp.batchcompiler.exception.caught.getting.warfile.list", throwable);
            this.returnCode = 1;
            return this.returnCode;
        }
        this.getClassLoaderManager(null, null);
        this.warFileCount = 0;
        if (!this.compileAllWebModules) {
            this.warFileCount = 1;
        } else if (this.warFileList != null) {
            this.warFileCount = this.warFileList.size();
        }
        boolean bl = false;
        for (int i = 0; i < this.warFileCount; ++i) {
            bl = !this.compileAllWebModules ? this.getWarFile() : this.getWarFile(i);
            if (!bl) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "runEarCompiler", "jsp.batchcompiler.webmodule.not.found", this.webModuleName);
                this.returnCode = 1;
                continue;
            }
            if (!this.getClassLoader()) {
                this.returnCode = 1;
                continue;
            }
            this.webModuleURL = this.extractToDirectoryComplete + File.separator + this.webModuleName;
            int n = this.getConfigOptions();
            if (n > 0) {
                this.returnCode = n;
                continue;
            }
            this.tempDirectory = this.compileToDirectory != null ? this.compileToDirectory : this.webModuleURL + File.separator + "WEB-INF" + File.separator + "classes";
            this.displayVariables();
            n = this.compile(null);
            if (n <= 0) continue;
            this.returnCode = n;
        }
        if (this.earFile != null && this.earFile.isOpen()) {
            this.earFile.close();
        }
        if (this.returnCode == 0) {
            File file = new File(this.earPath);
            if (this.compileToDirectory == null && (file.isFile() || file.isDirectory() && !this.compileInPlace) && this.zipArchiveFile((ModuleFile)this.earFile, 1) > 0) {
                this.returnCode = 1;
            }
        }
        return this.returnCode;
    }

    private int runWarCompiler() {
        if (this.returnCode == 1) {
            return this.returnCode;
        }
        if (this.extractArchiveFile(this.warPath, (ModuleFile)this.warFile, 2) > 0) {
            this.returnCode = 1;
            return this.returnCode;
        }
        try {
            this.warFile = this.impl.openWARFile(this.extractToDirectoryComplete);
        }
        catch (OpenFailureException openFailureException) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runWarCompiler", "jsp.batchcompiler.exception.caught.opening.warfile", openFailureException);
            this.returnCode = 1;
            return this.returnCode;
        }
        this.webModuleURL = this.extractToDirectoryComplete;
        int n = this.getConfigOptions();
        if (n > 0) {
            this.returnCode = n;
        } else {
            this.tempDirectory = this.compileToDirectory != null ? this.compileToDirectory : this.webModuleURL + File.separator + "WEB-INF" + File.separator + "classes";
            this.displayVariables();
            n = this.compile(null);
            if (n > 0) {
                this.returnCode = n;
            }
            if (this.warFile != null && this.warFile.isOpen()) {
                this.warFile.close();
            }
            if (this.returnCode == 0) {
                File file = new File(this.warPath);
                if (this.compileToDirectory == null && (file.isFile() || file.isDirectory() && !this.compileInPlace) && this.zipArchiveFile((ModuleFile)this.warFile, 2) > 0) {
                    this.returnCode = 1;
                }
            }
        }
        return this.returnCode;
    }

    protected int extractArchiveFile(String string, ModuleFile object, int n) {
        boolean bl = false;
        Throwable throwable = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                if (n == 1) {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.ear.path.does.not.exist", string);
                } else {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.war.path.does.not.exist", string);
                }
                this.returnCode = 1;
                return this.returnCode;
            }
            object = n == 1 ? this.impl.openEARFile(string) : this.impl.openWARFile(string);
            File file2 = new File(this.extractToDirectoryBase);
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath()) || file.getCanonicalPath().startsWith(file2.getCanonicalPath())) {
                if (n == 1) {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.must.not.overlap.with.ear.path");
                } else {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.must.not.overlap.with.war.path");
                }
                this.returnCode = 1;
                return this.returnCode;
            }
            if (file.isDirectory() && this.compileInPlace) {
                this.extractToDirectoryBase = string;
                this.extractToDirectoryComplete = string;
            } else {
                this.extractToDirectoryComplete = !this.extractToDirectoryBase.endsWith(File.separator) ? this.extractToDirectoryBase + this.fileSep + object.getName() : this.extractToDirectoryBase + object.getName();
            }
            this.extractToDir = new File(this.extractToDirectoryBase);
            if (!this.extractToDir.exists()) {
                this.returnCode = 1;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.does.not.exist", this.extractToDir);
                return this.returnCode;
            }
            if (!this.extractToDir.canWrite()) {
                this.returnCode = 1;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.not.writable", this.extractToDir);
                return this.returnCode;
            }
            if (!this.extractToDir.isDirectory()) {
                this.returnCode = 1;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.not.a.directory", this.extractToDir);
                return this.returnCode;
            }
            this.extractToDir = new File(this.extractToDirectoryComplete);
            if (file.isFile() || file.isDirectory() && !this.compileInPlace) {
                if (this.extractToDir.exists()) {
                    logger.logp(Level.CONFIG, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.removing.file", this.extractToDir);
                    if (this.extractToDir.isFile()) {
                        this.extractToDir.delete();
                    } else if (this.extractToDir.isDirectory()) {
                        JspFileUtils.deleteDirs(this.extractToDir, logger);
                    }
                }
                logger.logp(Level.CONFIG, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracting", new Object[]{object.getName(), this.extractToDirectoryComplete});
                object.extractTo(this.extractToDirectoryComplete, 2);
                logger.logp(Level.CONFIG, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.done.extracting");
            }
            object.close();
        }
        catch (OpenFailureException openFailureException) {
            bl = true;
            throwable = openFailureException;
        }
        catch (SaveFailureException saveFailureException) {
            bl = true;
            throwable = saveFailureException;
        }
        catch (IOException iOException) {
            bl = true;
            throwable = iOException;
        }
        if (bl) {
            this.returnCode = 1;
            if (n == 1) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.exception.caught.extracting.earfile", string);
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "exception:", throwable);
            } else {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.exception.caught.extracting.warfile", string);
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "exception: ", throwable);
            }
        }
        return this.returnCode;
    }

    protected int zipArchiveFile(ModuleFile object, int n) {
        boolean bl = false;
        Throwable throwable = null;
        try {
            object = n == 1 ? this.impl.openEARFile(this.extractToDirectoryComplete) : this.impl.openWARFile(this.extractToDirectoryComplete);
            logger.logp(Level.CONFIG, "JspBatchCompiler", "zipArchiveFile", "jsp.batchcompiler.saving.zipfile", object.getAbsolutePath());
            object.save();
            object.close();
            logger.logp(Level.CONFIG, "JspBatchCompiler", "zipArchiveFile", "jsp.batchcompiler.done.saving");
        }
        catch (OpenFailureException openFailureException) {
            bl = true;
            throwable = openFailureException;
        }
        catch (ReopenException reopenException) {
            bl = true;
            throwable = reopenException;
        }
        catch (SaveFailureException saveFailureException) {
            bl = true;
            throwable = saveFailureException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
            throwable = fileNotFoundException;
        }
        if (bl) {
            this.returnCode = 1;
            logger.logp(Level.SEVERE, "JspBatchCompiler", "zipArchiveFile", "jsp.batchcompiler.exception.while.saving", throwable);
        }
        return this.returnCode;
    }

    private int batchCompile() {
        Repository repository = (Repository)this.getService(Repository.class);
        if (repository == null) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.repository.not.available");
            this.returnCode = 1;
            return this.returnCode;
        }
        logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.reading.configfile");
        if (!this.addVarMaps(repository)) {
            this.returnCode = 1;
            return this.returnCode;
        }
        if (!this.findServer(repository)) {
            this.returnCode = 1;
            return this.returnCode;
        }
        if (this.findEnterpriseApp(repository)) {
            try {
                this.earFile = (EARFile)this.getEarFile(this.binariesURL, this.looseAppURL);
                this.warFileList = this.earFile.getWARFiles();
                if (this.warFileList != null && this.warFileList.size() <= 0 && logger.isLoggable(Level.CONFIG)) {
                    logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "No web modules found for Enterprise Application " + this.enterpriseApp);
                }
            }
            catch (Throwable throwable) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.enterpriseapp.not.found", this.enterpriseApp);
                this.returnCode = 1;
            }
        } else {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.enterpriseapp.not.found", this.enterpriseApp);
            this.returnCode = 1;
        }
        if (this.returnCode == 1) {
            return this.returnCode;
        }
        logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to call getClassLoaderManager  this.appDeployment: [" + this.appDeployment + "]");
        this.getClassLoaderManager(this.appDeployment, this.applicationServer);
        this.warFileCount = 0;
        if (!this.compileAllWebModules) {
            this.warFileCount = 1;
        } else if (this.warFileList != null) {
            this.warFileCount = this.warFileList.size();
        }
        logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.finished.reading.configfile");
        this.tagLibConfigArray = TagLibraryCacheInformation.loadTagLibraryCacheInfo();
        boolean bl = false;
        Map map = this.getLibraryPaths(this.appDeployment);
        ArrayList arrayList = this.getServerLibraryPaths(this.applicationServer);
        for (int i = 0; i < this.warFileCount; ++i) {
            int n;
            String[] stringArray;
            bl = !this.compileAllWebModules ? this.getWarFile() : this.getWarFile(i);
            if (!bl) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.webmodule.not.found", this.webModuleName);
                this.returnCode = 1;
                continue;
            }
            if (!this.getClassLoader()) {
                this.returnCode = 1;
                continue;
            }
            ModuleFile moduleFile = (ModuleFile)this.warFileList.get(this.warfileListIndex);
            try {
                this.webModuleURL = moduleFile.getAbsolutePath();
                this.webModuleConfigURL = moduleFile.getBinariesPath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            this.tempDirectory = this.wasTempDirectory;
            this.tempDirectory = this.tempDirectory + File.separator + this.node + File.separator + this.process.replace(' ', '_') + File.separator + this.enterpriseApp.replace(' ', '_') + File.separator + this.webModuleName.replace(' ', '_');
            int n2 = this.getConfigOptions();
            if (n2 > 0) {
                this.returnCode = n2;
                continue;
            }
            if (this.compileToWebInf) {
                this.tempDirectory = this.webModuleURL + File.separator + "WEB-INF" + File.separator + "classes";
            } else if (this.compileToDirectory != null) {
                this.tempDirectory = this.compileToDirectory;
            }
            this.displayVariables();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Iterator iterator = arrayList.iterator();
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to process serverLibraryPaths: [" + arrayList + "] serverLibraryPaths.size() [" + arrayList.size() + "]");
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "serverLib [" + stringArray + "] serverLib.length [" + stringArray.length + "]");
                for (n = 0; n < stringArray.length; ++n) {
                    logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "serverLib[j] [" + stringArray[n] + "]");
                    if (!stringArray[n].endsWith(".jar")) continue;
                    arrayList2.add(stringArray[n]);
                    logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "added serverLib[j]");
                }
            }
            stringArray = (String[])map.get(this.warFile.getURI());
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to process sharedLibraries: [" + stringArray + "] sharedLibraries.length [" + stringArray.length + "]");
            for (n = 0; n < stringArray.length; ++n) {
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "sharedLibraries[j] [" + stringArray[n] + "]");
                if (!stringArray[n].endsWith(".jar")) continue;
                arrayList2.add(stringArray[n]);
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "added sharedLibraries[j]");
            }
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "l.size: [" + arrayList2.size() + "]");
            String[] stringArray2 = new String[arrayList2.size()];
            stringArray2 = arrayList2.toArray(stringArray2);
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "sharedLibraryJars.length: [" + stringArray2.length + "]");
            n2 = this.compile(stringArray2);
            if (n2 <= 0) continue;
            this.returnCode = n2;
        }
        this.releaseService(repository);
        return this.returnCode;
    }

    protected void getApplicationServer(Repository repository) throws ComponentDisabledException {
        this.applicationServer = null;
        ConfigRoot configRoot = repository.getConfigRoot();
        WASResourceImpl wASResourceImpl = null;
        try {
            wASResourceImpl = (WASResourceImpl)configRoot.getResource(4, "server.xml");
        }
        catch (Exception exception) {
            throw new ComponentDisabledException();
        }
        EList eList = wASResourceImpl.getContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Server)) continue;
            EList eList2 = ((Server)e).getComponents();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                e = iterator2.next();
                if (!(e instanceof ApplicationServer)) continue;
                logger.logp(Level.FINE, "JspBatchCompiler", "getApplicationServer", "found ApplicationServer: [" + (ApplicationServer)e + "]");
                this.applicationServer = (ApplicationServer)e;
            }
        }
    }

    protected void readConfig(Repository repository) {
        try {
            Resource resource = repository.getConfigRoot().getResource(4, "server.xml");
            EList eList = resource.getContents();
            this.serverProcess = null;
            for (int i = 0; this.serverProcess == null && i < eList.size(); ++i) {
                Object e = eList.get(i);
                if (!(e instanceof Server)) continue;
                this.serverProcess = (Server)e;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "readConfig", "serverProcess: [" + this.serverProcess + "]");
            }
            if (this.serverProcess == null) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "readConfig", "jsp.batchcompiler.rootdomain.not.found");
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "readConfig", "jsp.batchcompiler.error.reading.configuration", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
        }
    }

    protected boolean addVarMaps(Repository repository) {
        ConfigRoot configRoot = repository.getConfigRoot();
        try {
            this.addVariableMap(configRoot.getResource(0, VARIABLE_CONFIG));
            this.addVariableMap(configRoot.getResource(3, VARIABLE_CONFIG));
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, "JspBatchCompiler", "addVarMaps", "jsp.batchcompiler.error.adding.variable.map", new Object[]{exception.getMessage()});
        }
        if (this.wasInstallRoot == null || this.appInstallRoot == null || this.userInstallRoot == null || this.wasTempDirectory == null) {
            return false;
        }
        this.wasInstallRoot = this.expandVariable(this.wasInstallRoot);
        this.appInstallRoot = this.expandVariable(this.appInstallRoot);
        this.userInstallRoot = this.expandVariable(this.userInstallRoot);
        this.wasTempDirectory = this.expandVariable(this.wasTempDirectory);
        return true;
    }

    protected void addVariableMap(Resource resource) {
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            VariableMap variableMap = (VariableMap)eList.get(i);
            EList eList2 = variableMap.getEntries();
            for (int j = 0; j < eList2.size(); ++j) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)eList2.get(j);
                this.variables.put(variableSubstitutionEntry.getSymbolicName(), variableSubstitutionEntry.getValue());
                if (variableSubstitutionEntry.getSymbolicName().equals("WAS_INSTALL_ROOT")) {
                    this.wasInstallRoot = variableSubstitutionEntry.getValue();
                }
                if (variableSubstitutionEntry.getSymbolicName().equals("APP_INSTALL_ROOT")) {
                    this.appInstallRoot = variableSubstitutionEntry.getValue();
                }
                if (variableSubstitutionEntry.getSymbolicName().equals("USER_INSTALL_ROOT")) {
                    this.userInstallRoot = variableSubstitutionEntry.getValue();
                }
                if (!variableSubstitutionEntry.getSymbolicName().equals("WAS_TEMP_DIR")) continue;
                this.wasTempDirectory = variableSubstitutionEntry.getValue();
            }
        }
    }

    protected boolean findServer(Repository repository) {
        boolean bl = false;
        try {
            Resource resource;
            try {
                resource = repository.getConfigRoot().getResource(3, SERVERINDEX);
            }
            catch (Exception exception) {
                throw new ConfigurationError("Error loading serverindex.xml", (Throwable)exception);
            }
            EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                this.serverEntry = (ServerEntry)eList.get(i);
                if (!this.serverEntry.getServerName().equals(this.process)) continue;
                bl = true;
                break;
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "findServer", "jsp.batchcompiler.error.while.finding.server", throwable);
            return false;
        }
        return bl;
    }

    protected boolean findEnterpriseApp(Repository repository) {
        boolean bl = false;
        try {
            ConfigRoot configRoot = repository.getConfigRoot();
            EList eList = this.serverEntry.getDeployedApplications();
            Resource resource = null;
            for (int i = 0; i < eList.size(); ++i) {
                configRoot.setValue(1, (String)eList.get(i));
                resource = configRoot.getResource(1, "deployment.xml");
                String string = (String)eList.get(i);
                if (string == null) continue;
                int n = string.lastIndexOf(".ear/");
                if (n > 1) {
                    string = string.substring(0, n);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "findEnterpriseApp", "Found Enterprise Application [" + string + "]");
                }
                if (!string.equals(this.enterpriseApp)) continue;
                Deployment deployment = (Deployment)resource.getContents().get(0);
                DeployedObject deployedObject = deployment.getDeployedObject();
                if (deployedObject instanceof ApplicationDeployment) {
                    this.appDeployment = (ApplicationDeployment)deployedObject;
                }
                if (this.appDeployment == null) continue;
                this.binariesURL = this.appDeployment.getBinariesURL();
                this.binariesURL = this.expandVariable(this.binariesURL);
                this.looseAppURL = this.getLooseAppURL(this.appDeployment);
                if (this.looseAppURL != null) {
                    this.looseAppURL = this.expandVariable(this.looseAppURL);
                }
                this.metadataFromBinaries = this.appDeployment.isUseMetadataFromBinaries();
                this.configURL = configRoot.getAbsolutePath(1, "");
                this.configURL = this.expandVariable(this.configURL);
                bl = true;
                break;
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "findEnterpriseApp", "jsp.batchcompiler.error.while.finding.enterpriseapp", throwable);
            return false;
        }
        return bl;
    }

    protected String getLooseAppURL(ApplicationDeployment applicationDeployment) {
        EList eList = applicationDeployment.getProperties();
        Iterator iterator = eList.iterator();
        String string = null;
        while (string == null && iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string2 = property.getName();
            if (string2 == null || !string2.equals(LOOSE_CONFIG_PROPERTY_NAME)) continue;
            string = property.getValue();
        }
        return string;
    }

    protected ModuleFile getEarFile(String string, String string2) throws Throwable {
        if (string2 != null) {
            LooseConfigRegister.singleton().addLooseMapping(string, string2);
        }
        CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setIsReadOnly(true);
        archiveOptions.setUseJavaReflection(false);
        this.earFile = commonarchiveFactory.openEARFile(archiveOptions, string);
        this.earFile.getDeploymentDescriptor();
        this.earFile.getBindings();
        this.earFile.getExtensions();
        return this.earFile;
    }

    protected int getConfigOptions() {
        int n = super.getConfigOptions();
        if (n > 0) {
            this.returnCode = n;
            return this.returnCode;
        }
        if (this.options.getOutputDir() != null) {
            if (this.warPath != null || this.earPath != null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "getConfigOptions", "jsp.batchcompiler.ignoring.scratchdir", this.options.getOutputDir().toString());
            } else {
                this.tempDirectory = this.options.getOutputDir().toString();
                this.tempDirectory = this.tempDirectory + File.separator + this.node + File.separator + this.process.replace(' ', '_') + File.separator + this.enterpriseApp.replace(' ', '_') + File.separator + this.webModuleName.replace(' ', '_');
            }
        }
        if (this.removeTempDir) {
            this.tempDirToRemove = this.tempDirectory;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        JspBatchCompiler jspBatchCompiler = new JspBatchCompiler(stringArray);
        if (jspBatchCompiler.startup()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private boolean parseCmdLine(String[] stringArray) {
        Object object;
        String string = null;
        try {
            String string2;
            object = new Properties();
            String string3 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                string2 = stringArray[i].toLowerCase();
                if (string2.equalsIgnoreCase("-jspcompileclasspath") && ((n = i) + 1 >= stringArray.length || n + 1 < stringArray.length && stringArray[n + 1].startsWith("-"))) {
                    string3 = new String("");
                    ((Properties)object).setProperty(string2, string3);
                    continue;
                }
                if (++i >= stringArray.length) continue;
                string3 = stringArray[i];
                ((Properties)object).setProperty(string2, string3);
            }
            this.responseFile = ((Properties)object).getProperty("-response.file");
            if (this.responseFile != null) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(this.responseFile));
                Enumeration<?> enumeration = properties.propertyNames();
                Properties properties2 = new Properties();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    string3 = properties.getProperty(string2);
                    string2 = string2.toLowerCase();
                    properties2.setProperty(string2, string3);
                }
                if (!((Properties)object).isEmpty()) {
                    properties2.putAll((Map<?, ?>)object);
                }
                object = properties2;
            }
            string3 = null;
            string2 = null;
            Enumeration<?> enumeration = ((Properties)object).propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string3 = ((Properties)object).getProperty(string2).trim();
                if (!string2.equalsIgnoreCase("-jspcompileclasspath") && string3.equals("") || string2.equals("-response.file")) continue;
                if ("-ear.path".equalsIgnoreCase(string2)) {
                    this.earPath = string3;
                    continue;
                }
                if ("-war.path".equalsIgnoreCase(string2)) {
                    this.warPath = string3;
                    continue;
                }
                if ("-enterpriseapp.name".equalsIgnoreCase(string2)) {
                    this.enterpriseApp = string3;
                    continue;
                }
                if ("-webmodule.name".equalsIgnoreCase(string2)) {
                    this.webModuleName = string3;
                    continue;
                }
                if ("-profileName".equals(string2)) continue;
                if ("-filename".equalsIgnoreCase(string2)) {
                    this.filename = string3;
                    continue;
                }
                if ("-config.root".equalsIgnoreCase(string2)) {
                    this.configRoot = string3;
                    continue;
                }
                if ("-cell.name".equalsIgnoreCase(string2)) {
                    this.cell = string3;
                    continue;
                }
                if ("-node.name".equalsIgnoreCase(string2)) {
                    this.node = string3;
                    continue;
                }
                if ("-config.root.hidden".equalsIgnoreCase(string2)) {
                    this.configRootHidden = string3;
                    continue;
                }
                if ("-cell.name.hidden".equalsIgnoreCase(string2)) {
                    this.cellHidden = string3;
                    continue;
                }
                if ("-node.name.hidden".equalsIgnoreCase(string2)) {
                    this.nodeHidden = string3;
                    continue;
                }
                if ("-server.name".equalsIgnoreCase(string2)) {
                    this.process = string3;
                    continue;
                }
                if ("-translate".equalsIgnoreCase(string2)) {
                    this.translateJsps = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-compile".equalsIgnoreCase(string2)) {
                    this.compileJsps = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-removeTempDir".equalsIgnoreCase(string2)) {
                    this.removeTempDir = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-recurse".equalsIgnoreCase(string2)) {
                    this.recurse = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-keepgenerated".equalsIgnoreCase(string2)) {
                    this.keepgenerated = Boolean.valueOf(string3);
                    continue;
                }
                if ("-usejdkcompiler".equalsIgnoreCase(string2)) {
                    this.useJDKCompiler = Boolean.valueOf(string3);
                    continue;
                }
                if ("-verbose".equalsIgnoreCase(string2)) {
                    this.verbose = Boolean.valueOf(string3);
                    continue;
                }
                if ("-usePageTagPool".equalsIgnoreCase(string2)) {
                    this.usePageTagPool = Boolean.valueOf(string3);
                    continue;
                }
                if ("-useThreadTagPool".equalsIgnoreCase(string2)) {
                    this.useThreadTagPool = Boolean.valueOf(string3);
                    continue;
                }
                if ("-deprecation".equalsIgnoreCase(string2)) {
                    this.deprecation = Boolean.valueOf(string3);
                    continue;
                }
                if ("-javaEncoding".equalsIgnoreCase(string2)) {
                    this.javaEncoding = string3;
                    continue;
                }
                if ("-compileWithAssert".equalsIgnoreCase(string2)) {
                    this.compileWithAssert = Boolean.valueOf(string3);
                    continue;
                }
                if ("-jdkSourceLevel".equalsIgnoreCase(string2)) {
                    this.jdkSourceLevel = string3;
                    continue;
                }
                if ("-jspCompileClasspath".equalsIgnoreCase(string2)) {
                    this.jspCompileClasspath = string3;
                    continue;
                }
                if ("-classloader.parentFirst".equalsIgnoreCase(string2)) {
                    this.classloaderParentFirst = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-classloader.singleWarClassloader".equalsIgnoreCase(string2)) {
                    this.classloaderSingleWarClassloader = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-compileToWebInf".equalsIgnoreCase(string2)) {
                    this.compileToWebInf = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-forceCompilation".equalsIgnoreCase(string2)) {
                    this.forceCompilation = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-trackDependencies".equalsIgnoreCase(string2)) {
                    this.trackDependencies = Boolean.valueOf(string3);
                    continue;
                }
                if ("-createDebugClassfiles".equalsIgnoreCase(string2)) {
                    this.createDebugClassfiles = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-keepGeneratedclassfiles".equalsIgnoreCase(string2)) {
                    this.keepGeneratedclassfiles = "true".equalsIgnoreCase(string3);
                    continue;
                }
                if ("-log.level".equalsIgnoreCase(string2)) {
                    this.logLevel = string3;
                    continue;
                }
                if ("-extractToDir".equalsIgnoreCase(string2)) {
                    this.extractToDirectoryBase = string3;
                    continue;
                }
                if ("-compileToDir".equalsIgnoreCase(string2)) {
                    this.compileToDirectory = string3;
                    continue;
                }
                if ("-additional.classpath".equalsIgnoreCase(string2)) {
                    this.additionalClasspath = string3;
                    continue;
                }
                if ("-useJikes".equalsIgnoreCase(string2)) {
                    this.useJikes = Boolean.valueOf(string3);
                    continue;
                }
                if ("-useFullPackageNames".equalsIgnoreCase(string2)) {
                    this.useFullPackageNames = Boolean.valueOf(string3);
                    continue;
                }
                if ("-jsp.file.extensions".equalsIgnoreCase(string2)) {
                    this.jspFileExtensions = string3;
                    continue;
                }
                if ("-compilerOptions".equalsIgnoreCase(string2)) {
                    string = string3;
                    continue;
                }
                if ("-userepeatint".equalsIgnoreCase(string2)) {
                    this.useRepeatInt = Boolean.valueOf(string3);
                    continue;
                }
                if ("-usescriptvardupinit".equalsIgnoreCase(string2)) {
                    this.useScriptVarDupInit = Boolean.valueOf(string3);
                    continue;
                }
                if ("-allowunmatchedendtag".equalsIgnoreCase(string2)) {
                    this.allowUnmatchedEndTag = Boolean.valueOf(string3);
                    continue;
                }
                if ("-useiterationeval".equalsIgnoreCase(string2)) {
                    this.useIterationEval = Boolean.valueOf(string3);
                    continue;
                }
                if ("-useCDataTrim".equalsIgnoreCase(string2)) {
                    this.useCDataTrim = Boolean.valueOf(string3);
                    continue;
                }
                if ("-disableURLEncodingForParamTag".equalsIgnoreCase(string2)) {
                    this.disableURLEncodingForParamTag = Boolean.valueOf(string3);
                    continue;
                }
                if ("-evalQuotedAndEscapedExpression".equalsIgnoreCase(string2)) {
                    this.evalQuotedAndEscapedExpression = Boolean.valueOf(string3);
                    continue;
                }
                if ("-convertexpression".equalsIgnoreCase(string2)) {
                    this.convertExpression = Boolean.valueOf(string3);
                    continue;
                }
                if ("-allowNullParentInTagFile".equalsIgnoreCase(string2)) {
                    this.allowNullParentInTagFile = Boolean.valueOf(string3);
                    continue;
                }
                if ("-modifyPageContextVariable".equalsIgnoreCase(string2)) {
                    this.modifyPageContextVar = Boolean.valueOf(string3);
                    continue;
                }
                if ("-compileAfterFailure".equalsIgnoreCase(string2)) {
                    this.compileAfterFailure = Boolean.valueOf(string3);
                    continue;
                }
                logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.unknown.argument", string2);
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.exception.while.processing.arguments.filenotfound", new Object[]{this.responseFile, fileNotFoundException.getMessage()});
            return false;
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.exception.while.processing.arguments", exception);
            return false;
        }
        if (this.logLevel != null) {
            if (this.logLevel.equals("SEVERE")) {
                logger.setLevel(Level.SEVERE);
                consoleHandler.setLevel(Level.SEVERE);
                if (myHandler != null) {
                    myHandler.setLevel(Level.SEVERE);
                }
            } else if (this.logLevel.equals("WARNING")) {
                logger.setLevel(Level.WARNING);
                consoleHandler.setLevel(Level.WARNING);
                if (myHandler != null) {
                    myHandler.setLevel(Level.WARNING);
                }
            } else if (this.logLevel.equals("INFO")) {
                logger.setLevel(Level.INFO);
                consoleHandler.setLevel(Level.INFO);
                if (myHandler != null) {
                    myHandler.setLevel(Level.INFO);
                }
            } else if (this.logLevel.equals("CONFIG")) {
                logger.setLevel(Level.CONFIG);
                consoleHandler.setLevel(Level.CONFIG);
                if (myHandler != null) {
                    myHandler.setLevel(Level.CONFIG);
                }
            } else if (this.logLevel.equals("FINE")) {
                logger.setLevel(Level.FINE);
                consoleHandler.setLevel(Level.FINE);
                if (myHandler != null) {
                    myHandler.setLevel(Level.FINE);
                }
            } else if (this.logLevel.equals("FINER")) {
                logger.setLevel(Level.FINER);
                consoleHandler.setLevel(Level.FINER);
                if (myHandler != null) {
                    myHandler.setLevel(Level.FINER);
                }
            } else if (this.logLevel.equals("FINEST")) {
                logger.setLevel(Level.FINEST);
                consoleHandler.setLevel(Level.FINEST);
                if (myHandler != null) {
                    myHandler.setLevel(Level.FINEST);
                }
            } else if (this.logLevel.equals("OFF")) {
                logger.setLevel(Level.OFF);
            } else {
                logger.logp(Level.WARNING, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.log.level", new Object[]{this.logLevel, defaultLogLevel});
            }
        }
        if (string != null) {
            this.compilerOptions = new ArrayList();
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.compilerOptions.add(((StringTokenizer)object).nextToken());
            }
        }
        int n = 0;
        if (this.earPath != null) {
            ++n;
        }
        if (this.warPath != null) {
            ++n;
        }
        if (this.enterpriseApp != null) {
            ++n;
        }
        if (n == 0) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.must.supply.ear.path.or.war.path.or.enterpriseapp");
            return false;
        }
        if (n > 1) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.must.supply.only.one.of.ear.path.or.war.path.or.enterpriseapp");
            return false;
        }
        if (this.removeTempDir && this.enterpriseApp == null) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.if.removetempdir.true.enterpriseapp.must.be.given");
            return false;
        }
        if (!this.translateJsps && !this.removeTempDir) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.if.translatejsps.false.removetempdir.must.be.true");
            return false;
        }
        if (this.compileToDirectory != null && this.compileToWebInf) {
            logger.logp(Level.WARNING, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.compiletowebinf.being.ignored.because.compiletodir.given", this.compileToDirectory);
            this.compileToWebInf = false;
        }
        if (this.javaEncoding != null && !EncodingUtils.isCharsetSupported(this.javaEncoding)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "Invalid value for javaEncoding [" + this.javaEncoding + "]. Defaulting to UTF-8.");
            }
            this.javaEncoding = "UTF-8";
        }
        if (this.compileWithAssert != null && this.compileWithAssert.booleanValue()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "compileWithAssert is deprecated.  Use jdkSourceLevel with value of '14' instead. ");
            }
            if (this.jdkSourceLevel == null) {
                this.jdkSourceLevel = "14";
                if (logger.isLoggable(Level.INFO)) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "Setting jdkSourceLevel to '14' because compileWithAssert is true.");
                }
            } else if (this.jdkSourceLevel.equals("13")) {
                this.jdkSourceLevel = "14";
                if (logger.isLoggable(Level.INFO)) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "jdkSourceLevel was set to '13'.  Setting jdkSourceLevel to '14' because compileWithAssert is true.");
                }
            } else if (this.jdkSourceLevel.equals("15") && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "jdkSourceLevel is set to '15' and compileWithAssert is 'true'.  Leaving jdkSourceLevel at higher '15' level.");
            }
        }
        if (!(this.jdkSourceLevel == null || this.jdkSourceLevel.equals("13") || this.jdkSourceLevel.equals("14") || this.jdkSourceLevel.equals("15"))) {
            this.jdkSourceLevel = null;
        }
        if (this.earPath != null) {
            if (this.compileToDirectory == null) {
                this.compileToWebInf = true;
            }
            if (this.webModuleName == null) {
                this.webModuleName = WEBMODULE_COMPILEALL;
            }
            return true;
        }
        if (this.warPath != null) {
            if (this.compileToDirectory == null) {
                this.compileToWebInf = true;
            }
            if (this.webModuleName != null) {
                logger.logp(Level.WARNING, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.webmodule.name.being.ignored.because.war.path.given", this.webModuleName);
                this.webModuleName = null;
            }
            return true;
        }
        if (this.configRoot == null) {
            this.configRoot = this.configRootHidden;
        }
        if (this.cell == null) {
            this.cell = this.cellHidden;
        }
        if (this.node == null) {
            this.node = this.nodeHidden;
        }
        if (this.enterpriseApp != null && this.configRoot != null) {
            logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "\n");
            if (this.cell == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.cell.name", "BaseApplicationServerCell");
                this.cell = "BaseApplicationServerCell";
            }
            if (this.node == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.node.name", "DefaultNode");
                this.node = "DefaultNode";
            }
            if (this.process == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.server.name", "server1");
                this.process = "server1";
            }
            if (this.webModuleName == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.compiling.all.webmodules");
                this.webModuleName = WEBMODULE_COMPILEALL;
            }
            if (this.extractToDirectoryBase != null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.ignoring.extracttodir", this.extractToDirectoryBase);
            }
            logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "\n");
            return true;
        }
        return false;
    }

    protected String expandVariable(String string) throws IllegalArgumentException {
        com.ibm.ws.runtime.service.VariableMap variableMap = null;
        try {
            variableMap = (com.ibm.ws.runtime.service.VariableMap)WsServiceRegistry.getService((Object)this, (Class)com.ibm.ws.runtime.service.VariableMap.class);
            return variableMap.expand(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)WsComponentImpl.class.getName(), (String)"365", (Object)this);
            return null;
        }
    }

    private void usage() {
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "\n");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "Usage:");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "JspBatchCompiler");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                -ear.path <path> | -war.path <path> | -enterpriseapp.name <name>");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-response.file <filename>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-webmodule.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-filename <jsp name | directory name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-recurse <true|false]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-config.root <path>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-cell.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-node.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-server.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-profileName <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-extractToDir <path>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compileToDir <path>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compileToWebInf <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-translate <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compile <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-removeTempDir <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-forceCompilation <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useFullPackageNames <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-trackDependencies <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-createDebugClassfiles <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-keepgenerated <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-keepGeneratedclassfiles <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-usePageTagPool <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useThreadTagPool <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-classloader.parentFirst <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-classloader.singleWarClassloader <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-additional.classpath <classpath to additional jars and classes>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-jspCompileClasspath <classpath to WAS public API jars; or no value at all]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-verbose <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-deprecation <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-javaEncoding <encoding>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-jdkSourceLevel <13 | 14 | 15>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useJDKCompiler <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useRepeatInt <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-allowUnmatchedEndTag <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useIterationEval <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useScriptVarDupInit <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useCDataTrim <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-disableURLEncodingForParamTag <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compilerOptions <space-separated list of java compiler options>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useJikes <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-evalQuotedAndEscapedExpression <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-modifyPageContextVariable <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compileAfterFailure <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-jsp.file.extensions <file extensions to process>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-log.level <SEVERE | WARNING | INFO | CONFIG | FINE | FINER | FINEST | OFF>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", " ");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                *** See batchcompiler.properties.default in {WAS_ROOT}/properties for more information. ***");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                *** See JspCBuild.xml in {WAS_ROOT}/properties for information about the public WebSphere Ant task JspC. ***");
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = null;
        if (this.earPath != null) {
            string2 = string + "jsp.batchcompiler.earPath =              [" + this.earPath + "]" + string + "jsp.batchcompiler.earFile.name =         [" + this.earFile.getName() + "]" + string + "jsp.batchcompiler.webmodulename =        [" + this.webModuleName + "]" + string + "jsp.batchcompiler.webmoduleURL =         [" + this.webModuleURL + "]" + string + "jsp.batchcompiler.extractToDir =         [" + this.extractToDirectoryBase + "]" + string + "classloader.parentFirst =                [" + this.classloaderParentFirst + "]" + string + "classloader.singleWarClassloader =       [" + this.classloaderSingleWarClassloader + "]" + string;
        } else if (this.warPath != null) {
            string2 = string + "jsp.batchcompiler.warPath =              [" + this.warPath + "]" + string + "jsp.batchcompiler.warFile.name =         [" + this.warFile.getName() + "]" + string + "jsp.batchcompiler.extractToDir =         [" + this.extractToDirectoryBase + "]" + string + "jsp.batchcompiler.webmoduleURL =         [" + this.webModuleURL + "]" + string;
        } else if (this.enterpriseApp != null) {
            string2 = string + "jsp.batchcompiler.config.root =        [" + this.configRoot + "]" + string + "jsp.batchcompiler.cellname =           [" + this.cell + "]" + string + "jsp.batchcompiler.nodename =           [" + this.node + "]" + string + "jsp.batchcompiler.servername =         [" + this.process + "]" + string + "jsp.batchcompiler.enterpriseappname =  [" + this.enterpriseApp + "]" + string + "jsp.batchcompiler.webmodulename =      [" + this.webModuleName + "]" + string + "install.root =                         [" + this.wasInstallRoot + "]" + string + "app.install.root =                     [" + this.appInstallRoot + "]" + string + "config.url =                           [" + this.configURL + "]" + string + "binaries.url =                         [" + this.binariesURL + "]" + string + "loose.app.url =                        [" + this.looseAppURL + "]" + string + "webmodule.url =                        [" + this.webModuleURL + "]" + string + "metadata.from.binaries =               [" + this.metadataFromBinaries + "]" + string + "classloader.parentFirst =              [" + this.classloaderParentFirst + "]" + string + "classloader.singleWarClassloader =     [" + this.classloaderSingleWarClassloader + "]" + string + "removeTempDir =                        [" + this.removeTempDir + "]" + string;
        }
        string2 = string2.concat("response file:                         [" + this.responseFile + "]" + string + "classfiles will be compiled to:        [" + this.tempDirectory + "]" + string + "jspFileName =                          [" + this.filename + "]" + string + "recurse =                              [" + this.recurse + "]" + string + "verbose =                              [" + this.options.isVerbose() + "]" + string + "translate =                            [" + this.translateJsps + "]" + string + "compile =                              [" + this.compileJsps + "]" + string + "deprecation =                          [" + this.options.isDeprecation() + "]" + string + "javaEncoding =                         [" + this.options.getJavaEncoding() + "]" + string + "jdkSourceLevel =                       [" + this.options.getJdkSourceLevel() + "]" + string + "useJDKCompiler =                       [" + this.options.isUseJDKCompiler() + "]" + string + "useRepeatInt =                         [" + this.options.isUseRepeatInt() + "]" + string + "useScriptVarDupInit =                  [" + this.options.isUseScriptVarDupInit() + "]" + string + "allowUnmatchedEndTag =                 [" + this.options.isAllowUnmatchedEndTag() + "]" + string + "useIterationEval =                     [" + this.options.isUseIterationEval() + "]" + string + "useCDataTrim =      \t\t              [" + this.options.isUseCDataTrim() + "]" + string + "disableURLEncodingForParamTag =\t\t  [" + this.options.isDisableURLEncodingForParamTag() + "]" + string + "compilerOptions =                      [" + this.compilerOptions + string + "keepgenerated =                        [" + this.options.isKeepGenerated() + "]" + string + "keepGeneratedclassfiles =              [" + this.keepGeneratedclassfiles + "]" + string + "usePageTagPool =                       [" + this.options.isUsePageTagPool() + "]" + string + "useThreadTagPool =                     [" + this.options.isUseThreadTagPool() + "]" + string + "compileToWebInf =                      [" + this.compileToWebInf + "]" + string + "createDebugClassfiles =                [" + this.createDebugClassfiles + "]" + string + "forceCompilation =                     [" + this.forceCompilation + "]" + string + "trackDependencies =                    [" + this.options.isTrackDependencies() + "]" + string + "useJikes =                             [" + this.options.isUseJikes() + "]" + string + "useFullPackageNames =                  [" + this.options.isUseFullPackageNames() + "]" + string + "jsp.file.extensions =                  [" + this.fullJspFileExtensions + "]" + string + "additionalClasspath =                  [" + this.additionalClasspath + "]" + string + "jspCompileClasspath =                  [" + this.options.getJspCompileClasspath() + "]" + string + "evalQuotedAndEscapedExpression =       [" + this.options.isEvalQuotedAndEscapedExpression() + "]" + string + "convertExpression =                 \t  [" + this.options.isConvertExpression() + "]" + string + "modifyPageContextVariable =         \t  [" + this.options.isModifyPageContextVariable() + "]" + "compileAfterFailure =                  [" + this.options.isCompileAfterFailure() + "]" + string + string + "");
        return string2;
    }

    public String getName() {
        return "JspBatchCompiler";
    }

    public String getState() {
        return null;
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
    }

    public void destroy() {
    }

    public void start() throws RuntimeError, RuntimeWarning {
    }

    public void stop() {
    }
}

