/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.ws.jsp.tools.AbstractJspModC;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JspFileUtils {
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.JspFileUtils";
    private static Pattern v4FilenamePattern = Pattern.compile("_jsp_[0-9]+\\.(dat|java)");
    private static Pattern classFilenamePattern = Pattern.compile("_[a-zA-Z0-9_$]*+\\.class");
    private Logger logger = null;

    public JspFileUtils() {
        this(null);
    }

    public JspFileUtils(Logger logger) {
        this.logger = logger;
    }

    public void removeVersion4Files(File file, String string) {
        int n = string.length();
        String string2 = file.toString().substring(n);
        if (string2.length() == 0) {
            string2 = "/";
        }
        String string3 = string2 = string2.replace('\\', '/');
        if (!string2.equals("/")) {
            string3 = NameMangler.handlePackageName(string2);
            string3 = string3.replace('.', '/');
        }
        if ((string3 = string3.replace('\\', '/')).charAt(0) != '/') {
            string3 = "/" + string3;
        }
        File file2 = null;
        file2 = string.endsWith("/") ? new File(string + string3.substring(1)) : new File(string + string3.substring(0));
        if (string3.equals(string2)) {
            String string4 = null;
            File[] fileArray = file2.listFiles(new WsFilenameFilter(v4FilenamePattern));
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isFile()) continue;
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", "Deleting: " + fileArray[i]);
                    }
                    fileArray[i].delete();
                    string4 = fileArray[i].toString();
                    int n2 = string4.lastIndexOf("_jsp_");
                    string4 = string4.substring(0, n2);
                    string4 = string4 + ".class";
                    File file3 = new File(string4);
                    if (!file3.exists() || !file3.isFile()) continue;
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", "Deleting: " + file3.toString());
                    }
                    file3.delete();
                }
            }
        } else if (file2.exists()) {
            if (this.logger != null) {
                this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", "Removing: " + file2.toString());
                this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", " ");
            }
            JspFileUtils.deleteDirs(file2, this.logger);
        }
    }

    public void removeFixedPackageFiles(String string, JspTranslationContext jspTranslationContext, String string2) {
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(0, n);
        if (string3.length() == 0) {
            string3 = "/";
        }
        if ((string3 = string3.replace('\\', '/')).charAt(0) != '/') {
            string3 = "/" + string3;
        }
        File file = null;
        file = string.endsWith("/") ? new File(string + string3.substring(1)) : new File(string + string3.substring(0));
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        File[] fileArray = file.listFiles(new WsFilenameFilter(classFilenamePattern));
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || (string5 = fileArray[i].toString()).indexOf(36) >= 0) continue;
                if (this.logger != null) {
                    this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "checking to see if we can delete: " + fileArray[i]);
                }
                string5 = fileArray[i].toString();
                string5 = string5.replace('\\', '/');
                n2 = string5.lastIndexOf(47);
                string5 = string5.substring(n2);
                n2 = string5.lastIndexOf(46);
                ClassLoader classLoader = AbstractJspModC.createClassLoader(string5 = string5.substring(1, n2), jspTranslationContext, fileArray[i].toString(), this.logger, false, file, fileArray[i]);
                if (classLoader == null) continue;
                boolean bl = true;
                String string6 = "com.ibm._jsp." + string5;
                if (!this.loadClass(string6, classLoader) && !this.loadClass(string6 = "org.apache.jsp." + string5, classLoader)) {
                    bl = false;
                }
                if (!bl) continue;
                if (this.logger != null) {
                    this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + fileArray[i]);
                }
                fileArray[i].delete();
                string4 = fileArray[i].toString();
                int n3 = string4.lastIndexOf(".");
                string4 = string4.substring(0, n3);
                String string7 = string4 + ".java";
                String string8 = string4 + ".dat";
                File file2 = new File(string7);
                if (file2.exists() && file2.isFile()) {
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + file2.toString());
                    }
                    file2.delete();
                }
                if ((file2 = new File(string8)).exists() && file2.isFile()) {
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + file2.toString());
                    }
                    file2.delete();
                }
                File[] fileArray2 = file.listFiles(new InnerclassFilenameFilter(string5));
                for (int j = 0; j < fileArray2.length; ++j) {
                    if (!fileArray2[j].isFile()) continue;
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + fileArray2[j].toString());
                    }
                    fileArray2[j].delete();
                }
            }
        }
        if (file.isDirectory()) {
            file.delete();
        }
    }

    public static void deleteDirs(File file, Logger logger) {
        File[] fileArray = file.listFiles();
        boolean bl = false;
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    JspFileUtils.deleteDirs(file2, logger);
                    continue;
                }
                bl = file2.delete();
                if (logger == null) continue;
                logger.logp(Level.FINEST, "JspFileUtils", "deleteDirs", "Attempted to remove file " + file2 + ". Removal succeeded?: " + bl);
            }
        }
        bl = file.delete();
        if (logger != null) {
            logger.logp(Level.FINE, "JspFileUtils", "deleteDirs", "Attempted to remove directory " + file + ". Removal succeeded?: " + bl);
        }
    }

    private boolean loadClass(String string, ClassLoader classLoader) {
        boolean bl = true;
        Object var4_4 = null;
        try {
            Class.forName(string, true, classLoader).newInstance();
        }
        catch (Throwable throwable) {
            if (this.logger != null) {
                this.logger.logp(Level.FINE, "JspFileUtils", "loadClass", "Exception caught during loading classfile", throwable);
            }
            bl = false;
        }
        return bl;
    }

    public void createJspFileExtensionList(String string, List list) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ": ;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (list.contains(string2)) {
                if (!this.logger.isLoggable(Level.WARNING)) continue;
                this.logger.logp(Level.WARNING, CLASS_NAME, "createJspFileExtensionList", "duplicate value for jsp file extensions ", string2);
                continue;
            }
            list.add(string2);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: JspFileUtils <packagename> <classname>");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = null;
        string3 = NameMangler.handlePackageName(string);
        string3 = string3.replace('.', '/');
        string2 = NameMangler.mangleClassName(string2);
    }

    private static class WsFilenameFilter
    implements FilenameFilter {
        Pattern filePattern;

        public WsFilenameFilter(Pattern pattern) {
            this.filePattern = pattern;
        }

        public boolean accept(File file, String string) {
            return this.filePattern.matcher(string).find();
        }
    }

    public static class InnerclassFilenameFilter
    implements FilenameFilter {
        String filename = null;

        public InnerclassFilenameFilter(String string) {
            this.filename = string;
        }

        public boolean accept(File file, String string) {
            String string2;
            int n = string.indexOf("$");
            return n > -1 && this.filename.equals(string2 = string.substring(0, n));
        }
    }
}

