/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.util.FileSystem;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JDTCompiler
implements JspCompiler {
    private static String separatorString = System.getProperty("line.separator");
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.JDTCompiler";
    private ClassLoader loader = null;
    private String javaEncoding = null;
    private String outputDir = null;
    private boolean isClassDebugInfo = false;
    private boolean isDebugEnabled = false;
    private boolean isVerbose = false;
    private boolean isDeprecation = false;
    private String jdkSourceLevel = null;
    private boolean useFullPackageNames = false;

    public JDTCompiler(ClassLoader classLoader, JspOptions jspOptions) {
        this.loader = classLoader;
        this.javaEncoding = jspOptions.getJavaEncoding();
        this.outputDir = jspOptions.getOutputDir().getPath();
        this.isClassDebugInfo = jspOptions.isClassDebugInfo();
        this.isDebugEnabled = jspOptions.isDebugEnabled();
        this.isVerbose = jspOptions.isVerbose();
        this.isDeprecation = jspOptions.isDeprecation();
        this.jdkSourceLevel = jspOptions.getJdkSourceLevel();
        this.useFullPackageNames = jspOptions.isUseFullPackageNames();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JDTCompiler", "Entering JDTCompiler.");
        }
    }

    public JspCompilerResult compile(String string, Collection collection, List list) {
        return null;
    }

    public JspCompilerResult compile(JspResources[] jspResourcesArray, JspResources[] jspResourcesArray2, Collection collection, List list) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JDTCompiler", "Entering JDTCompiler.compile");
        }
        ICompilationUnit[] iCompilationUnitArray = new JspCompilationUnit[jspResourcesArray.length];
        for (int i = 0; i < jspResourcesArray.length; ++i) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "JDTCompiler", "Adding compilation unit for [" + jspResourcesArray[i].getClassName() + "]");
            }
            iCompilationUnitArray[i] = new JspCompilationUnit(jspResourcesArray[i]);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            hashMap.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            hashMap.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            hashMap.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            hashMap.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        }
        hashMap.put("org.eclipse.jdt.core.encoding", this.javaEncoding);
        if (this.jdkSourceLevel.equals("14")) {
            hashMap.put("org.eclipse.jdt.core.compiler.source", "1.4");
        } else if (this.jdkSourceLevel.equals("15")) {
            hashMap.put("org.eclipse.jdt.core.compiler.source", "1.5");
            hashMap.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        } else {
            hashMap.put("org.eclipse.jdt.core.compiler.source", "1.3");
        }
        if (this.isDeprecation) {
            hashMap.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        }
        if (this.isVerbose) {
            // empty if block
        }
        JspCompilerRequestor jspCompilerRequestor = new JspCompilerRequestor(collection);
        Compiler compiler = new Compiler((INameEnvironment)new JspNameEnvironment(jspResourcesArray, jspResourcesArray2), DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(hashMap), (ICompilerRequestor)jspCompilerRequestor, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JDTCompiler", "about to call compiler.compile()");
        }
        compiler.compile(iCompilationUnitArray);
        return jspCompilerRequestor.getJspCompilerResult();
    }

    static /* synthetic */ ClassLoader access$100(JDTCompiler jDTCompiler) {
        return jDTCompiler.loader;
    }

    public class JspCompilerRequestor
    implements ICompilerRequestor {
        private int rc = 0;
        private StringBuffer compilerMessage = null;
        private Collection jspLineIds = null;

        public JspCompilerRequestor(Collection collection) {
            this.jspLineIds = collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void acceptResult(CompilationResult compilationResult) {
            Object object;
            boolean bl = true;
            if (compilationResult.hasProblems()) {
                object = compilationResult.getProblems();
                if (this.compilerMessage == null) {
                    this.compilerMessage = new StringBuffer();
                }
                for (int i = 0; i < ((CategorizedProblem[])object).length; ++i) {
                    CategorizedProblem categorizedProblem = object[i];
                    if (categorizedProblem.isError()) {
                        bl = false;
                        this.rc = 1;
                        this.addMessage((IProblem)categorizedProblem, ((JspCompilationUnit)compilationResult.getCompilationUnit()).getSourcePath());
                        continue;
                    }
                    if (!categorizedProblem.isWarning() || !JDTCompiler.this.isVerbose && !JDTCompiler.this.isDeprecation) continue;
                    this.addMessage((IProblem)categorizedProblem, ((JspCompilationUnit)compilationResult.getCompilationUnit()).getSourcePath());
                }
            }
            if (!bl) return;
            object = null;
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            for (int i = 0; i < classFileArray.length; ++i) {
                ClassFile classFile = classFileArray[i];
                char[][] cArray = classFile.getCompoundName();
                String string = "";
                String string2 = "";
                for (int j = 0; j < cArray.length; ++j) {
                    string = string + string2;
                    string = string + new String(cArray[j]);
                    string2 = ".";
                }
                byte[] byArray = classFile.getBytes();
                String string3 = null;
                if (JDTCompiler.this.useFullPackageNames) {
                    string3 = JDTCompiler.this.outputDir + "/" + string.replace('.', '/') + ".class";
                } else {
                    string3 = ((JspCompilationUnit)compilationResult.getCompilationUnit()).getSourcePath();
                    string3 = string3.substring(0, string3.lastIndexOf(File.separatorChar) + 1);
                    string3 = string3 + new String(cArray[cArray.length - 1]);
                    string3 = string3 + ".class";
                }
                object = new BufferedOutputStream(new FileOutputStream(string3));
                ((OutputStream)object).write(byArray);
                ((OutputStream)object).close();
            }
            Object var13_16 = null;
            if (object == null) return;
            try {
                ((OutputStream)object).close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var13_17 = null;
                    if (object == null) return;
                    try {
                        ((OutputStream)object).close();
                        return;
                    }
                    catch (IOException iOException2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (object == null) throw throwable;
                try {
                    ((OutputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private void addMessage(IProblem iProblem, String string) {
            String string2 = this.findMapping(iProblem.getSourceLineNumber(), string);
            if (string2 == null) {
                this.compilerMessage.append(separatorString);
            } else {
                this.compilerMessage.append(string2);
                this.compilerMessage.append(separatorString);
            }
            this.compilerMessage.append(string);
            this.compilerMessage.append(" : ");
            this.compilerMessage.append(iProblem.getSourceLineNumber());
            this.compilerMessage.append(" : ");
            this.compilerMessage.append(iProblem.getMessage());
            this.compilerMessage.append(separatorString);
        }

        public JspCompilerResult getJspCompilerResult() {
            JspCompilerResult jspCompilerResult = new JspCompilerResult(this){
                private final /* synthetic */ JspCompilerRequestor this$1;
                {
                    this.this$1 = jspCompilerRequestor;
                }

                public int getCompilerReturnValue() {
                    return JspCompilerRequestor.access$700(this.this$1);
                }

                public String getCompilerMessage() {
                    if (JspCompilerRequestor.access$800(this.this$1) != null) {
                        return JspCompilerRequestor.access$800(this.this$1).toString();
                    }
                    return "";
                }

                public List getCompilerFailureFileNames() {
                    return null;
                }
            };
            return jspCompilerResult;
        }

        private String findMapping(int n, String string) {
            String string2 = null;
            Iterator iterator = this.jspLineIds.iterator();
            while (iterator.hasNext()) {
                JspLineId jspLineId = (JspLineId)iterator.next();
                if (!jspLineId.getGeneratedFilePath().equals(string)) continue;
                if (jspLineId.getStartGeneratedLineCount() <= 1 && jspLineId.getStartGeneratedLineNum() == n) {
                    string2 = this.createErrorMsg(jspLineId, n);
                    break;
                }
                if (jspLineId.getStartGeneratedLineNum() > n || jspLineId.getStartGeneratedLineNum() + jspLineId.getStartGeneratedLineCount() - 1 < n) continue;
                string2 = this.createErrorMsg(jspLineId, n);
                break;
            }
            return string2;
        }

        private String createErrorMsg(JspLineId jspLineId, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (jspLineId.getSourceLineCount() <= 1) {
                Object[] objectArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objectArray));
                } else {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objectArray));
                }
            } else {
                int n2 = jspLineId.getStartSourceLineNum() + (n - jspLineId.getStartGeneratedLineNum());
                if (n2 >= jspLineId.getStartSourceLineNum() && n2 <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                    Object[] objectArray = new Object[]{new Integer(n2), jspLineId.getFilePath()};
                    if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                        stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objectArray));
                    } else {
                        stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objectArray));
                    }
                } else {
                    Object[] objectArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                    if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                        stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objectArray));
                    } else {
                        stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objectArray));
                    }
                }
            }
            stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}) + separatorString);
            return stringBuffer.toString();
        }

        static /* synthetic */ int access$700(JspCompilerRequestor jspCompilerRequestor) {
            return jspCompilerRequestor.rc;
        }

        static /* synthetic */ StringBuffer access$800(JspCompilerRequestor jspCompilerRequestor) {
            return jspCompilerRequestor.compilerMessage;
        }
    }

    public class JspNameEnvironment
    implements INameEnvironment {
        private JspCompilationUnit[] jspCompilationUnits = null;
        private JspResources[] dependencyResources = null;

        public JspNameEnvironment(JspResources[] jspResourcesArray, JspResources[] jspResourcesArray2) {
            this.jspCompilationUnits = new JspCompilationUnit[jspResourcesArray.length];
            for (int i = 0; i < jspResourcesArray.length; ++i) {
                this.jspCompilationUnits[i] = new JspCompilationUnit(jspResourcesArray[i]);
            }
            this.dependencyResources = jspResourcesArray2;
        }

        public void cleanup() {
        }

        public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2) {
            String string = "";
            String string2 = "";
            for (int i = 0; i < cArray2.length; ++i) {
                string = string + string2;
                string = string + new String(cArray2[i]);
                string2 = ".";
            }
            string = string + string2;
            string = string + new String(cArray);
            return this.getClass(string);
        }

        public NameEnvironmentAnswer findType(char[][] cArray) {
            String string = "";
            String string2 = "";
            for (int i = 0; i < cArray.length; ++i) {
                string = string + string2;
                string = string + new String(cArray[i]);
                string2 = ".";
            }
            return this.getClass(string);
        }

        public boolean isPackage(char[][] cArray, char[] cArray2) {
            String string;
            String string2 = "";
            String string3 = "";
            if (cArray != null) {
                for (int i = 0; i < cArray.length; ++i) {
                    string2 = string2 + string3;
                    String string4 = new String(cArray[i]);
                    string2 = string2 + string4;
                    string3 = ".";
                }
            }
            if (Character.isUpperCase((string = new String(cArray2)).charAt(0)) && !this.isPackage(string2)) {
                return false;
            }
            string2 = string2 + string3;
            string2 = string2 + string;
            return this.isPackage(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isPackage(String var1_1) {
            block14: {
                block13: {
                    var2_2 = null;
                    var3_3 = false;
                    try {
                        for (var4_4 = 0; var4_4 < this.jspCompilationUnits.length; ++var4_4) {
                            if (!var1_1.equals(this.jspCompilationUnits[var4_4].getJspClassName())) continue;
                            var5_6 = false;
                            var10_8 = null;
                            if (var2_2 == null) return var5_6;
                            break block13;
                        }
                        var4_5 = var1_1.replace('.', '/') + ".class";
                        var2_2 = JDTCompiler.access$100(JDTCompiler.this).getResourceAsStream(var4_5);
                        v0 = var3_3 = var2_2 == null;
                        if (var3_3 || !FileSystem.isCaseInsensitive) break block14;
                        var5_7 = var1_1.replace('.', '/');
                        var6_14 = JDTCompiler.access$100(JDTCompiler.this).getResource(var5_7 + "/");
                        if (var6_14 == null) break block14;
                        if (var6_14.getProtocol().equals("file")) {
                            var7_15 = "/.";
                            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                                var7_15 = "/...";
                            } else if (System.getProperty("os.name").toLowerCase().equals("os/400")) {
                                var7_15 = "/..";
                            }
                            var8_16 = var5_7 + var7_15;
                            v1 = var3_3 = JDTCompiler.access$100(JDTCompiler.this).getResource(var8_16) != null;
                            if (JDTCompiler.logger.isLoggable(Level.FINE)) {
                                JDTCompiler.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.JDTCompiler", "JDTCompiler", "retbool =" + var3_3 + " for path " + var8_16);
                            }
                            break block14;
                        }
                        if (JDTCompiler.logger.isLoggable(Level.FINE)) {
                            JDTCompiler.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.JDTCompiler", "JDTCompiler", "loader.getResource returned non null and protocol was not file");
                        }
                        var3_3 = true;
                        break block14;
                    }
                    catch (Throwable var9_17) {
                        var10_10 = null;
                        if (var2_2 == null) throw var9_17;
                        try {
                            var2_2.close();
                            throw var9_17;
                        }
                        catch (IOException var11_13) {
                            // empty catch block
                        }
                        throw var9_17;
                    }
                }
                ** try [egrp 1[TRYBLOCK] [3 : 366->373)] { 
lbl47:
                // 1 sources

                var2_2.close();
                return var5_6;
lbl49:
                // 1 sources

                catch (IOException var11_11) {
                    // empty catch block
                }
                return var5_6;
            }
            var10_9 = null;
            if (var2_2 == null) return var3_3;
            try {}
            catch (IOException var11_12) {
                return var3_3;
            }
            var2_2.close();
            return var3_3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NameEnvironmentAnswer getClass(String var1_1) {
            block38: {
                block33: {
                    block37: {
                        block32: {
                            block30: {
                                block31: {
                                    var2_2 = null;
                                    var3_3 = null;
                                    var4_4 = null;
                                    try {
                                        try {
                                            for (var5_5 = 0; var5_5 < this.jspCompilationUnits.length; ++var5_5) {
                                                if (!var1_1.equals(this.jspCompilationUnits[var5_5].getJspClassName())) continue;
                                                var6_9 = new NameEnvironmentAnswer((ICompilationUnit)this.jspCompilationUnits[var5_5], null);
                                                var12_11 = null;
                                                if (var2_2 == null) break block30;
                                                break block31;
                                            }
                                            if (this.dependencyResources != null) {
                                                for (var5_5 = 0; var5_5 < this.dependencyResources.length; ++var5_5) {
                                                    var6_10 = this.dependencyResources[var5_5].getGeneratedSourceFile().getPath();
                                                    var7_23 /* !! */  = (byte[])((this.dependencyResources[var5_5].getPackageName().length() != 0 ? this.dependencyResources[var5_5].getPackageName() + "." : "") + this.dependencyResources[var5_5].getClassName());
                                                    if (!var1_1.equals(var7_23 /* !! */ ) || (var8_24 = this.getClassFileBytes((String)var6_10)) == null) continue;
                                                    var9_26 = new ClassFileReader(var8_24, var1_1.toCharArray(), true);
                                                    var10_28 = new NameEnvironmentAnswer((IBinaryType)var9_26, null);
                                                    break block32;
                                                }
                                            }
                                            var5_6 = var1_1.replace('.', '/') + ".class";
                                            var2_2 = JDTCompiler.access$100(JDTCompiler.this).getResourceAsStream(var5_6);
                                            if (var2_2 != null) {
                                                var7_23 /* !! */  = new byte[4096];
                                                var3_3 = new ByteArrayOutputStream(var7_23 /* !! */ .length);
                                                while ((var8_25 = var2_2.read(var7_23 /* !! */ , 0, var7_23 /* !! */ .length)) > 0) {
                                                    var3_3.write(var7_23 /* !! */ , 0, var8_25);
                                                }
                                                var3_3.flush();
                                                var6_10 = var3_3.toByteArray();
                                                var9_27 = new ClassFileReader((byte[])var6_10, var1_1.toCharArray(), true);
                                                var4_4 = new NameEnvironmentAnswer((IBinaryType)var9_27, null);
                                            }
                                            break block33;
                                        }
                                        catch (IOException var5_7) {
                                            var5_7.printStackTrace();
                                            var12_14 = null;
                                            if (var2_2 != null) {
                                                try {
                                                    var2_2.close();
                                                }
                                                catch (IOException var13_20) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var3_3 == null) return var4_4;
                                            try {
                                                var3_3.close();
                                                return var4_4;
                                            }
                                            catch (IOException var13_20) {
                                                return var4_4;
                                            }
                                        }
                                        catch (ClassFormatException var5_8) {
                                            block35: {
                                                var5_8.printStackTrace();
                                                var12_15 = null;
                                                if (var2_2 != null) {
                                                    ** try [egrp 2[TRYBLOCK] [12 : 423->430)] { 
lbl58:
                                                    // 1 sources

                                                    var2_2.close();
                                                    break block35;
lbl60:
                                                    // 1 sources

                                                    catch (IOException var13_21) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (var3_3 == null) return var4_4;
                                            try {}
                                            catch (IOException var13_21) {
                                                return var4_4;
                                            }
                                            var3_3.close();
                                            return var4_4;
                                        }
                                    }
                                    catch (Throwable var11_29) {
                                        block36: {
                                            var12_16 = null;
                                            if (var2_2 != null) {
                                                ** try [egrp 2[TRYBLOCK] [12 : 423->430)] { 
lbl74:
                                                // 1 sources

                                                var2_2.close();
                                                break block36;
lbl76:
                                                // 1 sources

                                                catch (IOException var13_22) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var3_3 == null) throw var11_29;
                                        ** try [egrp 3[TRYBLOCK] [13 : 436->443)] { 
lbl81:
                                        // 1 sources

                                        var3_3.close();
                                        throw var11_29;
lbl83:
                                        // 1 sources

                                        catch (IOException var13_22) {
                                            // empty catch block
                                        }
                                        throw var11_29;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [12 : 423->430)] { 
lbl88:
                                // 1 sources

                                var2_2.close();
                                break block30;
lbl90:
                                // 1 sources

                                catch (IOException var13_17) {
                                    // empty catch block
                                }
                            }
                            if (var3_3 == null) return var6_9;
                            ** try [egrp 3[TRYBLOCK] [13 : 436->443)] { 
lbl95:
                            // 1 sources

                            var3_3.close();
                            return var6_9;
lbl97:
                            // 1 sources

                            catch (IOException var13_17) {
                                // empty catch block
                            }
                            return var6_9;
                        }
                        var12_12 = null;
                        if (var2_2 != null) {
                            ** try [egrp 2[TRYBLOCK] [12 : 423->430)] { 
lbl104:
                            // 1 sources

                            var2_2.close();
                            break block37;
lbl106:
                            // 1 sources

                            catch (IOException var13_18) {
                                // empty catch block
                            }
                        }
                    }
                    if (var3_3 == null) return var10_28;
                    ** try [egrp 3[TRYBLOCK] [13 : 436->443)] { 
lbl111:
                    // 1 sources

                    var3_3.close();
                    return var10_28;
lbl113:
                    // 1 sources

                    catch (IOException var13_18) {
                        // empty catch block
                    }
                    return var10_28;
                }
                var12_13 = null;
                if (var2_2 != null) {
                    ** try [egrp 2[TRYBLOCK] [12 : 423->430)] { 
lbl120:
                    // 1 sources

                    var2_2.close();
                    break block38;
lbl122:
                    // 1 sources

                    catch (IOException var13_19) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 == null) return var4_4;
            try {}
            catch (IOException var13_19) {}
            var3_3.close();
            return var4_4;
            return var4_4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public byte[] getClassFileBytes(String string) {
            byte[] byArray;
            block20: {
                IOException iOException2222;
                ByteArrayOutputStream byteArrayOutputStream;
                InputStream inputStream;
                block18: {
                    int n;
                    byArray = null;
                    inputStream = null;
                    byteArrayOutputStream = null;
                    String string2 = string.substring(0, string.lastIndexOf(46));
                    string2 = string2 + ".class";
                    inputStream = new FileInputStream(string2);
                    byte[] byArray2 = new byte[4096];
                    byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length);
                    while ((n = inputStream.read(byArray2, 0, byArray2.length)) > 0) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byteArrayOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                    Object var9_9 = null;
                    if (inputStream == null) break block18;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block20;
                {
                    catch (IOException iOException3) {
                        IOException iOException42222;
                        Object var9_10 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException42222) {
                                // empty catch block
                            }
                        }
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException42222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException52222;
                    Object var9_11 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return byArray;
        }
    }

    public class JspCompilationUnit
    implements ICompilationUnit {
        private String sourcePath = null;
        private String jspClassName = null;
        private String sourceFileName = null;

        public JspCompilationUnit(JspResources jspResources) {
            this.sourceFileName = jspResources.getGeneratedSourceFile().getName();
            this.sourcePath = jspResources.getGeneratedSourceFile().getPath();
            this.jspClassName = (jspResources.getPackageName().length() != 0 ? jspResources.getPackageName() + "." : "") + jspResources.getClassName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public char[] getContents() {
            char[] cArray = null;
            Reader reader = null;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.sourcePath), JDTCompiler.this.javaEncoding));
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] cArray2 = new char[4096];
            int n = 0;
            while ((n = reader.read(cArray2, 0, cArray2.length)) > 0) {
                charArrayWriter.write(cArray2, 0, n);
            }
            cArray = charArrayWriter.toCharArray();
            Object var7_7 = null;
            if (reader == null) return cArray;
            try {
                reader.close();
                return cArray;
            }
            catch (IOException iOException) {}
            return cArray;
            {
                catch (IOException iOException) {
                    Object var7_8 = null;
                    if (reader == null) return cArray;
                    try {
                        reader.close();
                        return cArray;
                    }
                    catch (IOException iOException2) {}
                    return cArray;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public char[] getMainTypeName() {
            char[] cArray = null;
            int n = this.jspClassName.lastIndexOf(46);
            cArray = n > 0 ? this.jspClassName.substring(n + 1).toCharArray() : this.jspClassName.toCharArray();
            return cArray;
        }

        public char[][] getPackageName() {
            StringTokenizer stringTokenizer = new StringTokenizer(this.jspClassName, ".");
            char[][] cArrayArray = new char[stringTokenizer.countTokens() - 1][];
            for (int i = 0; i < cArrayArray.length; ++i) {
                String string = stringTokenizer.nextToken();
                cArrayArray[i] = string.toCharArray();
            }
            return cArrayArray;
        }

        public char[] getFileName() {
            return this.sourceFileName.toCharArray();
        }

        public String getJspClassName() {
            return this.jspClassName;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }
    }
}

