/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JspCompilerResultImpl;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JikesJspCompiler
implements JspCompiler {
    protected static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.JikesJspCompiler";
    private static String separatorString;
    protected JspClassloaderContext classloaderContext = null;
    protected JspOptions options = null;
    protected CharArrayWriter out = null;
    protected String fullClasspath = null;
    protected String optimizedClasspath = null;
    protected String sourcepath = null;
    protected boolean isClassDebugInfo = false;
    protected boolean isDebugEnabled = false;
    protected boolean isVerbose = false;
    protected boolean isDeprecation = false;
    protected String jdkSourceLevel = null;
    protected boolean useOptimizedClasspath = false;
    protected String absouluteContextRoot = null;

    public JikesJspCompiler(String string, JspClassloaderContext jspClassloaderContext, JspOptions jspOptions, String string2, boolean bl) {
        this.absouluteContextRoot = string;
        this.classloaderContext = jspClassloaderContext;
        this.optimizedClasspath = string2;
        this.options = jspOptions;
        this.useOptimizedClasspath = bl;
        this.sourcepath = jspOptions.getOutputDir().getPath();
        this.isClassDebugInfo = jspOptions.isClassDebugInfo();
        this.isDebugEnabled = jspOptions.isDebugEnabled();
        this.isVerbose = jspOptions.isVerbose();
        this.isDeprecation = jspOptions.isDeprecation();
        this.jdkSourceLevel = jspOptions.getJdkSourceLevel();
        this.out = new CharArrayWriter();
    }

    public JspCompilerResult compile(JspResources[] jspResourcesArray, JspResources[] jspResourcesArray2, Collection collection, List list) {
        return this.compile(jspResourcesArray[0].getGeneratedSourceFile().getPath(), collection, list);
    }

    public JspCompilerResult compile(String string, Collection collection, List list) {
        boolean bl;
        this.out.reset();
        int n = 0;
        String string2 = null;
        try {
            string2 = new File(System.getProperty("java.home")).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.out.write(iOException.toString(), 0, iOException.toString().length());
            JspCompilerResultImpl jspCompilerResultImpl = new JspCompilerResultImpl(1, this.out.toString());
            return jspCompilerResultImpl;
        }
        this.fullClasspath = this.classloaderContext.getClassPath() + File.pathSeparatorChar + this.options.getOutputDir().getPath();
        this.fullClasspath = this.createJikesClasspath(this.fullClasspath, string2);
        this.optimizedClasspath = this.createJikesClasspath(this.optimizedClasspath, string2);
        String string3 = null;
        boolean bl2 = bl = string.charAt(0) == '@';
        if (!bl) {
            string = "\"" + string + "\"";
        }
        string3 = bl && !this.useOptimizedClasspath ? this.fullClasspath : this.optimizedClasspath;
        n = this.runCompile(string, list, string3);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "rc = " + n + " directoryCompile = " + bl + " useOptimizedClasspath = " + this.useOptimizedClasspath);
        }
        if (n != 0 && !bl && !this.useOptimizedClasspath) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "compile", "Warning: failed to compile " + string + " with optimized classpath [" + string3 + "]");
            }
            this.out.reset();
            n = this.runCompile(string, list, this.fullClasspath);
        }
        String string4 = null;
        if (n != 0 || n == 0 && (this.isVerbose || this.isDeprecation)) {
            string4 = this.out.toString();
            if (n != 0) {
                string4 = this.getJspLineErrors(string4, collection);
            }
        }
        JspCompilerResultImpl jspCompilerResultImpl = new JspCompilerResultImpl(n, string4);
        return jspCompilerResultImpl;
    }

    private int runCompile(String string, List list, String string2) {
        int n = 0;
        List list2 = this.buildArgList(string, list, string2);
        String[] stringArray = new String[list2.size()];
        stringArray = list2.toArray(stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        String string3 = "jikes " + stringBuffer.toString();
        long l = System.currentTimeMillis();
        try {
            Process process = Runtime.getRuntime().exec(string3, null, new File(this.absouluteContextRoot));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                this.out.write(string4 + separatorString);
                string4 = bufferedReader.readLine();
            }
            process.waitFor();
            n = process.exitValue();
        }
        catch (InterruptedException interruptedException) {
            this.out.write(interruptedException.toString(), 0, interruptedException.toString().length());
            n = 1;
        }
        catch (IOException iOException) {
            this.out.write(iOException.toString(), 0, iOException.toString().length());
            n = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compiling " + string);
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "classpath [" + string2 + "]");
        }
        long l2 = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compile complete for " + string + " time = " + (l2 - l) + " Milliseconds rc = " + n);
        }
        return n;
    }

    private List buildArgList(String string, List list, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            arrayList.add("-g");
        }
        if (this.isVerbose) {
            arrayList.add("-verbose");
        }
        if (this.isDeprecation) {
            arrayList.add("-deprecation");
        }
        arrayList.add("-source");
        if (this.jdkSourceLevel.equals("14")) {
            arrayList.add("1.4");
        } else if (this.jdkSourceLevel.equals("15")) {
            arrayList.add("1.5");
        } else {
            arrayList.add("1.3");
        }
        arrayList.add("-sourcepath");
        arrayList.add(this.sourcepath);
        arrayList.add("-classpath");
        arrayList.add(string2);
        arrayList.add("-Xstdout");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                if (string3.equals("-verbose")) {
                    this.isVerbose = true;
                }
                if (string3.equals("-deprecation")) {
                    this.isDeprecation = true;
                }
                arrayList.add(string3);
            }
        }
        arrayList.add(string);
        return arrayList;
    }

    private String createJikesClasspath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2 + File.separator + "lib" + File.separator + "core.jar" + File.pathSeparatorChar);
        stringBuffer.append(string2 + File.separator + "lib" + File.separator + "graphics.jar" + File.pathSeparatorChar);
        stringBuffer.append(string2 + File.separator + "lib" + File.separator + "security.jar" + File.pathSeparatorChar);
        stringBuffer.append(string2 + File.separator + "lib" + File.separator + "server.jar" + File.pathSeparatorChar);
        stringBuffer.append(string2 + File.separator + "lib" + File.separator + "xml.jar" + File.pathSeparatorChar);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getJspLineErrors(String string, Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2 = bufferedReader.readLine();
            int n = -1;
            String string3 = null;
            while (string2 != null) {
                int n2;
                int n3 = string2.indexOf(".java\":");
                if (n3 > 0 && (n2 = string2.indexOf("\"")) > 0) {
                    string3 = string2.substring(n2 + 1, n3 + 5);
                    string3 = string3.replace('\\', '/');
                    string3 = string3.replace('/', File.separatorChar);
                }
                n = string2.indexOf("*** Semantic Warning:");
                if (string3 != null && !string2.startsWith("[read ") && !string2.startsWith("] ") && n < 0) {
                    try {
                        n2 = string2.indexOf(46);
                        if (n2 > 0) {
                            int n4;
                            String string4 = string2.substring(0, n2);
                            String string5 = "";
                            for (n4 = 0; n4 < string4.length(); ++n4) {
                                if (string4.charAt(n4) < '0' || string4.charAt(n4) > '9') continue;
                                string5 = string5 + string4.charAt(n4);
                            }
                            n4 = Integer.parseInt(string5);
                            String string6 = this.findMapping(collection, n4, string3);
                            if (string6 == null) {
                                stringBuffer.append(separatorString);
                            } else {
                                stringBuffer.append(string6);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                stringBuffer.append(string2);
                stringBuffer.append(separatorString);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJspLineErrors", "Failed to find line number mappings for compiler errors", iOException);
        }
        return stringBuffer.toString();
    }

    private String findMapping(Collection collection, int n, String string) {
        String string2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JspLineId jspLineId = (JspLineId)iterator.next();
            if (!jspLineId.getGeneratedFilePath().equals(string)) continue;
            if (jspLineId.getStartGeneratedLineCount() <= 1 && jspLineId.getStartGeneratedLineNum() == n) {
                string2 = this.createErrorMsg(jspLineId, n);
                break;
            }
            if (jspLineId.getStartGeneratedLineNum() > n || jspLineId.getStartGeneratedLineNum() + jspLineId.getStartGeneratedLineCount() - 1 < n) continue;
            string2 = this.createErrorMsg(jspLineId, n);
            break;
        }
        return string2;
    }

    private String createErrorMsg(JspLineId jspLineId, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jspLineId.getSourceLineCount() <= 1) {
            Object[] objectArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
            if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objectArray));
            } else {
                stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objectArray));
            }
        } else {
            int n2 = jspLineId.getStartSourceLineNum() + (n - jspLineId.getStartGeneratedLineNum());
            if (n2 >= jspLineId.getStartSourceLineNum() && n2 <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                Object[] objectArray = new Object[]{new Integer(n2), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objectArray));
                } else {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objectArray));
                }
            } else {
                Object[] objectArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objectArray));
                } else {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objectArray));
                }
            }
        }
        stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}));
        return stringBuffer.toString();
    }

    static {
        separatorString = System.getProperty("line.separator");
        logger = Logger.getLogger("com.ibm.ws.jsp");
    }
}

