/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JspCompilerResultImpl;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.sun.tools.javac.Main;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardJspCompiler
implements JspCompiler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.StandardJspCompiler";
    private static Pattern warningPattern = Pattern.compile("[0-9]+ warning");
    private static String separatorString = System.getProperty("line.separator");
    protected CharArrayWriter out = null;
    protected String fullClasspath = null;
    protected String optimizedClasspath = null;
    protected String sourcepath = null;
    protected boolean isClassDebugInfo = false;
    protected boolean isDebugEnabled = false;
    protected boolean isVerbose = false;
    protected boolean isDeprecation = false;
    protected String jdkSourceLevel = null;
    protected String javaEncoding = null;
    protected boolean useOptimizedClasspath = false;
    protected List compilerFailureFileNames = null;
    protected boolean compileAfterFailure = false;

    public StandardJspCompiler(JspClassloaderContext jspClassloaderContext, JspOptions jspOptions, String string, boolean bl) {
        this.fullClasspath = jspClassloaderContext.getClassPath() + File.pathSeparatorChar + jspOptions.getOutputDir().getPath();
        this.optimizedClasspath = string;
        this.useOptimizedClasspath = bl;
        this.sourcepath = jspOptions.getOutputDir().getPath();
        this.isClassDebugInfo = jspOptions.isClassDebugInfo();
        this.isDebugEnabled = jspOptions.isDebugEnabled();
        this.isVerbose = jspOptions.isVerbose();
        this.isDeprecation = jspOptions.isDeprecation();
        this.javaEncoding = jspOptions.getJavaEncoding();
        this.jdkSourceLevel = jspOptions.getJdkSourceLevel();
        this.compileAfterFailure = jspOptions.isCompileAfterFailure();
        this.out = new CharArrayWriter();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "StandardJspCompiler", "Entering StandardJspCompiler.");
        }
    }

    public JspCompilerResult compile(JspResources[] jspResourcesArray, JspResources[] jspResourcesArray2, Collection collection, List list) {
        return this.compile(jspResourcesArray[0].getGeneratedSourceFile().getPath(), collection, list);
    }

    public JspCompilerResult compile(String string, Collection collection, List list) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering StandardJspCompiler.compile");
        }
        this.out.reset();
        int n = 0;
        this.setCompilerFailureFileNames(null);
        String string2 = null;
        boolean bl = string.charAt(0) == '@';
        string2 = bl && !this.useOptimizedClasspath ? this.fullClasspath : this.optimizedClasspath;
        n = this.runCompile(string, list, string2);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "rc = " + n + " directoryCompile = " + bl + " useOptimizedClasspath = " + this.useOptimizedClasspath);
        }
        String string3 = null;
        if (n != 0 || n == 0 && (this.isVerbose || this.isDeprecation)) {
            string3 = this.out.toString();
            if (n != 0) {
                string3 = this.getJspLineErrors(string3, collection);
            }
        }
        JspCompilerResultImpl jspCompilerResultImpl = new JspCompilerResultImpl(n, string3, this.getCompilerFailureFileNames());
        return jspCompilerResultImpl;
    }

    private int runCompile(String string, List list, String string2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering StandardJspCompiler.runCompile");
        }
        int n = 0;
        List list2 = this.buildArgList(string, list, string2);
        String[] stringArray = new String[list2.size()];
        stringArray = list2.toArray(stringArray);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compiling " + string);
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "classpath [" + string2 + "]");
        }
        long l = System.currentTimeMillis();
        n = Main.compile(stringArray, new PrintWriter(this.out));
        long l2 = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compile complete for " + string + " time = " + (l2 - l) + " Milliseconds rc = " + n);
        }
        return n;
    }

    private List buildArgList(String string, List list, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            arrayList.add("-g");
        }
        if (this.isVerbose) {
            arrayList.add("-verbose");
        }
        if (this.isDeprecation) {
            arrayList.add("-deprecation");
        }
        arrayList.add("-source");
        if (this.jdkSourceLevel.equals("14")) {
            arrayList.add("1.4");
        } else if (this.jdkSourceLevel.equals("15")) {
            arrayList.add("1.5");
        } else {
            arrayList.add("1.3");
        }
        arrayList.add("-encoding");
        arrayList.add(this.javaEncoding);
        arrayList.add("-XDjsrlimit=1000");
        arrayList.add("-sourcepath");
        arrayList.add(this.sourcepath);
        arrayList.add("-classpath");
        arrayList.add(string2);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                if (string3.equals("-verbose")) {
                    this.isVerbose = true;
                }
                if (string3.equals("-deprecation")) {
                    this.isDeprecation = true;
                }
                arrayList.add(string3);
            }
        }
        arrayList.add(string);
        return arrayList;
    }

    public String getJspLineErrors(String string, Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2 = bufferedReader.readLine();
            int n = -1;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (string2 != null) {
                int n2 = string2.indexOf(".java:");
                String string3 = null;
                if (n2 > 0) {
                    string3 = string2.substring(0, n2 + 5);
                    string3 = string3.replace('\\', '/');
                    string3 = string3.replace('/', File.separatorChar);
                }
                int n3 = string2.indexOf(58, 2);
                int n4 = string2.indexOf(58, n3 + 1);
                Matcher matcher = warningPattern.matcher(string2);
                String string4 = null;
                if (matcher.find()) {
                    string4 = matcher.group();
                }
                n = string2.indexOf("warning:");
                if (!(string3 == null || n3 < 0 || n >= 0 || string4 != null || n4 < 0 || string2.startsWith("Note: ") || string2.startsWith("[loaded ") || string2.startsWith("] ") || string2.startsWith("[parsed ") || string2.startsWith("[[parsing started ") || string2.startsWith("[parsing completed ") || string2.startsWith("[loading ") || string2.startsWith("[checking ") || string2.startsWith("[wrote ") || string2.startsWith("[total "))) {
                    try {
                        String string5 = string2.substring(n3 + 1, n4);
                        int n5 = Integer.parseInt(string5);
                        String string6 = this.findMapping(collection, n5, string3);
                        if (string6 == null) {
                            stringBuffer.append(separatorString);
                        } else {
                            stringBuffer.append(string6);
                            if (string3.indexOf(92) != -1) {
                                string3 = string3.replace('\\', '/');
                            }
                            if (this.compileAfterFailure) {
                                arrayList.add("\"" + string3 + "\"");
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                stringBuffer.append(string2);
                stringBuffer.append(separatorString);
                if (n >= 0) {
                    string2 = bufferedReader.readLine();
                    stringBuffer.append(string2);
                    stringBuffer.append(separatorString);
                    string2 = bufferedReader.readLine();
                    stringBuffer.append(string2);
                    stringBuffer.append(separatorString);
                }
                string2 = bufferedReader.readLine();
            }
            if (this.compileAfterFailure) {
                this.setCompilerFailureFileNames(arrayList);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJspLineErrors", "Failed to find line number mappings for compiler errors", iOException);
        }
        return stringBuffer.toString();
    }

    private String findMapping(Collection collection, int n, String string) {
        String string2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JspLineId jspLineId = (JspLineId)iterator.next();
            if (!jspLineId.getGeneratedFilePath().equals(string)) continue;
            if (jspLineId.getStartGeneratedLineCount() <= 1 && jspLineId.getStartGeneratedLineNum() == n) {
                string2 = this.createErrorMsg(jspLineId, n);
                break;
            }
            if (jspLineId.getStartGeneratedLineNum() > n || jspLineId.getStartGeneratedLineNum() + jspLineId.getStartGeneratedLineCount() - 1 < n) continue;
            string2 = this.createErrorMsg(jspLineId, n);
            break;
        }
        return string2;
    }

    private String createErrorMsg(JspLineId jspLineId, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jspLineId.getSourceLineCount() <= 1) {
            Object[] objectArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
            if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objectArray));
            } else {
                stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objectArray));
            }
        } else {
            int n2 = jspLineId.getStartSourceLineNum() + (n - jspLineId.getStartGeneratedLineNum());
            if (n2 >= jspLineId.getStartSourceLineNum() && n2 <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                Object[] objectArray = new Object[]{new Integer(n2), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objectArray));
                } else {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objectArray));
                }
            } else {
                Object[] objectArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objectArray));
                } else {
                    stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objectArray));
                }
            }
        }
        stringBuffer.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}) + separatorString);
        return stringBuffer.toString();
    }

    private void setCompilerFailureFileNames(List list) {
        this.compilerFailureFileNames = list;
    }

    private List getCompilerFailureFileNames() {
        if (this.compilerFailureFileNames != null && logger != null) {
            logger.logp(Level.FINER, "StandardJspCompiler", "getCompilerFailureFileNames", "The following file failed to compile: " + this.compilerFailureFileNames);
        }
        return this.compilerFailureFileNames;
    }
}

