/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.JspDocumentConverter;
import com.ibm.ws.jsp.translator.document.JspDocumentParser;
import com.ibm.ws.jsp.translator.document.JspEncodingScanner;
import com.ibm.ws.jsp.translator.document.JspPageParser;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Jsp2Dom {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.document.Jsp2Dom";
    static final String DEFAULT_ENCODING = "ISO-8859-1";
    static final String CONVERTED_DEFAULT_ENCODING = EncodingUtils.getJvmConverter("ISO-8859-1");
    private Stack directoryStack = null;
    private Stack dependencyStack = null;
    private List dependencyList = null;
    private Map cdataJspIdMap = null;
    private Map implicitTagLibMap = null;
    private JspInputSource jspInputSource = null;
    private String resolvedRelativeURL = null;
    private JspCoreContext context = null;
    private JspConfiguration jspConfiguration = null;
    private JspOptions jspOptions = null;
    private Boolean parentIsXml = null;

    public Jsp2Dom(JspInputSource jspInputSource, JspCoreContext jspCoreContext, JspConfiguration jspConfiguration, JspOptions jspOptions, Map map) {
        this.jspInputSource = jspInputSource;
        this.context = jspCoreContext;
        this.jspConfiguration = jspConfiguration;
        this.directoryStack = new Stack();
        this.directoryStack.push("/");
        this.dependencyStack = new Stack();
        this.dependencyList = new ArrayList();
        this.jspOptions = jspOptions;
        this.cdataJspIdMap = new HashMap();
        this.resolveBaseDir();
        this.implicitTagLibMap = map;
    }

    public Jsp2Dom(JspInputSource jspInputSource, JspCoreContext jspCoreContext, Stack stack, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack stack2, List list, Map map, Map map2, boolean bl) {
        this.jspInputSource = jspInputSource;
        this.context = jspCoreContext;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.directoryStack = stack;
        this.dependencyStack = stack2;
        this.dependencyList = list;
        this.cdataJspIdMap = map;
        this.implicitTagLibMap = map2;
        this.parentIsXml = bl;
        this.resolveBaseDir();
    }

    public Document getJspDocument() throws JspCoreException {
        Document document = null;
        if (this.jspInputSource.isXmlDocument()) {
            document = new JspDocumentConverter(this.jspInputSource, this.resolvedRelativeURL, this.context, this.directoryStack, this.jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap).convert();
            this.jspConfiguration.setIsXml(true);
        } else if (this.jspConfiguration.isXmlSpecified()) {
            document = this.jspConfiguration.isXml() ? this.parseToDom() : this.getJspDocumentAsJspPage(false);
        } else if (this.jspInputSource.getRelativeURL().endsWith(".jspx") || this.jspInputSource.getRelativeURL().endsWith(".tagx")) {
            document = this.parseToDom();
            this.jspConfiguration.setIsXml(true);
        } else {
            document = this.getJspDocumentAsJspPage(true);
        }
        this.directoryStack.pop();
        return document;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document getJspDocumentAsJspPage(boolean bl) throws JspCoreException {
        IOException iOException2;
        BufferedReader bufferedReader;
        InputStream inputStream;
        Document document;
        block28: {
            Object object;
            document = null;
            inputStream = null;
            bufferedReader = null;
            inputStream = this.getInputStream();
            JspEncodingScanner jspEncodingScanner = null;
            if (this.jspConfiguration.getPageEncoding() == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", " Default Encoding = {0}", new Object[]{DEFAULT_ENCODING});
                }
                if (!(jspEncodingScanner = new JspEncodingScanner(bufferedReader = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_ENCODING), 8192))).scan()) {
                    bufferedReader.close();
                    inputStream.close();
                    inputStream = this.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_ENCODING), 8192);
                }
                if (jspEncodingScanner.getEncoding() != null && !jspEncodingScanner.getEncoding().equals(DEFAULT_ENCODING)) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", "Scanned Encoding = {0}", new Object[]{jspEncodingScanner.getEncoding()});
                    }
                    bufferedReader.close();
                    inputStream.close();
                    inputStream = this.getInputStream();
                    object = EncodingUtils.getJvmConverter(jspEncodingScanner.getEncoding());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", "Converted Scanned Encoding = {0}", new Object[]{object});
                    }
                    if (!(jspEncodingScanner = new JspEncodingScanner(bufferedReader = new BufferedReader(new InputStreamReader(inputStream, (String)object), 8192))).scan()) {
                        bufferedReader.close();
                        inputStream.close();
                        inputStream = this.getInputStream();
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, (String)object), 8192);
                    }
                } else if (!CONVERTED_DEFAULT_ENCODING.equals(DEFAULT_ENCODING)) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", "Converted Default Encoding = {0}", new Object[]{CONVERTED_DEFAULT_ENCODING});
                    }
                    bufferedReader.close();
                    inputStream.close();
                    inputStream = this.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, CONVERTED_DEFAULT_ENCODING), 8192);
                }
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", "Jsp Configuration Encoding = {0}", new Object[]{this.jspConfiguration.getPageEncoding()});
                }
                if (!(jspEncodingScanner = new JspEncodingScanner(bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.jspConfiguration.getPageEncoding()), 8192))).scan()) {
                    bufferedReader.close();
                    inputStream.close();
                    inputStream = this.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.jspConfiguration.getPageEncoding()), 8192);
                }
            }
            if (jspEncodingScanner.jspRootFound()) {
                if (!bl) throw new JspCoreException("jsp.error.root.only.in.jsp.document");
                bufferedReader.close();
                inputStream.close();
                bufferedReader = null;
                inputStream = null;
                document = this.parseToDom();
                this.jspConfiguration.setIsXml(true);
            } else {
                object = new JspPageParser(bufferedReader, this.jspInputSource, this.resolvedRelativeURL, this.context, this.directoryStack, this.jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap);
                try {
                    document = ((JspPageParser)object).parse();
                }
                catch (JspCoreException jspCoreException) {
                    throw new JspCoreException(((JspPageParser)object).buildLineNumberMessage(jspCoreException.getLocalizedMessage()));
                }
            }
            Object var9_9 = null;
            if (bufferedReader == null) break block28;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        if (inputStream == null) return document;
        try {
            inputStream.close();
            return document;
        }
        catch (IOException iOException2) {}
        return document;
        {
            catch (IOException iOException3) {
                throw new JspCoreException(iOException3);
            }
        }
        catch (Throwable throwable) {
            IOException iOException42;
            Object var9_10 = null;
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException42) {
                    // empty catch block
                }
            }
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException42) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Document parseToDom() throws JspCoreException {
        Document document = null;
        InputStream inputStream = this.getInputStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            JspDocumentParser jspDocumentParser = new JspDocumentParser(this.jspInputSource, this.resolvedRelativeURL, this.context, this.jspConfiguration, this.jspOptions, this.directoryStack, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap);
            try {
                document = jspDocumentParser.parse(inputSource);
            }
            catch (JspCoreException jspCoreException) {
                throw new JspCoreException(jspDocumentParser.buildLineNumberMessage(jspCoreException.getLocalizedMessage()));
            }
            Object var7_6 = null;
            if (inputStream == null) return document;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return document;
        }
        catch (IOException iOException) {}
        return document;
    }

    protected InputStream getInputStream() throws JspCoreException {
        InputStream inputStream = null;
        try {
            inputStream = this.jspInputSource.getInputStream();
        }
        catch (IOException iOException) {
            String string = JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{this.jspInputSource.getRelativeURL()});
            throw new JspCoreException(string, new FileNotFoundException(string));
        }
        return inputStream;
    }

    private void resolveBaseDir() {
        String string = this.jspInputSource.getRelativeURL();
        if (string.charAt(0) != '/') {
            this.resolvedRelativeURL = (String)this.directoryStack.peek() + string;
            this.jspInputSource = this.context.getJspInputSourceFactory().copyJspInputSource(this.jspInputSource, this.resolvedRelativeURL);
        } else {
            this.resolvedRelativeURL = string;
        }
        String string2 = this.resolvedRelativeURL.substring(0, this.resolvedRelativeURL.lastIndexOf("/") + 1);
        this.directoryStack.push(string2);
    }

    public List getDependencyList() {
        return this.dependencyList;
    }

    public Map getCdataJspIdMap() {
        return this.cdataJspIdMap;
    }
}

