/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JspDocumentConverter {
    private JspInputSource inputSource = null;
    private String resovledRelativeURL = null;
    private String encodedRelativeURL = null;
    private JspCoreContext ctxt = null;
    private JspConfiguration jspConfiguration = null;
    private JspOptions jspOptions = null;
    private Stack directoryStack = null;
    private Stack dependencyStack = null;
    private List dependencyList = null;
    private Map cdataJspIdMap = null;
    private Map implicitTagLibMap = null;
    private String jspPrefix = "jsp";

    public JspDocumentConverter(JspInputSource jspInputSource, String string, JspCoreContext jspCoreContext, Stack stack, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack stack2, List list, Map map, Map map2) {
        this.inputSource = jspInputSource;
        this.resovledRelativeURL = string;
        try {
            this.encodedRelativeURL = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.ctxt = jspCoreContext;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.directoryStack = stack;
        this.dependencyStack = stack2;
        this.dependencyList = list;
        this.cdataJspIdMap = map;
        this.implicitTagLibMap = map2;
    }

    public Document convert() throws JspCoreException {
        Document document = null;
        try {
            document = ParserFactory.newDocument(false, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        this.convertDocument(document, document, this.inputSource.getDocument().getChildNodes());
        return document;
    }

    private void convertDocument(Document document, Node node, NodeList nodeList) throws JspCoreException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node2;
            Node node3 = nodeList.item(i);
            if (node3.getNamespaceURI() != null && node3.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                this.jspPrefix = node3.getPrefix();
            }
            if (node3.getNodeType() == 1) {
                node2 = (Element)node3;
                if (node2.getLocalName() != null && node2.getLocalName().equals("directive.include") && node2.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                    this.insertInclude(document, node2.getParentNode(), node2.getAttribute("file"));
                    continue;
                }
                Node node4 = document.importNode(node3, false);
                object = new StringBuffer();
                NamedNodeMap namedNodeMap = node2.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Attr attr = (Attr)namedNodeMap.item(j);
                    if (attr.getNodeName().startsWith("xmlns")) continue;
                    if (attr.getPrefix() != null) {
                        ((StringBuffer)object).append(attr.getPrefix() + ":" + attr.getLocalName() + "~");
                        continue;
                    }
                    ((StringBuffer)object).append(attr.getLocalName() + "~");
                }
                String string = null;
                string = namedNodeMap.getLength() > 0 ? "{" + ((StringBuffer)object).toString() + "}" + this.encodedRelativeURL + "[0,0,0]" : this.encodedRelativeURL + "[0,0,0]";
                ((Element)node4).setAttributeNS("http://java.sun.com/JSP/Page", this.jspPrefix + ":id", string);
                node.appendChild(node4);
                this.convertDocument(document, node4, node3.getChildNodes());
                continue;
            }
            if (node3.getNodeType() == 4) {
                boolean bl = false;
                boolean bl2 = false;
                if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && node.getLocalName().equals("text")) {
                    bl = true;
                }
                object = (CDATASection)node3;
                for (int j = 0; j < object.getLength(); ++j) {
                    char c = object.getData().charAt(j);
                    if (c == '\n' || c == ' ' || c == '\r' || c == '\t') continue;
                    bl2 = true;
                }
                if (bl2) {
                    Node node5 = document.importNode(node3, false);
                    node.appendChild(node5);
                    continue;
                }
                if (!bl) continue;
                Node node6 = document.importNode(node3, false);
                node.appendChild(node6);
                continue;
            }
            if (node3.getNodeType() == 3) {
                boolean bl = false;
                boolean bl3 = false;
                if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && node.getLocalName().equals("text")) {
                    bl = true;
                }
                object = (Text)node3;
                for (int j = 0; j < object.getLength(); ++j) {
                    char c = object.getData().charAt(j);
                    if (c == '\n' || c == ' ' || c == '\r' || c == '\t') continue;
                    bl3 = true;
                }
                if (bl3) {
                    CDATASection cDATASection = document.createCDATASection(object.getData());
                    node.appendChild(cDATASection);
                    continue;
                }
                if (!bl) continue;
                CDATASection cDATASection = document.createCDATASection(object.getData());
                node.appendChild(cDATASection);
                continue;
            }
            node2 = document.importNode(node3, false);
            node.appendChild(node2);
            this.convertDocument(document, node2, node3.getChildNodes());
        }
    }

    private void insertInclude(Document document, Node node, String string) throws JspCoreException {
        Object object;
        String string2 = this.ctxt.getRealPath(string);
        if (this.dependencyStack.contains(string2)) {
            throw new JspCoreException("jsp.error.static.include.circular.dependency", new Object[]{string2});
        }
        this.dependencyStack.push(string2);
        if (this.inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            object = string;
            if (!((String)object).startsWith("/")) {
                int n = this.resovledRelativeURL.lastIndexOf("/");
                object = n > 0 ? this.resovledRelativeURL.substring(0, n + 1) + (String)object : "/" + (String)object;
            }
            this.dependencyList.add(object);
        }
        object = this.jspConfiguration.getConfigManager().getConfigurationForStaticInclude(string, this.jspConfiguration);
        JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.inputSource, string);
        Jsp2Dom jsp2Dom = new Jsp2Dom(jspInputSource, this.ctxt, this.directoryStack, (JspConfiguration)object, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap, true);
        Document document2 = jsp2Dom.getJspDocument();
        if (document2.getDocumentElement().getNamespaceURI() != null && document2.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/JSP/Page") && document2.getDocumentElement().getLocalName().equals("root")) {
            for (int i = 0; i < document2.getDocumentElement().getChildNodes().getLength(); ++i) {
                Integer n;
                Node node2 = document2.getDocumentElement().getChildNodes().item(i);
                Node node3 = document.importNode(node2, true);
                if (node2.getNodeType() == 4 && this.cdataJspIdMap.containsKey(n = new Integer(node2.hashCode()))) {
                    String string3 = (String)this.cdataJspIdMap.remove(n);
                    this.cdataJspIdMap.put(new Integer(node3.hashCode()), string3);
                }
                node.appendChild(node3);
            }
        } else {
            for (int i = 0; i < document2.getChildNodes().getLength(); ++i) {
                Node node4 = document.importNode(document2.getChildNodes().item(i), true);
                node.appendChild(node4);
            }
        }
        this.dependencyStack.pop();
    }

    public void printElements(Element element, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println("Element - " + element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            for (int j = 0; j < n; ++j) {
                System.out.print("\t");
            }
            System.out.println("Attr - " + attr.getName() + " : " + attr.getValue() + " : " + attr.getNamespaceURI());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node;
            Node node2 = nodeList.item(i);
            if (node2 instanceof Element) {
                node = (Element)node2;
                System.out.println();
                this.printElements((Element)node, n + 1);
                continue;
            }
            if (node2 instanceof CDATASection) {
                System.out.println();
                node = (CDATASection)node2;
                for (int j = 0; j < n + 1; ++j) {
                    System.out.print("\t");
                }
                string = node.getData();
                string = string.replaceAll("\r", "");
                string = string.replaceAll("\n", "{cr}");
                System.out.println("CDATA - [" + string + "]");
                continue;
            }
            if (!(node2 instanceof Text)) continue;
            System.out.println();
            node = (Text)node2;
            for (int j = 0; j < n + 1; ++j) {
                System.out.print("\t");
            }
            string = node.getData();
            string = string.replaceAll("\r", "");
            string = string.replaceAll("\n", "{cr}");
            System.out.println("Text - [" + string + "]");
        }
    }
}

