/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.ws.util.WSUtil;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class JspDocumentParser
extends DefaultHandler
implements LexicalHandler {
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String DTD_FOUND_MESSAGE = "dtd has been found";
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.document.JspDocumentParser";
    protected Locator locator;
    protected int textLineNum = 0;
    protected int textColNum = 0;
    protected int lastLineNum = 1;
    protected int lastColNum = 1;
    protected Document document = null;
    protected JspCoreContext ctxt = null;
    protected SAXParser saxParser = null;
    protected Stack elementStack = new Stack();
    protected Stack directoryStack = null;
    protected Stack dependencyStack = null;
    protected List dependencyList = null;
    protected Map cdataJspIdMap = null;
    protected Map implicitTagLibMap = null;
    protected HashMap tagPrefixes = new HashMap();
    protected JspConfiguration jspConfiguration = null;
    protected JspOptions jspOptions = null;
    protected JspInputSource inputSource = null;
    protected String resolvedRelativeURL = null;
    protected String encodedRelativeURL = null;
    protected String encoding = null;
    protected Stack charsBuffers = new Stack();
    protected boolean inDTD = false;
    protected List preRootCommentList = new ArrayList();
    protected boolean pageEncodingSpecified = false;
    protected String jspPrefix = "jsp";
    protected boolean isValidating = false;

    public JspDocumentParser(JspInputSource jspInputSource, String string, JspCoreContext jspCoreContext, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack stack, Stack stack2, List list, Map map, Map map2) throws JspCoreException {
        this.inputSource = jspInputSource;
        this.ctxt = jspCoreContext;
        this.directoryStack = stack;
        this.dependencyStack = stack2;
        this.dependencyList = list;
        this.cdataJspIdMap = map;
        this.implicitTagLibMap = map2;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.resolvedRelativeURL = string;
        try {
            this.encodedRelativeURL = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JspCoreException(unsupportedEncodingException);
        }
        if (this.implicitTagLibMap != null && this.implicitTagLibMap.size() > 0) {
            this.tagPrefixes.putAll(map2);
        }
    }

    public Document parse(InputSource inputSource) throws JspCoreException {
        try {
            this.document = ParserFactory.newDocument(false, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        this.elementStack.push(this.document);
        if (this.parse(false, inputSource)) {
            this.parse(true, inputSource);
        }
        return this.document;
    }

    protected boolean parse(boolean bl, InputSource inputSource) throws JspCoreException {
        boolean bl2;
        block10: {
            this.isValidating = bl;
            bl2 = false;
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(JspDocumentParser.class.getClassLoader());
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                sAXParserFactory.setValidating(bl);
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.saxParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = this.saxParser.getXMLReader();
                xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY, this);
                xMLReader.setErrorHandler(this);
                ParserFactory.parseDocument(this.saxParser, inputSource, (DefaultHandler)this);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new JspCoreException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                if (sAXException.getMessage().equals(DTD_FOUND_MESSAGE)) {
                    bl2 = true;
                    break block10;
                }
                if (sAXException.getCause() != null) {
                    throw new JspCoreException(this.buildLineNumberMessage(sAXException.getCause().getLocalizedMessage()));
                }
                throw new JspCoreException(this.buildLineNumberMessage(sAXException.getLocalizedMessage()));
            }
            catch (IOException iOException) {
                throw new JspCoreException(this.buildLineNumberMessage(iOException.getLocalizedMessage()));
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
        }
        return bl2;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        if (this.encoding == null) {
            object3 = null;
            try {
                object3 = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                if (object3 != null) {
                    this.encoding = (String)((Method)object3).invoke((Object)this.locator, null);
                    if (this.jspConfiguration.getPageEncoding() != null && !this.compareEncoding(this.jspConfiguration.getPageEncoding(), this.encoding)) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.xml", new Object[]{this.jspConfiguration.getPageEncoding(), this.encoding}));
                    }
                }
            }
            catch (SecurityException securityException) {
                logger.logp(Level.WARNING, CLASS_NAME, "startElement", this.buildLineNumberMessage("failed to determine encoding for jsp element"), securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.logp(Level.WARNING, CLASS_NAME, "startElement", this.buildLineNumberMessage("failed to determine encoding for jsp element"), noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.logp(Level.WARNING, CLASS_NAME, "startElement", this.buildLineNumberMessage("failed to determine encoding for jsp element"), invocationTargetException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.logp(Level.WARNING, CLASS_NAME, "startElement", this.buildLineNumberMessage("failed to determine encoding for jsp element"), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.logp(Level.WARNING, CLASS_NAME, "startElement", this.buildLineNumberMessage("failed to determine encoding for jsp element"), illegalAccessException);
            }
        }
        if (string2.equals("directive.include") && string.equals("http://java.sun.com/JSP/Page")) {
            try {
                String string4;
                object3 = null;
                boolean bl = false;
                if (attributes.getLength() > 0 && !(string4 = attributes.getLocalName(0)).equals("")) {
                    if (!string4.equals("file")) {
                        throw new JspCoreException("jsp.error.include.directive.attribute.invalid", new Object[]{string4});
                    }
                    object3 = attributes.getValue("file");
                    bl = true;
                }
                if (!bl || ((String)object3).equals("")) {
                    throw new JspCoreException("jsp.error.static.include.value.missing");
                }
                this.insertInclude((String)object3);
            }
            catch (JspCoreException jspCoreException) {
                throw new SAXException(jspCoreException.getLocalizedMessage());
            }
        }
        object3 = (Node)this.elementStack.peek();
        if (this.charsBuffers.size() > 0) {
            object2 = (CharacterBuffer)this.charsBuffers.peek();
            this.createJspTextElement((Node)object3, ((CharacterBuffer)object2).charsBuffer);
            ((CharacterBuffer)object2).charsBuffer.delete(0, ((CharacterBuffer)object2).charsBuffer.length());
            ((CharacterBuffer)object2).clearNonWhiteSpaceFound();
        }
        object2 = new StringBuffer();
        Element element = this.document.createElementNS(string, string3);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).startsWith("xmlns")) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                if (attributes.getValue(i).equals("http://java.sun.com/JSP/Page")) {
                    this.jspPrefix = attributes.getQName(i).substring(attributes.getQName(i).indexOf("xmlns:") + 6);
                    continue;
                }
                object = attributes.getQName(i).substring(attributes.getQName(i).indexOf("xmlns:") + 6);
                if (((String)object).equals("")) continue;
                this.tagPrefixes.put(object, attributes.getValue(i));
                continue;
            }
            element.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
            if (!attributes.getURI(i).equals("")) {
                ((StringBuffer)object2).append(attributes.getURI(i) + ":" + attributes.getQName(i) + "~");
                continue;
            }
            ((StringBuffer)object2).append(attributes.getQName(i) + "~");
        }
        String string5 = null;
        string5 = !string.equals("http://java.sun.com/JSP/Page") && ((StringBuffer)object2).length() > 0 ? "{" + ((StringBuffer)object2).toString() + "}" + this.encodedRelativeURL + "[" + this.lastLineNum + "," + this.lastColNum + "," + (this.locator.getLineNumber() - (this.lastLineNum - 1)) + "]" : this.encodedRelativeURL + "[" + this.lastLineNum + "," + this.lastColNum + "," + (this.locator.getLineNumber() - (this.lastLineNum - 1)) + "]";
        element.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", string5);
        if (string.equals("http://java.sun.com/JSP/Page") && string2.equals("directive.page") && element.hasAttribute("pageEncoding")) {
            if (!this.pageEncodingSpecified) {
                this.pageEncodingSpecified = true;
                if (this.jspConfiguration.getPageEncoding() != null) {
                    if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), this.encoding)) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.xml", new Object[]{this.jspConfiguration.getPageEncoding(), this.encoding}));
                    }
                    if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), element.getAttribute("pageEncoding"))) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.pageencoding", new Object[]{this.jspConfiguration.getPageEncoding(), element.getAttribute("pageEncoding")}));
                    }
                }
                if (!this.compareEncoding(element.getAttribute("pageEncoding"), this.encoding)) {
                    throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.pageencoding.xml", new Object[]{element.getAttribute("pageEncoding"), this.encoding}));
                }
                if (this.jspConfiguration.getPageEncoding() == null) {
                    this.jspConfiguration.setPageEncoding(this.encoding);
                }
            } else {
                throw new SAXException(JspCoreException.getMsg("jsp.error.page.pageencoding.dup", new Object[]{this.resolvedRelativeURL}));
            }
        }
        object3.appendChild(element);
        this.elementStack.push(element);
        if (object3 instanceof Document) {
            object = this.preRootCommentList.iterator();
            while (object.hasNext()) {
                Element element2 = (Element)object.next();
                element.appendChild(element2);
            }
            if (this.jspConfiguration.getPreludeList().size() > 0) {
                try {
                    this.insertImplictIncludes(this.jspConfiguration.getPreludeList());
                }
                catch (JspCoreException jspCoreException) {
                    throw new SAXException(jspCoreException.getLocalizedMessage());
                }
            }
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        this.charsBuffers.push(new CharacterBuffer());
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object object;
        Node node = (Node)this.elementStack.peek();
        boolean bl = false;
        if (node instanceof Element && (object = (Element)node).getNamespaceURI() != null && object.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && object.getLocalName().equals("text")) {
            bl = true;
        }
        object = new StringBuffer();
        this.textLineNum = this.locator.getLineNumber();
        this.textColNum = this.locator.getColumnNumber();
        CharacterBuffer characterBuffer = (CharacterBuffer)this.charsBuffers.peek();
        for (int i = 0; i < n2; ++i) {
            ((StringBuffer)object).append(cArray[n + i]);
            if (cArray[n + i] == '\n' || cArray[n + i] == ' ' || cArray[n + i] == '\r' || cArray[n + i] == '\t') continue;
            characterBuffer.setNonWhiteSpaceFound();
        }
        if (characterBuffer.isNonWhiteSpaceFound() || bl) {
            characterBuffer.charsBuffer.append((StringBuffer)object);
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Node node = null;
        CharacterBuffer characterBuffer = (CharacterBuffer)this.charsBuffers.pop();
        if (string.equals("http://java.sun.com/JSP/Page")) {
            if (string2.equals("declaration") || string2.equals("expression") || string2.equals("scriptlet")) {
                String string4 = characterBuffer.charsBuffer.toString();
                CDATASection cDATASection = this.document.createCDATASection(string4);
                node = (Node)this.elementStack.pop();
                node.appendChild(cDATASection);
            } else if (!string2.equals("directive.include")) {
                node = this.getJspElement();
                this.createJspTextElement(node, characterBuffer.charsBuffer);
            }
        } else {
            node = this.getJspElement();
            this.createJspTextElement(node, characterBuffer.charsBuffer);
        }
        if (node != null && node.getParentNode() instanceof Document) {
            this.elementStack.push(node);
            if (this.jspConfiguration.getCodaList().size() > 0) {
                try {
                    this.insertImplictIncludes(this.jspConfiguration.getCodaList());
                }
                catch (JspCoreException jspCoreException) {
                    throw new SAXException(jspCoreException.getLocalizedMessage());
                }
            }
            this.elementStack.pop();
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        characterBuffer = null;
    }

    public void createJspTextElement(Node node, StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        if (stringBuffer.length() > 0) {
            CDATASection cDATASection = this.document.createCDATASection(string);
            node.appendChild(cDATASection);
            String string2 = this.encodedRelativeURL + "[" + this.textLineNum + "," + this.textColNum + "," + this.getLineCount(string) + "]";
            this.cdataJspIdMap.put(new Integer(cDATASection.hashCode()), string2);
        }
    }

    public Node getJspElement() {
        Node node = (Node)this.elementStack.pop();
        if (node.hasChildNodes()) {
            Element element = (Element)node;
            String string = element.getAttributeNS("http://java.sun.com/JSP/Page", "id");
            string = string + "[" + this.lastLineNum + "," + this.lastColNum + "]";
            element.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", string);
        }
        return node;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.inDTD) {
            // empty if block
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
        CharacterBuffer characterBuffer = (CharacterBuffer)this.charsBuffers.peek();
        characterBuffer.clearNonWhiteSpaceFound();
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
        if (!this.isValidating) {
            throw new SAXException(DTD_FOUND_MESSAGE);
        }
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private void insertInclude(String string) throws JspCoreException {
        String string2;
        if (!string.startsWith("/")) {
            int n = this.resolvedRelativeURL.lastIndexOf("/");
            string = n > 0 ? WSUtil.resolveURI((String)(this.resolvedRelativeURL.substring(0, n + 1) + string)) : WSUtil.resolveURI((String)("/" + string));
        }
        if (this.dependencyStack.contains(string2 = this.ctxt.getRealPath(string))) {
            throw new JspCoreException("jsp.error.static.include.circular.dependency", new Object[]{string2});
        }
        this.dependencyStack.push(string2);
        if (this.inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.dependencyList.add(string);
        }
        JspConfiguration jspConfiguration = this.jspConfiguration.getConfigManager().getConfigurationForStaticInclude(string, this.jspConfiguration);
        JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.inputSource, string);
        HashMap hashMap = new HashMap(this.implicitTagLibMap);
        hashMap.putAll(this.tagPrefixes);
        Jsp2Dom jsp2Dom = new Jsp2Dom(jspInputSource, this.ctxt, this.directoryStack, jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, hashMap, true);
        Document document = jsp2Dom.getJspDocument();
        Node node = (Node)this.elementStack.peek();
        if (document.getDocumentElement().getNamespaceURI() != null && document.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/JSP/Page") && document.getDocumentElement().getLocalName().equals("root")) {
            for (int i = 0; i < document.getDocumentElement().getChildNodes().getLength(); ++i) {
                Integer n;
                Node node2 = document.getDocumentElement().getChildNodes().item(i);
                Node node3 = this.document.importNode(node2, true);
                if (node2.getNodeType() == 4 && this.cdataJspIdMap.containsKey(n = new Integer(node2.hashCode()))) {
                    String string3 = (String)this.cdataJspIdMap.remove(n);
                    this.cdataJspIdMap.put(new Integer(node3.hashCode()), string3);
                }
                node.appendChild(node3);
            }
        } else {
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                Node node4 = this.document.importNode(document.getChildNodes().item(i), true);
                node.appendChild(node4);
            }
        }
        this.dependencyStack.pop();
    }

    private int getLineCount(String string) {
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private boolean compareEncoding(String string, String string2) {
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else if (string.startsWith("UTF-16") && string2.startsWith("UTF-16")) {
            bl = true;
        }
        return bl;
    }

    public String buildLineNumberMessage(String string) {
        string = this.resolvedRelativeURL + "(" + this.lastLineNum + "," + this.lastColNum + ") " + string;
        return string;
    }

    private void insertImplictIncludes(ArrayList arrayList) throws JspCoreException {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.insertInclude(string);
        }
    }

    private class CharacterBuffer {
        StringBuffer charsBuffer = new StringBuffer();
        private boolean nonWhiteSpaceFound = false;

        private CharacterBuffer() {
        }

        public boolean isNonWhiteSpaceFound() {
            return this.nonWhiteSpaceFound;
        }

        public void setNonWhiteSpaceFound() {
            this.nonWhiteSpaceFound = true;
        }

        public void clearNonWhiteSpaceFound() {
            this.nonWhiteSpaceFound = false;
        }
    }
}

