/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.optimizedtag;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagConfig;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OptimizedTagConfigParser
extends DefaultHandler {
    public static final String DTD_PUBLIC_ID = "http://www.ibm.com/xml/ns/OptimizedTag.xsd";
    public static final String DTD_RESOURCE_PATH = "/com/ibm/ws/jsp/translator/optimizedtag/OptimizedTag.xsd";
    protected SAXParser saxParser = null;
    protected JspCoreContext ctxt = null;
    protected StringBuffer chars = null;
    protected Map optimizedTagConfigMap = new HashMap();
    protected OptimizedTagConfig optimizedTagConfig = null;
    protected String className = null;
    protected String uri = null;
    protected String version = null;
    protected String shortName = null;

    public OptimizedTagConfigParser(JspCoreContext jspCoreContext) throws JspCoreException {
        this.ctxt = jspCoreContext;
        try {
            this.saxParser = ParserFactory.newSAXParser(false, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JspCoreException(sAXException);
        }
    }

    public Map parse(InputStream inputStream) throws JspCoreException {
        this.optimizedTagConfigMap.clear();
        try {
            ParserFactory.parseDocument(this.saxParser, inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getCause() != null) {
                throw new JspCoreException(sAXException.getCause());
            }
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            throw new JspCoreException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.optimizedTagConfigMap);
        return hashMap;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars = new StringBuffer();
        if (string3.equals("optimized-tag")) {
            this.optimizedTagConfig = new OptimizedTagConfig();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        for (int i = 0; i < n2; ++i) {
            if (this.chars == null) continue;
            this.chars.append(cArray[n + i]);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("class-name")) {
            this.className = this.chars.toString().trim();
        } else if (string3.equals("short-name")) {
            this.shortName = this.chars.toString().trim();
        } else if (string3.equals("taglib-uri")) {
            this.uri = this.chars.toString().trim();
        } else if (string3.equals("tlib-version")) {
            this.version = this.chars.toString().trim();
        } else if (string3.equals("optimized-tag")) {
            try {
                Class<?> clazz = Class.forName(this.className, true, this.ctxt.getJspClassloaderContext().getClassLoader());
                this.optimizedTagConfig.setOptClass(clazz);
                this.optimizedTagConfig.setShortName(this.shortName);
                this.optimizedTagConfig.setTlibUri(this.uri);
                this.optimizedTagConfig.setTlibversion(this.version);
                this.optimizedTagConfigMap.put(this.uri + this.version + this.shortName, this.optimizedTagConfig);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXException(classNotFoundException);
            }
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        String string3 = null;
        if (string.equals(DTD_PUBLIC_ID)) {
            string3 = DTD_RESOURCE_PATH;
        }
        if (string3 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (inputStream == null) {
                throw new SAXException("jsp.error.internal.dtd.not.found");
            }
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }
}

