/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceUtil {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.resource.ResourceUtil";

    public static void sync(File file, File file2, File file3, String string, boolean bl, boolean bl2) {
        boolean bl3;
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "sync", "Synching for sourceFile [" + file + "] ts [" + file.lastModified() + "]");
        }
        if (!bl2) {
            bl3 = file3.delete();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (bl3 ? "Deleted" : "Unable to delete") + " classFile [" + file3 + "]");
            }
            File[] fileArray = file2.getParentFile().listFiles(new InnerclassFilenameFilter(string));
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                boolean bl4 = fileArray[i].delete();
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (bl4 ? "Deleted" : "Unable to delete") + " inner classFile [" + fileArray[i] + "]");
            }
        } else {
            bl3 = file3.setLastModified(file.lastModified());
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (bl3 ? "Updated" : "Unable to update") + " lastModified timestamp for classFile [" + file3 + "] [" + file3.lastModified() + "]");
            }
        }
        if (file2.exists()) {
            if (!bl) {
                bl3 = file2.delete();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sync", (bl3 ? "Deleted" : "Unable to delete") + " generatedSourceFile [" + file2 + "]");
                }
            } else {
                bl3 = file2.setLastModified(file.lastModified());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sync", (bl3 ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + file2 + "] [" + file2.lastModified() + "]");
                }
            }
        }
    }

    public static boolean isOutdated(File file, File file2, File file3, File file4) {
        boolean bl = true;
        if (file != null) {
            if (!file.exists()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isOutdated", "sourceFile [" + file + "] does not exist");
                }
                return true;
            }
            if (file3.exists()) {
                if (file.lastModified() == file3.lastModified()) {
                    bl = false;
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile [" + file + "]");
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "classFile [" + file3 + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "isOutdated", "sourceFile ts [" + file.lastModified() + "] differs from tempDirClassFile ts [" + file3.lastModified() + "]. Recompile JSP.");
                }
            } else if (file4.exists()) {
                if (file.lastModified() == file4.lastModified()) {
                    bl = false;
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile [" + file + "]");
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "webinfClassFile [" + file4 + "]");
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile ts [" + file.lastModified() + "] differs from webinfClassFile ts [" + file4.lastModified() + "]. Recompile JSP.");
                }
            }
            if (bl && !file2.getParentFile().exists()) {
                boolean bl2 = file2.getParentFile().mkdirs();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", (bl2 ? "Created" : "Unable to create") + " directory for generated source file [" + file2.getParentFile() + "]");
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isTagFileOutdated(File file, File file2, File file3, File file4) {
        boolean bl = true;
        if (!file.exists()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + file + "] does not exist");
            }
            return true;
        }
        if (file2.exists()) {
            if (file.lastModified() == file2.lastModified()) {
                bl = false;
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + file + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "generatedSourceFile [" + file2 + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + file.lastModified() + "] differs from generatedSourceFile ts [" + file2.lastModified() + "]. Recompile tag file.");
            }
        } else if (file3.exists()) {
            if (file.lastModified() == file3.lastModified()) {
                bl = false;
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + file + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "classFile [" + file3 + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + file.lastModified() + "] differs from tempDirClassFile ts [" + file3.lastModified() + "]. Recompile tag file.");
            }
        } else if (file4.exists()) {
            if (file.lastModified() == file4.lastModified()) {
                bl = false;
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + file + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "webinfClassFile [" + file4 + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + file.lastModified() + "] differs from webinfClassFile ts [" + file4.lastModified() + "]. Recompile tag file.");
            }
        }
        if (bl && !file2.getParentFile().exists()) {
            boolean bl2 = file2.getParentFile().mkdirs();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", (bl2 ? "Created" : "Unable to create") + " directory for generated source file [" + file2.getParentFile() + "]");
            }
        }
        return bl;
    }

    public static void syncGeneratedSource(File file, File file2) {
        if (file2.exists()) {
            boolean bl = file2.setLastModified(file.lastModified());
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "syncGeneratedSource", (bl ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + file2 + "] [" + file2.lastModified() + "]");
            }
        }
    }

    public static void syncTagFile(File file, File file2, File file3, boolean bl, boolean bl2) {
        if (file.lastModified() == file2.lastModified()) {
            boolean bl3;
            if (!bl2) {
                bl3 = file3.delete();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (bl3 ? "Deleted" : "Unable to delete") + " classFile [" + file3 + "]");
                }
            } else {
                bl3 = file3.setLastModified(file.lastModified());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (bl3 ? "Updated" : "Unable to update") + " lastModified timestamp for classFile [" + file3 + "] [" + file3.lastModified() + "]");
                }
            }
            if (file2.exists()) {
                if (!bl) {
                    bl3 = file2.delete();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (bl3 ? "Deleted" : "Unable to delete") + " generatedSourceFile [" + file2 + "]");
                    }
                } else {
                    bl3 = file2.setLastModified(file.lastModified());
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (bl3 ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + file2 + "] [" + file2.lastModified() + "]");
                    }
                }
            }
        }
    }

    private static class InnerclassFilenameFilter
    implements FilenameFilter {
        String filename = null;

        public InnerclassFilenameFilter(String string) {
            this.filename = string;
        }

        public boolean accept(File file, String string) {
            String string2;
            int n = string.indexOf("$");
            return n > -1 && this.filename.equals(string2 = string.substring(0, n));
        }
    }
}

