/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.utils.FileLocker;
import com.ibm.ws.jsp.translator.utils.JspTranslationResult;
import com.ibm.ws.jsp.translator.utils.SDEInstaller;
import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.smap.SmapVisitorResult;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspClassFactory;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagFileInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JspTranslatorUtil {
    private static final String JSP_TRANSLATION_ID = "JspTranslation";
    private static final String DEBUG_JSP_TRANSLATION_ID = "DebugJspTranslation";
    private static final String TAGFILE_TRANSLATION_ID = "TagFileTranslation";
    private static final String DEBUG_TAGFILE_TRANSLATION_ID = "DebugTagFileTranslation";
    private static String separatorString = System.getProperty("line.separator");
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JspCompilerResult translateJspAndCompile(JspResources jspResources, JspTranslationContext jspTranslationContext, JspConfiguration jspConfiguration, JspOptions jspOptions, TagLibraryCache tagLibraryCache, boolean bl, List list) throws JspCoreException {
        boolean bl2 = true;
        boolean bl3 = jspOptions.isZOS();
        JspCompilerResult jspCompilerResult = null;
        long l = System.currentTimeMillis();
        FileLocker fileLocker = null;
        if (bl3 && (fileLocker = (FileLocker)new JspClassFactory().getInstanceOf("FileLocker")) != null) {
            bl2 = fileLocker.obtainFileLock(jspResources.getInputSource().getRelativeURL());
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "obtainFileLock [" + jspResources.getInputSource().getRelativeURL() + "] -> [" + bl2 + "]");
            }
        }
        if (bl2) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "begin translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                }
                JspTranslationResult jspTranslationResult = null;
                try {
                    jspTranslationResult = JspTranslatorUtil.translateJsp(jspResources, jspTranslationContext, jspConfiguration, jspOptions, tagLibraryCache, bl, list);
                }
                catch (JspTranslationException jspTranslationException) {
                    String string = jspTranslationException.getFilePath();
                    JspTranslationException jspTranslationException2 = null;
                    if (string != null && !string.equals(jspResources.getInputSource().getRelativeURL())) {
                        jspTranslationException2 = new JspTranslationException("jsp.error.exception.caught.translating.included.file", new Object[]{jspResources.getInputSource().getRelativeURL(), separatorString + jspTranslationException.getLocalizedMessage() + separatorString});
                    } else {
                        String string2 = jspResources.getInputSource().getRelativeURL() + ":  " + separatorString + jspTranslationException.getLocalizedMessage() + separatorString;
                        jspTranslationException2 = new JspTranslationException("jsp.error.exception.caught.translating", new Object[]{string2});
                    }
                    jspTranslationException2.setStackTrace(jspTranslationException.getStackTrace());
                    throw jspTranslationException2;
                }
                long l2 = System.currentTimeMillis();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "completed translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "] time = " + (l2 - l) + "ms");
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "translateJspAndCompile", "begin compile phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                }
                if (jspTranslationResult.getTagFileCompileResult() != null && jspTranslationResult.getTagFileCompileResult().getCompilerReturnValue() != 0) {
                    jspCompilerResult = jspTranslationResult.getTagFileCompileResult();
                } else {
                    JspResources[] jspResourcesArray = null;
                    if (jspTranslationResult.getTagFileDependencyList().size() > 0) {
                        jspResourcesArray = new JspResources[jspTranslationResult.getTagFileDependencyList().size()];
                        jspResourcesArray = jspTranslationResult.getTagFileDependencyList().toArray(jspResourcesArray);
                    }
                    JspCompiler jspCompiler = jspTranslationContext.getJspCompilerFactory().createJspCompiler();
                    jspCompilerResult = jspCompiler.compile(new JspResources[]{jspResources}, jspResourcesArray, jspTranslationResult.getJspLineIds(), list);
                    boolean bl4 = false;
                    if (jspCompilerResult.getCompilerReturnValue() == 0) {
                        if (jspOptions.isVerbose() || jspOptions.isDeprecation() || list != null && (list.contains("-verbose") || list.contains("-deprecation"))) {
                            bl4 = true;
                        }
                        if (jspTranslationResult.hasSmap()) {
                            SmapGenerator smapGenerator = jspTranslationResult.getSmapGenerator(jspResources.getInputSource().getAbsoluteURL().toExternalForm());
                            JspTranslatorUtil.installSmap(jspResources, smapGenerator);
                        }
                        jspResources.sync();
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "translateJspAndCompile", "complete compile phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                    }
                    if (bl4 && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "translateJspAndCompile", "[" + jspCompilerResult.getCompilerMessage() + "]");
                    }
                }
                Object var21_22 = null;
                if (!bl3 || fileLocker == null) return jspCompilerResult;
                fileLocker.releaseFileLock(jspResources.getInputSource().getRelativeURL());
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                if (!bl3 || fileLocker == null) throw throwable;
                fileLocker.releaseFileLock(jspResources.getInputSource().getRelativeURL());
                if (!logger.isLoggable(Level.FINE)) throw throwable;
                logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "releaseFileLock");
                throw throwable;
            }
            if (!logger.isLoggable(Level.FINE)) return jspCompilerResult;
            logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "releaseFileLock");
            return jspCompilerResult;
        }
        if (!logger.isLoggable(Level.FINE)) return jspCompilerResult;
        logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "Failed translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
        return jspCompilerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JspTranslationResult translateJsp(JspResources jspResources, JspTranslationContext jspTranslationContext, JspConfiguration jspConfiguration, JspOptions jspOptions, TagLibraryCache tagLibraryCache, boolean bl, List list) throws JspCoreException {
        Object object;
        JspTranslator jspTranslator;
        HashMap hashMap;
        JspTranslationResult jspTranslationResult = new JspTranslationResult();
        ArrayList arrayList = new ArrayList();
        JspVisitorInputMap jspVisitorInputMap = new JspVisitorInputMap();
        jspVisitorInputMap.put("TagFileDependencies", arrayList);
        jspVisitorInputMap.put("TagLibraryCache", tagLibraryCache);
        jspVisitorInputMap.put("JspFiles", jspResources);
        jspVisitorInputMap.put("JspOptions", jspOptions);
        jspVisitorInputMap.put("JspUri", jspResources.getInputSource().getRelativeURL());
        String string = JSP_TRANSLATION_ID;
        String string2 = TAGFILE_TRANSLATION_ID;
        if (jspOptions.isDebugEnabled()) {
            string = DEBUG_JSP_TRANSLATION_ID;
            string2 = DEBUG_TAGFILE_TRANSLATION_ID;
        }
        if ((hashMap = (jspTranslator = JspTranslatorFactory.getFactory().createTranslator(string, jspResources.getInputSource(), jspTranslationContext, jspConfiguration, jspOptions, tagLibraryCache.getImplicitTagLibPrefixMap())).processVisitors(jspVisitorInputMap)).containsKey("Smap")) {
            object = (SmapVisitorResult)hashMap.get("Smap");
            jspTranslationResult.addSmapGenerator(jspResources.getInputSource().getAbsoluteURL().toExternalForm(), ((SmapVisitorResult)object).getSmapGenerator());
        }
        jspTranslationResult.addJspLineIds(jspResources, jspTranslator.getDocument());
        if (arrayList.size() > 0) {
            object = tagLibraryCache.getTagFileLock(arrayList);
            try {
                Object object2 = object;
                synchronized (object2) {
                    Object object3;
                    JspResources[] jspResourcesArray;
                    Object object4;
                    ArrayList<TagFileResources> arrayList2 = new ArrayList<TagFileResources>();
                    ArrayList<TagFileResources> arrayList3 = new ArrayList<TagFileResources>();
                    ArrayList arrayList4 = new ArrayList();
                    JspResources[] jspResourcesArray2 = arrayList.iterator();
                    while (jspResourcesArray2.hasNext()) {
                        object4 = (TagFileId)jspResourcesArray2.next();
                        jspResourcesArray = tagLibraryCache.getTagLibraryInfo(((TagFileId)object4).getUri(), ((TagFileId)object4).getPrefix(), jspResources.getInputSource().getRelativeURL());
                        object3 = jspResourcesArray.getTagFile(((TagFileId)object4).getTagName());
                        JspInputSource jspInputSource = jspTranslationContext.getJspInputSourceFactory().copyJspInputSource(jspResourcesArray.getInputSource(), object3.getPath());
                        TagFileResources tagFileResources = jspTranslationContext.getJspResourcesFactory().createTagFileResources(jspInputSource, (TagFileInfo)object3);
                        tagFileResources = tagLibraryCache.getTagFileResources(tagFileResources);
                        jspTranslationResult.getTagFileDependencyList().add(tagFileResources);
                        if (bl && !tagFileResources.getGeneratedSourceFile().getParentFile().exists()) {
                            tagFileResources.getGeneratedSourceFile().getParentFile().mkdirs();
                        }
                        if (bl || tagFileResources.isOutdated()) {
                            JspConfiguration jspConfiguration2 = jspConfiguration.createEmptyJspConfiguration();
                            jspConfiguration2.setElIgnored(jspConfiguration.elIgnored());
                            JspTranslator jspTranslator2 = JspTranslatorFactory.getFactory().createTranslator(string2, jspInputSource, jspTranslationContext, jspConfiguration2, jspOptions, tagLibraryCache.getImplicitTagLibPrefixMap());
                            JspVisitorInputMap jspVisitorInputMap2 = new JspVisitorInputMap();
                            jspVisitorInputMap2.put("JspOptions", jspOptions);
                            jspVisitorInputMap2.put("TagLibraryCache", tagLibraryCache);
                            jspVisitorInputMap2.put("TagFileFiles", tagFileResources);
                            jspVisitorInputMap2.put("TagFileInfo", object3);
                            jspVisitorInputMap2.put("isTagFile", new Boolean(true));
                            jspVisitorInputMap2.put("JspUri", jspResources.getInputSource().getRelativeURL());
                            HashMap hashMap2 = jspTranslator2.processVisitors(jspVisitorInputMap2);
                            if (hashMap2.containsKey("Smap")) {
                                SmapVisitorResult smapVisitorResult = (SmapVisitorResult)hashMap2.get("Smap");
                                jspTranslationResult.addSmapGenerator(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm(), smapVisitorResult.getSmapGenerator());
                            }
                            JspTranslationResult.loadJspIdList(tagFileResources, jspTranslator2.getDocument().getDocumentElement(), arrayList4);
                            tagFileResources.syncGeneratedSource();
                            arrayList2.add(tagFileResources);
                            continue;
                        }
                        arrayList3.add(tagFileResources);
                    }
                    if (arrayList2.size() > 0) {
                        jspResourcesArray2 = new JspResources[arrayList2.size()];
                        jspResourcesArray2 = arrayList2.toArray(jspResourcesArray2);
                        object4 = jspTranslationContext.getJspCompilerFactory().createJspCompiler();
                        jspResourcesArray = null;
                        if (arrayList3.size() > 0) {
                            jspResourcesArray = new JspResources[arrayList3.size()];
                            jspResourcesArray = arrayList3.toArray(jspResourcesArray);
                        }
                        object3 = object4.compile(jspResourcesArray2, jspResourcesArray, arrayList4, list);
                        jspTranslationResult.setTagFileCompileResult((JspCompilerResult)object3);
                        JspTranslatorUtil.syncTagFileFiles(jspOptions, arrayList2, jspTranslationResult);
                    }
                }
            }
            finally {
                tagLibraryCache.releaseTagFileLock(arrayList);
            }
        }
        return jspTranslationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncTagFileFiles(JspOptions jspOptions, List list, JspTranslationResult jspTranslationResult) throws JspCoreException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TagFileResources tagFileResources;
            TagFileResources tagFileResources2 = tagFileResources = (TagFileResources)iterator.next();
            synchronized (tagFileResources2) {
                tagFileResources.sync();
                if (jspTranslationResult.hasSmap()) {
                    SmapGenerator smapGenerator = jspTranslationResult.getSmapGenerator(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm());
                    JspTranslatorUtil.installSmap(tagFileResources, smapGenerator);
                }
            }
        }
    }

    public static void installSmap(JspResources jspResources, SmapGenerator smapGenerator) throws JspCoreException {
        int n = jspResources.getGeneratedSourceFile().getPath().lastIndexOf(".java");
        String string = jspResources.getGeneratedSourceFile().getPath().substring(0, n) + ".class";
        File file = new File(string);
        if (smapGenerator != null) {
            try {
                SDEInstaller.install(file, smapGenerator);
            }
            catch (IOException iOException) {
                throw new JspCoreException(iOException);
            }
        }
    }

    public static void printTagFileFiles(List list) throws JspCoreException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TagFileResources tagFileResources = (TagFileResources)iterator.next();
            System.out.println("JspTranslatorUtil printTagFileFiles() " + tagFileResources.toString());
        }
    }

    public static boolean isExpression(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression", "token = [" + string + "]");
        }
        boolean bl = JspTranslatorUtil.isExpression(string, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression", "returning = [" + bl + "]");
        }
        return bl;
    }

    public static boolean isExpression(String string, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = "%=";
            string2 = "%";
        } else {
            string3 = "<%=";
            string2 = "%>";
        }
        return string.startsWith(string3) && string.endsWith(string2);
    }

    public static boolean isELInterpreterInput(String string, JspConfiguration jspConfiguration) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput", "value= [" + string + "]");
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput", "jspConfiguration.elIgnored() =[" + jspConfiguration.elIgnored() + "]");
        }
        boolean bl = false;
        if (!jspConfiguration.elIgnored()) {
            int n = string.indexOf("${");
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput", "index= [" + n + "]");
            }
            if (n != -1) {
                char c = ' ';
                if (n > 0) {
                    c = string.charAt(n - 1);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput", "prevChar= [" + c + "]");
                }
                if (c != '\\') {
                    bl = true;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput", "isELValue= [" + bl + "]");
                }
            }
        }
        return bl;
    }

    public static void printAllElements(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Document document = (Document)hashMap.get(string);
            JspTranslatorUtil.printElements(document.getDocumentElement(), 0);
        }
    }

    public static void printElements(Element element, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println("Element - " + element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            for (int j = 0; j < n; ++j) {
                System.out.print("\t");
            }
            System.out.println("Attr - " + attr.getName() + " : " + attr.getValue() + " : " + attr.getNamespaceURI());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            if (node2 instanceof Element) {
                node = (Element)node2;
                System.out.println();
                JspTranslatorUtil.printElements((Element)node, n + 1);
                continue;
            }
            if (!(node2 instanceof CDATASection)) continue;
            System.out.println();
            node = (CDATASection)node2;
            for (int j = 0; j < n + 1; ++j) {
                System.out.print("\t");
            }
            String string = node.getData();
            string = string.replaceAll("\r", "");
            string = string.replaceAll("\n", "{cr}");
            System.out.println("CDATA - [" + string + "]");
        }
    }

    public static Class toClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        String string2 = string;
        if (string2.endsWith("[]")) {
            string2 = string2.substring(0, string2.indexOf("[]"));
            string2 = "[L" + string2 + ";";
        }
        return classLoader.loadClass(string2);
    }

    public static boolean hasJspBody(Element element) {
        boolean bl = false;
        boolean bl2 = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (element2 = (Element)node).getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element2.getLocalName().equals("body") || !element2.hasChildNodes()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean hasBody(Element element) {
        boolean bl = false;
        NodeList nodeList = element.getChildNodes();
        boolean bl2 = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                if (element2.getNamespaceURI() != null && element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                    if (element2.getLocalName().equals("attribute") || element2.getLocalName().equals("body")) {
                        bl2 = true;
                        continue;
                    }
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (node.getNodeType() != 4) continue;
            bl = true;
        }
        if (bl2 && bl) {
            bl = false;
        }
        return bl;
    }
}

