/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import java.io.File;
import java.util.StringTokenizer;

public class NameMangler {
    public static String[] keywords;
    public static String[] keywordsSlash;

    public static final String mangleName(String string) {
        int n = string.lastIndexOf(47) + 1;
        int n2 = string.length();
        String string2 = string.substring(n, n2);
        if (string.endsWith(".jsp")) {
            string2 = string2.substring(0, string2.length() - 4);
        } else if (string.indexOf(".") > -1) {
            string2 = string2.replace('.', '_');
        }
        return NameMangler.mangleString(string2);
    }

    public static final String mangleClassName(String string) {
        return "_" + NameMangler.mangleName(string);
    }

    public static final String mangleChar(char c) {
        return NameMangler.mangleChar(c, false);
    }

    public static final String mangleChar(char c, boolean bl) {
        if (c == File.separatorChar) {
            c = (char)47;
        }
        if (!bl && Character.isLetterOrDigit(c)) {
            return "" + c;
        }
        return "_" + Integer.toHexString(c).toUpperCase() + "_";
    }

    public static String mangleString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '/') {
                stringBuffer.append(string.substring(i, i + 1));
                continue;
            }
            stringBuffer.append(NameMangler.mangleChar(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String handlePackageName(String string) {
        string = string.replace('\\', '/');
        String string2 = NameMangler.mangleString(string);
        string = NameMangler.handleReservedWords(string2.toString());
        string = NameMangler.removeLeadingSlashes(new StringBuffer(string));
        string = NameMangler.handlePackageStartingWithDigits(string);
        return NameMangler.convertFileSepCharToPackageChar(string);
    }

    public static String handlePackageStartingWithDigits(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Character.isDigit(string2.charAt(0))) {
                stringBuffer.append(NameMangler.mangleChar(string2.charAt(0), true));
                stringBuffer.append(string2.substring(1));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String removeLeadingSlashes(StringBuffer stringBuffer) {
        int n = 0;
        while (stringBuffer.charAt(n) == '/') {
            ++n;
        }
        String string = stringBuffer.toString();
        return string.substring(n);
    }

    public static String convertFileSepCharToPackageChar(String string) {
        if (string != null) {
            String string2;
            string = string.replace('.', '_');
            string = string.replace('\\', '/');
            string = string2 = string.replace('/', '.');
        }
        return string;
    }

    public static String handleReservedWords(String string) {
        String string2 = "/";
        for (int i = 0; i < keywords.length; ++i) {
            boolean bl;
            boolean bl2 = bl = string.indexOf(keywordsSlash[i]) > -1 || string.startsWith(keywords[i]);
            if (!bl) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(keywords[i])) {
                    String string4 = NameMangler.mangleChar(string3.charAt(0), true);
                    String string5 = string3.substring(1);
                    stringBuffer.append(string4 + string5);
                    continue;
                }
                stringBuffer.append(string3);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static {
        String[] stringArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        keywords = stringArray;
        keywordsSlash = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            NameMangler.keywordsSlash[i] = "/" + stringArray[i];
        }
    }
}

