/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SDEInstaller {
    private static final boolean verbose = false;
    static final String nameSDE = "SourceDebugExtension";
    byte[] orig;
    byte[] sdeAttr;
    byte[] gen;
    int origPos = 0;
    int genPos = 0;
    int sdeIndex;

    static void install(File file, SmapGenerator smapGenerator) throws IOException {
        File file2 = new File(file.getPath() + "tmp");
        new SDEInstaller(file, smapGenerator, file2);
        if (!file.delete()) {
            throw new IOException("inOutClassFile.delete() failed");
        }
        if (!file2.renameTo(file)) {
            throw new IOException("tmpFile.renameTo(inOutClassFile) failed");
        }
    }

    SDEInstaller(File file, SmapGenerator smapGenerator, File file2) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("no such file: " + file);
        }
        this.orig = SDEInstaller.readWhole(file);
        this.sdeAttr = smapGenerator.toString().getBytes("UTF-8");
        this.gen = new byte[this.orig.length + this.sdeAttr.length + 100];
        this.addSDE();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(this.gen, 0, this.genPos);
        fileOutputStream.close();
    }

    static byte[] readWhole(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        if (fileInputStream.read(byArray, 0, n) != n) {
            throw new IOException("expected size: " + n);
        }
        fileInputStream.close();
        return byArray;
    }

    void addSDE() throws UnsupportedEncodingException, IOException {
        this.copy(8);
        int n = this.genPos;
        int n2 = this.readU2();
        this.writeU2(n2);
        this.sdeIndex = this.copyConstantPool(n2);
        if (this.sdeIndex < 0) {
            this.writeUtf8ForSDE();
            this.sdeIndex = n2++;
            this.randomAccessWriteU2(n, n2);
        }
        this.copy(6);
        int n3 = this.readU2();
        this.writeU2(n3);
        this.copy(n3 * 2);
        this.copyMembers();
        this.copyMembers();
        int n4 = this.genPos;
        int n5 = this.readU2();
        this.writeU2(n5);
        if (!this.copyAttrs(n5)) {
            this.randomAccessWriteU2(n4, ++n5);
        }
        this.writeAttrForSDE(this.sdeIndex);
    }

    void copyMembers() {
        int n = this.readU2();
        this.writeU2(n);
        for (int i = 0; i < n; ++i) {
            this.copy(6);
            int n2 = this.readU2();
            this.writeU2(n2);
            this.copyAttrs(n2);
        }
    }

    boolean copyAttrs(int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = this.readU2();
            if (n2 == this.sdeIndex) {
                bl = true;
                continue;
            }
            this.writeU2(n2);
            int n3 = this.readU4();
            this.writeU4(n3);
            this.copy(n3);
        }
        return bl;
    }

    void writeAttrForSDE(int n) {
        this.writeU2(n);
        this.writeU4(this.sdeAttr.length);
        for (int i = 0; i < this.sdeAttr.length; ++i) {
            this.writeU1(this.sdeAttr[i]);
        }
    }

    void randomAccessWriteU2(int n, int n2) {
        int n3 = this.genPos;
        this.genPos = n;
        this.writeU2(n2);
        this.genPos = n3;
    }

    int readU1() {
        return this.orig[this.origPos++] & 0xFF;
    }

    int readU2() {
        int n = this.readU1();
        return (n << 8) + this.readU1();
    }

    int readU4() {
        int n = this.readU2();
        return (n << 16) + this.readU2();
    }

    void writeU1(int n) {
        this.gen[this.genPos++] = (byte)n;
    }

    void writeU2(int n) {
        this.writeU1(n >> 8);
        this.writeU1(n & 0xFF);
    }

    void writeU4(int n) {
        this.writeU2(n >> 16);
        this.writeU2(n & 0xFFFF);
    }

    void copy(int n) {
        for (int i = 0; i < n; ++i) {
            this.gen[this.genPos++] = this.orig[this.origPos++];
        }
    }

    byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.orig[this.origPos++];
        }
        return byArray;
    }

    void writeBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.gen[this.genPos++] = byArray[i];
        }
    }

    int copyConstantPool(int n) throws UnsupportedEncodingException, IOException {
        int n2 = -1;
        block6: for (int i = 1; i < n; ++i) {
            int n3 = this.readU1();
            this.writeU1(n3);
            switch (n3) {
                case 7: 
                case 8: {
                    this.copy(2);
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.copy(4);
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++i;
                    continue block6;
                }
                case 1: {
                    int n4 = this.readU2();
                    this.writeU2(n4);
                    byte[] byArray = this.readBytes(n4);
                    String string = new String(byArray, "UTF-8");
                    if (string.equals(nameSDE)) {
                        n2 = i;
                    }
                    this.writeBytes(byArray);
                    continue block6;
                }
                default: {
                    throw new IOException("unexpected tag: " + n3);
                }
            }
        }
        return n2;
    }

    void writeUtf8ForSDE() {
        int n = nameSDE.length();
        this.writeU1(1);
        this.writeU2(n);
        for (int i = 0; i < n; ++i) {
            this.writeU1(nameSDE.charAt(i));
        }
    }
}

