/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import java.util.ArrayList;
import java.util.List;

public class SmapStratum {
    private String stratumName;
    private List fileNameList;
    private List filePathList;
    private List lineData;
    private int lastFileID;

    public SmapStratum(String string) {
        this.stratumName = string;
        this.fileNameList = new ArrayList();
        this.filePathList = new ArrayList();
        this.lineData = new ArrayList();
        this.lastFileID = 0;
    }

    public void addFile(String string) {
        this.addFile(string, null);
    }

    public synchronized void addFile(String string, String string2) {
        int n = this.fileNameList.indexOf(string);
        if (n == -1) {
            this.fileNameList.add(string);
            this.filePathList.add(string2);
        }
    }

    public synchronized void addLineData(int n, String string, int n2, int n3, int n4) {
        int n5 = this.fileNameList.indexOf(string);
        if (n5 == -1) {
            throw new IllegalArgumentException("inputFileName: " + string);
        }
        LineInfo lineInfo = new LineInfo();
        lineInfo.setInputStartLine(n);
        lineInfo.setInputLineCount(n2);
        lineInfo.setOutputStartLine(n3);
        lineInfo.setOutputLineIncrement(n4);
        if (n5 != this.lastFileID) {
            lineInfo.setLineFileID(n5);
        }
        this.lastFileID = n5;
        this.lineData.add(lineInfo);
    }

    public String getStratumName() {
        return this.stratumName;
    }

    public synchronized String getString() {
        int n;
        if (this.fileNameList.size() == 0 || this.lineData.size() == 0) {
            throw new IllegalStateException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*S " + this.stratumName + "\n");
        stringBuffer.append("*F\n");
        int n2 = this.fileNameList.size();
        for (n = 0; n < n2; ++n) {
            if (this.filePathList.get(n) != null) {
                stringBuffer.append("+ " + n + " " + this.fileNameList.get(n) + "\n");
                stringBuffer.append(this.filePathList.get(n) + "\n");
                continue;
            }
            stringBuffer.append(n + " " + this.fileNameList.get(n) + "\n");
        }
        stringBuffer.append("*L\n");
        n2 = this.lineData.size();
        for (n = 0; n < n2; ++n) {
            LineInfo lineInfo = (LineInfo)this.lineData.get(n);
            stringBuffer.append(lineInfo.getString());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    public static class LineInfo {
        private int inputStartLine = -1;
        private int outputStartLine = -1;
        private int lineFileID = 0;
        private int inputLineCount = 1;
        private int outputLineIncrement = 1;
        private boolean lineFileIDSet = false;

        public void setInputStartLine(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.inputStartLine = n;
        }

        public void setOutputStartLine(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.outputStartLine = n;
        }

        public void setLineFileID(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.lineFileID = n;
            this.lineFileIDSet = true;
        }

        public void setInputLineCount(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.inputLineCount = n;
        }

        public void setOutputLineIncrement(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.outputLineIncrement = n;
        }

        public String getString() {
            if (this.inputStartLine == -1 || this.outputStartLine == -1) {
                throw new IllegalStateException();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.inputStartLine);
            if (this.lineFileIDSet) {
                stringBuffer.append("#" + this.lineFileID);
            }
            if (this.inputLineCount != 1) {
                stringBuffer.append("," + this.inputLineCount);
            }
            stringBuffer.append(":" + this.outputStartLine);
            if (this.outputLineIncrement != 1) {
                stringBuffer.append("," + this.outputLineIncrement);
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }

        public String toString() {
            return this.getString();
        }
    }
}

