/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JspVisitor {
    protected JspVisitorUsage visitorUsage = null;
    protected JspConfiguration jspConfiguration = null;
    protected JspCoreContext context = null;
    protected HashMap resultMap = null;
    protected JspVisitorInputMap inputMap = null;
    protected int visitCount = 0;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.JspVisitor";

    public JspVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        this.visitorUsage = jspVisitorUsage;
        this.jspConfiguration = jspConfiguration;
        this.context = jspCoreContext;
        this.resultMap = hashMap;
        this.inputMap = jspVisitorInputMap;
    }

    protected abstract void visitJspRootStart(Element var1) throws JspCoreException;

    protected abstract void visitJspRootEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspTextStart(Element var1) throws JspCoreException;

    protected abstract void visitJspTextEnd(Element var1) throws JspCoreException;

    protected abstract void visitIncludeDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitIncludeDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitPageDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitPageDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitTagDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitTagDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitAttributeDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitAttributeDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitVariableDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitVariableDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspDeclarationStart(Element var1) throws JspCoreException;

    protected abstract void visitJspDeclarationEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspExpressionStart(Element var1) throws JspCoreException;

    protected abstract void visitJspExpressionEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspScriptletStart(Element var1) throws JspCoreException;

    protected abstract void visitJspScriptletEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspParamStart(Element var1) throws JspCoreException;

    protected abstract void visitJspParamEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspParamsStart(Element var1) throws JspCoreException;

    protected abstract void visitJspParamsEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspFallbackStart(Element var1) throws JspCoreException;

    protected abstract void visitJspFallbackEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspIncludeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspIncludeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspForwardStart(Element var1) throws JspCoreException;

    protected abstract void visitJspForwardEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspUseBeanStart(Element var1) throws JspCoreException;

    protected abstract void visitJspUseBeanEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspGetPropertyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspGetPropertyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspSetPropertyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspSetPropertyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspPluginStart(Element var1) throws JspCoreException;

    protected abstract void visitJspPluginEnd(Element var1) throws JspCoreException;

    protected abstract void visitCustomTagStart(Element var1) throws JspCoreException;

    protected abstract void visitCustomTagEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspAttributeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspAttributeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspElementStart(Element var1) throws JspCoreException;

    protected abstract void visitJspElementEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspBodyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspBodyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspInvokeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspInvokeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspDoBodyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspDoBodyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspOutputStart(Element var1) throws JspCoreException;

    protected abstract void visitJspOutputEnd(Element var1) throws JspCoreException;

    protected abstract void visitUninterpretedTagStart(Element var1) throws JspCoreException;

    protected abstract void visitUninterpretedTagEnd(Element var1) throws JspCoreException;

    protected abstract void visitCDataTag(CDATASection var1) throws JspCoreException;

    public abstract JspVisitorResult getResult() throws JspCoreException;

    public void visit(Document document, int n) throws JspCoreException {
        this.visitCount = n;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "jspNodes.item(i) =[" + nodeList.item(i) + "]");
            }
            Node node = nodeList.item(i);
            this.processJspElement(node);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processJspElement(Node node) throws JspCoreException {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String string = element.getNamespaceURI();
            String string2 = element.getLocalName();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "jspElement =[" + element + "]  namespaceURI= [" + string + "] jspElementType= [ " + string2 + "]");
            }
            if (string != null && string.equals("http://java.sun.com/JSP/Page")) {
                if (string2.equals("root")) {
                    this.visitJspRootStart(element);
                    this.processChildren(element);
                    this.visitJspRootEnd(element);
                    return;
                } else if (string2.equals("text")) {
                    this.visitJspTextStart(element);
                    this.processChildren(element);
                    this.visitJspTextEnd(element);
                    return;
                } else if (string2.equals("directive.include")) {
                    this.visitIncludeDirectiveStart(element);
                    this.processChildren(element);
                    this.visitIncludeDirectiveEnd(element);
                    return;
                } else if (string2.equals("directive.page")) {
                    this.visitPageDirectiveStart(element);
                    this.processChildren(element);
                    this.visitPageDirectiveEnd(element);
                    return;
                } else if (string2.equals("directive.tag")) {
                    this.visitTagDirectiveStart(element);
                    this.processChildren(element);
                    this.visitTagDirectiveEnd(element);
                    return;
                } else if (string2.equals("directive.attribute")) {
                    this.visitAttributeDirectiveStart(element);
                    this.processChildren(element);
                    this.visitAttributeDirectiveEnd(element);
                    return;
                } else if (string2.equals("directive.variable")) {
                    this.visitVariableDirectiveStart(element);
                    this.processChildren(element);
                    this.visitVariableDirectiveEnd(element);
                    return;
                } else if (string2.equals("declaration")) {
                    this.visitJspDeclarationStart(element);
                    this.processChildren(element);
                    this.visitJspDeclarationEnd(element);
                    return;
                } else if (string2.equals("expression")) {
                    this.visitJspExpressionStart(element);
                    this.processChildren(element);
                    this.visitJspExpressionEnd(element);
                    return;
                } else if (string2.equals("scriptlet")) {
                    this.visitJspScriptletStart(element);
                    this.processChildren(element);
                    this.visitJspScriptletEnd(element);
                    return;
                } else if (string2.equals("param")) {
                    this.visitJspParamStart(element);
                    this.processChildren(element);
                    this.visitJspParamEnd(element);
                    return;
                } else if (string2.equals("params")) {
                    this.visitJspParamsStart(element);
                    this.processChildren(element);
                    this.visitJspParamsEnd(element);
                    return;
                } else if (string2.equals("fallback")) {
                    this.visitJspFallbackStart(element);
                    this.processChildren(element);
                    this.visitJspFallbackEnd(element);
                    return;
                } else if (string2.equals("include")) {
                    this.visitJspIncludeStart(element);
                    this.processChildren(element);
                    this.visitJspIncludeEnd(element);
                    return;
                } else if (string2.equals("forward")) {
                    this.visitJspForwardStart(element);
                    this.processChildren(element);
                    this.visitJspForwardEnd(element);
                    return;
                } else if (string2.equals("useBean")) {
                    this.visitJspUseBeanStart(element);
                    this.processChildren(element);
                    this.visitJspUseBeanEnd(element);
                    return;
                } else if (string2.equals("getProperty")) {
                    this.visitJspGetPropertyStart(element);
                    this.processChildren(element);
                    this.visitJspGetPropertyEnd(element);
                    return;
                } else if (string2.equals("setProperty")) {
                    this.visitJspSetPropertyStart(element);
                    this.processChildren(element);
                    this.visitJspSetPropertyEnd(element);
                    return;
                } else if (string2.equals("plugin")) {
                    this.visitJspPluginStart(element);
                    this.processChildren(element);
                    this.visitJspPluginEnd(element);
                    return;
                } else if (string2.equals("attribute")) {
                    this.visitJspAttributeStart(element);
                    this.processChildren(element);
                    this.visitJspAttributeEnd(element);
                    return;
                } else if (string2.equals("element")) {
                    this.visitJspElementStart(element);
                    this.processChildren(element);
                    this.visitJspElementEnd(element);
                    return;
                } else if (string2.equals("body")) {
                    this.visitJspBodyStart(element);
                    this.processChildren(element);
                    this.visitJspBodyEnd(element);
                    return;
                } else if (string2.equals("invoke")) {
                    this.visitJspInvokeStart(element);
                    this.processChildren(element);
                    this.visitJspInvokeEnd(element);
                    return;
                } else if (string2.equals("doBody")) {
                    this.visitJspDoBodyStart(element);
                    this.processChildren(element);
                    this.visitJspDoBodyEnd(element);
                    return;
                } else {
                    if (!string2.equals("output")) throw new JspTranslationException(element, "jsp.error.element.unknown", new Object[]{element.getTagName()});
                    this.visitJspOutputStart(element);
                    this.processChildren(element);
                    this.visitJspOutputEnd(element);
                }
                return;
            } else if (element.getTagName().indexOf(58) != -1) {
                this.visitCustomTagStart(element);
                this.processChildren(element);
                this.visitCustomTagEnd(element);
                return;
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call visitUninterpretedTagStart(jspElement), jspElement =[" + element + "]");
                }
                this.visitUninterpretedTagStart(element);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call processChildren(jspElement), jspElement =[" + element + "]");
                }
                this.processChildren(element);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call visitUninterpretedTagEnd(jspElement), jspElement =[" + element + "]");
                }
                this.visitUninterpretedTagEnd(element);
            }
            return;
        } else {
            if (node.getNodeType() != 4) return;
            CDATASection cDATASection = (CDATASection)node;
            Node node2 = node.getParentNode();
            if (node2.getNamespaceURI() != null && node2.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                if (node2.getLocalName().equals("text") || node2.getLocalName().equals("expression") || node2.getLocalName().equals("declaration") || node2.getLocalName().equals("scriptlet")) return;
                this.visitCDataTag(cDATASection);
                return;
            } else {
                this.visitCDataTag(cDATASection);
            }
        }
    }

    private void processChildren(Node node) throws JspCoreException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            this.processJspElement(node2);
        }
    }
}

