/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.configuration;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorCollection;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorConfiguration;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorDefinition;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VisitorConfigParser
extends DefaultHandler {
    public static final String DTD_PUBLIC_ID = "http://www.ibm.com/xml/ns/JspVisitorConfiguration.xsd";
    public static final String DTD_RESOURCE_PATH = "/com/ibm/ws/jsp/translator/visitor/configuration/JspVisitorConfiguration.xsd";
    protected SAXParser saxParser = null;
    protected JspVisitorUsage visitorUsage = null;
    protected JspVisitorCollection visitorCollection = null;
    protected JspVisitorDefinition visitorDefinition = null;
    protected JspVisitorConfiguration visitorConfiguration = null;
    protected String className = null;
    protected String resultType = null;
    protected StringBuffer chars = null;
    protected ClassLoader cl = null;

    public VisitorConfigParser(ClassLoader classLoader) throws JspCoreException {
        this.cl = classLoader;
        try {
            this.saxParser = ParserFactory.newSAXParser(false, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JspCoreException(sAXException);
        }
    }

    public JspVisitorConfiguration parse(InputStream inputStream) throws JspCoreException {
        this.visitorConfiguration = new JspVisitorConfiguration();
        try {
            ParserFactory.parseDocument(this.saxParser, inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getCause() != null) {
                throw new JspCoreException(sAXException.getCause());
            }
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            throw new JspCoreException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return this.visitorConfiguration;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars = new StringBuffer();
        if (string3.equals("jsp-visitor-collection")) {
            this.visitorCollection = new JspVisitorCollection();
            this.visitorCollection.setId(attributes.getValue("id"));
        } else if (string3.equals("jsp-visitor-definition")) {
            this.visitorDefinition = new JspVisitorDefinition();
            this.visitorDefinition.setId(attributes.getValue("id"));
        } else if (string3.equals("jsp-visitor")) {
            int n = 1;
            int n2 = 1;
            try {
                n = Integer.valueOf(attributes.getValue("order"));
                n2 = Integer.valueOf(attributes.getValue("visits"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string4 = attributes.getValue("id");
            this.visitorUsage = new JspVisitorUsage(n, n2, this.visitorConfiguration.getJspVisitorDefinition(string4));
            this.visitorCollection.getJspVisitorUsageList().add(this.visitorUsage);
            this.visitorUsage = null;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        for (int i = 0; i < n2; ++i) {
            if (this.chars == null) continue;
            this.chars.append(cArray[n + i]);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("class-name")) {
            this.className = this.chars.toString().trim();
        } else if (string3.equals("result-type")) {
            this.resultType = this.chars.toString().trim();
        } else if (string3.equals("jsp-visitor-collection")) {
            this.visitorConfiguration.addJspVisitorCollection(this.visitorCollection);
            this.visitorCollection = null;
        } else if (string3.equals("jsp-visitor-definition")) {
            try {
                Class<?> clazz = Class.forName(this.className, true, this.cl);
                Class<?> clazz2 = Class.forName(this.resultType, true, this.cl);
                this.visitorDefinition.setVisitorClass(clazz);
                this.visitorDefinition.setVisitorResultClass(clazz2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string4 = JspCoreException.getMsg("jsp.error.failed.load.jsp-visitor-definition");
                throw new SAXException(string4, classNotFoundException);
            }
            this.visitorConfiguration.addJspVisitorDefinition(this.visitorDefinition);
            this.visitorDefinition = null;
            this.className = null;
            this.resultType = null;
        }
        this.chars = null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        String string3 = null;
        if (string.equals(DTD_PUBLIC_ID)) {
            string3 = DTD_RESOURCE_PATH;
        }
        if (string3 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (inputStream == null) {
                throw new SAXException(JspCoreException.getMsg("jsp.error.internal.dtd.not.found"));
            }
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }
}

