/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.CleanupTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateJspResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateVisitor;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.InitTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.JavaFileWriter;
import com.ibm.ws.jsp.translator.visitor.generator.MethodWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateJspResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateJspVisitor
extends GenerateVisitor {
    protected GenerateJspResult result = null;
    protected ArrayList interfaces = new ArrayList();
    protected String jspServletBase = "com.ibm.ws.jsp.runtime.HttpJspBase";
    protected String serviceMethodName = "_jspService";
    protected String jspClassName = null;
    protected String jspPackageName = null;
    protected String jspSourceFileName = null;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GenerateJspVisitor";

    public GenerateJspVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        super(jspVisitorUsage, jspConfiguration, jspCoreContext, hashMap, jspVisitorInputMap, "JspValidate");
        this.result = new GenerateJspResult(jspVisitorUsage.getJspVisitorDefinition().getId());
        JspResources jspResources = (JspResources)jspVisitorInputMap.get("JspFiles");
        this.jspClassName = jspResources.getClassName();
        this.jspPackageName = jspResources.getPackageName();
        this.jspSourceFileName = jspResources.getGeneratedSourceFile().toString();
        this.jspSourceFileName = this.jspSourceFileName.replace('\\', '/');
        this.createWriter(jspResources.getGeneratedSourceFile().getPath(), this.jspClassName, this.result.getCustomTagMethodJspIdMap());
    }

    public JspVisitorResult getResult() throws JspCoreException {
        this.closeWriter();
        return this.result;
    }

    public void visit(Document document, int n) throws JspCoreException {
        ValidateJspResult validateJspResult = (ValidateJspResult)this.resultMap.get("JspValidate");
        boolean bl = validateJspResult.isGenSessionVariable();
        switch (n) {
            case 1: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase IMPORT_SECTION");
                }
                this.generateImportSection(validateJspResult);
                break;
            }
            case 2: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase CLASS_SECTION");
                }
                this.generateClassSection(validateJspResult);
                break;
            }
            case 3: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase STATIC_SECTION");
                }
                this.generateStaticSection();
                break;
            }
            case 4: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase INIT_SECTION");
                }
                this.generateInitSection(validateJspResult);
                break;
            }
            case 5: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_INIT_SECTION");
                }
                this.generateServiceInitSection(validateJspResult, bl);
                break;
            }
            case 6: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_SECTION");
                }
                this.generateServiceSection(validateJspResult, bl, document);
                break;
            }
            case 7: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FINALLY_SECTION");
                }
                this.generateFinallySection();
            }
        }
        super.visit(document, n);
        if (n == 7) {
            MethodWriter methodWriter;
            this.writer.println("}");
            this.writer.println("}");
            boolean bl2 = false;
            Object object = this.methodWriterList.iterator();
            while (object.hasNext()) {
                MethodWriter methodWriter2;
                methodWriter = (MethodWriter)object.next();
                if (methodWriter instanceof InitTaglibLookupWriter) {
                    methodWriter2 = (InitTaglibLookupWriter)methodWriter;
                    ((InitTaglibLookupWriter)methodWriter2).complete();
                    bl2 = true;
                } else if (methodWriter instanceof CleanupTaglibLookupWriter) {
                    methodWriter2 = (CleanupTaglibLookupWriter)methodWriter;
                    ((CleanupTaglibLookupWriter)methodWriter2).complete();
                }
                this.writer.printMultiLn(methodWriter.toString());
            }
            if ((this.jspOptions.isUsePageTagPool() || this.jspOptions.isUseThreadTagPool()) && !bl2) {
                object = new InitTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                ((InitTaglibLookupWriter)object).complete();
                this.writer.printMultiLn(((MethodWriter)object).toString());
                methodWriter = new CleanupTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                ((CleanupTaglibLookupWriter)methodWriter).complete();
                this.writer.printMultiLn(methodWriter.toString());
            }
            if (this.fragmentHelperClassWriter.isUsed()) {
                this.fragmentHelperClassWriter.generatePostamble();
                this.writer.printMultiLn(this.fragmentHelperClassWriter.toString());
            }
            this.writer.println("}");
            if (this.jspOptions.isKeepGenerated()) {
                this.writer.println("/*");
                this.writer.println(this.jspSourceFileName + " was generated @ " + new Date());
                this.writer.println(GeneratorUtils.fullClassfileInformation);
                this.writer.println(" ");
                this.writer.println("********************************************************");
                this.writer.println("The JSP engine configuration parameters were set as follows:");
                this.writer.println(this.jspOptions.toString());
                this.writer.println("********************************************************");
                this.writer.println("The following JSP Configuration Parameters were obtained from web.xml:");
                this.writer.println(" ");
                this.writer.println("prelude list = [" + this.jspConfiguration.getPreludeList() + "]");
                this.writer.println("coda list = [" + this.jspConfiguration.getCodaList() + "]");
                this.writer.println("elIgnored = [" + this.jspConfiguration.elIgnored() + "]");
                this.writer.println("pageEncoding = [" + this.jspConfiguration.getPageEncoding() + "]");
                this.writer.println("isXML = [" + this.jspConfiguration.isXml() + "]");
                this.writer.println("scriptingInvalid = [" + this.jspConfiguration.scriptingInvalid() + "]");
                this.writer.println("*/");
            }
        }
    }

    protected void generateImportSection(ValidateJspResult validateJspResult) {
        String string = this.jspPackageName;
        this.writer.println("package " + string + ";");
        this.writer.println();
        for (int i = 0; i < Constants.STANDARD_IMPORTS.length; ++i) {
            this.writer.println("import " + Constants.STANDARD_IMPORTS[i] + ";");
        }
        this.writer.println();
    }

    protected void generateClassSection(ValidateJspResult validateJspResult) {
        this.writer.println();
        this.writer.print("public final class " + this.jspClassName + " extends ");
        String string = validateJspResult.getExtendsClass();
        this.writer.print(string == null ? this.jspServletBase : string);
        this.interfaces.add("com.ibm.ws.jsp.runtime.JspClassInformation");
        boolean bl = validateJspResult.isSingleThreaded();
        if (bl) {
            this.interfaces.add("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.print("     implements");
            for (int i = 0; i < this.interfaces.size() - 1; ++i) {
                this.writer.print(" " + this.interfaces.get(i) + ",");
            }
            this.writer.print(" " + this.interfaces.get(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.println();
        GeneratorUtils.generateDependencyList(this.writer, validateJspResult, this.context, this.jspOptions.isTrackDependencies());
        this.writer.println();
        GeneratorUtils.generateVersionInformation(this.writer, this.jspOptions.isDebugEnabled());
        if (validateJspResult.getInfo() != null) {
            this.writer.println();
            this.writer.println("public String getServletInfo() {");
            this.writer.print("return ");
            this.writer.print(GeneratorUtils.quote(validateJspResult.getInfo()));
            this.writer.println(";");
            this.writer.print("}");
            this.writer.println();
        }
    }

    protected void generateStaticSection() {
        this.writer.println();
        this.writer.println("static {");
    }

    protected void generateInitSection(ValidateJspResult validateJspResult) throws JspCoreException {
        this.writer.println("}");
        this.writer.println();
        GeneratorUtils.generateELFunctionCode(this.writer, validateJspResult);
        this.writer.println();
    }

    protected void generateServiceInitSection(ValidateJspResult validateJspResult, boolean bl) {
        boolean bl2;
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws java.io.IOException, ServletException {");
        this.writer.println();
        this.result.setServiceMethodLineNumber(((JavaFileWriter)this.writer).getCurrentLineNumber());
        this.writer.println("JspFactory _jspxFactory = null;");
        this.writer.println("PageContext pageContext = null;");
        if (bl) {
            this.writer.println("HttpSession session = null;");
        }
        if (bl2 = validateJspResult.isErrorPage()) {
            this.writer.println("Throwable exception = org.apache.jasper.runtime.JspRuntimeLibrary.getThrowable(request);");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println();
        this.writer.println("JspWriter _jspx_out = null;");
        this.writer.println();
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup();");
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup(request);");
        }
    }

    protected void generateServiceSection(ValidateJspResult validateJspResult, boolean bl, Document document) {
        String string;
        this.writer.println();
        this.writer.println("try {");
        this.writer.println();
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        String string2 = validateJspResult.getContentType();
        boolean bl2 = this.jspOptions.isAutoResponseEncoding();
        if (string2 == null) {
            string2 = this.jspConfiguration.isXml() ? "text/xml" : "text/html";
        }
        if (string2.indexOf("charset=") < 0) {
            if (this.jspConfiguration.isXml()) {
                if (!bl2) {
                    string2 = string2 + ";charset=UTF-8";
                }
            } else {
                string = validateJspResult.getPageEncoding();
                if (string != null && !string.equals("")) {
                    string2 = string2 + ";charset=" + string;
                } else {
                    string = this.jspConfiguration.getPageEncoding();
                    if (string != null && !string.equals("")) {
                        string2 = string2 + ";charset=" + string;
                    } else {
                        logger.logp(Level.FINEST, CLASS_NAME, "generateServiceSection", "JSP did not specify charset; defer to webcontainer");
                    }
                }
            }
        }
        this.writer.println("response.setContentType(" + this.writer.quoteString(string2) + ");");
        string = validateJspResult.getError();
        int n = validateJspResult.getBufferSize();
        boolean bl3 = validateJspResult.isAutoFlush();
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response, " + this.writer.quoteString(string) + ", " + bl + ", " + n + ", " + bl3 + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (bl) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
        this.writer.println("_jspx_out = out;");
        this.writer.println();
        if (this.jspConfiguration.isXml()) {
            String string3;
            boolean bl4 = false;
            if (document.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "root").getLength() > 0) {
                bl4 = true;
            }
            Element element = null;
            if (document.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").getLength() > 0) {
                element = (Element)document.getDocumentElement().getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").item(0);
                string3 = element.getAttribute("omit-xml-declaration");
                if (string3.equalsIgnoreCase("no") || string3.equalsIgnoreCase("false")) {
                    bl4 = false;
                } else if (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true")) {
                    bl4 = true;
                }
            }
            if (!bl4) {
                string3 = validateJspResult.getPageEncoding();
                if ((string3 == null || string3.equals("")) && ((string3 = this.jspConfiguration.getPageEncoding()) == null || string3.equals(""))) {
                    string3 = "UTF-8";
                }
                this.writer.println("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + string3 + "\\\"?>\\n\");");
            }
            string3 = "";
            if (element != null) {
                string3 = element.getAttribute("doctype-root-element");
            }
            if (element != null && !string3.equals("")) {
                String string4 = element.getAttribute("doctype-root-element");
                String string5 = element.getAttribute("doctype-system");
                String string6 = element.getAttribute("doctype-public");
                this.writer.print("out.write(\"<!DOCTYPE " + string4);
                if (!string6.equals("")) {
                    this.writer.print(" PUBLIC \\\"" + string6 + "\\\" \\\"" + string5 + "\\\">\\n\");");
                    this.writer.println();
                } else {
                    this.writer.print(" SYSTEM \\\"" + string5 + "\\\">\\n\");");
                    this.writer.println();
                }
            }
        }
    }

    protected void generateFinallySection() {
        this.writer.println();
        this.writer.println("} catch (Throwable t) {");
        this.writer.println("if (!(t instanceof javax.servlet.jsp.SkipPageException)){");
        this.writer.println("out = _jspx_out;");
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.println("out.clearBuffer();");
        this.writer.println("if (pageContext != null) pageContext.handlePageException(t);");
        this.writer.println("}");
        this.writer.println("else if (t instanceof com.ibm.ws.jsp.runtime.WsSkipPageException){");
        this.writer.println("((com.ibm.ws.jsp.runtime.WsSkipPageException)t).printStackTraceIfTraceEnabled();");
        this.writer.println("}");
        this.writer.println("} finally {");
        this.writer.println("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("cleanupTaglibLookup(_jspx_TagLookup);");
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("cleanupTaglibLookup(request, _jspx_TagLookup);");
        }
    }
}

