/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagFileTagInfo;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.CleanupTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateTagFileResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateVisitor;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.InitTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.MethodWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateTagFileResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateTagFileVisitor
extends GenerateVisitor {
    protected GenerateTagFileResult result = null;
    protected TagFileResources tagFileFiles = null;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GenerateTagFileVisitor";

    public GenerateTagFileVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        super(jspVisitorUsage, jspConfiguration, jspCoreContext, hashMap, jspVisitorInputMap, "TagFileValidate");
        this.result = new GenerateTagFileResult(jspVisitorUsage.getJspVisitorDefinition().getId());
        this.tagFileFiles = (TagFileResources)jspVisitorInputMap.get("TagFileFiles");
        this.createWriter(this.tagFileFiles.getGeneratedSourceFile().getPath(), this.tagFileFiles.getClassName(), this.result.getCustomTagMethodJspIdMap());
    }

    public JspVisitorResult getResult() throws JspCoreException {
        this.closeWriter();
        return this.result;
    }

    public void visit(Document document, int n) throws JspCoreException {
        ValidateTagFileResult validateTagFileResult = (ValidateTagFileResult)this.resultMap.get("TagFileValidate");
        switch (n) {
            case 1: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase IMPORT_SECTION");
                }
                this.generateImportSection(validateTagFileResult);
                break;
            }
            case 2: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase CLASS_SECTION");
                }
                this.generateClassSection(validateTagFileResult);
                break;
            }
            case 3: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase STATIC_SECTION");
                }
                this.generateStaticSection();
                break;
            }
            case 4: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase INIT_SECTION");
                }
                this.generateInitSection(validateTagFileResult);
                break;
            }
            case 5: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_INIT_SECTION");
                }
                this.generateDoTagInitSection(validateTagFileResult);
                break;
            }
            case 6: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_SECTION");
                }
                this.generateDoTagSection(validateTagFileResult, document);
                break;
            }
            case 7: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FINALLY_SECTION");
                }
                this.generateFinallySection();
            }
        }
        super.visit(document, n);
        if (n == 7) {
            MethodWriter methodWriter;
            this.writer.println("}");
            this.writer.println("}");
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_WRITE");
            }
            boolean bl = false;
            Object object = this.methodWriterList.iterator();
            while (object.hasNext()) {
                MethodWriter methodWriter2;
                methodWriter = (MethodWriter)object.next();
                if (methodWriter instanceof InitTaglibLookupWriter) {
                    methodWriter2 = (InitTaglibLookupWriter)methodWriter;
                    ((InitTaglibLookupWriter)methodWriter2).complete();
                    bl = true;
                } else if (methodWriter instanceof CleanupTaglibLookupWriter) {
                    methodWriter2 = (CleanupTaglibLookupWriter)methodWriter;
                    ((CleanupTaglibLookupWriter)methodWriter2).complete();
                    bl = true;
                }
                this.writer.printMultiLn(methodWriter.toString());
            }
            if (this.jspOptions.isUsePageTagPool() && !bl) {
                object = new InitTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                ((InitTaglibLookupWriter)object).complete();
                this.writer.printMultiLn(((MethodWriter)object).toString());
                methodWriter = new CleanupTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                ((CleanupTaglibLookupWriter)methodWriter).complete();
                this.writer.printMultiLn(methodWriter.toString());
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FRAGMENT_HELPER");
            }
            if (this.fragmentHelperClassWriter.isUsed()) {
                this.fragmentHelperClassWriter.generatePostamble();
                this.writer.printMultiLn(this.fragmentHelperClassWriter.toString());
            }
            this.writer.println("}");
        }
    }

    protected void generateImportSection(ValidateTagFileResult validateTagFileResult) {
        TagFileInfo tagFileInfo = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)tagFileInfo.getTagInfo().getTagLibrary();
        String string = null;
        if (tagFileInfo.getPath().startsWith("/WEB-INF/tags")) {
            string = tagFileInfo.getPath().substring(tagFileInfo.getPath().indexOf("/WEB-INF/tags") + 13);
        } else if (tagFileInfo.getPath().startsWith("/META-INF/tags")) {
            string = tagFileInfo.getPath().substring(tagFileInfo.getPath().indexOf("/META-INF/tags") + 14);
        }
        string = string.substring(0, string.lastIndexOf("/"));
        string = string.replace('/', '.');
        String string2 = "com.ibm.ws.jsp.tagfile." + tagLibraryInfoImpl.getOriginatorId();
        if (string.length() > 0) {
            string2 = string2 + string;
        }
        this.writer.println("package " + string2 + ";");
        this.writer.println();
        for (int i = 0; i < Constants.STANDARD_IMPORTS.length; ++i) {
            this.writer.println("import " + Constants.STANDARD_IMPORTS[i] + ";");
        }
        this.writer.println();
    }

    protected void generateClassSection(ValidateTagFileResult validateTagFileResult) {
        this.writer.println();
        this.writer.print("public class " + this.tagFileFiles.getClassName() + " extends javax.servlet.jsp.tagext.SimpleTagSupport");
        TagFileInfo tagFileInfo = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagInfo tagInfo = tagFileInfo.getTagInfo();
        if (tagInfo.hasDynamicAttributes()) {
            this.writer.println();
            this.writer.print(" implements javax.servlet.jsp.tagext.DynamicAttributes");
        }
        this.writer.println(" {");
    }

    protected void generateStaticSection() {
        this.writer.println();
        this.writer.println("static {");
    }

    protected void generateInitSection(ValidateTagFileResult validateTagFileResult) throws JspCoreException {
        int n;
        int n2;
        TagFileInfo tagFileInfo = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagInfo tagInfo = tagFileInfo.getTagInfo();
        boolean bl = false;
        TagVariableInfo[] tagVariableInfoArray = tagInfo.getTagVariableInfos();
        for (n2 = 0; n2 < tagVariableInfoArray.length; ++n2) {
            if (tagVariableInfoArray[n2].getNameFromAttribute() == null || tagVariableInfoArray[n2].getNameGiven() == null) continue;
            bl = true;
            break;
        }
        this.writer.println("}");
        this.writer.println();
        GeneratorUtils.generateELFunctionCode(this.writer, validateTagFileResult);
        this.writer.println("private JspContext jspContext;");
        this.writer.println("private java.io.Writer _jspx_sout;");
        if (bl) {
            this.writer.println("public void setJspContext(JspContext ctx, java.util.Map aliasMap) {");
        } else {
            this.writer.println("public void setJspContext( JspContext ctx ) {");
        }
        this.writer.println("super.setJspContext(ctx);");
        this.writer.println("java.util.ArrayList _jspx_nested = null;");
        this.writer.println("java.util.ArrayList _jspx_at_begin = null;");
        this.writer.println("java.util.ArrayList _jspx_at_end = null;");
        for (n2 = 0; n2 < tagVariableInfoArray.length; ++n2) {
            switch (tagVariableInfoArray[n2].getScope()) {
                case 0: {
                    this.writer.println("if (_jspx_nested == null)");
                    this.writer.println("_jspx_nested = new java.util.ArrayList();");
                    this.writer.print("_jspx_nested.add(");
                    break;
                }
                case 1: {
                    this.writer.println("if (_jspx_at_begin == null)");
                    this.writer.println("_jspx_at_begin = new java.util.ArrayList();");
                    this.writer.print("_jspx_at_begin.add(");
                    break;
                }
                case 2: {
                    this.writer.println("if (_jspx_at_end == null)");
                    this.writer.println("_jspx_at_end = new java.util.ArrayList();");
                    this.writer.print("_jspx_at_end.add(");
                }
            }
            this.writer.print(GeneratorUtils.quote(tagVariableInfoArray[n2].getNameGiven()));
            this.writer.print(");");
            this.writer.println();
        }
        if (bl) {
            this.writer.println("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, aliasMap);");
        } else {
            this.writer.println("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, null);");
        }
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public JspContext getJspContext() {");
        this.writer.println("return this.jspContext;");
        this.writer.println("}");
        if (tagInfo.hasDynamicAttributes()) {
            this.writer.println("private java.util.HashMap _jspx_dynamic_attrs = new java.util.HashMap();");
        }
        TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
        for (n = 0; n < tagAttributeInfoArray.length; ++n) {
            this.writer.print("private ");
            if (tagAttributeInfoArray[n].isFragment()) {
                this.writer.print("javax.servlet.jsp.tagext.JspFragment ");
            } else {
                this.writer.print(GeneratorUtils.toJavaSourceType(tagAttributeInfoArray[n].getTypeName()));
                this.writer.print(" ");
            }
            this.writer.print(tagAttributeInfoArray[n].getName());
            this.writer.print(";");
            this.writer.println();
        }
        this.writer.println();
        if (tagAttributeInfoArray != null) {
            for (n = 0; n < tagAttributeInfoArray.length; ++n) {
                this.writer.print("public ");
                if (tagAttributeInfoArray[n].isFragment()) {
                    this.writer.print("javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    this.writer.print(GeneratorUtils.toJavaSourceType(tagAttributeInfoArray[n].getTypeName()));
                    this.writer.print(" ");
                }
                this.writer.print(GeneratorUtils.toGetterMethod(tagAttributeInfoArray[n].getName()));
                this.writer.print(" {");
                this.writer.println();
                this.writer.print("return this.");
                this.writer.print(tagAttributeInfoArray[n].getName());
                this.writer.print(";");
                this.writer.println();
                this.writer.println("}");
                this.writer.println();
                this.writer.print("public void ");
                this.writer.print(GeneratorUtils.toSetterMethodName(tagAttributeInfoArray[n].getName()));
                if (tagAttributeInfoArray[n].isFragment()) {
                    this.writer.print("(javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    this.writer.print("(");
                    this.writer.print(GeneratorUtils.toJavaSourceType(tagAttributeInfoArray[n].getTypeName()));
                    this.writer.print(" ");
                }
                this.writer.print(tagAttributeInfoArray[n].getName());
                this.writer.print(") {");
                this.writer.println();
                this.writer.print("this.");
                this.writer.print(tagAttributeInfoArray[n].getName());
                this.writer.print(" = ");
                this.writer.print(tagAttributeInfoArray[n].getName());
                this.writer.print(";");
                this.writer.println();
                this.writer.println("}");
                this.writer.println();
            }
        }
        if (tagInfo.hasDynamicAttributes()) {
            this.writer.println("public void setDynamicAttribute(String uri, String localName, Object value) throws javax.servlet.jsp.JspException {");
            this.writer.println("if (uri == null) _jspx_dynamic_attrs.put(localName, value);");
            this.writer.println("}");
        }
    }

    protected void generateDoTagInitSection(ValidateTagFileResult validateTagFileResult) {
        TagFileInfo tagFileInfo = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagInfo tagInfo = tagFileInfo.getTagInfo();
        String string = "pageContext";
        if (this.jspOptions.isModifyPageContextVariable()) {
            string = "_jspx_page_context";
        }
        this.writer.println("public void doTag() throws javax.servlet.jsp.JspException, java.io.IOException {");
        this.writer.println("PageContext " + string + " = (PageContext)jspContext;");
        this.writer.println("javax.servlet.http.HttpServletRequest request = (javax.servlet.http.HttpServletRequest) " + string + ".getRequest();");
        this.writer.println("javax.servlet.http.HttpServletResponse response = (javax.servlet.http.HttpServletResponse) " + string + ".getResponse();");
        this.writer.println("javax.servlet.http.HttpSession session = " + string + ".getSession();");
        this.writer.println("javax.servlet.ServletContext application = " + string + ".getServletContext();");
        this.writer.println("javax.servlet.ServletConfig config = " + string + ".getServletConfig();");
        this.writer.println("javax.servlet.jsp.JspWriter out = jspContext.getOut();");
        this.writer.println();
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup();");
            this.writer.println();
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = new java.util.HashMap();");
            this.writer.println();
        }
        TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
        for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
            String string2 = tagAttributeInfoArray[i].getName();
            this.writer.print("if (" + GeneratorUtils.toGetterMethod(string2) + " != null) ");
            this.writer.print(" " + string + ".setAttribute(");
            this.writer.print(GeneratorUtils.quote(string2));
            this.writer.print(", ");
            this.writer.print(GeneratorUtils.toGetterMethod(string2));
            this.writer.print(");");
            this.writer.println();
        }
        if (tagInfo.hasDynamicAttributes()) {
            this.writer.print(string + ".setAttribute(\"");
            this.writer.print(((TagFileTagInfo)tagInfo).getDynamicAttributesMapName());
            this.writer.print("\", _jspx_dynamic_attrs);");
            this.writer.println();
        }
    }

    protected void generateDoTagSection(ValidateTagFileResult validateTagFileResult, Document document) {
        this.writer.println("try {");
        if (this.jspConfiguration.isXml()) {
            String string;
            boolean bl = true;
            Element element = null;
            if (document.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").getLength() > 0) {
                element = (Element)document.getDocumentElement().getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").item(0);
                string = element.getAttribute("omit-xml-declaration");
                if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false")) {
                    bl = false;
                } else if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
                    bl = true;
                }
            }
            if (!bl) {
                string = validateTagFileResult.getPageEncoding();
                if ((string == null || string.equals("")) && ((string = this.jspConfiguration.getPageEncoding()) == null || string.equals(""))) {
                    string = "UTF-8";
                }
                this.writer.println("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + string + "\\\"?>\\n\");");
            }
            string = "";
            if (element != null) {
                string = element.getAttribute("doctype-root-element");
            }
            if (element != null && !string.equals("")) {
                String string2 = element.getAttribute("doctype-root-element");
                String string3 = element.getAttribute("doctype-system");
                String string4 = element.getAttribute("doctype-public");
                this.writer.print("out.write(\"<!DOCTYPE " + string2);
                if (!string4.equals("")) {
                    this.writer.print(" PUBLIC \\\"" + string4 + "\\\" \\\"" + string3 + "\\\">\\n\");");
                    this.writer.println();
                } else {
                    this.writer.print(" SYSTEM \\\"" + string3 + "\\\">\\n\");");
                    this.writer.println();
                }
            }
        }
    }

    protected void generateFinallySection() {
        this.writer.println("} catch( Throwable t ) {");
        this.writer.println("if( t instanceof javax.servlet.jsp.SkipPageException )");
        this.writer.println("    throw (javax.servlet.jsp.SkipPageException) t;");
        this.writer.println("if( t instanceof java.io.IOException )");
        this.writer.println("    throw (java.io.IOException) t;");
        this.writer.println("if( t instanceof IllegalStateException )");
        this.writer.println("    throw (IllegalStateException) t;");
        this.writer.println("if( t instanceof javax.servlet.jsp.JspException )");
        this.writer.println("    throw (javax.servlet.jsp.JspException) t;");
        this.writer.println("throw new javax.servlet.jsp.JspException(t);");
        this.writer.println("} finally {");
        this.writer.println("((org.apache.jasper.runtime.JspContextWrapper) jspContext).syncEndTagFile();");
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("cleanupTaglibLookup(_jspx_TagLookup);");
        }
    }
}

