/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.utils.FunctionSignature;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class GeneratorUtils {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils";
    public static String classfileVersion = "unknown";
    public static String fullClassfileInformation = "unknown";

    public static String quote(String string) {
        if (string == null) {
            return "null";
        }
        return '\"' + GeneratorUtils.escape(string) + '\"';
    }

    public static String escape(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                stringBuffer.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                stringBuffer.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                stringBuffer.append('\\').append('r');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toGetterMethod(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return "get" + new String(cArray) + "()";
    }

    public static String toSetterMethodName(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return "set" + new String(cArray);
    }

    public static void generateLocalVariables(JavaCodeWriter javaCodeWriter, Element element, String string) throws JspCoreException {
        if (GeneratorUtils.hasUseBean(element)) {
            javaCodeWriter.println("HttpSession session = " + string + ".getSession();");
            javaCodeWriter.println("ServletContext application = " + string + ".getServletContext();");
        }
        if (GeneratorUtils.hasUseBean(element) || GeneratorUtils.hasIncludeAction(element) || GeneratorUtils.hasSetProperty(element) || GeneratorUtils.hasForwardAction(element)) {
            javaCodeWriter.println("HttpServletRequest request = (HttpServletRequest)" + string + ".getRequest();");
        }
        if (GeneratorUtils.hasIncludeAction(element)) {
            javaCodeWriter.println("HttpServletResponse response = (HttpServletResponse)" + string + ".getResponse();");
        }
    }

    private static boolean hasUseBean(Element element) {
        boolean bl = false;
        if (element.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "useBean").getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    private static boolean hasIncludeAction(Element element) {
        boolean bl = false;
        if (element.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "include").getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    private static boolean hasForwardAction(Element element) {
        boolean bl = false;
        if (element.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "forward").getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    private static boolean hasSetProperty(Element element) {
        boolean bl = false;
        if (element.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "setProperty").getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    public static String interpreterCall(boolean bl, String string, Class clazz, String string2, boolean bl2, String string3) {
        String string4 = null;
        string4 = bl ? "getJspContext()" : string3;
        String string5 = clazz.getName();
        String string6 = null;
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                string5 = Boolean.class.getName();
                string6 = "booleanValue";
            } else if (clazz.equals(Byte.TYPE)) {
                string5 = Byte.class.getName();
                string6 = "byteValue";
            } else if (clazz.equals(Character.TYPE)) {
                string5 = Character.class.getName();
                string6 = "charValue";
            } else if (clazz.equals(Short.TYPE)) {
                string5 = Short.class.getName();
                string6 = "shortValue";
            } else if (clazz.equals(Integer.TYPE)) {
                string5 = Integer.class.getName();
                string6 = "intValue";
            } else if (clazz.equals(Long.TYPE)) {
                string5 = Long.class.getName();
                string6 = "longValue";
            } else if (clazz.equals(Float.TYPE)) {
                string5 = Float.class.getName();
                string6 = "floatValue";
            } else if (clazz.equals(Double.TYPE)) {
                string5 = Double.class.getName();
                string6 = "doubleValue";
            }
        }
        string5 = GeneratorUtils.toJavaSourceType(string5);
        if (string6 != null) {
            bl2 = false;
        }
        StringBuffer stringBuffer = new StringBuffer("(" + string5 + ") " + "org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate" + "(" + GeneratorUtils.quote(string) + ", " + string5 + ".class, " + "(PageContext)" + string4 + ", " + string2 + ", " + bl2 + ")");
        if (string6 != null) {
            stringBuffer.insert(0, "(");
            stringBuffer.append(")." + string6 + "()");
        }
        return stringBuffer.toString();
    }

    public static String nextTemporaryVariableName(Map map) {
        String string = "_jspx_temp";
        Integer n = (Integer)map.get("tempVarIndex");
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n;
        n = new Integer(++n2);
        string = string + n;
        map.put("tempVarIndex", n);
        return string;
    }

    public static String attributeValue(String string, boolean bl, Class clazz, JspConfiguration jspConfiguration, boolean bl2, String string2) {
        String string3 = string;
        string3 = string3.replaceAll("&gt;", ">");
        string3 = string3.replaceAll("&lt;", "<");
        string3 = string3.replaceAll("&amp;", "&");
        string3 = string3.replaceAll("<\\%", "<%");
        string3 = string3.replaceAll("%\\>", "%>");
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "valueIn = [" + string + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "encode = [" + bl + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "expectedType = [" + clazz + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isTagFile = [" + bl2 + "]");
        }
        if (JspTranslatorUtil.isExpression(string3)) {
            string3 = string3.substring(2, string3.length() - 1);
            if (bl) {
                string3 = "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(String.valueOf(" + string3 + "), request.getCharacterEncoding())";
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isExpression. value = [" + string3 + "]");
            }
        } else if (JspTranslatorUtil.isELInterpreterInput(string3, jspConfiguration)) {
            string3 = bl ? "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + GeneratorUtils.interpreterCall(bl2, string3, clazz, "_jspx_fnmap", false, string2) + ", request.getCharacterEncoding())" : GeneratorUtils.interpreterCall(bl2, string3, clazz, "_jspx_fnmap", false, string2);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isELInterpreterInput. value = [" + string3 + "]");
            }
        } else {
            string3 = bl ? "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + GeneratorUtils.quote(string3) + ", request.getCharacterEncoding())" : GeneratorUtils.quote(string3);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "default. value = [" + string3 + "]");
            }
        }
        return string3;
    }

    public static String replace(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (true) {
            int n3;
            if ((n3 = string.indexOf(c, n)) < 0) {
                n3 = n2;
            }
            stringBuffer.append(string.substring(n, n3));
            if (n3 == n2) break;
            stringBuffer.append(string2);
            n = n3 + 1;
        }
        return stringBuffer.toString();
    }

    public static char[] removeQuotes(char[] cArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%' && cArray[i + 1] == '\\' && cArray[i + 2] == '>') {
                charArrayWriter.write(37);
                charArrayWriter.write(62);
                i += 3;
                continue;
            }
            charArrayWriter.write(cArray[i]);
        }
        return charArrayWriter.toCharArray();
    }

    public static char[] escapeQuotes(char[] cArray) {
        char[] cArray2 = GeneratorUtils.escapeScriptingStart(cArray);
        cArray2 = GeneratorUtils.escapeScriptingEnd(cArray2);
        return cArray2;
    }

    private static char[] escapeScriptingStart(char[] cArray) {
        int n;
        String string = new String(cArray);
        while ((n = string.indexOf("<\\%")) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append("<%");
            stringBuffer.append(string.substring(n + 3));
            string = stringBuffer.toString();
        }
        cArray = string.toCharArray();
        return cArray;
    }

    private static char[] escapeScriptingEnd(char[] cArray) {
        int n;
        String string = new String(cArray);
        while ((n = string.indexOf("%\\>")) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append("%>");
            stringBuffer.append(string.substring(n + 3));
            string = stringBuffer.toString();
        }
        cArray = string.toCharArray();
        return cArray;
    }

    public static void generateELFunctionCode(JavaCodeWriter javaCodeWriter, ValidateResult validateResult) throws JspCoreException {
        javaCodeWriter.println("private static org.apache.jasper.runtime.ProtectedFunctionMapper _jspx_fnmap = null;");
        if (validateResult.getValidateFunctionMapper().size() > 0) {
            javaCodeWriter.println();
            javaCodeWriter.println("static {");
            javaCodeWriter.println("_jspx_fnmap = org.apache.jasper.runtime.ProtectedFunctionMapper.getInstance();");
            Iterator iterator = validateResult.getValidateFunctionMapper().keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = string.substring(0, string.indexOf(58));
                String string3 = string.substring(string.indexOf(58) + 1);
                javaCodeWriter.print("_jspx_fnmap.mapFunction(");
                javaCodeWriter.print(GeneratorUtils.quote(string2));
                javaCodeWriter.print(", ");
                javaCodeWriter.print(GeneratorUtils.quote(string3));
                javaCodeWriter.print(", ");
                FunctionSignature functionSignature = validateResult.getValidateFunctionMapper().getSignature(string);
                javaCodeWriter.print(functionSignature.getFunctionClassName() + ".class, ");
                javaCodeWriter.print(GeneratorUtils.quote(functionSignature.getMethodName()));
                javaCodeWriter.print(", ");
                Class[] classArray = functionSignature.getParameterTypes();
                if (classArray != null) {
                    javaCodeWriter.print("new Class[] {");
                    for (int i = 0; i < classArray.length; ++i) {
                        if (classArray[i].isArray()) {
                            javaCodeWriter.print("java.lang.reflect.Array.newInstance(" + classArray[i].getComponentType().getName() + ".class, 0).getClass()");
                        } else {
                            javaCodeWriter.print(classArray[i].getName() + ".class");
                        }
                        if (i >= classArray.length - 1) continue;
                        javaCodeWriter.print(", ");
                    }
                    javaCodeWriter.print("} ");
                } else {
                    javaCodeWriter.print("null");
                }
                javaCodeWriter.print(");");
                javaCodeWriter.println();
            }
            javaCodeWriter.println("}");
            javaCodeWriter.println();
        }
    }

    public static void generateDependencyList(JavaCodeWriter javaCodeWriter, ValidateResult validateResult, JspCoreContext jspCoreContext, boolean bl) {
        javaCodeWriter.println("private static String[] _jspx_dependants;");
        if (validateResult.getDependencyList().size() > 0 || bl) {
            javaCodeWriter.println("static {");
            javaCodeWriter.print("_jspx_dependants = new String[");
            if (validateResult.getDependencyList().size() > 0) {
                javaCodeWriter.print("" + validateResult.getDependencyList().size());
            } else {
                javaCodeWriter.print("0");
            }
            javaCodeWriter.print("];");
            javaCodeWriter.println();
            int n = 0;
            String string = null;
            String string2 = null;
            File file = null;
            Iterator iterator = validateResult.getDependencyList().iterator();
            while (iterator.hasNext()) {
                javaCodeWriter.print("_jspx_dependants[" + n++ + "] = \"");
                string = (String)iterator.next();
                string2 = jspCoreContext.getRealPath(string);
                file = new File(string2);
                javaCodeWriter.print(string + "^" + file.lastModified() + "^" + new Date(file.lastModified()).toString());
                javaCodeWriter.print("\";");
                javaCodeWriter.println();
            }
            javaCodeWriter.println("}");
            javaCodeWriter.println();
        }
        javaCodeWriter.println("public String[] getDependants() {");
        javaCodeWriter.println("return _jspx_dependants;");
        javaCodeWriter.println("}");
    }

    public static void generateVersionInformation(JavaCodeWriter javaCodeWriter, boolean bl) {
        javaCodeWriter.println("private static String _jspx_classVersion;");
        javaCodeWriter.println("private static boolean _jspx_isDebugClassFile;");
        javaCodeWriter.println("static {");
        javaCodeWriter.print("_jspx_classVersion = new String(");
        javaCodeWriter.print("\"" + classfileVersion);
        javaCodeWriter.print("\");");
        javaCodeWriter.println();
        javaCodeWriter.print("_jspx_isDebugClassFile = ");
        javaCodeWriter.print("" + bl);
        javaCodeWriter.print(";");
        javaCodeWriter.println();
        javaCodeWriter.println("}");
        javaCodeWriter.println();
        javaCodeWriter.println("public String getVersionInformation() {");
        javaCodeWriter.println("return _jspx_classVersion;");
        javaCodeWriter.println("}");
        javaCodeWriter.println("public boolean isDebugClassFile() {");
        javaCodeWriter.println("return _jspx_isDebugClassFile;");
        javaCodeWriter.println("}");
    }

    public static String coerceToPrimitiveBoolean(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToBoolean(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "false";
        }
        return Boolean.valueOf(string).toString();
    }

    public static String coerceToBoolean(String string, boolean bl) {
        if (bl) {
            return "(Boolean) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Boolean.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Boolean(false)";
        }
        return "new Boolean(" + Boolean.valueOf(string).toString() + ")";
    }

    public static String coerceToPrimitiveByte(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToByte(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(byte) 0";
        }
        return "((byte)" + Byte.valueOf(string).toString() + ")";
    }

    public static String coerceToByte(String string, boolean bl) {
        if (bl) {
            return "(Byte) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Byte.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Byte((byte) 0)";
        }
        return "new Byte((byte)" + Byte.valueOf(string).toString() + ")";
    }

    public static String coerceToChar(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToChar(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(char) 0";
        }
        char c = string.charAt(0);
        return "((char) " + c + ")";
    }

    public static String coerceToCharacter(String string, boolean bl) {
        if (bl) {
            return "(Character) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Character.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Character((char) 0)";
        }
        char c = string.charAt(0);
        return "new Character((char) " + c + ")";
    }

    public static String coerceToPrimitiveDouble(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToDouble(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(double) 0";
        }
        return Double.valueOf(string).toString();
    }

    public static String coerceToDouble(String string, boolean bl) {
        if (bl) {
            return "(Double) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Double.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Double(0)";
        }
        return "new Double(" + Double.valueOf(string).toString() + ")";
    }

    public static String coerceToPrimitiveFloat(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToFloat(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(float) 0";
        }
        return Float.valueOf(string).toString() + "f";
    }

    public static String coerceToFloat(String string, boolean bl) {
        if (bl) {
            return "(Float) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Float.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Float(0)";
        }
        return "new Float(" + Float.valueOf(string).toString() + "f)";
    }

    public static String coerceToInt(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToInt(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "0";
        }
        return Integer.valueOf(string).toString();
    }

    public static String coerceToInteger(String string, boolean bl) {
        if (bl) {
            return "(Integer) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Integer.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Integer(0)";
        }
        return "new Integer(" + Integer.valueOf(string).toString() + ")";
    }

    public static String coerceToPrimitiveShort(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToShort(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(short) 0";
        }
        return "((short) " + Short.valueOf(string).toString() + ")";
    }

    public static String coerceToShort(String string, boolean bl) {
        if (bl) {
            return "(Short) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Short.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Short((short) 0)";
        }
        return "new Short(\"" + Short.valueOf(string).toString() + "\")";
    }

    public static String coerceToPrimitiveLong(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToLong(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(long) 0";
        }
        return Long.valueOf(string).toString() + "l";
    }

    public static String coerceToLong(String string, boolean bl) {
        if (bl) {
            return "(Long) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Long.class)";
        }
        if (string == null || string.length() == 0) {
            return "new Long(0)";
        }
        return "new Long(" + Long.valueOf(string).toString() + "l)";
    }

    public static String toJavaSourceType(String string) {
        if (string.charAt(0) != '[') {
            return string;
        }
        int n = 1;
        String string2 = null;
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == '[') {
                ++n;
                continue;
            }
            switch (string.charAt(i)) {
                case 'Z': {
                    string2 = "boolean";
                    break;
                }
                case 'B': {
                    string2 = "byte";
                    break;
                }
                case 'C': {
                    string2 = "char";
                    break;
                }
                case 'D': {
                    string2 = "double";
                    break;
                }
                case 'F': {
                    string2 = "float";
                    break;
                }
                case 'I': {
                    string2 = "int";
                    break;
                }
                case 'J': {
                    string2 = "long";
                    break;
                }
                case 'S': {
                    string2 = "short";
                    break;
                }
                case 'L': {
                    string2 = string.substring(i + 1, string.indexOf(59));
                }
            }
            break;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (n > 0) {
            stringBuffer.append("[]");
            --n;
        }
        return stringBuffer.toString();
    }
}

