/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.smap;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.resource.ResourcesImpl;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import com.ibm.ws.jsp.translator.utils.SmapStratum;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateJspResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateTagFileResult;
import com.ibm.ws.jsp.translator.visitor.smap.SmapVisitorResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

public class SmapVisitor
extends JspVisitor {
    private SmapGenerator smapGenerator = null;
    private SmapStratum smapStratum = null;
    private List fileList = new ArrayList();
    private ResourcesImpl generatedFiles = null;
    private Map cdataJspIdMap = null;
    private int serviceMethodLineNumber = 0;
    private Map customTagMethodJspIdMap = null;
    private String validateResultId = null;

    public SmapVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        super(jspVisitorUsage, jspConfiguration, jspCoreContext, hashMap, jspVisitorInputMap);
        this.smapGenerator = new SmapGenerator();
        this.smapStratum = new SmapStratum("JSP");
        if (jspVisitorInputMap.containsKey("JspFiles")) {
            this.generatedFiles = (ResourcesImpl)jspVisitorInputMap.get("JspFiles");
            this.validateResultId = "JspValidate";
        } else if (jspVisitorInputMap.containsKey("TagFileFiles")) {
            this.generatedFiles = (ResourcesImpl)jspVisitorInputMap.get("TagFileFiles");
            this.validateResultId = "TagFileValidate";
        }
        this.smapGenerator.setOutputFileName(this.generatedFiles.getGeneratedSourceFile().getName());
        this.cdataJspIdMap = (Map)jspVisitorInputMap.get("CdataJspIdMap");
        GenerateJspResult generateJspResult = (GenerateJspResult)hashMap.get("JspGenerate");
        if (generateJspResult != null) {
            this.serviceMethodLineNumber = generateJspResult.getServiceMethodLineNumber();
            this.customTagMethodJspIdMap = generateJspResult.getCustomTagMethodJspIdMap();
        } else {
            GenerateTagFileResult generateTagFileResult = (GenerateTagFileResult)hashMap.get("TagFileGenerate");
            this.customTagMethodJspIdMap = generateTagFileResult.getCustomTagMethodJspIdMap();
        }
    }

    private void addStartLineInfo(Element element) {
        JspId jspId = new JspId(element.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if (jspId.getStartGeneratedLineNum() > 0) {
            this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), 1, jspId.getStartGeneratedLineNum(), jspId.getStartGeneratedLineCount());
        }
    }

    private void addEndLineInfo(Element element) {
        JspId jspId = new JspId(element.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (jspId.getEndGeneratedLineNum() > 0) {
            this.smapStratum.addLineData(jspId.getEndSourceLineNum(), jspId.getFileName(), 1, jspId.getEndGeneratedLineNum(), jspId.getEndGeneratedLineCount());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JspVisitorResult getResult() throws JspCoreException {
        this.smapGenerator.addStratum(this.smapStratum, true);
        JspOptions jspOptions = (JspOptions)this.inputMap.get("JspOptions");
        if (!jspOptions.isKeepGenerated()) return new SmapVisitorResult(this.visitorUsage.getJspVisitorDefinition().getId(), this.smapGenerator);
        Object object = null;
        PrintWriter printWriter = null;
        try {
            try {
                File file = new File(this.generatedFiles.getClassFile().getPath() + ".smap");
                object = new FileOutputStream(file);
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                printWriter.print(this.smapGenerator.getString());
            }
            catch (IOException iOException) {
                throw new JspCoreException(iOException);
            }
            Object var6_6 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            if (object == null) return new SmapVisitorResult(this.visitorUsage.getJspVisitorDefinition().getId(), this.smapGenerator);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            if (object == null) throw throwable;
            try {
                ((FileOutputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((FileOutputStream)object).close();
        return new SmapVisitorResult(this.visitorUsage.getJspVisitorDefinition().getId(), this.smapGenerator);
    }

    protected void visitCustomTagStart(Element element) throws JspCoreException {
        String string;
        JspId jspId = new JspId(element.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if ((string = (String)this.customTagMethodJspIdMap.get(element)) != null) {
            String string2 = string.substring(0, string.indexOf(44));
            String string3 = string.substring(string.indexOf(44) + 1);
            this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), 1, Integer.valueOf(string2), Integer.valueOf(string3));
        }
        if (jspId.getStartGeneratedLineNum() > 0) {
            this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), 1, jspId.getStartGeneratedLineNum(), jspId.getStartGeneratedLineCount());
        }
    }

    protected void visitJspRootStart(Element element) throws JspCoreException {
        JspId jspId = new JspId(element.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if (this.serviceMethodLineNumber > 0) {
            this.smapStratum.addLineData(1, jspId.getFileName(), 1, this.serviceMethodLineNumber, 1);
        }
    }

    protected void visitPageDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitJspGetPropertyStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspForwardStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspPluginStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitIncludeDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitJspSetPropertyStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspIncludeStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspAttributeStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspElementStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspBodyStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspInvokeStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspDoBodyStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitTagDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitAttributeDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitVariableDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitJspParamsStart(Element element) throws JspCoreException {
    }

    protected void visitJspFallbackStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspParamStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspUseBeanStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspExpressionStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspScriptletStart(Element element) throws JspCoreException {
        this.addScriptingLineInfo(element);
    }

    protected void visitJspDeclarationStart(Element element) throws JspCoreException {
        this.addScriptingLineInfo(element);
    }

    protected void visitJspTextStart(Element element) throws JspCoreException {
        this.addStartLineInfo(element);
    }

    protected void visitJspOutputStart(Element element) throws JspCoreException {
    }

    protected void visitUninterpretedTagStart(Element element) throws JspCoreException {
        String string = element.getNamespaceURI();
        if (string != null) {
            if (string.startsWith("urn:jsptld:")) {
                string = string.substring(string.indexOf("urn:jsptld:") + 11);
            } else if (string.startsWith("urn:jsptagdir:")) {
                string = string.substring(string.indexOf("urn:jsptagdir:") + 14);
            }
            ValidateResult validateResult = (ValidateResult)this.resultMap.get(this.validateResultId);
            if (validateResult.getTagLibMap().get(string) != null) {
                this.visitCustomTagStart(element);
            } else {
                this.addStartLineInfo(element);
            }
        } else {
            this.addStartLineInfo(element);
        }
    }

    protected void visitJspParamEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspGetPropertyEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspRootEnd(Element element) throws JspCoreException {
    }

    protected void visitJspFallbackEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspUseBeanEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspForwardEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspPluginEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspSetPropertyEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitIncludeDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitJspExpressionEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitPageDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitJspIncludeEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspScriptletEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspDeclarationEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspTextEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspParamsEnd(Element element) throws JspCoreException {
    }

    protected void visitJspAttributeEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspElementEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspBodyEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspInvokeEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspDoBodyEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitTagDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitAttributeDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitVariableDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitCustomTagEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitJspOutputEnd(Element element) throws JspCoreException {
    }

    protected void visitUninterpretedTagEnd(Element element) throws JspCoreException {
        this.addEndLineInfo(element);
    }

    protected void visitCDataTag(CDATASection cDATASection) throws JspCoreException {
        String string = (String)this.cdataJspIdMap.get(new Integer(cDATASection.hashCode()));
        if (string != null) {
            JspId jspId = new JspId(string);
            if (!this.fileList.contains(jspId.getFilePath())) {
                this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
                this.fileList.add(jspId.getFilePath());
            }
            if (jspId.getStartGeneratedLineNum() > 0) {
                this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), jspId.getStartGeneratedLineCount(), jspId.getStartGeneratedLineNum(), 1);
            }
        }
    }

    private void addScriptingLineInfo(Element element) {
        JspId jspId = new JspId(element.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if (jspId.getStartGeneratedLineNum() > 0) {
            CDATASection cDATASection = (CDATASection)element.getChildNodes().item(0);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(cDATASection.getData()));
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            try {
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    ++n3;
                    if (string.trim().length() < 1) {
                        if (bl) {
                            ++n2;
                            continue;
                        }
                        ++n;
                        continue;
                    }
                    bl = true;
                    n2 = 0;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.smapStratum.addLineData(jspId.getStartSourceLineNum() + n, jspId.getFileName(), n3 - n - n2, jspId.getStartGeneratedLineNum() + n, 1);
        }
    }
}

