/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateJspResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ValidateJspVisitor
extends ValidateVisitor {
    private HashMap userDefinedDirectives = new HashMap();
    private Boolean autoFlushValue = null;
    private String bufferValue = null;

    public ValidateJspVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        super(jspVisitorUsage, jspConfiguration, jspCoreContext, hashMap, jspVisitorInputMap);
        this.result = new ValidateJspResult(jspVisitorUsage.getJspVisitorDefinition().getId());
    }

    protected void visitJspUseBeanStart(Element element) throws JspCoreException {
        super.visitJspUseBeanStart(element);
        ValidateJspResult validateJspResult = (ValidateJspResult)this.result;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            Attr attr = element.getAttributeNode("scope");
            if (attr != null && attr.getValue().equalsIgnoreCase("session") && !validateJspResult.isGenSessionVariable()) {
                throw new JspTranslationException(element, "jsp.error.usebean.prohibited.as.session");
            }
        } else {
            throw new JspTranslationException(element, "jsp.error.usebean.contains.no.attributes");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitPageDirectiveStart(Element element) throws JspCoreException {
        ValidateJspResult validateJspResult = (ValidateJspResult)this.result;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) throw new JspTranslationException(element, "jsp.error.page.directive.contains.no.attributes");
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            Object object;
            String string2;
            Node node = namedNodeMap.item(i);
            String string3 = node.getNodeName();
            Object object2 = this.addUserPageDirective(string3, string2 = node.getNodeValue());
            if (!(object2 == null || string3.equals("import") || string3.equals("pageEncoding") || string3.equals("jsp:id") || object2.equals(string2))) {
                throw new JspTranslationException(element, "jsp.error.multiple.occurrences.directive", new Object[]{string3, object2, string2});
            }
            boolean bl = false;
            if (string3.equals("language")) {
                if (string2 != null && !string2.equals("java")) {
                    throw new JspTranslationException(element, "jsp.error.invalid.value.for.language", new Object[]{string2});
                }
                bl = true;
                validateJspResult.setLanguage(string2);
            } else if (string3.equals("extends")) {
                bl = true;
                validateJspResult.setExtendsClass(string2);
            } else if (string3.equals("import")) {
                bl = true;
            } else if (string3.equals("session")) {
                bl = true;
                if (string2.equalsIgnoreCase("true")) {
                    validateJspResult.setGenSessionVariable(true);
                } else {
                    if (!string2.equalsIgnoreCase("false")) throw new JspTranslationException(element, "jsp.error.invalid.value.for.session");
                    validateJspResult.setGenSessionVariable(false);
                }
            } else if (string3.equals("buffer")) {
                bl = true;
                if (string2.equalsIgnoreCase("none")) {
                    validateJspResult.setBufferSize(0);
                } else {
                    object = null;
                    try {
                        int n = string2.indexOf("k");
                        string = n == -1 ? string2 : string2.substring(0, n);
                        object = new Integer(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JspTranslationException(element, "jsp.error.page.invalid.buffer");
                    }
                    validateJspResult.setBufferSize((Integer)object * 1024);
                }
                this.bufferValue = string2;
                if (this.autoFlushValue != null && this.bufferValue.equalsIgnoreCase("none") && !this.autoFlushValue.booleanValue()) {
                    throw new JspTranslationException(element, "jsp.error.page.invalid.autoflush.buffer");
                }
            } else if (string3.equals("autoFlush")) {
                bl = true;
                if (string2.equalsIgnoreCase("true")) {
                    validateJspResult.setAutoFlush(true);
                    this.autoFlushValue = new Boolean(true);
                } else {
                    if (!string2.equalsIgnoreCase("false")) throw new JspTranslationException(element, "jsp.error.page.invalid.autoflush");
                    validateJspResult.setAutoFlush(false);
                    this.autoFlushValue = new Boolean(false);
                }
                if (this.bufferValue != null && this.bufferValue.equalsIgnoreCase("none") && !this.autoFlushValue.booleanValue()) {
                    throw new JspTranslationException(element, "jsp.error.page.invalid.autoflush.buffer");
                }
            } else if (string3.equals("isThreadSafe")) {
                bl = true;
                if (string2.equalsIgnoreCase("true")) {
                    validateJspResult.setSingleThreaded(false);
                } else {
                    if (!string2.equalsIgnoreCase("false")) throw new JspTranslationException(element, "jsp.error.page.invalid.threadsafe");
                    validateJspResult.setSingleThreaded(true);
                }
            } else if (string3.equals("info")) {
                bl = true;
                validateJspResult.setInfo(string2);
            } else if (string3.equals("errorPage")) {
                bl = true;
                validateJspResult.setError(string2);
            } else if (string3.equals("isErrorPage")) {
                bl = true;
                if (string2.equalsIgnoreCase("true")) {
                    validateJspResult.setIsErrorPage(true);
                } else {
                    if (!string2.equalsIgnoreCase("false")) throw new JspTranslationException(element, "jsp.error.page.invalid.iserrorpage");
                    validateJspResult.setIsErrorPage(false);
                }
            } else if (string3.equals("contentType")) {
                bl = true;
                validateJspResult.setContentType(string2);
            } else if (string3.equals("pageEncoding")) {
                bl = true;
                object = new JspId(element.getAttribute("jsp:id"));
                String string4 = this.jspConfiguration.getPageEncoding();
                string = EncodingUtils.getJvmConverter(string2);
                if (string4 != null && (string.startsWith("UTF-16") ? !string4.startsWith("UTF-16") : !string.equals(string4))) {
                    throw new JspTranslationException(element, "jsp.error.page.pageencoding.mismatch", new Object[]{string, string4});
                }
                validateJspResult.setPageEncoding(string);
            } else if (string3.equals("isELIgnored")) {
                bl = true;
                if (string2.equalsIgnoreCase("true")) {
                    validateJspResult.setIsELIgnored(true);
                    this.jspConfiguration.setElIgnored(true);
                } else {
                    if (!string2.equalsIgnoreCase("false")) throw new JspTranslationException(element, "jsp.error.page.invalid.iselignored");
                    validateJspResult.setIsELIgnored(false);
                    this.jspConfiguration.setElIgnored(false);
                }
            } else if (string3.equals("jsp:id")) {
                bl = true;
            } else if (string3.startsWith("xmlns")) {
                bl = true;
            }
            if (bl) continue;
            throw new JspTranslationException(element, "jsp.error.page.directive.unknown", new Object[]{string3});
        }
    }

    protected void visitJspInvokeStart(Element element) throws JspCoreException {
        throw new JspTranslationException(element, "jsp.error.invoke.only.in.tagfiles");
    }

    protected void visitJspDoBodyStart(Element element) throws JspCoreException {
        throw new JspTranslationException(element, "jsp.error.dobody.only.in.tagfiles");
    }

    protected void visitTagDirectiveStart(Element element) throws JspCoreException {
        throw new JspTranslationException(element, "jsp.error.tag.directive.only.in.tagfiles");
    }

    protected void visitAttributeDirectiveStart(Element element) throws JspCoreException {
        throw new JspTranslationException(element, "jsp.error.attribute.directive.only.in.tagfiles");
    }

    protected void visitVariableDirectiveStart(Element element) throws JspCoreException {
        throw new JspTranslationException(element, "jsp.error.variable.directive.only.in.tagfiles");
    }

    protected Object addUserPageDirective(String string, String string2) {
        return this.userDefinedDirectives.put(string, string2);
    }
}

