/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagFileTagInfo;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateTagFileResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.HashMap;
import java.util.List;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ValidateTagFileVisitor
extends ValidateVisitor {
    private static final String[] invokeAttrNames = new String[]{"fragment", "var", "varReader", "scope"};
    private static final String[] doBodyAttrNames = new String[]{"var", "varReader", "scope"};
    private static final String[] tagDirectiveAttrNames = new String[]{"display-name", "body-content", "dynamic-attributes", "small-icon", "large-icon", "description", "example", "language", "import", "pageEncoding", "isELIgnored"};
    private static final String[] attributeDirectiveAttrNames = new String[]{"name", "required", "fragment", "rtexprvalue", "type", "description"};
    private static final String[] variableDirectiveAttrNames = new String[]{"name-given", "name-from-attribute", "alias", "variable-class", "declare", "scope", "description"};
    private static final String[] invokeRequiredAttrs = new String[]{"fragment"};
    private static final String[] attributeDirectiveRequiredAttrs = new String[]{"name"};
    private HashMap userDefinedDirectives = new HashMap();

    public ValidateTagFileVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        super(jspVisitorUsage, jspConfiguration, jspCoreContext, hashMap, jspVisitorInputMap);
        this.result = new ValidateTagFileResult(jspVisitorUsage.getJspVisitorDefinition().getId());
    }

    public JspVisitorResult getResult() throws JspCoreException {
        return this.result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitTagDirectiveStart(Element element) throws JspCoreException {
        this.validateAttributes(element, tagDirectiveAttrNames);
        ValidateTagFileResult validateTagFileResult = (ValidateTagFileResult)this.result;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) throw new JspTranslationException(element, "jsp.error.page.directive.contains.no.attributes");
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            Node node = namedNodeMap.item(i);
            String string2 = node.getNodeName();
            Object object = this.addUserTagDirective(string2, string = node.getNodeValue());
            if (!(object == null || string2.equals("import") || string2.equals("jsp:id") || object.equals(string))) {
                throw new JspTranslationException(element, "jsp.error.multiple.occurrences.tag.directive", new Object[]{string2, object, string});
            }
            boolean bl = false;
            if (string2.equals("language")) {
                bl = true;
                this.result.setLanguage(string);
            } else if (string2.equals("import")) {
                bl = true;
            } else if (string2.equals("pageEncoding")) {
                bl = true;
                this.result.setPageEncoding(string);
            } else if (string2.equals("isELIgnored")) {
                bl = true;
                if (string.equalsIgnoreCase("true")) {
                    this.result.setIsELIgnored(true);
                    this.jspConfiguration.setElIgnored(true);
                } else {
                    if (!string.equalsIgnoreCase("false")) throw new JspTranslationException(element, "jsp.error.page.invalid.iselignored");
                    this.result.setIsELIgnored(false);
                    this.jspConfiguration.setElIgnored(false);
                }
            } else if (string2.equals("display-name")) {
                bl = true;
                validateTagFileResult.setDisplayName(string);
            } else if (string2.equals("body-content")) {
                if (!string.equals("scriptless") && !string.equals("tagdependent") && !string.equals("empty")) throw new JspTranslationException(element, "jsp.body-content.directive.value.invalid", new Object[]{string});
                bl = true;
                validateTagFileResult.setBodyContent(string);
            } else if (string2.equals("dynamic-attributes")) {
                bl = true;
                validateTagFileResult.setDynamicAttributes(string);
            } else if (string2.equals("small-icon")) {
                bl = true;
                validateTagFileResult.setSmallIcon(string);
            } else if (string2.equals("large-icon")) {
                bl = true;
                validateTagFileResult.setLargeIcon(string);
            } else if (string2.equals("description")) {
                bl = true;
                validateTagFileResult.setDescription(string);
            } else if (string2.equals("example")) {
                bl = true;
                validateTagFileResult.setExample(string);
            } else if (string2.equals("jsp:id")) {
                bl = true;
            } else if (string2.startsWith("xmlns")) {
                bl = true;
            }
            if (bl) continue;
            throw new JspTranslationException(element, "jsp.error.page.directive.unknown", new Object[]{string2});
        }
    }

    protected void visitPageDirectiveStart(Element element) throws JspCoreException {
        throw new JspTranslationException(element, "jsp.error.page.directive.only.in.jsps");
    }

    protected void visitJspInvokeStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, invokeRequiredAttrs);
        this.validateAttributes(list, element, invokeAttrNames);
        this.validateEmptyBody(element);
        if (element.hasAttribute("var") && element.hasAttribute("varReader")) {
            throw new JspTranslationException(element, "jsp.error.tagfile.invoke.var_varreader");
        }
        if (element.hasAttribute("scope") && !element.hasAttribute("var") && !element.hasAttribute("varReader")) {
            throw new JspTranslationException(element, "jsp.error.tagfile.invoke.scope_var_varreader");
        }
        Attr attr = element.getAttributeNode("scope");
        if (attr != null) {
            boolean bl = false;
            if (attr.getValue().equals("page")) {
                bl = true;
            } else if (attr.getValue().equals("request")) {
                bl = true;
            } else if (attr.getValue().equals("session")) {
                bl = true;
            } else if (attr.getValue().equals("application")) {
                bl = true;
            }
            if (!bl) {
                throw new JspTranslationException(element, "jsp.error.tagfile.invoke.scope_invalid");
            }
        }
    }

    protected void visitJspDoBodyStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateAttributes(list, element, doBodyAttrNames);
        this.validateEmptyBody(element);
        Attr attr = element.getAttributeNode("var");
        Attr attr2 = element.getAttributeNode("varReader");
        if (attr != null && attr2 != null) {
            throw new JspTranslationException(element, "jsp.error.tagfile.dobody.var_varreader");
        }
        if (element.hasAttribute("scope") && !element.hasAttribute("var") && !element.hasAttribute("varReader")) {
            throw new JspTranslationException(element, "jsp.error.tagfile.dobody.scope_var_varreader");
        }
        Attr attr3 = element.getAttributeNode("scope");
        if (attr3 != null) {
            boolean bl = false;
            if (attr3.getValue().equals("page")) {
                bl = true;
            } else if (attr3.getValue().equals("request")) {
                bl = true;
            } else if (attr3.getValue().equals("session")) {
                bl = true;
            } else if (attr3.getValue().equals("application")) {
                bl = true;
            }
            if (!bl) {
                throw new JspTranslationException(element, "jsp.error.tagfile.dobody.scope_invalid");
            }
        }
    }

    protected void visitAttributeDirectiveStart(Element element) throws JspCoreException {
        TagFileTagInfo tagFileTagInfo;
        TagFileInfo tagFileInfo;
        TagInfo tagInfo;
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, attributeDirectiveRequiredAttrs);
        this.validateAttributes(list, element, attributeDirectiveAttrNames);
        Attr attr = element.getAttributeNode("name");
        if (attr != null && (tagInfo = (tagFileInfo = (TagFileInfo)this.inputMap.get("TagFileInfo")).getTagInfo()) instanceof TagFileTagInfo && (tagFileTagInfo = (TagFileTagInfo)tagInfo).getDynamicAttributesMapName() != null && tagFileTagInfo.getDynamicAttributesMapName().equals(attr.getValue())) {
            throw new JspTranslationException(element, "jsp.error.tagfile.tag_dynamic_attrs_equals_attr_name");
        }
    }

    protected void visitVariableDirectiveStart(Element element) throws JspCoreException {
        TagFileTagInfo tagFileTagInfo;
        TagFileInfo tagFileInfo;
        TagInfo tagInfo;
        this.validateAttributes(element, variableDirectiveAttrNames);
        Attr attr = element.getAttributeNode("name-given");
        if (attr != null && (tagInfo = (tagFileInfo = (TagFileInfo)this.inputMap.get("TagFileInfo")).getTagInfo()) instanceof TagFileTagInfo && (tagFileTagInfo = (TagFileTagInfo)tagInfo).getDynamicAttributesMapName() != null && tagFileTagInfo.getDynamicAttributesMapName().equals(attr.getValue())) {
            throw new JspTranslationException(element, "jsp.error.tagfile.tag_dynamic_attrs_equals_var_name_given");
        }
    }

    protected Object addUserTagDirective(String string, String string2) {
        return this.userDefinedDirectives.put(string, string2);
    }
}

