/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.bean.BeanRepository;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.FunctionSignature;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.PageDataImpl;
import com.ibm.ws.jsp.translator.visitor.validator.TagCountResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.commons.el.ArraySuffix;
import org.apache.commons.el.BinaryOperatorExpression;
import org.apache.commons.el.ComplexValue;
import org.apache.commons.el.ConditionalExpression;
import org.apache.commons.el.Expression;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.ExpressionString;
import org.apache.commons.el.FunctionInvocation;
import org.apache.commons.el.UnaryOperatorExpression;
import org.apache.commons.el.ValueSuffix;
import org.apache.commons.el.parser.ELParser;
import org.apache.commons.el.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ValidateVisitor
extends JspVisitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor";
    public static final String[] ATTR_STANDARD_ACTIONS = new String[]{"useBean", "setProperty", "getProperty", "include", "forward", "param", "plugin", "invoke", "doBody", "element", "output"};
    public static final String[] BODY_STANDARD_ACTIONS = new String[]{"useBean", "setProperty", "getProperty", "include", "forward", "param", "params", "plugin", "element", "output", "fallback"};
    private static final String[] includeAttrNames = new String[]{"page", "flush"};
    private static final String[] forwardAttrNames = new String[]{"page"};
    private static final String[] useBeanAttrNames = new String[]{"id", "scope", "class", "beanName", "type"};
    private static final String[] setPropertyAttrNames = new String[]{"name", "property", "param", "value"};
    private static final String[] getPropertyAttrNames = new String[]{"name", "property"};
    private static final String[] paramAttrNames = new String[]{"name", "value"};
    private static final String[] pluginAttrNames = new String[]{"type", "code", "codebase", "align", "archive", "height", "hspace", "jreversion", "name", "vspace", "title", "width", "nspluginurl", "iepluginurl", "mayscript"};
    private static final String[] attributeAttrNames = new String[]{"name", "trim"};
    private static final String[] elementAttrNames = new String[]{"name"};
    private static final String[] outputAttrNames = new String[]{"omit-xml-declaration", "doctype-root-element", "doctype-system", "doctype-public"};
    private static final String[] includeRuntimeAttrNames = new String[]{"page"};
    private static final String[] forwardRuntimeAttrNames = new String[]{"page"};
    private static final String[] setPropertyRuntimeAttrNames = new String[]{"value"};
    private static final String[] useBeanRuntimeAttrNames = new String[]{"beanName"};
    private static final String[] pluginRuntimeAttrNames = new String[]{"height", "width"};
    private static final String[] paramRuntimeAttrNames = new String[]{"value"};
    private static final String[] includeRequiredAttrs = new String[]{"page"};
    private static final String[] forwardRequiredAttrs = new String[]{"page"};
    private static final String[] useBeanRequiredAttrsClass = new String[]{"class", "id"};
    private static final String[] useBeanRequiredAttrsType = new String[]{"type", "id"};
    private static final String[] setPropertyRequiredAttrs = new String[]{"name", "property"};
    private static final String[] getPropertyRequiredAttrs = new String[]{"name", "property"};
    private static final String[] paramAttrsRequiredAttrs = new String[]{"name", "value"};
    private static final String[] pluginAttrsRequiredAttrs = new String[]{"type", "code", "codebase"};
    private static final String[] attributeRequiredAttrs = new String[]{"name"};
    private static final String[] elementRequiredAttrs = new String[]{"name"};
    protected ValidateResult result = null;
    protected TagLibraryCache tagLibraryCache = null;
    protected Stack tagCountStack = new Stack();
    private Vector dupVector = new Vector();
    private HashMap scriptVars = new HashMap();
    private HashMap prefixToUriMap = new HashMap();
    private ExpressionEvaluatorImpl expressionEvaluator;
    protected String jspUri = null;
    protected TagCountResult tagCountResult = null;
    protected boolean dupFlag = false;
    protected JspOptions jspOptions = null;
    protected boolean evalQuotedAndEscapedExpression = false;

    protected ValidateVisitor(JspVisitorUsage jspVisitorUsage, JspConfiguration jspConfiguration, JspCoreContext jspCoreContext, HashMap hashMap, JspVisitorInputMap jspVisitorInputMap) throws JspCoreException {
        super(jspVisitorUsage, jspConfiguration, jspCoreContext, hashMap, jspVisitorInputMap);
        this.tagLibraryCache = (TagLibraryCache)jspVisitorInputMap.get("TagLibraryCache");
        this.jspUri = (String)jspVisitorInputMap.get("JspUri");
        this.tagCountResult = (TagCountResult)hashMap.get("TagCount");
        this.jspOptions = (JspOptions)jspVisitorInputMap.get("JspOptions");
        this.evalQuotedAndEscapedExpression = this.jspOptions.isEvalQuotedAndEscapedExpression();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "ValidateVisitor", "evalQuotedAndEscapedExpression =[" + this.evalQuotedAndEscapedExpression + "]");
        }
        this.expressionEvaluator = this.jspOptions.isDisableELCache() ? new ExpressionEvaluatorImpl(true) : new ExpressionEvaluatorImpl(false);
    }

    public JspVisitorResult getResult() throws JspCoreException {
        List list = (List)this.inputMap.get("StaticIncludeDependencyList");
        this.result.getDependencyList().addAll(list);
        List list2 = (List)this.inputMap.get("TagFileDependencies");
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            TagFileId tagFileId = (TagFileId)iterator.next();
            TagLibraryInfoImpl tagLibraryInfoImpl = this.tagLibraryCache.getTagLibraryInfo(tagFileId.getUri(), tagFileId.getPrefix(), this.jspUri);
            if (!tagLibraryInfoImpl.getInputSource().getAbsoluteURL().getProtocol().equals("file")) continue;
            TagFileInfo tagFileInfo = tagLibraryInfoImpl.getTagFile(tagFileId.getTagName());
            this.result.getDependencyList().add(tagFileInfo.getPath());
        }
        this.getBeanRepository();
        return this.result;
    }

    private BeanRepository getBeanRepository() {
        if (this.result.getBeanRepository() == null) {
            this.result.setBeanRepository(new BeanRepository(this.context.getJspClassloaderContext().getClassLoader()));
        }
        return this.result.getBeanRepository();
    }

    protected void visitJspParamsStart(Element element) throws JspCoreException {
        Node node = element.getParentNode();
        if (node.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
            if (!node.getLocalName().equals("plugin") && !node.getLocalName().equals("body")) {
                throw new JspTranslationException(element, "jsp.params.invalid.parent");
            }
        } else {
            throw new JspTranslationException(element, "jsp.params.invalid.parent");
        }
    }

    protected void visitJspFallbackStart(Element element) throws JspCoreException {
        Node node = element.getParentNode();
        if (node.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
            if (!node.getLocalName().equals("plugin") && !node.getLocalName().equals("body")) {
                throw new JspTranslationException(element, "jsp.fallback.invalid.parent");
            }
        } else {
            throw new JspTranslationException(element, "jsp.fallback.invalid.parent");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitJspParamStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, paramAttrsRequiredAttrs);
        this.validateAttributes(list, element, paramAttrNames);
        this.validateRuntimeExpressions(element, paramRuntimeAttrNames, Object.class);
        this.validateEmptyBody(element);
        Node node = element.getParentNode();
        String string = element.getParentNode().getLocalName();
        if (!node.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) throw new JspTranslationException(element, "jsp.param.invalid.parent");
        if (!string.equals("include") && !string.equals("forward") && !string.equals("params") && !string.equals("body")) throw new JspTranslationException(element, "jsp.param.invalid.parent");
        String string2 = this.getAttributeValue(element, "name");
        if (!string2.equals("")) return;
        throw new JspTranslationException(element, "jsp.param.name.empty");
    }

    protected void visitCustomTagStart(Element element) throws JspCoreException {
        String string;
        TagFileInfo tagFileInfo;
        TagInfo tagInfo;
        this.getAttributeList(element);
        String string2 = element.getNamespaceURI();
        String string3 = element.getPrefix();
        String string4 = element.getLocalName();
        boolean bl = false;
        if (string2.startsWith("urn:jsptld:")) {
            string2 = string2.substring(string2.indexOf("urn:jsptld:") + 11);
        } else if (string2.startsWith("urn:jsptagdir:")) {
            string2 = string2.substring(string2.indexOf("urn:jsptagdir:") + 14);
        }
        TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string2));
        if (tagLibraryInfoImpl == null) {
            tagLibraryInfoImpl = this.tagLibraryCache.getTagLibraryInfo(string2, string3, this.jspUri);
            if (tagLibraryInfoImpl != null) {
                if (tagLibraryInfoImpl.getTldFilePath() != null && tagLibraryInfoImpl.getInputSource().getAbsoluteURL().getProtocol().equals("file") && !this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(string2)) {
                    this.result.getDependencyList().add(tagLibraryInfoImpl.getTldFilePath());
                }
                this.result.getTagLibMap().put(string2, tagLibraryInfoImpl);
                this.prefixToUriMap.put(string3, string2);
                this.validateTagLib(element.getOwnerDocument(), string2, string3, tagLibraryInfoImpl);
            } else {
                if (!this.jspConfiguration.isXml()) {
                    throw new JspTranslationException(element, "jsp.error.tld.not.found", new Object[]{string2, string3});
                }
                return;
            }
        }
        if ((tagInfo = tagLibraryInfoImpl.getTag(string4)) == null) {
            tagFileInfo = tagLibraryInfoImpl.getTagFile(string4);
            if (tagFileInfo == null) {
                throw new JspTranslationException(element, "jsp.error.tagfile.not.found", new Object[]{string4});
            }
            tagInfo = tagFileInfo.getTagInfo();
            this.tagLibraryCache.addTagFileClassInfo(tagFileInfo);
            bl = true;
        }
        tagFileInfo = tagInfo.getAttributes();
        this.validateCustomTagAttributes(element, (TagAttributeInfo[])tagFileInfo);
        CustomTagInstance customTagInstance = this.validateCustomTagAttributeValues(element, (TagAttributeInfo[])tagFileInfo, tagInfo.hasDynamicAttributes());
        Hashtable hashtable = customTagInstance.getAttributes();
        boolean bl2 = customTagInstance.isScriptless();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        for (int i = 0; i < ((TagFileInfo)tagFileInfo).length; ++i) {
            if (tagFileInfo[i].isRequired() && !hashtable.containsKey(tagFileInfo[i].getName())) {
                throw new JspTranslationException(element, "jsp.error.missing.attribute", new Object[]{tagFileInfo[i].getName()});
            }
            if (tagFileInfo[i].isRequired() || !hashtable.containsKey(tagFileInfo[i].getName())) continue;
            stringBuffer.append("_" + tagFileInfo[i].getName());
        }
        if (JspTranslatorUtil.hasBody(element) || JspTranslatorUtil.hasJspBody(element)) {
            stringBuffer.append("_jspxhasbody");
        }
        String string5 = stringBuffer.toString();
        stringBuffer = new StringBuffer("_" + string5.hashCode());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            boolean bl3 = false;
            string = (String)enumeration.nextElement();
            for (int i = 0; i < ((TagFileInfo)tagFileInfo).length; ++i) {
                if (!tagFileInfo[i].getName().equals(string)) continue;
                bl3 = true;
                break;
            }
            if (bl3 || tagInfo.hasDynamicAttributes()) continue;
            throw new JspTranslationException(element, "jsp.error.bad.attribute", new Object[]{string});
        }
        TagData tagData = new TagData(hashtable);
        if (!tagInfo.isValid(tagData)) {
            throw new JspTranslationException(element, "jsp.error.invalid.attributes");
        }
        string = tagInfo.getTagExtraInfo();
        if (string != null && string.getVariableInfo(tagData) != null && string.getVariableInfo(tagData).length > 0 && tagInfo.getTagVariableInfos().length > 0) {
            throw new JspTranslationException(element, "jsp.error.non_null_tei_and_var_subelems");
        }
        ValidationMessage[] validationMessageArray = tagInfo.validate(tagData);
        if (validationMessageArray != null && validationMessageArray.length > 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < validationMessageArray.length; ++i) {
                if (validationMessageArray[i] == null) continue;
                stringBuffer2.append("<p>");
                stringBuffer2.append(validationMessageArray[i].getId());
                stringBuffer2.append(": ");
                stringBuffer2.append(validationMessageArray[i].getMessage());
                stringBuffer2.append("</p>");
            }
            throw new JspTranslationException(element, "jsp.error.tei.invalid.attributes", new Object[]{string2, string4, stringBuffer2.toString()});
        }
        if (bl2) {
            bl2 = this.areChildrenScriptless(element);
        }
        TagVariableInfo[] tagVariableInfoArray = tagInfo.getTagVariableInfos();
        VariableInfo[] variableInfoArray = tagInfo.getVariableInfo(tagData);
        if (variableInfoArray == null) {
            variableInfoArray = new VariableInfo[]{};
        }
        boolean bl4 = variableInfoArray.length > 0 || tagVariableInfoArray.length > 0;
        Integer n = (Integer)this.tagCountResult.getCountMap().get(element);
        Vector vector = this.setScriptingVars(tagVariableInfoArray, variableInfoArray, tagData, 1, n);
        Vector vector2 = this.setScriptingVars(tagVariableInfoArray, variableInfoArray, tagData, 0, n);
        this.result.addCollectTagData(element, bl2, bl4, vector, null, vector2, tagData, stringBuffer.toString());
        if (this.tagLibraryCache.getTagClassInfo(tagInfo) == null && !bl) {
            Class<?> clazz = null;
            try {
                clazz = this.context.getJspClassloaderContext().getClassLoader().loadClass(tagInfo.getTagClassName());
                this.tagLibraryCache.addTagClassInfo(tagInfo, clazz);
            }
            catch (Exception exception) {
                throw new JspTranslationException(element, "jsp.error.unable.loadclass", new Object[]{tagInfo.getTagClassName()});
            }
        }
        this.tagCountStack.push(this.tagCountResult.getCountMap().get(element));
    }

    protected void visitCustomTagEnd(Element element) throws JspCoreException {
        ValidateResult.CollectedTagData collectedTagData = this.result.getCollectedTagData(element);
        String string = element.getNamespaceURI();
        String string2 = element.getPrefix();
        String string3 = element.getLocalName();
        if (string.startsWith("urn:jsptld:")) {
            string = string.substring(string.indexOf("urn:jsptld:") + 11);
        } else if (string.startsWith("urn:jsptagdir:")) {
            string = string.substring(string.indexOf("urn:jsptagdir:") + 14);
        }
        TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string));
        if (tagLibraryInfoImpl != null) {
            TagFileInfo tagFileInfo;
            this.tagCountStack.pop();
            TagInfo tagInfo = tagLibraryInfoImpl.getTag(string3);
            if (tagInfo == null) {
                tagFileInfo = tagLibraryInfoImpl.getTagFile(string3);
                tagInfo = tagFileInfo.getTagInfo();
            }
            tagFileInfo = tagInfo.getTagVariableInfos();
            VariableInfo[] variableInfoArray = tagInfo.getVariableInfo(collectedTagData.getTagData());
            if (variableInfoArray == null) {
                variableInfoArray = new VariableInfo[]{};
            }
            Integer n = (Integer)this.tagCountResult.getCountMap().get(element);
            Vector vector = this.setScriptingVars((TagVariableInfo[])tagFileInfo, variableInfoArray, collectedTagData.getTagData(), 2, n);
            if (this.dupFlag) {
                Vector vector2 = this.getDuplicateVars();
                collectedTagData.setAtEndDuplicateVars(vector2);
                this.dupFlag = false;
            }
            collectedTagData.setAtEndScriptingVars(vector);
        }
    }

    protected void visitJspRootStart(Element element) throws JspCoreException {
        if (element.getParentNode().getNodeType() != 9) {
            throw new JspTranslationException(element, "jsp.error.root.must.be.top");
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            if (!element.hasAttribute("version")) {
                throw new JspTranslationException(element, "jsp.error.root.invalid.version", new Object[]{"none found"});
            }
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                if (node.getNodeName().startsWith("xmlns:")) {
                    String string = node.getNodeName();
                    string = string.substring(string.indexOf(":") + 1);
                    String string2 = node.getNodeValue();
                    if (string2.startsWith("urn:jsptld:")) {
                        string2 = string2.substring(string2.indexOf("urn:jsptld:") + 11);
                    } else if (string2.startsWith("urn:jsptagdir:")) {
                        string2 = string2.substring(string2.indexOf("urn:jsptagdir:") + 14);
                    }
                    if (string2.equals("http://java.sun.com/JSP/Page") || string2.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                    TagLibraryInfoImpl tagLibraryInfoImpl = this.tagLibraryCache.getTagLibraryInfo(string2, string, this.jspUri);
                    if (tagLibraryInfoImpl != null) {
                        if (tagLibraryInfoImpl.getTldFilePath() != null && tagLibraryInfoImpl.getInputSource().getAbsoluteURL().getProtocol().equals("file") && !this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(string2)) {
                            this.result.getDependencyList().add(tagLibraryInfoImpl.getTldFilePath());
                        }
                        if (this.result.getTagLibMap().containsKey(string2)) continue;
                        this.result.getTagLibMap().put(string2, tagLibraryInfoImpl);
                        this.prefixToUriMap.put(string, string2);
                        this.validateTagLib(element.getOwnerDocument(), string2, string, tagLibraryInfoImpl);
                        continue;
                    }
                    if (this.jspConfiguration.isXml()) continue;
                    throw new JspTranslationException(element, "jsp.error.tld.not.found", new Object[]{string2, string});
                }
                if (!node.getNodeName().equals("version") || node.getNodeValue().equals("1.2") || node.getNodeValue().equals("2.0")) continue;
                throw new JspTranslationException(element, "jsp.error.root.invalid.version", new Object[]{node.getNodeValue()});
            }
        } else {
            throw new JspTranslationException(element, "jsp.root.has.no.attributes");
        }
    }

    protected void visitJspUseBeanStart(Element element) throws JspCoreException {
        Object object;
        List list = this.getAttributeList(element);
        try {
            this.validateRequiredAttributes(element, list, useBeanRequiredAttrsClass);
        }
        catch (JspCoreException jspCoreException) {
            this.validateRequiredAttributes(element, list, useBeanRequiredAttrsType);
        }
        this.validateAttributes(list, element, useBeanAttrNames);
        this.validateRuntimeExpressions(element, useBeanRuntimeAttrNames, String.class);
        String string = this.getAttributeValue(element, "id");
        String string2 = this.getAttributeValue(element, "scope");
        String string3 = this.getAttributeValue(element, "class");
        String string4 = this.getAttributeValue(element, "type");
        String string5 = this.getAttributeValue(element, "beanName");
        if (string.equals("")) {
            throw new JspTranslationException(element, "jsp.error.usebean.missing.attribute");
        }
        if (string3.equals("") && string4.equals("")) {
            throw new JspTranslationException(element, "jsp.error.usebean.missing.type");
        }
        if (this.getBeanRepository().checkVariable(string)) {
            throw new JspTranslationException(element, "jsp.error.usebean.duplicate", new Object[]{string});
        }
        if (!string3.equals("") && !string5.equals("")) {
            throw new JspTranslationException(element, "jsp.error.usebean.not.both", new Object[]{string3, string5});
        }
        if (!string3.equals("") && !string4.equals("")) {
            try {
                object = Class.forName(string3, true, this.context.getJspClassloaderContext().getClassLoader());
                Class<?> clazz = Class.forName(string4, true, this.context.getJspClassloaderContext().getClassLoader());
                if (!clazz.isAssignableFrom((Class<?>)object)) {
                    throw new JspTranslationException(element, "jsp.error.usebean.class.must.be.assignable.to.type", new Object[]{string3, string4, element.getTagName()});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JspTranslationException(element, "jsp.error.usebean.cannot.locate.class.to.validate.assignable", new Object[]{string3, string4, element.getTagName()}, classNotFoundException);
            }
        }
        object = null;
        object = string3 != null && !string3.equals("") ? string3 : string4;
        if (string2.equals("") || string2.equals("page")) {
            this.getBeanRepository().addPageBean(string, (String)object);
        } else if (string2.equals("request")) {
            this.getBeanRepository().addRequestBean(string, (String)object);
        } else if (string2.equals("session")) {
            this.getBeanRepository().addSessionBean(string, (String)object);
        } else if (string2.equals("application")) {
            this.getBeanRepository().addApplicationBean(string, (String)object);
        } else {
            throw new JspTranslationException(element, "jsp.error.usebean.invalid.scope", new Object[]{string2});
        }
    }

    protected void visitJspExpressionStart(Element element) throws JspCoreException {
        Node node = element.getFirstChild();
        if (node.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(element, "jsp.error.expressions.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(element, "jsp.error.expression.contains.no.cdata");
        }
    }

    protected void visitJspScriptletStart(Element element) throws JspCoreException {
        Node node = element.getFirstChild();
        if (node.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(element, "jsp.error.scriptlets.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(element, "jsp.error.scriptlet.contains.no.cdata");
        }
    }

    protected void visitJspDeclarationStart(Element element) throws JspCoreException {
        Node node = element.getFirstChild();
        if (node.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(element, "jsp.error.declarations.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(element, "jsp.error.declaration.contains.no.cdata");
        }
    }

    protected void visitJspTextStart(Element element) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "jspElement =[" + element + "]");
        }
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node node = element.getChildNodes().item(i);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "Node n =[" + node + "]");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "Node n TYPE =[" + node.getNodeType() + "]");
            }
            if (node.getNodeType() == 4) {
                CDATASection cDATASection = (CDATASection)node;
                this.visitJspELTextStart(element, cDATASection.getData(), class$java$lang$String == null ? ValidateVisitor.class$("java.lang.String") : class$java$lang$String);
                continue;
            }
            if (node.getNodeType() == 7) continue;
            throw new JspTranslationException(element, "jsp.error.jsptext.has.child.elements");
        }
    }

    protected void visitJspIncludeStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, includeRequiredAttrs);
        String string = this.getAttributeValue(element, "flush");
        if (!(string.equals("") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("true"))) {
            throw new JspTranslationException(element, "jsp.error.include.flush.invalid.value", new Object[]{string});
        }
        this.validateAttributes(list, element, includeAttrNames);
        this.validateRuntimeExpressions(element, includeRuntimeAttrNames, String.class);
    }

    protected void visitJspGetPropertyStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, getPropertyRequiredAttrs);
        this.validateAttributes(list, element, getPropertyAttrNames);
    }

    protected void visitJspForwardStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, forwardRequiredAttrs);
        this.validateAttributes(list, element, forwardAttrNames);
        this.validateRuntimeExpressions(element, forwardRuntimeAttrNames, String.class);
    }

    protected void visitJspPluginStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, pluginAttrsRequiredAttrs);
        this.validateAttributes(list, element, pluginAttrNames);
        this.validateRuntimeExpressions(element, pluginRuntimeAttrNames, String.class);
        String string = this.getAttributeValue(element, "type");
        if (!string.equals("applet") && !string.equals("bean")) {
            throw new JspTranslationException(element, "jsp.error.plugin.invalid.type", new Object[]{string});
        }
    }

    protected void visitJspSetPropertyStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element);
        this.validateRequiredAttributes(element, list, setPropertyRequiredAttrs);
        this.validateAttributes(list, element, setPropertyAttrNames);
        this.validateRuntimeExpressions(element, setPropertyRuntimeAttrNames, Object.class);
    }

    protected void visitJspAttributeStart(Element element) throws JspCoreException {
        Object object;
        Object object2;
        Object object3;
        Node node = element.getParentNode();
        if (node.getNodeType() == 1) {
            String string;
            object3 = (Element)node;
            object2 = element.getAttribute("name");
            String string2 = null;
            if (((String)object2).indexOf(58) != -1) {
                string2 = ((String)object2).substring(0, ((String)object2).indexOf(58));
                object2 = ((String)object2).substring(((String)object2).indexOf(58) + 1);
            }
            if ((string = (String)this.prefixToUriMap.get(object3.getPrefix())) == null) {
                object = object3.getLocalName();
                boolean bl = false;
                for (int i = 0; i < ATTR_STANDARD_ACTIONS.length; ++i) {
                    if (!((String)object).equals(ATTR_STANDARD_ACTIONS[i])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new JspTranslationException(element, "jsp.error.jsp.attribute.invalid.parent");
                }
                if (string2 != null && !object3.getLocalName().equals("element") && !object3.getPrefix().equals(string2)) {
                    throw new JspTranslationException(element, "jsp.error.jsp.attribute.prefix.mismatch", new Object[]{object3.getPrefix(), string2});
                }
            } else if (string2 != null) {
                object = object3.getLocalName();
                TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string));
                TagInfo tagInfo = tagLibraryInfoImpl.getTag((String)object);
                if (!tagInfo.hasDynamicAttributes() && !object3.getPrefix().equals(string2)) {
                    throw new JspTranslationException(element, "jsp.error.jsp.attribute.prefix.mismatch", new Object[]{object3.getPrefix(), string2});
                }
            }
        } else {
            throw new JspTranslationException(element, "jsp.error.jsp.attribute.invalid.parent");
        }
        object3 = this.getAttributeList(element);
        this.validateRequiredAttributes(element, (List)object3, attributeRequiredAttrs);
        this.validateAttributes((List)object3, element, attributeAttrNames);
        object2 = element.getChildNodes();
        int n = object2.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            object = object2.item(i);
            if (object.getNodeType() != 1 || (element2 = (Element)object).getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element2.getLocalName().equals("attribute")) continue;
            throw new JspTranslationException(element, "jsp.error.jsp.attribute.defined.value.jsp.attribute");
        }
    }

    protected void visitJspElementStart(Element element) throws JspCoreException {
        List list = this.getAttributeList(element, true);
        this.validateRequiredAttributes(element, list, elementRequiredAttrs);
        this.validateAttributes(element, elementAttrNames);
    }

    protected void visitJspOutputStart(Element element) throws JspCoreException {
        if (!this.jspConfiguration.isXml()) {
            throw new JspTranslationException(element, "jsp.error.jspoutput.xml.only");
        }
        this.validateAttributes(element, outputAttrNames);
        if (element.hasChildNodes()) {
            throw new JspTranslationException(element, "jsp.error.output.has.body");
        }
        Attr attr = element.getAttributeNode("doctype-root-element");
        Attr attr2 = element.getAttributeNode("doctype-system");
        Attr attr3 = element.getAttributeNode("doctype-public");
        if (attr2 == null) {
            if (attr != null) {
                throw new JspTranslationException(element, "jsp.error.no.doctype-system.attr");
            }
            if (attr3 != null) {
                throw new JspTranslationException(element, "jsp.error.no.doctype-system.attr");
            }
        } else if (attr == null) {
            throw new JspTranslationException(element, "jsp.error.no.doctype-root-element.attr");
        }
    }

    protected void visitCDataTag(CDATASection cDATASection) throws JspCoreException {
        this.visitJspELTextStart((Element)cDATASection.getParentNode(), cDATASection.getData(), String.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitJspBodyStart(Element element) throws JspCoreException {
        Node node = element.getParentNode();
        if (node.getNodeType() != 1) throw new JspTranslationException(element, "jsp.error.jsp.body.invalid.parent");
        Element element2 = (Element)node;
        String string = (String)this.prefixToUriMap.get(element2.getPrefix());
        if (string == null) {
            String string2 = element2.getLocalName();
            boolean bl = false;
            for (int i = 0; i < BODY_STANDARD_ACTIONS.length; ++i) {
                if (!string2.equals(BODY_STANDARD_ACTIONS[i])) continue;
                return;
            }
            if (bl) return;
            if (!string2.equals("root")) throw new JspTranslationException(element, "jsp.error.jsp.body.invalid.parent");
            if (this.jspConfiguration.isXml()) return;
            throw new JspTranslationException(element, "jsp.error.jsp.body.invalid.parent");
        }
        String string3 = element2.getLocalName();
        TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string));
        TagInfo tagInfo = tagLibraryInfoImpl.getTag(string3);
        if (tagInfo == null) return;
        if (!tagInfo.getBodyContent().equalsIgnoreCase("EMPTY")) return;
        throw new JspTranslationException(element, "jsp.error.jsp.body.parent.nobody");
    }

    protected void visitIncludeDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitTagDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitAttributeDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitVariableDirectiveStart(Element element) throws JspCoreException {
    }

    protected void visitUninterpretedTagStart(Element element) throws JspCoreException {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "jspElement =[" + element + "]");
        }
        String string = element.getNamespaceURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "uri =[" + string + "]");
        }
        if (string != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "uri =[" + string + "]");
            }
            if (string.startsWith("urn:jsptld:")) {
                string = string.substring(string.indexOf("urn:jsptld:") + 11);
            } else if (string.startsWith("urn:jsptagdir:")) {
                string = string.substring(string.indexOf("urn:jsptagdir:") + 14);
            }
            object = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string));
            if (object == null) {
                object = this.tagLibraryCache.getTagLibraryInfo(string, "", this.jspUri);
                if (object != null) {
                    element.setPrefix("");
                    this.visitCustomTagStart(element);
                }
            } else {
                element.setPrefix("");
                this.visitCustomTagStart(element);
            }
        }
        object = element.getAttributes();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs = [" + object + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs.getLength() = [" + object.getLength() + "]");
        }
        for (int i = 0; i < object.getLength(); ++i) {
            Attr attr = (Attr)object.item(i);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs attr = [" + attr + "]");
            }
            this.visitJspELTextStart(element, attr.getValue(), class$java$lang$String == null ? ValidateVisitor.class$("java.lang.String") : class$java$lang$String);
        }
    }

    protected void visitJspParamEnd(Element element) throws JspCoreException {
    }

    protected void visitJspGetPropertyEnd(Element element) throws JspCoreException {
    }

    protected void visitJspRootEnd(Element element) throws JspCoreException {
    }

    protected void visitJspFallbackEnd(Element element) throws JspCoreException {
    }

    protected void visitJspUseBeanEnd(Element element) throws JspCoreException {
    }

    protected void visitJspForwardEnd(Element element) throws JspCoreException {
    }

    protected void visitJspPluginEnd(Element element) throws JspCoreException {
    }

    protected void visitJspSetPropertyEnd(Element element) throws JspCoreException {
    }

    protected void visitIncludeDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitJspExpressionEnd(Element element) throws JspCoreException {
    }

    protected void visitPageDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitJspIncludeEnd(Element element) throws JspCoreException {
    }

    protected void visitJspScriptletEnd(Element element) throws JspCoreException {
    }

    protected void visitJspDeclarationEnd(Element element) throws JspCoreException {
    }

    protected void visitJspTextEnd(Element element) throws JspCoreException {
    }

    protected void visitJspParamsEnd(Element element) throws JspCoreException {
    }

    protected void visitJspAttributeEnd(Element element) throws JspCoreException {
    }

    protected void visitJspElementEnd(Element element) throws JspCoreException {
    }

    protected void visitJspBodyEnd(Element element) throws JspCoreException {
    }

    protected void visitJspInvokeEnd(Element element) throws JspCoreException {
    }

    protected void visitJspDoBodyEnd(Element element) throws JspCoreException {
    }

    protected void visitTagDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitAttributeDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitVariableDirectiveEnd(Element element) throws JspCoreException {
    }

    protected void visitJspOutputEnd(Element element) throws JspCoreException {
    }

    protected void visitUninterpretedTagEnd(Element element) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagEnd", "jspElement =[" + element + "]");
        }
        String string = element.getNamespaceURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagEnd", "uri =[" + string + "]");
        }
        if (string != null) {
            if (string.startsWith("urn:jsptld:")) {
                string = string.substring(string.indexOf("urn:jsptld:") + 11);
            } else if (string.startsWith("urn:jsptagdir:")) {
                string = string.substring(string.indexOf("urn:jsptagdir:") + 14);
            }
            TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string));
            if (tagLibraryInfoImpl != null) {
                element.setPrefix("");
                this.visitCustomTagEnd(element);
            }
        }
    }

    private Vector setScriptingVars(TagVariableInfo[] tagVariableInfoArray, VariableInfo[] variableInfoArray, TagData tagData, int n, int n2) throws JspCoreException {
        if (tagVariableInfoArray.length == 0 && variableInfoArray.length == 0) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        Integer n3 = null;
        n3 = n == 1 || n == 2 ? (this.tagCountStack.size() > 0 ? (Integer)this.tagCountStack.peek() : new Integer(Integer.MAX_VALUE)) : new Integer(n2);
        if (variableInfoArray.length > 0) {
            for (int i = 0; i < variableInfoArray.length; ++i) {
                if (variableInfoArray[i].getScope() != n || !variableInfoArray[i].getDeclare()) continue;
                String string = variableInfoArray[i].getVarName();
                Integer n4 = (Integer)this.scriptVars.get(string);
                if (n4 != null) {
                    this.dupFlag = true;
                    this.setDuplicateVars(variableInfoArray[i]);
                }
                if (n4 != null && n3.compareTo(n4) <= 0) continue;
                this.scriptVars.put(string, n3);
                vector.add(variableInfoArray[i]);
            }
        } else {
            for (int i = 0; i < tagVariableInfoArray.length; ++i) {
                if (tagVariableInfoArray[i].getScope() != n || !tagVariableInfoArray[i].getDeclare()) continue;
                String string = tagVariableInfoArray[i].getNameGiven();
                if (string == null && (string = tagData.getAttributeString(tagVariableInfoArray[i].getNameFromAttribute())) == null) {
                    throw new JspTranslationException("jsp.error.scripting.variable.missing_name", new Object[]{tagVariableInfoArray[i].getNameFromAttribute()});
                }
                Integer n5 = (Integer)this.scriptVars.get(string);
                if (n5 != null && n3.compareTo(n5) <= 0) continue;
                this.scriptVars.put(string, n3);
                vector.add(tagVariableInfoArray[i]);
            }
        }
        return vector;
    }

    private void setDuplicateVars(VariableInfo variableInfo) {
        this.dupVector.addElement(variableInfo);
    }

    private Vector getDuplicateVars() {
        return this.dupVector;
    }

    protected void validateTagLib(Document document, String string, String string2, TagLibraryInfoImpl tagLibraryInfoImpl) throws JspCoreException {
        TagLibraryValidator tagLibraryValidator = tagLibraryInfoImpl.getTagLibraryValidator();
        if (tagLibraryValidator != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.context.getJspClassloaderContext().getClassLoader());
            try {
                ValidationMessage[] validationMessageArray = tagLibraryValidator.validate(string2, string, (PageData)new PageDataImpl(document, this.tagLibraryCache));
                Thread.currentThread().setContextClassLoader(classLoader);
                if (validationMessageArray != null && validationMessageArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < validationMessageArray.length; ++i) {
                        if (validationMessageArray[i] == null) continue;
                        stringBuffer.append("<p>");
                        if (validationMessageArray[i].getId() != null) {
                            JspId jspId = new JspId(validationMessageArray[i].getId());
                            stringBuffer.append("File [" + jspId.getFilePath() + "] ");
                            stringBuffer.append("Line [" + jspId.getStartSourceLineNum() + "] ");
                            stringBuffer.append("Column [" + jspId.getStartSourceColNum() + "] ");
                        }
                        stringBuffer.append(validationMessageArray[i].getMessage());
                        stringBuffer.append("</p>");
                    }
                    throw new JspTranslationException("jsp.error.tlv.invalid.page", new Object[]{string, stringBuffer.toString()});
                }
            }
            catch (Throwable throwable) {
                throw new JspCoreException(throwable);
            }
        }
    }

    protected void validateAttributes(List list, Element element, String[] stringArray) throws JspCoreException {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string.equals("jsp:id") || string.startsWith("xmlns")) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new JspTranslationException(element, "jsp.error.unknown.attribute", new Object[]{string, element.getTagName()});
        }
    }

    protected void validateAttributes(Element element, String[] stringArray) throws JspCoreException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = node.getPrefix();
            String string4 = node.getNodeName();
            if (string != null && node.getLocalName().equals("id") && string.equals("http://java.sun.com/JSP/Page") || string4.startsWith("xmlns")) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!node.getNodeName().equals(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new JspTranslationException(element, "jsp.error.unknown.attribute", new Object[]{node.getNodeName(), element.getTagName()});
        }
    }

    protected void validateEmptyBody(Element element) throws JspCoreException {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            CDATASection cDATASection = null;
            Element element2 = null;
            String string = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 4) {
                    cDATASection = (CDATASection)node;
                    string = cDATASection.getData();
                    if (string.trim().length() <= 0) continue;
                    throw new JspTranslationException(element, "jsp.error.jspbody.emptybody.only", new Object[]{element.getNodeName(), "[" + node.getNodeName() + "] : " + string});
                }
                if (!(node instanceof Element) || (element2 = (Element)node).getNamespaceURI().equals("http://java.sun.com/JSP/Page") && element2.getLocalName().equals("attribute")) continue;
                throw new JspTranslationException(element, "jsp.error.jspbody.emptybody.only", new Object[]{element.getNodeName(), element2.getNamespaceURI() + " : " + element2.getLocalName()});
            }
        }
    }

    protected void validateELExpression(Element element, String string, Class clazz) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "expression= [" + string + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "jspConfiguration.elIgnored() =[" + this.jspConfiguration.elIgnored() + "]");
        }
        if (JspTranslatorUtil.isELInterpreterInput(string, this.jspConfiguration)) {
            try {
                String string2 = string;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 1= [" + string2 + "]");
                }
                string2 = string2.replaceAll("&gt;", ">");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 2= [" + string2 + "]");
                }
                string2 = string2.replaceAll("&lt;", "<");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 3= [" + string2 + "]");
                }
                string2 = string2.replaceAll("&amp;", "&");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 4= [" + string2 + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "jspElement= [" + element + "]");
                }
                this.validateElFunction(element, string2);
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 5= [" + string2 + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "jspElement= [" + element + "]");
                }
                this.expressionEvaluator.parseExpression(string2, clazz, this.result.getValidateFunctionMapper());
            }
            catch (ELException eLException) {
                throw new JspTranslationException(element, "failed.to.parse.el.expression", new Object[]{string}, eLException);
            }
        }
    }

    protected void validateELExpression(Element element, String string, String string2) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 2", "expression= [" + string + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 2", "expectedType= [" + string2 + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 2", "jspConfiguration.elIgnored() =[" + this.jspConfiguration.elIgnored() + "]");
        }
        if (JspTranslatorUtil.isELInterpreterInput(string, this.jspConfiguration)) {
            try {
                Class clazz = JspTranslatorUtil.toClass(string2, this.context.getJspClassloaderContext().getClassLoader());
                this.validateELExpression(element, string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JspTranslationException(element, "failed.to.parse.el.expression", new Object[]{string}, classNotFoundException);
            }
        }
    }

    protected void visitJspELTextStart(Element element, String string, Class clazz) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata =[" + string + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata.indexOf('${') =[" + string.indexOf("${") + "]");
        }
        if (string.indexOf("${") == -1) {
            return;
        }
        String[] stringArray = this.getELExpressions(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.validateELExpression(element, stringArray[i], clazz);
            }
        }
    }

    private void validateElFunction(Element element, String string) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "jspElement= [" + element + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "expression= [" + string + "]");
        }
        ELParser eLParser = new ELParser(new StringReader(string));
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "elParser= [" + eLParser + "]");
        }
        try {
            Object object = eLParser.ExpressionString();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "expr= [" + object + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "(expr instanceof FunctionInvocation)= [" + (object instanceof FunctionInvocation) + "]");
            }
            if (object instanceof FunctionInvocation) {
                FunctionInvocation functionInvocation = (FunctionInvocation)object;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "fi= [" + functionInvocation + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "fi value= [" + functionInvocation.getExpressionString() + "]");
                }
                this.checkElFunction(element, functionInvocation);
            } else if (object instanceof ExpressionString) {
                ExpressionString expressionString = (ExpressionString)object;
                Object[] objectArray = expressionString.getElements();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "es= [" + expressionString + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "es value= [" + expressionString.getExpressionString() + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "subexprs= [" + objectArray + "]");
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof FunctionInvocation)) continue;
                    this.checkElFunction(element, (FunctionInvocation)objectArray[i]);
                }
            } else if (object instanceof BinaryOperatorExpression) {
                this.inspectBinaryExpression(element, (BinaryOperatorExpression)object);
            } else if (object instanceof UnaryOperatorExpression) {
                this.inspectUnaryExpression(element, (UnaryOperatorExpression)object);
            } else if (object instanceof ConditionalExpression) {
                this.inspectConditionalExpression(element, (ConditionalExpression)object);
            } else if (object instanceof ComplexValue) {
                this.inspectComplexValue(element, (ComplexValue)object);
            }
        }
        catch (ParseException parseException) {
            throw new JspTranslationException(element, "jsp.error.el.function.cannot.parse", new Object[]{string});
        }
    }

    protected void inspectComplexValue(Element element, ComplexValue complexValue) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "boe= [" + complexValue + "]");
        }
        Expression expression = complexValue.getPrefix();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "prefix= [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "prefix value= [" + expression.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "(prefix instanceof FunctionInvocation)= [" + (expression instanceof FunctionInvocation) + "]");
        }
        this.recurseExpression(element, expression);
        List list = complexValue.getSuffixes();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "suffixes= [" + list + "]");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValueSuffix valueSuffix = (ValueSuffix)iterator.next();
            Expression expression2 = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "suffix= [" + valueSuffix + "]");
                logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "suffix value= [" + valueSuffix.getExpressionString() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "(suffix instanceof ArraySuffix)= [" + (valueSuffix instanceof ArraySuffix) + "]");
            }
            if (valueSuffix instanceof ArraySuffix) {
                expression2 = ((ArraySuffix)valueSuffix).getIndex();
                this.recurseExpression(element, expression2);
                continue;
            }
            logger.logp(Level.FINER, CLASS_NAME, "inspectComplexValue", "unsupported ValueSuffix type: " + expression2.getClass().getName());
        }
    }

    protected void inspectBinaryExpression(Element element, BinaryOperatorExpression binaryOperatorExpression) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "boe= [" + binaryOperatorExpression + "]");
        }
        Expression expression = binaryOperatorExpression.getExpression();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "leftExpr= [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "leftExpr value= [" + expression.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "(leftExpr instanceof FunctionInvocation)= [" + (expression instanceof FunctionInvocation) + "]");
        }
        this.recurseExpression(element, expression);
        List list = binaryOperatorExpression.getExpressions();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "subexprs= [" + list + "]");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "subexpr= [" + expression2 + "]");
                logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "subexpr value= [" + expression2.getExpressionString() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "inspectBinaryExpression", "(subexpr instanceof FunctionInvocation)= [" + (expression2 instanceof FunctionInvocation) + "]");
            }
            this.recurseExpression(element, expression2);
        }
    }

    protected void inspectUnaryExpression(Element element, UnaryOperatorExpression unaryOperatorExpression) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectUnaryExpression", "uoe= [" + unaryOperatorExpression + "]");
        }
        Expression expression = unaryOperatorExpression.getExpression();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectUnaryExpression", "leftExpr= [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectUnaryExpression", "leftExpr value= [" + expression.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectUnaryExpression", "(leftExpr instanceof FunctionInvocation)= [" + (expression instanceof FunctionInvocation) + "]");
        }
        this.recurseExpression(element, expression);
    }

    protected void inspectConditionalExpression(Element element, ConditionalExpression conditionalExpression) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "ce= [" + conditionalExpression + "]");
        }
        Expression expression = conditionalExpression.getCondition();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "leftExpr= [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "leftExpr value= [" + expression.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "(leftExpr instanceof FunctionInvocation)= [" + (expression instanceof FunctionInvocation) + "]");
        }
        this.recurseExpression(element, expression);
        Expression expression2 = conditionalExpression.getTrueBranch();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "trueBranchExpr= [" + expression2 + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "trueBranchExpr value= [" + expression2.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "(trueBranchExpr instanceof FunctionInvocation)= [" + (expression2 instanceof FunctionInvocation) + "]");
        }
        this.recurseExpression(element, expression2);
        Expression expression3 = conditionalExpression.getFalseBranch();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "falseBranchExpr= [" + expression3 + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "falseBranchExpr value= [" + expression3.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "inspectConditionalExpression", "(falseBranchExpr instanceof FunctionInvocation)= [" + (expression3 instanceof FunctionInvocation) + "]");
        }
        this.recurseExpression(element, expression3);
    }

    protected void checkElFunction(Element element, FunctionInvocation functionInvocation) throws JspCoreException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "jspElement= [" + element + "]");
            logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "fi= [" + functionInvocation + "]");
        }
        String string = null;
        String string2 = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "fi.getFunctionName()= [" + functionInvocation.getFunctionName() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "fi.getExpressionString()= [" + functionInvocation.getExpressionString() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "(fi.getFunctionName().indexOf(':'))= [" + functionInvocation.getFunctionName().indexOf(58) + "]");
        }
        if (functionInvocation.getFunctionName().indexOf(58) != -1) {
            string = functionInvocation.getFunctionName().substring(0, functionInvocation.getFunctionName().indexOf(58));
            string2 = functionInvocation.getFunctionName().substring(functionInvocation.getFunctionName().indexOf(58) + 1);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "functionPrefix 1= [" + string + "]");
                logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "functionName 1= [" + string2 + "]");
            }
        } else {
            string = element.getPrefix();
            string2 = functionInvocation.getFunctionName();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "functionPrefix 2= [" + string + "]");
                logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "functionName 2= [" + string2 + "]");
            }
        }
        if (string == null) {
            string = "";
        }
        if (this.result.getValidateFunctionMapper().resolveFunction(string, string2) == null) {
            String string3 = (String)this.prefixToUriMap.get(string);
            if (string3 == null) {
                string3 = element.getNamespaceURI();
            }
            TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.result.getTagLibMap().get(string3));
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "uri= [" + string3 + "]");
                logger.logp(Level.FINER, CLASS_NAME, "checkElFunction", "tli= [" + (Object)((Object)tagLibraryInfoImpl) + "]");
            }
            if (tagLibraryInfoImpl == null) {
                throw new JspTranslationException("jsp.error.el.function.not.found", new Object[]{string2, string3});
            }
            FunctionInfo functionInfo = tagLibraryInfoImpl.getFunction(string2);
            if (functionInfo == null) {
                throw new JspTranslationException("jsp.error.el.function.not.found", new Object[]{string2, string3});
            }
            FunctionSignature functionSignature = new FunctionSignature(functionInfo.getFunctionClass(), functionInfo.getFunctionSignature(), tagLibraryInfoImpl.getShortName(), this.context.getJspClassloaderContext().getClassLoader());
            Class<?> clazz = null;
            Method method = null;
            try {
                clazz = this.context.getJspClassloaderContext().getClassLoader().loadClass(functionInfo.getFunctionClass());
                method = clazz.getDeclaredMethod(functionSignature.getMethodName(), functionSignature.getParameterTypes());
                int n = method.getModifiers();
                if (!Modifier.isStatic(n)) {
                    throw new JspTranslationException("jsp.error.function.not.static", new Object[]{functionInfo.getFunctionClass(), functionInfo.getFunctionSignature()});
                }
                if (!Modifier.isPublic(n)) {
                    throw new JspTranslationException("jsp.error.function.not.public", new Object[]{functionInfo.getFunctionClass(), functionInfo.getFunctionSignature()});
                }
                this.result.getValidateFunctionMapper().mapFunction(string + ":" + string2, method);
                this.result.getValidateFunctionMapper().mapSignature(string + ":" + string2, functionSignature);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JspTranslationException("jsp.error.function.classnotfound", new Object[]{functionInfo.getFunctionClass()});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JspTranslationException("jsp.error.noFunctionMethod", new Object[]{functionSignature.getMethodName()});
            }
            Iterator iterator = functionInvocation.getArgumentList().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Expression)) continue;
                this.recurseExpression(element, (Expression)e);
            }
        }
    }

    protected void recurseExpression(Element element, Expression expression) throws JspCoreException {
        if (expression instanceof FunctionInvocation) {
            this.checkElFunction(element, (FunctionInvocation)expression);
        } else if (expression instanceof BinaryOperatorExpression) {
            this.inspectBinaryExpression(element, (BinaryOperatorExpression)expression);
        } else if (expression instanceof UnaryOperatorExpression) {
            this.inspectUnaryExpression(element, (UnaryOperatorExpression)expression);
        } else if (expression instanceof ConditionalExpression) {
            this.inspectConditionalExpression(element, (ConditionalExpression)expression);
        } else if (expression instanceof ComplexValue) {
            this.inspectComplexValue(element, (ComplexValue)expression);
        }
    }

    protected String[] getELExpressions(String string) {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\'': {
                    if (bl && this.evalQuotedAndEscapedExpression) {
                        if (bl2 && bl3 && !bl4) {
                            bl2 = false;
                            bl3 = false;
                        } else {
                            bl2 = true;
                            bl3 = true;
                        }
                    }
                    if (bl) {
                        stringBuffer.append(c);
                    }
                    bl4 = false;
                    continue block7;
                }
                case '\"': {
                    if (bl) {
                        if (this.evalQuotedAndEscapedExpression) {
                            bl2 = !bl2 || bl3 || bl4;
                            if (bl4) {
                                stringBuffer.append('\\');
                            } else {
                                stringBuffer.append(c);
                            }
                        } else {
                            stringBuffer.append(c);
                        }
                    }
                    bl4 = false;
                    continue block7;
                }
                case '\\': {
                    char c2;
                    if (this.evalQuotedAndEscapedExpression) {
                        c2 = ' ';
                        if (i + 1 < cArray.length) {
                            c2 = cArray[i + 1];
                        }
                        int n = 32;
                        if (i - 1 >= 0) {
                            n = cArray[i - 1];
                        }
                        if (bl4) {
                            bl4 = false;
                        } else if (c2 == '\'' || c2 == '\"' || c2 == '\\' || c2 == '$') {
                            bl4 = true;
                        }
                        if (!bl || bl4) continue block7;
                        stringBuffer.append('\\');
                        stringBuffer.append('\\');
                        continue block7;
                    }
                    if (!bl) continue block7;
                    stringBuffer.append('\\');
                    continue block7;
                }
                case '$': {
                    char c2;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "case '$'");
                        logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "jspConfiguration.elIgnored() =[" + this.jspConfiguration.elIgnored() + "]");
                    }
                    if (!this.jspConfiguration.elIgnored() && i + 1 < cArray.length) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "i =[" + i + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i + 1] == '{' =[" + (cArray[i + 1] == '{') + "]");
                        }
                        if (cArray[i + 1] == '{') {
                            c2 = ' ';
                            if (i > 0) {
                                c2 = cArray[i - 1];
                            }
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "prevChar =[" + c2 + "]");
                            }
                            if (this.evalQuotedAndEscapedExpression) {
                                if (!bl2 && !bl4) {
                                    if (c2 != '\\' && stringBuffer == null) {
                                        stringBuffer = new StringBuffer();
                                        stringBuffer.append(c);
                                        bl = true;
                                    } else if (stringBuffer != null) {
                                        stringBuffer.append(c);
                                    }
                                } else if (bl) {
                                    stringBuffer.append(c);
                                }
                            } else if (!this.evalQuotedAndEscapedExpression && c2 != '\'' && c2 != '\\') {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append(c);
                                bl = true;
                            }
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "1 inElExpression =[" + bl + "]");
                        }
                    }
                    bl4 = false;
                    continue block7;
                }
                case '}': {
                    if (this.evalQuotedAndEscapedExpression) {
                        if (!bl2) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "case '}'");
                                logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "jspConfiguration.elIgnored() =[" + this.jspConfiguration.elIgnored() + "]");
                            }
                            if (!this.jspConfiguration.elIgnored()) {
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "2 inElExpression =[" + bl + "]");
                                }
                                if (bl) {
                                    stringBuffer.append(c);
                                    arrayList.add(stringBuffer.toString());
                                    bl = false;
                                    stringBuffer = null;
                                }
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "3 inElExpression =[" + bl + "]");
                                }
                            }
                        } else {
                            stringBuffer.append(c);
                        }
                    } else if (bl) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 1] =[" + cArray[i - 1] + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 2] =[" + cArray[i - 2] + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 3] =[" + cArray[i - 3] + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 4] =[" + cArray[i - 4] + "]");
                        }
                        if (cArray[i - 1] == '\'' && cArray[i - 2] == '{' && cArray[i - 3] == '$' && cArray[i - 4] == '\'') {
                            stringBuffer.append(c);
                        } else {
                            stringBuffer.append(c);
                            arrayList.add(stringBuffer.toString());
                            bl = false;
                            stringBuffer = null;
                        }
                    }
                    bl4 = false;
                    if (!logger.isLoggable(Level.FINER)) continue block7;
                    logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "3 inElExpression =[" + bl + "]");
                    continue block7;
                }
                default: {
                    if (stringBuffer != null) {
                        stringBuffer.append(c);
                    }
                    bl4 = false;
                }
            }
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    protected void validateRuntimeExpressions(Element element, String[] stringArray, Class clazz) throws JspCoreException {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "Entry");
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "jspElement =[" + element + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "validRuntimeAttrs =[" + stringArray + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "expectedType =[" + clazz + "]");
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeName().equals("jsp:id")) continue;
            object = node.getNodeValue();
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!node.getNodeName().equals(stringArray[j])) continue;
                this.validateExpressionForScripts(element, (String)object);
                bl = true;
                this.validateELExpression(element, (String)object, clazz);
                break;
            }
            if (bl) continue;
            if (JspTranslatorUtil.isExpression((String)object)) {
                throw new JspTranslationException(element, "rt.expression.not.allowed.for.attribute", new Object[]{element.getTagName(), node.getNodeName(), object});
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "About to check for isELInterpreterInput 1");
            }
            if (!JspTranslatorUtil.isELInterpreterInput((String)object, this.jspConfiguration)) continue;
            throw new JspTranslationException(element, "el.expression.not.allowed.for.attribute", new Object[]{element.getTagName(), node.getNodeName(), object});
        }
        if (stringArray != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                object = nodeList.item(i);
                if (!(object instanceof Element) || (element2 = (Element)object).getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element2.getLocalName().equals("attribute")) continue;
                String string = element2.getAttribute("name");
                if (string.indexOf(":") != -1) {
                    string = string.substring(string.indexOf(58) + 1);
                }
                if (string.equals("")) continue;
                boolean bl = false;
                String string2 = element2.getAttribute("value");
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string.equals(stringArray[j])) continue;
                    bl = true;
                    this.validateExpressionForScripts(element, string2);
                    this.validateELExpression(element, string2, clazz);
                    break;
                }
                if (bl) continue;
                if (JspTranslatorUtil.isExpression(string2)) {
                    throw new JspTranslationException(element, "rt.expression.not.allowed.for.attribute", new Object[]{element.getTagName(), object.getNodeName(), string2});
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "About to check for isELInterpreterInput 2");
                }
                if (!JspTranslatorUtil.isELInterpreterInput(string2, this.jspConfiguration)) continue;
                throw new JspTranslationException(element, "el.expression.not.allowed.for.attribute", new Object[]{element.getTagName(), object.getNodeName(), string2});
            }
        }
    }

    protected String getAttributeValue(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (element2 = (Element)node).getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element2.getLocalName().equals("attribute")) continue;
                String string3 = element2.getAttribute("name");
                if (string3.indexOf(58) != -1) {
                    string3 = string3.substring(string3.indexOf(58) + 1);
                }
                if (!string3.equals(string)) continue;
                Node node2 = element2.getFirstChild();
                CDATASection cDATASection = null;
                if (node2.getNodeType() == 4) {
                    cDATASection = (CDATASection)node2;
                } else if (node2 instanceof Element && node2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && node2.getLocalName().equals("text")) {
                    Element element3 = (Element)node2;
                    cDATASection = (CDATASection)element3.getFirstChild();
                }
                string2 = cDATASection.getData();
                if (element2.getAttribute("trim").equals("false")) continue;
                string2 = string2.trim();
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    protected List getAttributeList(Element element) throws JspCoreException {
        return this.getAttributeList(element, false);
    }

    protected List getAttributeList(Element element, boolean bl) throws JspCoreException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(11);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            object = node.getNodeName();
            if (((String)object).equals("jsp:id")) continue;
            if (arrayList.contains(object)) {
                if (bl) continue;
                throw new JspTranslationException(element, "jsp.error.multiple.attribute.definitions", new Object[]{object, element.getTagName()});
            }
            arrayList.add(object);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            object = nodeList.item(i);
            if (object.getNodeType() != 1 || (element2 = (Element)object).getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element2.getLocalName().equals("attribute")) continue;
            NamedNodeMap namedNodeMap2 = element2.getAttributes();
            String string = element2.getAttribute("name");
            if (string.indexOf(58) != -1) {
                string = string.substring(string.indexOf(58) + 1);
            }
            if (arrayList.contains(string)) {
                if (bl) continue;
                throw new JspTranslationException(element, "jsp.error.multiple.attribute.definitions", new Object[]{string, element.getTagName()});
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    protected CustomTagInstance validateCustomTagAttributeValues(Element element, TagAttributeInfo[] tagAttributeInfoArray, boolean bl) throws JspCoreException {
        Object object;
        boolean bl2;
        Object object2;
        Object object3;
        Object object4;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Entry");
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(11);
        boolean bl3 = true;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            object4 = node.getNodeName();
            object3 = node.getNodeValue();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nodeName =[" + (String)object4 + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nodeValue =[" + (String)object3 + "]");
            }
            if (((String)object4).equals("jsp:id") || ((String)object4).startsWith("xmlns")) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "NOT jsp:id and NOT xmlns");
            }
            object2 = this.getTagAttributeInfo(tagAttributeInfoArray, (String)object4);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "tai: " + object2);
            }
            if (object2 == null) {
                if (bl) continue;
                throw new JspTranslationException(element, "jsp.error.unable.locate.tagname", new Object[]{object4});
            }
            if (!object2.canBeRequestTime() && (JspTranslatorUtil.isExpression((String)object3, true) || JspTranslatorUtil.isELInterpreterInput((String)object3, this.jspConfiguration))) {
                throw new JspTranslationException(element, "jsp.error.attribute.cannot.be.request.time", new Object[]{object4, object3});
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "about to call JspTranslatorUtil.isExpression(nodeValue, true)");
            }
            bl2 = JspTranslatorUtil.isExpression((String)object3, true);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "about to call JspTranslatorUtil.isELInterpreterInput(nodeValue, jspConfiguration)");
            }
            boolean bl4 = JspTranslatorUtil.isELInterpreterInput((String)object3, this.jspConfiguration);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "isExpr =[" + bl2 + "] isElExpr= [" + bl4 + "]");
            }
            if (bl2 || bl4) {
                if (bl2) {
                    bl3 = false;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "isScriptless =[" + bl3 + "]");
                }
                if (bl4) {
                    object = object2.getTypeName();
                    if (object == null) {
                        object = "java.lang.Object";
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "about to call validateELExpression, expectedType =[" + (String)object + "]");
                    }
                    this.validateELExpression(element, (String)object3, (String)object);
                }
                hashtable.put(object4, TagData.REQUEST_TIME_VALUE);
                continue;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Adding to attribute map nodeName =[" + (String)object4 + "] nodeValue =[" + (String)object3 + "]");
            }
            hashtable.put(object4, object3);
        }
        NodeList nodeList = element.getChildNodes();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nl.getLength() =[" + nodeList.getLength() + "]");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object4 = nodeList.item(i);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "n.getNodeName() =[" + object4.getNodeName() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "n.getNodeType() =[" + object4.getNodeType() + "]");
            }
            if (object4.getNodeType() != 1) continue;
            object3 = (Element)object4;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "e.getNamespaceURI() =[" + object3.getNamespaceURI() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "e.getLocalName() =[" + object3.getLocalName() + "]");
            }
            if (object3.getNamespaceURI() == null || !object3.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !object3.getLocalName().equals("attribute")) continue;
            object2 = object3.getAttribute("name");
            if (((String)object2).indexOf(":") != -1) {
                object2 = ((String)object2).substring(((String)object2).indexOf(58) + 1);
            }
            bl2 = true;
            if (!object3.getAttribute("trim").equals("")) {
                bl2 = Boolean.valueOf(object3.getAttribute("trim"));
            }
            NodeList nodeList2 = object3.getChildNodes();
            object = this.getTagAttributeInfo(tagAttributeInfoArray, (String)object2);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "TagAttributeInfo for nodeName [" + (String)object2 + "] tai =[" + object + "]");
            }
            boolean bl5 = false;
            String string = null;
            boolean bl6 = false;
            if (object == null) {
                if (!bl) {
                    throw new JspTranslationException(element, "jsp.error.unable.locate.tagname", new Object[]{object2});
                }
                string = "java.lang.String";
                bl5 = true;
            } else {
                bl5 = object.canBeRequestTime();
                string = object.getTypeName();
                bl6 = object.isFragment();
            }
            if (object3.hasChildNodes()) {
                String string2;
                int n = nodeList2.getLength();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "numChildren =[" + n + "]");
                }
                String[] stringArray = new String[n];
                if (n == 1) {
                    Node node = object3.getFirstChild();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childAttrNode.getNodeName(): " + node.getNodeName());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childAttrNode.getNodeType(): " + node.getNodeType());
                    }
                    if (node.getNodeType() == 4) {
                        CDATASection cDATASection = (CDATASection)node;
                        String string3 = cDATASection.getData();
                        if (!bl5 && (JspTranslatorUtil.isExpression(string3, true) || JspTranslatorUtil.isELInterpreterInput(string3, this.jspConfiguration))) {
                            throw new JspTranslationException(element, "jsp.error.attribute.cannot.be.request.time", new Object[]{object2, string3});
                        }
                        boolean bl7 = JspTranslatorUtil.isExpression(string3, true);
                        boolean bl8 = JspTranslatorUtil.isELInterpreterInput(string3, this.jspConfiguration);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues 2", "isExpr =[" + bl7 + "] isElExpr= [" + bl8 + "]");
                        }
                        if (bl7 || bl8) {
                            if (bl7) {
                                bl3 = false;
                            }
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "isScriptless 2 =[" + bl3 + "]");
                            }
                            if (bl8) {
                                string2 = string;
                                if (string2 == null) {
                                    string2 = "java.lang.Object";
                                }
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "about to call validateELExpression 2, expectedType =[" + string2 + "]");
                                }
                                this.validateELExpression(element, string3, string2);
                            }
                            hashtable.put(object2, TagData.REQUEST_TIME_VALUE);
                            continue;
                        }
                        hashtable.put(object2, string3);
                        continue;
                    }
                    if (node.getNodeType() != 1) continue;
                    if (!this.areChildrenScriptless((Element)object3)) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Element children are not scriptless.");
                        }
                        if (!bl5) {
                            throw new JspTranslationException(element, "jsp.error.attribute.cannot.be.request.time", new Object[]{object2, node.getNodeValue()});
                        }
                        bl3 = false;
                        hashtable.put(object2, TagData.REQUEST_TIME_VALUE);
                        continue;
                    }
                    hashtable.put(object2, TagData.REQUEST_TIME_VALUE);
                    continue;
                }
                int n2 = 0;
                boolean bl9 = false;
                for (int j = 0; j < n; ++j) {
                    Node node;
                    Node node2 = nodeList2.item(j);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeName(): " + node2.getNodeName());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeType(): " + node2.getNodeType());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeValue(): " + node2.getNodeValue());
                    }
                    if (node2.getNodeType() == 4) {
                        node = (CDATASection)node2;
                        string2 = node.getData();
                        if (bl2) {
                            string2 = string2.trim();
                        }
                        if (string2.length() <= 0) continue;
                        if (!bl9) {
                            ++n2;
                        }
                        bl9 = true;
                        continue;
                    }
                    if (node2.getNodeType() == 1) {
                        node = (Element)node2;
                        if (this.areChildrenScriptless((Element)object3)) continue;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues 2", "2. Element children are not scriptless.");
                        }
                        if (!bl5) {
                            throw new JspTranslationException(element, "jsp.error.attribute.cannot.be.request.time", new Object[]{object2, node2.getNodeValue()});
                        }
                        bl3 = false;
                        continue;
                    }
                    ++n2;
                }
                if (bl6 && n2 > 1) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childrenWithValues =[" + n2 + "]");
                    }
                    throw new JspTranslationException(element, "jsp.error.attribute.cannot.be.request.time.fragment", new Object[]{object2});
                }
                hashtable.put(object2, TagData.REQUEST_TIME_VALUE);
                continue;
            }
            hashtable.put(object2, "");
        }
        return new CustomTagInstance(hashtable, bl3);
    }

    protected void validateRequiredAttributes(Element element, List list, String[] stringArray) throws JspCoreException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (list.contains(stringArray[i])) continue;
            throw new JspTranslationException(element, "jsp.error.missing.required.attribute", new Object[]{stringArray[i], element.getTagName()});
        }
    }

    protected void validateCustomTagAttributes(Element element, TagAttributeInfo[] tagAttributeInfoArray) throws JspCoreException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (element2 = (Element)node).getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element2.getLocalName().equals("attribute")) continue;
            NamedNodeMap namedNodeMap = element2.getAttributes();
            String string = element2.getAttribute("name");
            if (string.indexOf(":") != -1) {
                string = string.substring(string.indexOf(58) + 1);
            }
            for (int j = 0; j < tagAttributeInfoArray.length; ++j) {
                TagAttributeInfo tagAttributeInfo = tagAttributeInfoArray[j];
                String string2 = tagAttributeInfo.getName();
                if (string2 == null || !string2.equals(string) || !tagAttributeInfo.isFragment()) continue;
                NodeList nodeList2 = element2.getChildNodes();
                for (int k = 0; k < nodeList2.getLength(); ++k) {
                    Element element3;
                    Node node2 = nodeList2.item(k);
                    if (node2.getNodeType() != 1 || (element3 = (Element)node2).getNamespaceURI() == null || !element3.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !element3.getLocalName().equals("scriptlet") && !element3.getLocalName().equals("expression") && !element3.getLocalName().equals("declaration")) continue;
                    throw new JspTranslationException(element, "jsp.error.attribute.fragment.cannot.be.scriplet", new Object[]{element3.getNodeName()});
                }
            }
        }
    }

    protected void validateExpressionForScripts(Element element, String string) throws JspCoreException {
        if (this.jspConfiguration.scriptingInvalid() && JspTranslatorUtil.isExpression(string, true)) {
            throw new JspTranslationException(element, "jsp.error.scripting.disabled.for.translation.unit");
        }
    }

    protected TagAttributeInfo getTagAttributeInfo(TagAttributeInfo[] tagAttributeInfoArray, String string) {
        for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
            if (!tagAttributeInfoArray[i].getName().equals(string)) continue;
            return tagAttributeInfoArray[i];
        }
        return null;
    }

    protected boolean areChildrenScriptless(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            if (element2.getNamespaceURI() != null && element2.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                if (element2.getLocalName().equals("scriptlet") || element2.getLocalName().equals("expression") || element2.getLocalName().equals("declaration")) {
                    return false;
                }
                for (int j = 0; j < ATTR_STANDARD_ACTIONS.length; ++j) {
                    if (!element2.getLocalName().equals(ATTR_STANDARD_ACTIONS[j])) continue;
                    NamedNodeMap namedNodeMap = element2.getAttributes();
                    if (namedNodeMap != null) {
                        for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                            if (!JspTranslatorUtil.isExpression(namedNodeMap.item(k).getNodeValue(), true)) continue;
                            return false;
                        }
                    }
                    if (this.areChildrenScriptless(element2)) continue;
                    return false;
                }
                continue;
            }
            if (this.areChildrenScriptless(element2)) continue;
            return false;
        }
        return true;
    }

    protected class CustomTagInstance {
        private Hashtable attributes;
        private boolean isScriptless = true;

        protected CustomTagInstance(Hashtable hashtable, boolean bl) {
            this.attributes = hashtable;
            this.isScriptless = bl;
        }

        protected Hashtable getAttributes() {
            return this.attributes;
        }

        protected boolean isScriptless() {
            return this.isScriptless;
        }
    }
}

