/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tsx.tag;

import com.ibm.ws.jsp.tsx.tag.DefinedIndexManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class RepeatTag
extends BodyTagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 3257568395246778423L;
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tsx.tag.RepeatTag";
    private String index = "";
    private int start = 0;
    private int end = Integer.MAX_VALUE;
    private int currentIteration = 0;
    private StringBuffer internalBodyContent;
    private boolean breakTsxRepeatLoop = false;

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String string) {
        this.index = string;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n > 0 ? n : 0;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n >= this.start ? n : Integer.MAX_VALUE;
    }

    public int doStartTag() throws JspException {
        Hashtable<String, Integer> hashtable;
        Stack<String> stack;
        this.internalBodyContent = new StringBuffer();
        DefinedIndexManager definedIndexManager = (DefinedIndexManager)this.pageContext.getAttribute("TSXDefinedIndexManager", 1);
        if (definedIndexManager == null) {
            definedIndexManager = new DefinedIndexManager();
            this.pageContext.setAttribute("TSXDefinedIndexManager", (Object)definedIndexManager, 1);
        }
        if ((stack = (Stack<String>)this.pageContext.getAttribute("TSXRepeatStack", 1)) == null) {
            stack = new Stack<String>();
            this.pageContext.setAttribute("TSXRepeatStack", stack, 1);
        }
        if ((hashtable = (Hashtable<String, Integer>)this.pageContext.getAttribute("TSXRepeatLookup", 1)) == null) {
            hashtable = new Hashtable<String, Integer>();
            this.pageContext.setAttribute("TSXRepeatLookup", hashtable, 1);
        }
        if (this.index == null || this.index.equals("")) {
            this.index = definedIndexManager.getNextIndex();
        } else {
            if (definedIndexManager.exists(this.index)) {
                throw new JspException("Index specified in <tsx:repeat> tag has already been defined. index =[" + this.index + "]");
            }
            definedIndexManager.addIndex(this.index);
        }
        if (this.start > 0) {
            this.currentIteration = this.start;
        }
        this.pageContext.setAttribute(this.index, (Object)new Integer(this.currentIteration));
        stack.push(this.index);
        hashtable.put(this.index, new Integer(this.currentIteration++));
        if (this.end < 0) {
            this.end = Integer.MAX_VALUE;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        Hashtable hashtable = (Hashtable)this.pageContext.getAttribute("TSXRepeatLookup", 1);
        Boolean bl = (Boolean)this.pageContext.findAttribute("TSXBreakRepeat");
        if (this.breakTsxRepeatLoop || bl != null) {
            return 0;
        }
        BodyContent bodyContent = this.getBodyContent();
        String string = bodyContent.getString();
        this.internalBodyContent.append(string);
        try {
            bodyContent.clearBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.currentIteration <= this.end) {
            this.pageContext.setAttribute(this.index, (Object)new Integer(this.currentIteration));
            hashtable.put(this.index, new Integer(this.currentIteration++));
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.doOutput(true);
        return 6;
    }

    private void doOutput(boolean bl) throws JspException {
        Object object;
        Stack stack = (Stack)this.pageContext.getAttribute("TSXRepeatStack", 1);
        this.index = (String)stack.pop();
        this.currentIteration = 0;
        if (bl) {
            object = this.internalBodyContent.toString();
            JspWriter jspWriter = this.pageContext.getOut();
            try {
                jspWriter.write((String)object);
            }
            catch (IOException iOException) {
                throw new JspException("Unable to write <tsx:repeat> tag output " + iOException.getMessage());
            }
            finally {
                this.pageContext.removeAttribute("TSXBreakRepeat", 2);
            }
        }
        if ((object = (DefinedIndexManager)this.pageContext.getAttribute("TSXDefinedIndexManager", 1)) != null) {
            ((DefinedIndexManager)object).removeIndex(this.index);
        }
        this.reset();
    }

    public void release() {
        super.release();
        this.reset();
    }

    public void doCatch(Throwable throwable) throws Throwable {
        this.breakTsxRepeatLoop = true;
        if (throwable instanceof ArrayIndexOutOfBoundsException || throwable instanceof NoSuchElementException) {
            this.doOutput(true);
        } else {
            logger.logp(Level.SEVERE, CLASS_NAME, "doCatch", "Caught unexpected exception in tsx:repeat. breaking loop @[" + this.currentIteration + "]", throwable);
            this.doOutput(false);
        }
    }

    public void doFinally() {
    }

    private void reset() {
        this.index = "";
        this.start = 0;
        this.end = Integer.MAX_VALUE;
        this.internalBodyContent = new StringBuffer();
        this.breakTsxRepeatLoop = false;
    }
}

