/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.runtime.JspClassInformation;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.translator.utils.FileLocker;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.webcontainerext.JSPErrorReport;
import com.ibm.ws.jsp.webcontainerext.JSPExtensionClassLoader;
import com.ibm.ws.jsp.webcontainerext.JspDependent;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspClassFactory;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WebContainerConstants;
import com.ibm.wsspi.webcontainer.filter.WebAppFilterManager;
import com.ibm.wsspi.webcontainer.servlet.GenericServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractJSPExtensionServletWrapper
extends GenericServletWrapper {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.JSPExtensionServletWrapper";
    private static final String JSP_TRANSLATION_TIME_STAMP = "jsp_translation_ts";
    protected Long lastTranslationTime = null;
    private static String separatorString = System.getProperty("line.separator");
    protected JspOptions options = null;
    protected JspConfigurationManager configManager = null;
    protected TagLibraryCache tlc = null;
    protected JspTranslationContext tcontext = null;
    protected CodeSource codeSource = null;
    protected JspInputSource inputSource = null;
    protected JspResources jspResources = null;
    protected List dependentsList = null;
    protected String versionNumber = null;
    protected boolean classloaderCreated = false;
    protected long lastCheck = 0L;
    protected boolean debugClassFile = true;

    public AbstractJSPExtensionServletWrapper(IServletContext iServletContext, JspOptions jspOptions, JspConfigurationManager jspConfigurationManager, TagLibraryCache tagLibraryCache, JspTranslationContext jspTranslationContext, CodeSource codeSource) throws Exception {
        super(iServletContext);
        this.options = jspOptions;
        this.configManager = jspConfigurationManager;
        this.tlc = tagLibraryCache;
        this.tcontext = jspTranslationContext;
        this.codeSource = codeSource;
        if (jspOptions.isTrackDependencies()) {
            this.dependentsList = new ArrayList();
        }
    }

    public void initialize(IServletConfig iServletConfig) throws Exception {
        if (iServletConfig.getFileName() == null || iServletConfig.getFileName().equals("")) {
            throw new UnavailableException(JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{iServletConfig.getFileName()}));
        }
        this.inputSource = this.tcontext.getJspInputSourceFactory().createJspInputSource(iServletConfig.getFileName());
        if (iServletConfig.isLoadOnStartup()) {
            this.checkForTranslation(null);
            iServletConfig.setClassName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName());
        }
        super.initialize(iServletConfig);
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            try {
                if (System.getSecurityManager() != null) {
                    try {
                        final HttpServletRequest httpServletRequest2 = (HttpServletRequest)servletRequest;
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws JspCoreException {
                                AbstractJSPExtensionServletWrapper.this.checkForTranslation(httpServletRequest2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jsp.webcontainerext.JSPExtensionServletWrapper.handleRequest", (String)"143", (Object)this);
                        throw (JspCoreException)privilegedActionException.getException();
                    }
                } else {
                    this.checkForTranslation((HttpServletRequest)servletRequest);
                }
                if (this.preCompile(httpServletRequest)) {
                    if (httpServletRequest != null) {
                        httpServletRequest.setAttribute(JSP_TRANSLATION_TIME_STAMP, (Object)this.lastTranslationTime);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "precompile was requested for [" + this.getJspUri() + "] last translation time =[" + this.lastTranslationTime + "]");
                    }
                    return;
                }
            }
            catch (JspCoreException jspCoreException) {
                FFDCFilter.processException((Throwable)jspCoreException, (String)"com.ibm.ws.jsp.webcontainerext.JSPExtensionServletWrapper.translateJsp", (String)"259", (Object)this);
                int n = 500;
                if (jspCoreException.getCause() != null && jspCoreException.getCause() instanceof FileNotFoundException) {
                    n = 404;
                }
                Throwable throwable = null;
                Throwable throwable2 = jspCoreException;
                while ((throwable = throwable2.getCause()) != null) {
                    throwable2 = throwable;
                }
                JSPErrorReport jSPErrorReport = new JSPErrorReport(throwable2.getLocalizedMessage(), throwable2);
                jSPErrorReport.setStackTrace(throwable2.getStackTrace());
                jSPErrorReport.setErrorCode(n);
                jSPErrorReport.setTargetServletName(super.getServletName());
                boolean bl = false;
                if (jspCoreException.getCause() != null && jspCoreException.getCause() instanceof FileNotFoundException) {
                    IServletContext iServletContext = (IServletContext)this.getWrapper().getServletContext();
                    IServletWrapper iServletWrapper = null;
                    if (iServletContext.isFiltersDefined()) {
                        iServletWrapper = (IServletWrapper)iServletContext.getMappingTarget(WebContainerConstants.FILTER_PROXY_MAPPING);
                        httpServletRequest.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound", (Object)jspCoreException);
                    }
                    if (WebAppFilterManager.invokeFiltersCompatibility) {
                        if (!((IServletContext)this.getServletContext()).getFilterManager().invokeFilters(httpServletRequest, (HttpServletResponse)servletResponse, iServletWrapper, iServletContext, this.getWrapper())) {
                            if (httpServletRequest.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter") != null) {
                                Exception exception = (Exception)httpServletRequest.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                throwable = null;
                                throwable2 = exception;
                                while ((throwable = throwable2.getCause()) != null) {
                                    throwable2 = throwable;
                                }
                                httpServletRequest.removeAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                JSPErrorReport jSPErrorReport2 = new JSPErrorReport(throwable2.getLocalizedMessage(), exception);
                                jSPErrorReport2.setStackTrace(exception.getStackTrace());
                                jSPErrorReport2.setErrorCode(500);
                                jSPErrorReport2.setTargetServletName(super.getServletName());
                                iServletContext.sendError(httpServletRequest, (HttpServletResponse)servletResponse, jSPErrorReport2);
                                return;
                            }
                            iServletContext.sendError(httpServletRequest, (HttpServletResponse)servletResponse, jSPErrorReport);
                            return;
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    this.context.sendError(httpServletRequest, (HttpServletResponse)servletResponse, jSPErrorReport);
                }
                return;
            }
            super.handleRequest(servletRequest, servletResponse);
            this.loadClassInformation();
        }
    }

    public String getJspUri() {
        return this.inputSource.getRelativeURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadClassInformation() {
        if (this.classloaderCreated && this.getTarget() instanceof JspClassInformation) {
            AbstractJSPExtensionServletWrapper abstractJSPExtensionServletWrapper = this;
            synchronized (abstractJSPExtensionServletWrapper) {
                JspClassInformation jspClassInformation = (JspClassInformation)this.getTarget();
                if (this.options.isTrackDependencies()) {
                    this.dependentsList.clear();
                    String[] stringArray = jspClassInformation.getDependants();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            JspDependent jspDependent = new JspDependent(stringArray[i], this.tcontext);
                            this.dependentsList.add(jspDependent);
                        }
                    }
                }
                this.versionNumber = jspClassInformation.getVersionInformation();
                this.debugClassFile = jspClassInformation.isDebugClassFile();
            }
        }
    }

    protected void checkForTranslation(HttpServletRequest httpServletRequest) throws JspCoreException {
        if (this.options.isZOS()) {
            this.preinvokeCheckForTranslation(httpServletRequest);
        } else {
            this._checkForTranslation(httpServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _checkForTranslation(HttpServletRequest httpServletRequest) throws JspCoreException {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "About to enter checkForTranslation sync block for " + this.inputSource.getRelativeURL());
        }
        AbstractJSPExtensionServletWrapper abstractJSPExtensionServletWrapper = this;
        synchronized (abstractJSPExtensionServletWrapper) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Entered checkForTranslation sync block for " + this.inputSource.getRelativeURL());
            }
            if (logger.isLoggable(Level.FINE) && this.versionNumber != null && this.jspResources != null) {
                logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Classfile: [" + this.jspResources.getClassName() + "] version: [" + this.versionNumber + "]");
            }
            this.classloaderCreated = false;
            if (!this.options.isDisableJspRuntimeCompilation() && System.currentTimeMillis() - this.lastCheck > this.options.getReloadInterval()) {
                Object object;
                int n;
                String[] stringArray;
                boolean bl;
                boolean bl2 = false;
                if (this.jspResources == null) {
                    this.jspResources = this.tcontext.getJspResourcesFactory().createJspResources(this.inputSource);
                    if (!this.options.isReloadEnabled() && !(bl2 = this.jspResources.isOutdated()) && this.options.isDebugEnabled()) {
                        boolean bl3 = bl2 = !this.debugClassFile;
                        if (bl2 && !this.jspResources.getGeneratedSourceFile().getParentFile().exists()) {
                            bl = this.jspResources.getGeneratedSourceFile().getParentFile().mkdirs();
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, CLASS_NAME, "_checkForTranslation", (bl ? "Created" : "Unable to create") + " directory for generated source file [" + this.jspResources.getGeneratedSourceFile().getParentFile() + "]");
                            }
                        }
                    }
                    if (this.servletConfig != null) {
                        this.servletConfig.setClassName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName());
                    }
                }
                this.jspResources.setCurrentRequest(httpServletRequest);
                if (this.options.isReloadEnabled()) {
                    bl2 = this.jspResources.isOutdated();
                    if (!bl2 && this.options.isDebugEnabled()) {
                        boolean bl4 = bl2 = !this.debugClassFile;
                        if (bl2 && !this.jspResources.getGeneratedSourceFile().getParentFile().exists()) {
                            bl = this.jspResources.getGeneratedSourceFile().getParentFile().mkdirs();
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, CLASS_NAME, "_checkForTranslation", (bl ? "Created" : "Unable to create") + " directory for generated source file [" + this.jspResources.getGeneratedSourceFile().getParentFile() + "]");
                            }
                        }
                    }
                    if (this.options.isTrackDependencies() && !bl2) {
                        bl = false;
                        JspClassInformation jspClassInformation = null;
                        if (this.getTarget() == null && (this.dependentsList == null || this.dependentsList.isEmpty())) {
                            block45: {
                                if (this.getTargetClassLoader() == null) {
                                    this.createClassLoader();
                                    bl = true;
                                }
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "_checkForTranslation", "getTargetClassLoader(): " + this.getTargetClassLoader());
                                }
                                try {
                                    jspClassInformation = (JspClassInformation)Class.forName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName(), true, this.getTargetClassLoader()).newInstance();
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "_checkForTranslation", "created a temporary JspClassInformation object to get dependencies: " + jspClassInformation);
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (logger == null) break block45;
                                    logger.logp(Level.INFO, CLASS_NAME, "_checkForTranslation", "Exception caught checking JSP dependencies:", throwable);
                                }
                            }
                            if (jspClassInformation != null) {
                                this.dependentsList.clear();
                                stringArray = jspClassInformation.getDependants();
                                if (stringArray != null) {
                                    for (n = 0; n < stringArray.length; ++n) {
                                        object = new JspDependent(stringArray[n], this.tcontext);
                                        this.dependentsList.add(object);
                                    }
                                }
                                jspClassInformation = null;
                            }
                        }
                        bl2 = this.isDependentOutdated();
                        if (bl) {
                            this.setTargetClassLoader(null);
                            this.classloaderCreated = false;
                        }
                    }
                    if (!bl2 && this.jspResources.isExternallyTranslated()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", this.inputSource.getRelativeURL() + " has been externally translated");
                        }
                        this.setTargetClassLoader(null);
                        this.jspResources.sync();
                    }
                }
                if (bl2) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Translation required for " + this.inputSource.getRelativeURL());
                    }
                    bl = this.translateJsp();
                    if (this.options.isZOS()) {
                        if (!bl && this.jspResources.isOutdated()) {
                            int n2 = 5;
                            stringArray = WebContainer.getWebContainerProperties();
                            if (stringArray != null) {
                                try {
                                    n2 = Integer.parseInt(stringArray.getProperty("com.ibm.ws.jsp.zosrecompile", "5"));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "translateJsp", "NumberFormatException in the com.ibm.ws.jsp.zosReCompile property...default to 5 times");
                                    }
                                    n2 = 5;
                                }
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Compile fails and isOutDated, retrying up to " + n2 + " times");
                            }
                            for (n = 0; n < n2; ++n) {
                                bl = this.translateJsp();
                                if (bl || !this.jspResources.isOutdated()) {
                                    if (!logger.isLoggable(Level.FINE)) break;
                                    logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", bl ? "Recompiled" : "Resource up to date");
                                    break;
                                }
                                if (n2 != n + 1) continue;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Compile still fails after [" + n2 + "] attempts");
                                }
                                object = new JspCoreException("jsp.error.compile.failed");
                                throw object;
                            }
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", (bl ? "Compiled" : "Resource is updated") + " successfully");
                        }
                    }
                    this.setTargetClassLoader(null);
                    this.lastTranslationTime = new Long(System.currentTimeMillis());
                }
                this.lastCheck = System.currentTimeMillis();
            }
            if (this.getTargetClassLoader() == null) {
                if (this.getTarget() != null) {
                    this.prepareForReload();
                }
                this.createClassLoader();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Exiting checkForTranslation sync block for " + this.inputSource.getRelativeURL());
        }
    }

    protected boolean translateJsp() throws JspCoreException {
        JspCompilerResult jspCompilerResult = JspTranslatorUtil.translateJspAndCompile(this.jspResources, this.tcontext, this.configManager.getConfigurationForUrl(this.inputSource.getRelativeURL()), this.options, this.tlc, false, Collections.EMPTY_LIST);
        if (jspCompilerResult == null && this.options.isZOS()) {
            int n = 240;
            Properties properties = WebContainer.getWebContainerProperties();
            if (properties != null) {
                try {
                    n = Integer.parseInt(properties.getProperty("com.ibm.ws.jsp.zosfilelockretrying", "240"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "translateJsp", "NumberFormatException in the zOSFileLockRetrying property...default to 240 seconds");
                    }
                    n = 240;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "translateJsp", "FileLock failed in translateJspAndCompile...retrying up to " + n + " seconds");
            }
            boolean bl = false;
            FileLocker fileLocker = (FileLocker)new JspClassFactory().getInstanceOf("FileLocker");
            if (fileLocker == null) {
                JspCoreException jspCoreException = new JspCoreException("jsp.error.file.locker.failed");
                throw jspCoreException;
            }
            for (int i = 0; i < n; ++i) {
                try {
                    bl = fileLocker.obtainFileLock(this.jspResources.getInputSource().getRelativeURL());
                    if (bl) {
                        fileLocker.releaseFileLock(this.jspResources.getInputSource().getRelativeURL());
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "translateJsp", "FileLock retrying succeeded, releaseFileLock");
                        }
                        return false;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    JspCoreException jspCoreException = new JspCoreException("jsp.error.file.lock.retrying.failed");
                    throw jspCoreException;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "translateJsp", "FileLock failed in translateJspAndCompile...retrying has expired");
            }
            JspCoreException jspCoreException = new JspCoreException("jsp.error.compile.failed");
            throw jspCoreException;
        }
        if (jspCompilerResult.getCompilerReturnValue() != 0) {
            JspCoreException jspCoreException = new JspCoreException("jsp.error.compile.failed", new Object[]{this.inputSource.getRelativeURL(), separatorString + jspCompilerResult.getCompilerMessage()});
            throw jspCoreException;
        }
        return true;
    }

    protected void createClassLoader() {
        if (this.jspResources == null) {
            this.jspResources = this.tcontext.getJspResourcesFactory().createJspResources(this.inputSource);
            if (this.servletConfig != null) {
                this.servletConfig.setClassName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName());
            }
        }
        if (this.options.isDisableJspRuntimeCompilation() && this.options.isUseFullPackageNames()) {
            this.classloaderCreated = true;
            return;
        }
        URL[] uRLArray = null;
        try {
            PermissionCollection permissionCollection = this.createPermissionCollection();
            String string = this.jspResources.getGeneratedSourceFile().getParentFile().toString() + File.separator + "*";
            permissionCollection.add(new FilePermission(string, "read"));
            uRLArray = !this.options.isUseFullPackageNames() ? new URL[]{this.jspResources.getGeneratedSourceFile().getParentFile().toURL(), this.options.getOutputDir().toURL(), new File(this.tcontext.getRealPath("/WEB-INF/classes") + this.inputSource.getRelativeURL().substring(0, this.inputSource.getRelativeURL().lastIndexOf("/") + 1)).toURL(), new File(this.tcontext.getRealPath("/WEB-INF/classes")).toURL()} : new URL[]{this.options.getOutputDir().toURL(), new File(this.tcontext.getRealPath("/WEB-INF/classes")).toURL()};
            JSPExtensionClassLoader jSPExtensionClassLoader = new JSPExtensionClassLoader(uRLArray, this.tcontext.getJspClassloaderContext(), this.jspResources.getClassName(), this.codeSource, permissionCollection);
            if (this.servletConfig != null && this.jspResources.getPackageName().equals("com.ibm._jsp")) {
                try {
                    jSPExtensionClassLoader.loadClass(this.jspResources.getPackageName() + "." + this.jspResources.getClassName(), true);
                }
                catch (Throwable throwable) {
                    this.servletConfig.setClassName("org.apache.jsp." + this.jspResources.getClassName());
                }
            }
            this.setTargetClassLoader(jSPExtensionClassLoader);
            this.classloaderCreated = true;
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.jsp.webcontainerext.JSPExtensionProcessor.createClassLoader", (String)"312", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "createClassLoader", "failed to create JSP class loader", malformedURLException);
        }
    }

    boolean preCompile(HttpServletRequest httpServletRequest) throws ServletException {
        String string;
        String string2 = httpServletRequest.getQueryString();
        if (string2 == null) {
            return false;
        }
        int n = string2.indexOf("jsp_precompile");
        if (n < 0) {
            return false;
        }
        if ((string2 = string2.substring(n + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (string2.startsWith("&")) {
            return true;
        }
        if (!string2.startsWith("=")) {
            return false;
        }
        int n2 = string2.length();
        int n3 = string2.indexOf("&");
        if (n3 > 0) {
            n2 = n3;
        }
        if ((string = string2.substring(1, n2)).equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + string);
    }

    protected boolean isDependentOutdated() throws JspCoreException {
        boolean bl = false;
        Iterator iterator = this.dependentsList.iterator();
        while (iterator.hasNext()) {
            JspDependent jspDependent = (JspDependent)iterator.next();
            if (!jspDependent.isOutdated()) continue;
            if (!this.jspResources.getGeneratedSourceFile().exists()) {
                this.jspResources.getGeneratedSourceFile().getParentFile().mkdirs();
            }
            if (jspDependent.getDependentFilePath().endsWith(".tld")) {
                this.tlc.reloadTld(jspDependent.getDependentFilePath(), jspDependent.getTimestamp());
            }
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isAvailable() {
        boolean bl = false;
        String string = this.inputSource.getRelativeURL();
        String string2 = this.tcontext.getRealPath(string);
        bl = !this.options.isDisableJspRuntimeCompilation() ? new File(string2).exists() : true;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isAvailable", "relativeURL [" + string + "]  " + "realPath [" + string2 + "] is available [" + bl + "]");
        }
        return bl;
    }

    public JspResources getJspResources() {
        return this.jspResources;
    }

    protected abstract void preinvokeCheckForTranslation(HttpServletRequest var1) throws JspCoreException;

    protected abstract PermissionCollection createPermissionCollection() throws MalformedURLException;
}

