/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext.ws;

import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import java.io.File;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSPClassloaderContextImpl
implements JspClassloaderContext {
    private static final String WAS_ROOT_BASE = System.getProperty("was.install.root");
    private static final String WAS_ROOT = WAS_ROOT_BASE + File.separator;
    private static final String WAS_CLASSES = WAS_ROOT + "classes";
    private static final String WAS_LIB = WAS_ROOT + "lib" + File.separator;
    private static final String WAS_LIB_EXT = WAS_LIB + "ext";
    private static final String WAS_BUNDLES = WAS_ROOT_BASE + File.separator + "plugins" + File.separator;
    private static String classesClasspath = null;
    private static String libExtClasspath = null;
    private static String requiredClasspath = null;
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.JSPClassloaderContextImpl";
    private ClassLoader loader = null;
    private String classpath = "";
    private JspXmlExtConfig webAppConfig = null;
    private boolean useOptimizedClasspath = false;

    public JSPClassloaderContextImpl(ClassLoader classLoader, JspXmlExtConfig jspXmlExtConfig) {
        this.loader = classLoader;
        this.webAppConfig = jspXmlExtConfig;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        if (this.classpath.trim().length() > 0) {
            return this.classpath;
        }
        logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "jspCompileClasspath: " + this.webAppConfig.getJspOptions().getJspCompileClasspath());
        StringBuffer stringBuffer = null;
        if (WAS_ROOT_BASE != null) {
            if (this.webAppConfig.getJspOptions().getJspCompileClasspath() != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.webAppConfig.getJspOptions().getJspCompileClasspath(), " ");
                int n = 0;
                int n2 = stringTokenizer.countTokens();
                while (stringTokenizer.hasMoreTokens()) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(WAS_ROOT + stringTokenizer.nextToken());
                    if (++n >= n2) continue;
                    stringBuffer.append(File.pathSeparator);
                }
            }
            logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "additionalClasspath: [" + stringBuffer + "]");
            logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "loader: [" + this.loader + "]");
            if (this.loader instanceof ReloadableClassLoader || this.loader instanceof CompoundClassLoader) {
                boolean bl;
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "about to build classpath");
                boolean bl2 = false;
                String string = null;
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "loader instanceof com.ibm.ws.classloader.ReloadableClassLoader: [" + (this.loader instanceof ReloadableClassLoader) + "]");
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "loader instanceof com.ibm.ws.classloader.CompoundClassLoader: [" + (this.loader instanceof CompoundClassLoader) + "]");
                if (this.loader instanceof ReloadableClassLoader) {
                    string = ((ReloadableClassLoader)this.loader).getClassPath();
                    logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "ReloadableClassLoader.getClassPath(): [" + ((ReloadableClassLoader)this.loader).getClassPath() + "]");
                    bl2 = ((ReloadableClassLoader)this.loader).getDelegationMode();
                } else if (this.loader instanceof CompoundClassLoader) {
                    string = ((CompoundClassLoader)this.loader).getClassPath();
                    logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "CompoundClassLoader.getClassPath(): [" + ((CompoundClassLoader)this.loader).getClassPath() + "]");
                    bl2 = ((CompoundClassLoader)this.loader).getDelegationMode();
                }
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "webappClasspath: [" + string + "]");
                ClassLoader classLoader = this.loader.getParent();
                String string2 = null;
                if (classLoader instanceof ReloadableClassLoader) {
                    string2 = this.getPathsAsString(((ReloadableClassLoader)classLoader).getPaths());
                    bl = ((ReloadableClassLoader)classLoader).getDelegationMode();
                    if (bl2 && !bl) {
                        bl2 = false;
                    }
                } else if (classLoader instanceof CompoundClassLoader) {
                    string2 = this.getPathsAsString(((CompoundClassLoader)classLoader).getPaths());
                    bl = ((CompoundClassLoader)classLoader).getDelegationMode();
                    if (bl2 && !bl) {
                        bl2 = false;
                    }
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                if (bl2) {
                    if (classesClasspath.length() > 0) {
                        stringBuffer2.append(classesClasspath);
                    }
                    stringBuffer2.append(requiredClasspath);
                    if (libExtClasspath.length() > 0) {
                        stringBuffer2.append(libExtClasspath);
                    }
                    stringBuffer2.append(string);
                    if (!string.endsWith(File.pathSeparator)) {
                        stringBuffer2.append(File.pathSeparator);
                    }
                    if (string2 != null && !string2.equals("")) {
                        stringBuffer2.append(string2);
                        if (!string2.endsWith(File.pathSeparator)) {
                            stringBuffer2.append(File.pathSeparator);
                        }
                    }
                } else {
                    stringBuffer2.append(string);
                    if (!string.endsWith(File.pathSeparator)) {
                        stringBuffer2.append(File.pathSeparator);
                    }
                    if (string2 != null && !string2.equals("")) {
                        stringBuffer2.append(string2);
                        if (!string2.endsWith(File.pathSeparator)) {
                            stringBuffer2.append(File.pathSeparator);
                        }
                    }
                    if (classesClasspath.length() > 0) {
                        stringBuffer2.append(classesClasspath);
                    }
                    stringBuffer2.append(requiredClasspath);
                    if (libExtClasspath.length() > 0) {
                        stringBuffer2.append(libExtClasspath);
                    }
                }
                if (stringBuffer != null) {
                    stringBuffer2.append(stringBuffer);
                }
                this.classpath = stringBuffer2.toString();
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "constructed classpath: [" + stringBuffer2.toString() + "]");
            }
        }
        logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "returning classpath: [" + this.classpath + "]");
        return this.classpath;
    }

    public String getOptimizedClassPath() {
        return this.getClassPath();
    }

    public boolean isPredefineClassEnabled() {
        return CompoundClassLoader.plugin != null;
    }

    public byte[] predefineClass(String string, byte[] byArray) {
        if (CompoundClassLoader.plugin != null) {
            return CompoundClassLoader.plugin.preDefineApplicationClass(string, byArray);
        }
        return byArray;
    }

    private static String loadClasspathFromDirectory(String string) {
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dir: " + string);
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(string);
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dirFile: " + file);
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dirFile.exists(): " + file.exists());
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dirFile.isDirectory(): " + file.isDirectory());
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "classesFileList: " + stringArray);
            if (logger.isLoggable(Level.FINE) && stringArray != null) {
                logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "classesFileList.length: " + stringArray.length);
            }
            if (stringArray != null && stringArray.length > 0) {
                stringBuffer.append(string + File.pathSeparator);
                for (int i = 0; i < stringArray.length; ++i) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "classesFileList[i]: " + stringArray[i]);
                    if (!stringArray[i].endsWith(".jar") && !stringArray[i].endsWith(".zip")) continue;
                    stringBuffer.append(string + File.separator + stringArray[i] + File.pathSeparator);
                    logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "appended: " + string + File.separator + stringArray[i] + File.pathSeparator);
                }
            }
        }
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "returning cp: " + stringBuffer);
        return stringBuffer.toString();
    }

    private static String loadRequiredClasspath() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "enter loadRequiredClasspath() ");
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "About to load jars from BUNDLES: ");
        for (n = 0; n < Constants.STANDARD_REQUIRED_JSP_JARS.length; ++n) {
            logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "appending WAS_BUNDLES+Constants.STANDARD_REQUIRED_JSP_JARS[i]+File.pathSeparator: " + WAS_BUNDLES + Constants.STANDARD_REQUIRED_JSP_JARS[n] + File.pathSeparator);
            stringBuffer.append(WAS_BUNDLES + Constants.STANDARD_REQUIRED_JSP_JARS[n] + File.pathSeparator);
        }
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "About to load jars from LIB: ");
        for (n = 0; n < Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB.length; ++n) {
            logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "appending WAS_LIB+Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB[i]+File.pathSeparator: " + WAS_LIB + Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB[n] + File.pathSeparator);
            stringBuffer.append(WAS_LIB + Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB[n] + File.pathSeparator);
        }
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "returning cp: " + stringBuffer);
        return stringBuffer.toString();
    }

    private String getPathsAsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        logger.logp(Level.FINE, CLASS_NAME, "getPathsAsString", "entering getPathsAsString");
        for (int i = 0; i < stringArray.length; ++i) {
            logger.logp(Level.FINE, CLASS_NAME, "getPathsAsString", "appending paths[i]: " + stringArray[i]);
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        logger.logp(Level.FINE, CLASS_NAME, "getPathsAsString", "returning cp: " + stringBuffer);
        return stringBuffer.toString();
    }

    static {
        classesClasspath = JSPClassloaderContextImpl.loadClasspathFromDirectory(WAS_CLASSES);
        libExtClasspath = JSPClassloaderContextImpl.loadClasspathFromDirectory(WAS_LIB_EXT);
        requiredClasspath = JSPClassloaderContextImpl.loadRequiredClasspath();
    }
}

