/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext.ws;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.tools.JspModC;
import com.ibm.ws.jsp.webcontainerext.ws.PrepareJspServletRequest;
import com.ibm.ws.jsp.webcontainerext.ws.PrepareJspServletResponse;
import com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionProcessor;
import com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionServletWrapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.File;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrepareJspHelper
implements Runnable {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.PrepareJspHelper";
    WASJSPExtensionProcessor _jspExtProcessor = null;
    String appName = null;
    int _threads = 1;
    int _counter = 0;
    int _notify = 25;
    int _minLength = 0;
    int _startAt = 0;
    boolean shouldClassload = false;
    boolean onlyCLChanged = false;
    private Stack _files = new Stack();
    private Stack _parents = new Stack();
    WebApp webapp = null;
    JspOptions options = null;

    public PrepareJspHelper(WASJSPExtensionProcessor wASJSPExtensionProcessor, IServletContext iServletContext, JspOptions jspOptions) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "PrepareJspHelper", "enter");
        }
        this._jspExtProcessor = wASJSPExtensionProcessor;
        this.webapp = (WebApp)iServletContext;
        this.options = jspOptions;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "PrepareJspHelper", "exit");
        }
    }

    public void run() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "run", "enter");
        }
        String string = null;
        Object var2_2 = null;
        string = this.webapp.getRealPath("/");
        this.appName = this.webapp.getWebAppName();
        this._minLength = this.options.getPrepareJSPs() * 1024;
        if (this.options.getPrepareJSPsClassloadChanged() != null) {
            this.onlyCLChanged = true;
            this._startAt = 0;
        } else {
            this._startAt = this.options.getPrepareJSPsClassload();
        }
        this._threads = this.options.getPrepareJSPThreadCount();
        logger.logp(Level.INFO, CLASS_NAME, "run", "PrepareJspHelper executing on application [" + this.appName + "]");
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Document Root: " + string);
            logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: File size minimum (in bytes): " + this._minLength);
            logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Number of threads: " + this._threads);
            if (this.onlyCLChanged) {
                logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Only classloading out-of-date (changed) JSPs.");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Classloading JSPs starting at JSP number " + this._startAt);
            }
        }
        this._parents.push(new File(string));
        try {
            int n;
            Thread[] threadArray = new Thread[this._threads];
            for (n = 0; n < this._threads; ++n) {
                PrepareJspHelperThread prepareJspHelperThread = new PrepareJspHelperThread(this, string.length());
                threadArray[n] = new Thread((Runnable)prepareJspHelperThread, "PrepareJspHelperThread " + n);
                threadArray[n].setDaemon(true);
                threadArray[n].start();
            }
            for (n = 0; n < this._threads; ++n) {
                try {
                    threadArray[n].join();
                    continue;
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "run", "Pretouch Thread died during execution.", throwable);
                }
            }
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLASS_NAME, "run", "Unexpected exception while running pretouch.", exception);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.logp(Level.INFO, CLASS_NAME, "run", "PrepareJspHelper in group [" + this.appName + "]: All " + this._counter + " jsp files have been processed.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "run", "< run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File getJsp() {
        String string;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "getJsp", "enter");
        }
        try {
            if (this._counter % this._notify == 0 && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, CLASS_NAME, "getJsp", "PrepareJspHelper in group [" + this.appName + "]: " + this._counter + " jsp files have been processed.");
            }
            if (!this._files.isEmpty()) {
                ++this._counter;
                if (this._counter >= this._startAt) {
                    this.shouldClassload = true;
                }
                File file = (File)this._files.pop();
                return file;
            }
            if (this._parents.isEmpty()) {
                File file = null;
                return file;
            }
            List list = JspModC.buildJspFileExtensionList(Constants.STANDARD_JSP_EXTENSIONS, this._jspExtProcessor.getPatternList());
            string = null;
            while (this._files.isEmpty() && !this._parents.isEmpty()) {
                File[] fileArray = ((File)this._parents.pop()).listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    string = fileArray[i].getName().replace('\\', '/');
                    if (string.startsWith("/META-INF")) continue;
                    if (fileArray[i].isDirectory()) {
                        this._parents.push(fileArray[i]);
                        continue;
                    }
                    if (!fileArray[i].isFile() || !this.isJspFile(fileArray[i].getName(), list)) continue;
                    this._files.push(fileArray[i]);
                }
            }
            if (!this._files.isEmpty()) {
                ++this._counter;
                if (this._counter >= this._startAt) {
                    this.shouldClassload = true;
                }
                File file = (File)this._files.pop();
                return file;
            }
            File file = null;
            return file;
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJsp", "Pretouch ERROR: Unexpected exception retrieving jsp names", exception);
            string = null;
            return string;
        }
        finally {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getJsp", "exit");
            }
        }
    }

    private boolean isJspFile(String string, List list) {
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        return list.contains(string2);
    }

    protected boolean compileJsp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "compileJsp", "enter");
        }
        boolean bl = false;
        try {
            this._jspExtProcessor.handleRequest((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            bl = true;
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLASS_NAME, "compileJsp", "PrepareJspHelper: Exception while compiling JSP with pretouch. JSP: [" + httpServletRequest.getServletPath() + "]", exception);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "compileJsp", "exit: " + bl);
        }
        return bl;
    }

    private class PrepareJspHelperThread
    implements Runnable {
        private static final String CLASS_NAME2 = "com.ibm.ws.jsp.webcontainerext.PrepareJspHelperThread";
        PrepareJspHelper _helper;
        int _rootLength;
        String _id;

        public PrepareJspHelperThread(PrepareJspHelper prepareJspHelper2, int n) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "PrepareJspHelperThread", "enter");
            }
            this._helper = prepareJspHelper2;
            this._rootLength = n;
            try {
                this._id = Integer.toHexString(Thread.currentThread().hashCode());
            }
            catch (Exception exception) {
                this._id = "        ";
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "PrepareJspHelperThread", "exit");
            }
        }

        public void prepareJspReloadClass(ClassLoader classLoader, String string) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "prepareJspReloadClass", "enter, Config: " + string);
            }
            if (classLoader != null) {
                try {
                    classLoader.loadClass(string);
                }
                catch (Throwable throwable) {
                    logger.logp(Level.WARNING, CLASS_NAME2, "prepareJspReloadClass", "Error loading jsp class " + string + " during pretouch.", throwable);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "prepareJspReloadClass", "exit");
            }
        }

        public void run() {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "run", "enter");
            }
            File file = this._helper.getJsp();
            PrepareJspServletRequest prepareJspServletRequest = new PrepareJspServletRequest();
            PrepareJspServletResponse prepareJspServletResponse = new PrepareJspServletResponse();
            String string = null;
            String string2 = null;
            while (file != null) {
                if (file.length() >= (long)this._helper._minLength) {
                    string = file.getAbsolutePath().substring(this._rootLength, file.getAbsolutePath().length());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME2, "run", "Processing jsp: " + string);
                    }
                    string = string.replace('\\', '/');
                    prepareJspServletRequest.setServletPath(string);
                    prepareJspServletRequest.setRequestURI(string);
                    prepareJspServletRequest.setQueryString("jsp_precompile");
                    try {
                        IServletWrapper iServletWrapper;
                        if (PrepareJspHelper.this.compileJsp(prepareJspServletRequest, prepareJspServletResponse) && (iServletWrapper = this._helper._jspExtProcessor.findWrapper(prepareJspServletRequest, prepareJspServletResponse)) instanceof WASJSPExtensionServletWrapper) {
                            WASJSPExtensionServletWrapper wASJSPExtensionServletWrapper = (WASJSPExtensionServletWrapper)iServletWrapper;
                            string2 = wASJSPExtensionServletWrapper.getJspResources().getPackageName() + '.' + wASJSPExtensionServletWrapper.getJspResources().getClassName();
                            if (this._helper.onlyCLChanged) {
                                if (wASJSPExtensionServletWrapper.getJspResources().isOutdated()) {
                                    this.prepareJspReloadClass(wASJSPExtensionServletWrapper.getTargetClassLoader(), string2);
                                }
                            } else if (PrepareJspHelper.this.shouldClassload) {
                                this.prepareJspReloadClass(wASJSPExtensionServletWrapper.getTargetClassLoader(), string2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        logger.logp(Level.WARNING, CLASS_NAME2, "run", "Unexpected exception while processing jsp " + string, exception);
                    }
                }
                file = this._helper.getJsp();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "run", "exit");
            }
        }
    }
}

