/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webxml;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigProperty;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlParser
extends DefaultHandler
implements JspXmlExtConfig {
    public static final String WEBAPP_DTD_PUBLIC_ID_22 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String WEBAPP_DTD_RESOURCE_PATH_22 = "/javax/servlet/resources/web-app_2_2.dtd";
    public static final String WEBAPP_DTD_PUBLIC_ID_23 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String WEBAPP_DTD_RESOURCE_PATH_23 = "/javax/servlet/resources/web-app_2_3.dtd";
    public static final String WEBAPP_DTD_PUBLIC_ID_24 = "http://java.sun.com/xml/ns/j2ee web-app_2_4.xsd";
    public static final String WEBAPP_DTD_RESOURCE_PATH_24 = "/javax/servlet/resources/web-app_2_4.xsd";
    protected SAXParser saxParser = null;
    protected boolean isServlet24 = false;
    protected StringBuffer chars = null;
    protected HashMap tagLibMap = new HashMap();
    protected String taglibUri = null;
    protected String taglibLocation = null;
    protected List jspPropertyGroups = new ArrayList();
    protected JspConfigPropertyGroup jspConfigPropertyGroup = null;
    protected List jspFileExtensions = new ArrayList();
    protected JspOptions options = null;

    public WebXmlParser(File file) throws JspCoreException {
        try {
            String string;
            this.options = new JspOptions(new Properties());
            if (file == null && (string = System.getProperty("java.io.tmpdir")) != null) {
                file = new File(string);
            }
            this.options.setOutputDir(file.getCanonicalFile());
            this.saxParser = ParserFactory.newSAXParser(true, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            throw new JspCoreException(iOException);
        }
    }

    public void parseWebXml(InputStream inputStream) throws JspCoreException {
        this.tagLibMap.clear();
        this.jspPropertyGroups.clear();
        try {
            ParserFactory.parseDocument(this.saxParser, inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getCause() != null) {
                throw new JspCoreException(sAXException.getCause());
            }
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            throw new JspCoreException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Map getTagLibMap() {
        return new HashMap(this.tagLibMap);
    }

    public List getJspPropertyGroups() {
        return new ArrayList(this.jspPropertyGroups);
    }

    public boolean isServlet24() {
        return this.isServlet24;
    }

    public JspOptions getJspOptions() {
        return this.options;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars = new StringBuffer();
        if (string3.equals("web-app")) {
            if (attributes.getValue("version") != null && attributes.getValue("version").equals("2.4")) {
                this.isServlet24 = true;
            }
        } else if (string3.equals("jsp-property-group")) {
            this.jspConfigPropertyGroup = new JspConfigPropertyGroup();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        for (int i = 0; i < n2; ++i) {
            if (this.chars == null) continue;
            this.chars.append(cArray[n + i]);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("taglib")) {
            this.tagLibMap.put(this.taglibUri, this.taglibLocation);
            this.taglibUri = null;
            this.taglibLocation = null;
        } else if (string3.equals("taglib-uri")) {
            this.taglibUri = this.chars.toString().trim();
        } else if (string3.equals("taglib-location")) {
            this.taglibLocation = this.chars.toString().trim();
        } else if (string3.equals("jsp-property-group")) {
            this.jspPropertyGroups.add(this.jspConfigPropertyGroup);
            this.jspConfigPropertyGroup = null;
            this.isServlet24 = true;
        } else if (string3.equals("url-pattern")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.addUrlPattern(this.chars.toString().trim());
            }
        } else if (string3.equals("el-ignored")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(2, new Boolean(this.chars.toString().trim())));
            }
        } else if (string3.equals("scripting-invalid")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(3, new Boolean(this.chars.toString().trim())));
            }
        } else if (string3.equals("include-prelude")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(5, this.chars.toString().trim()));
            }
        } else if (string3.equals("include-coda")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(6, this.chars.toString().trim()));
            }
        } else if (string3.equals("is-xml")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(1, new Boolean(this.chars.toString().trim())));
            }
        } else if (string3.equals("page-encoding") && this.jspConfigPropertyGroup != null) {
            this.jspConfigPropertyGroup.add(new JspConfigProperty(4, this.chars.toString().trim()));
        }
        this.chars = null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        String string3 = null;
        if (string.equals(WEBAPP_DTD_PUBLIC_ID_22)) {
            string3 = WEBAPP_DTD_RESOURCE_PATH_22;
        } else if (string.equals(WEBAPP_DTD_PUBLIC_ID_23)) {
            string3 = WEBAPP_DTD_RESOURCE_PATH_23;
        } else if (string.equals(WEBAPP_DTD_PUBLIC_ID_24)) {
            string3 = WEBAPP_DTD_RESOURCE_PATH_24;
            this.isServlet24 = true;
        }
        if (string3 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (inputStream == null) {
                System.out.println("publicId = " + string);
                System.out.println("resourcePath = " + string3);
                throw new SAXException("jsp error internal dtd not found");
            }
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }

    public List getJspFileExtensions() {
        return this.jspFileExtensions;
    }

    public boolean containsServletClassName(String string) {
        return false;
    }
}

