/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.servlet.event.ApplicationEvent;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletContextEventSource;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.event.ServletInvocationEvent;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.wswebcontainer.WebContainer;
import com.ibm.ws.wswebcontainer.stats.SmfWebAppModule;
import com.ibm.ws.wswebcontainer.stats.WebAppModule;
import com.ibm.ws.wswebcontainer.stats.WebAppPerf;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.wswebcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.wswebcontainer.metadata.WebModuleMetaData;
import javax.servlet.http.HttpServletRequest;

public class WebAppPmiListener
implements ServletListener,
ServletInvocationListener,
ServletErrorListener,
ApplicationListener {
    private static TraceComponent tc = Tr.register((Class)WebAppPmiListener.class, (String)"Webcontainer", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    J2EEName _appName = null;
    boolean areAppAggregatesInited = false;
    WebAppPerf appPmi = null;

    public void onApplicationAvailableForService(ApplicationEvent applicationEvent) {
        if (!this.areAppAggregatesInited) {
            this.InitializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
    }

    public void onApplicationUnavailableForService(ApplicationEvent applicationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onApplicationUnavailableForService();
        }
    }

    public void onApplicationStart(ApplicationEvent applicationEvent) {
        String string = (String)applicationEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.application.host");
        WebApp webApp = (WebApp)applicationEvent.getSource();
        WebAppConfiguration webAppConfiguration = webApp.getConfiguration();
        WebModuleMetaData webModuleMetaData = (WebModuleMetaData)webApp.getModuleMetaData();
        this._appName = webModuleMetaData.getJ2EEName();
        ServletContextEventSource servletContextEventSource = (ServletContextEventSource)applicationEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
        servletContextEventSource.addServletErrorListener(this);
        servletContextEventSource.addServletListener(this);
        servletContextEventSource.addServletInvocationListener(this);
        if (!this.areAppAggregatesInited) {
            this.InitializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
        if (this.appPmi != null) {
            this.appPmi.onApplicationStart();
        }
    }

    public void onApplicationEnd(ApplicationEvent applicationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onApplicationEnd();
        }
    }

    public void onServletStartService(ServletInvocationEvent servletInvocationEvent) {
        if (this.appPmi != null) {
            HttpServletRequest httpServletRequest = servletInvocationEvent.getRequest();
            if (httpServletRequest == null) {
                this.appPmi.onServletStartService(servletInvocationEvent.getServletName(), null);
            } else {
                this.appPmi.onServletStartService(servletInvocationEvent.getServletName(), RequestUtils.getURIForCurrentDispatch(servletInvocationEvent.getRequest()));
            }
        }
    }

    public void onServletFinishService(ServletInvocationEvent servletInvocationEvent) {
        if (this.appPmi != null) {
            HttpServletRequest httpServletRequest = servletInvocationEvent.getRequest();
            if (httpServletRequest == null) {
                this.appPmi.onServletFinishService(servletInvocationEvent.getServletName(), servletInvocationEvent.getResponseTime(), null);
            } else {
                this.appPmi.onServletFinishService(servletInvocationEvent.getServletName(), servletInvocationEvent.getResponseTime(), RequestUtils.getURIForCurrentDispatch(servletInvocationEvent.getRequest()));
            }
        }
    }

    public void onServletStartInit(ServletEvent servletEvent) {
        if (this.isStatisticsEnabled(servletEvent)) {
            WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            J2EEName j2EEName = webComponentMetaData.getJ2EEName();
            if (this.appPmi != null) {
                this.appPmi.onServletStartInit(j2EEName.toString(), servletEvent.getServletName());
            }
        }
    }

    public void onServletFinishInit(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletFinishInit(servletEvent.getServletName());
        }
    }

    public void onServletStartDestroy(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletStartDestroy(servletEvent.getServletName());
        }
    }

    public void onServletFinishDestroy(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletFinishDestroy(servletEvent.getServletName());
        }
    }

    public void onServletUnloaded(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletUnloaded(servletEvent.getServletName());
        }
    }

    public void onServletAvailableForService(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletAvailableForService(servletEvent.getServletName());
        }
    }

    public void onServletUnavailableForService(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletUnavailableForService(servletEvent.getServletName());
        }
    }

    public void onServletInitError(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletInitError(servletErrorEvent.getServletName());
        }
    }

    public void onServletServiceError(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletServiceError(servletErrorEvent.getServletName());
        }
    }

    public void onServletServiceDenied(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletServiceDenied(servletErrorEvent.getServletName());
        }
    }

    public void onServletDestroyError(ServletErrorEvent servletErrorEvent) {
        if (servletErrorEvent != null && servletErrorEvent.getServletName() != null && this.appPmi != null) {
            this.appPmi.onServletDestroyError(servletErrorEvent.getServletName());
        }
    }

    public void InitializeAppCounters(String string) {
        if (StatsFactory.isPMIEnabled()) {
            this.appPmi = WebContainer.isZOS ? new SmfWebAppModule(string) : new WebAppModule(string);
        } else if (WebContainer.isZOS && (SmfJActivity.isContainerActivityRecordingEnabled() || SmfJActivity.isContainerIntervalRecordingEnabled())) {
            this.appPmi = new SmfWebAppModule(string);
        }
    }

    public boolean isStatisticsEnabled(ServletEvent servletEvent) {
        Object object = servletEvent.getSource();
        if (object instanceof IServletWrapper) {
            IServletConfig iServletConfig = (IServletConfig)((IServletWrapper)object).getServletConfig();
            if (iServletConfig == null || iServletConfig.isStatisticsEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("pmi enabled for the servlet-->[" + servletEvent.getServletName() + "]"));
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("pmi disabled for the servlet-->[" + servletEvent.getServletName() + "]"));
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Event Source is not a ServletWrapper, we have to assume statistics enabled is true");
        }
        return true;
    }

    public String getAppName() {
        return this._appName.toString();
    }
}

