/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.FilterErrorListener;
import com.ibm.websphere.servlet.event.FilterInvocationListener;
import com.ibm.websphere.servlet.event.FilterListener;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.websphere.servlet.response.ResponseUtils;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.SessionRegistry;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.WebContainerConfiguration;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebContainerException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapper;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.spi.servlet.http.IHttpServletResponseListener;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.InvalidCacheTargetException;
import com.ibm.ws.webcontainer.util.URIToServletWrapperCache;
import com.ibm.ws.webcontainer.util.VirtualHostMapper;
import com.ibm.ws.webcontainer.util.WSURLDecoder;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public abstract class WebContainer
extends BaseContainer {
    protected static final String ISO = "ISO-8859-1";
    protected String encoding = null;
    protected boolean decode = true;
    protected WebContainerConfiguration wcconfig;
    protected static List applicationListeners = new ArrayList();
    protected static List servletListeners = new ArrayList();
    protected static List servletErrorListeners = new ArrayList();
    protected static List servletInvocationListeners = new ArrayList();
    protected static List filterInvocationListeners = new ArrayList();
    protected static List filterErrorListeners = new ArrayList();
    protected static List filterListeners = new ArrayList();
    private static List servletRequestListeners = new ArrayList();
    private static List servletRequestAttributeListeners = new ArrayList();
    private static List servletContextListeners = new ArrayList();
    private static List servletContextAttributeListeners = new ArrayList();
    private static List sessionListeners = new ArrayList();
    private static List sessionAttributeListeners = new ArrayList();
    public static final String DEFAULT_HOST = "default_host";
    protected boolean _initialized;
    protected static TraceComponent tc = Tr.register((Class)WebContainer.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    protected static WebContainer self = null;
    protected boolean production = false;
    private HashMap _cipherToBit = new HashMap();
    private static ThreadLocal cacheKeyStringBuffer = new WSThreadLocal();
    private static boolean listenersInitialized = false;
    protected static Properties webConProperties = new Properties();
    protected SessionRegistry sessionRegistry;
    protected boolean isStopped = false;
    public static final String urlPrefix = ";jsessionid=";
    public static ArrayList extensionFactories = new ArrayList();
    private static ArrayList httpResponseListeners = new ArrayList();
    private static int invocationCacheSize = 500;
    protected static boolean decodePlusSign;
    private static HashMap _cacheMap;
    private static boolean _cacheIsFull;
    protected boolean vHostCompatFlag = true;

    protected WebContainer(String string, Container container) {
        super(string, container);
        this.requestMapper = new VirtualHostMapper();
    }

    public void initialize(WebContainerConfiguration webContainerConfiguration) {
        this.wcconfig = webContainerConfiguration;
        this.getURIEncoding();
        this._initialized = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Web Container invocationCache -->" + invocationCacheSize));
        }
    }

    private static void registerGlobalWebAppListeners() {
        block5: {
            try {
                Properties properties = WebContainer.getWebContainerProperties();
                String string = properties.getProperty("listeners");
                String string2 = null;
                if (string == null) break block5;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                string2 = null;
                while (stringTokenizer.hasMoreElements()) {
                    try {
                        string2 = stringTokenizer.nextToken().trim();
                        WebContainer.addGlobalListener(string2);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.webapp.WebApp.registerGlobalWebAppListeners", (String)"785", (Object)WebContainer.getWebContainer());
                    }
                    listenersInitialized = true;
                }
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"Error occured while processing global listeners for the WebApp. \n{0}", (Object)throwable);
            }
        }
    }

    public static void addGlobalListener(String string) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addGlobalListener classname->" + string));
        }
        if ((object = WebContainer.loadListener(string)) != null) {
            if (object instanceof ApplicationListener) {
                applicationListeners.add(object);
            }
            if (object instanceof ServletListener) {
                servletListeners.add(object);
            }
            if (object instanceof ServletErrorListener) {
                servletErrorListeners.add(object);
            }
            if (object instanceof ServletInvocationListener) {
                servletInvocationListeners.add(object);
            }
            if (object instanceof FilterInvocationListener) {
                filterInvocationListeners.add(object);
            }
            if (object instanceof FilterListener) {
                filterListeners.add(object);
            }
            if (object instanceof FilterErrorListener) {
                filterErrorListeners.add(object);
            }
            if (object instanceof ServletContextAttributeListener) {
                servletContextAttributeListeners.add(object);
            }
            if (object instanceof ServletContextListener) {
                servletContextListeners.add(object);
            }
            if (object instanceof ServletRequestAttributeListener) {
                servletRequestAttributeListeners.add(object);
            }
            if (object instanceof ServletRequestListener) {
                servletRequestListeners.add(object);
            }
            if (object instanceof HttpSessionListener) {
                sessionListeners.add(object);
            }
            if (object instanceof HttpSessionAttributeListener) {
                sessionAttributeListeners.add(object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addGlobalListener");
        }
    }

    private static Object loadListener(String string) {
        Object object = null;
        try {
            object = Beans.instantiate(Thread.currentThread().getContextClassLoader(), string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1523", (Object)WebContainer.getWebContainer());
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1527", (Object)WebContainer.getWebContainer());
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1531", (Object)WebContainer.getWebContainer());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1535", (Object)WebContainer.getWebContainer());
        }
        catch (ClassFormatError classFormatError) {
            FFDCFilter.processException((Throwable)classFormatError, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1539", (Object)WebContainer.getWebContainer());
        }
        return object;
    }

    protected void loadCipherToBit() {
        Properties properties = new Properties();
        try {
            String string = System.getProperty("server.root") + File.separator + "properties" + File.separator + "sslbitsizes.properties";
            properties.load(new FileInputStream(string));
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"failed.to.load.sslbitsizes.properties \n{0}", (Object)exception);
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer.loadCipherToBit", (String)"825", (Object)this);
        }
        this._cipherToBit.putAll(properties);
    }

    public void destroy() {
        super.destroy();
        this.requestMapper = null;
    }

    public void shutdown() {
        this.destroy();
    }

    public void addWebApplication(DeployedModule deployedModule, boolean bl) throws WebAppNotLoadedException {
        try {
            this.production = bl;
            this.addWebApp(deployedModule, bl);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            throw webAppNotLoadedException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"695", (Object)this);
            throw new WebAppNotLoadedException(throwable.getMessage(), throwable);
        }
    }

    private void addWebApp(DeployedModule deployedModule, boolean bl) throws WebAppNotLoadedException {
        try {
            VirtualHost virtualHost;
            String string = deployedModule.getVirtualHostName();
            if (string == null || string.equals("")) {
                string = DEFAULT_HOST;
            }
            if ((virtualHost = this.getVirtualHost(string)) == null) {
                throw new WebAppNotLoadedException("Virtual Host " + string + " not found");
            }
            virtualHost.addWebApplication(deployedModule, extensionFactories, bl);
        }
        catch (WebAppHostNotFoundException webAppHostNotFoundException) {
            FFDCFilter.processException((Throwable)webAppHostNotFoundException, (String)"com.ibm.ws.webcontainer.Webcontainer", (String)"732", (Object)this);
            throw new WebAppNotLoadedException(webAppHostNotFoundException.getMessage(), webAppHostNotFoundException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"736", (Object)this);
            throw new WebAppNotLoadedException(throwable.getMessage(), throwable);
        }
    }

    public VirtualHost getVirtualHost(String string) throws WebAppHostNotFoundException {
        Iterator iterator = this.requestMapper.targetMappings();
        while (iterator.hasNext()) {
            VirtualHost virtualHost;
            RequestProcessor requestProcessor = (RequestProcessor)iterator.next();
            if (!(requestProcessor instanceof VirtualHost) || !string.equalsIgnoreCase((virtualHost = (VirtualHost)requestProcessor).getName())) continue;
            return virtualHost;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeWebApplication(DeployedModule deployedModule) throws Exception {
        WebContainer webContainer;
        try {
            try {
                VirtualHost virtualHost = this.getVirtualHost(deployedModule.getVirtualHostName());
                if (virtualHost == null) {
                    throw new WebAppHostNotFoundException("VirtualHost not found");
                }
                virtualHost.removeWebApplication(deployedModule);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"Exception \n{0}", (Object)exception);
                throw exception;
            }
            Object var4_4 = null;
            webContainer = this;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            WebContainer webContainer2 = this;
            synchronized (webContainer2) {
                _cacheIsFull = false;
                throw throwable;
            }
        }
        synchronized (webContainer) {
            _cacheIsFull = false;
            return;
        }
    }

    public static WebContainer getWebContainer() {
        return self;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void restartWebApplication(String string) throws WebAppNotLoadedException {
    }

    public void reload(DeployedModule deployedModule) throws WebAppNotLoadedException {
        this.restartWebApplication(deployedModule);
    }

    public void restartWebApplication(DeployedModule deployedModule) throws WebAppNotLoadedException {
        String string = deployedModule.getName();
        try {
            this.removeWebApplication(deployedModule);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)("Failed to remove webmodule " + string + "\n{0}"), (Object)exception);
            return;
        }
        this.addWebApplication(deployedModule, this.production);
    }

    public boolean areRequestsOutstanding() {
        return false;
    }

    public WebContainerConfiguration getWebContainerConfig() {
        return this.wcconfig;
    }

    public IHttpSessionContext getSessionContext(DeployedModule deployedModule, WebApp webApp, String string, ArrayList[] arrayListArray) throws Throwable {
        try {
            return this.getSessionRegistry().getSessionContext(deployedModule, webApp, string, arrayListArray);
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"unable to get sessionContext \n{0}", (Object)throwable);
            return null;
        }
    }

    private SessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(IRequest iRequest, IResponse iResponse) throws IOException {
        SRTConnectionContext sRTConnectionContext = null;
        sRTConnectionContext = this.getConnectionContext();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = iRequest.getServerName();
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
            }
            stringBuffer2.append(string);
        }
        stringBuffer2.append(':');
        stringBuffer2.append(iRequest.getServerPort());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Handling request with virtual host key of --> " + stringBuffer2.toString()));
        }
        Request request = null;
        Response response = null;
        StringBuffer stringBuffer = (StringBuffer)cacheKeyStringBuffer.get();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            cacheKeyStringBuffer.set(stringBuffer);
        }
        try {
            try {
                block43: {
                    RequestProcessor requestProcessor;
                    Object object;
                    sRTConnectionContext.prepareForNextConnection(iRequest, iResponse);
                    request = sRTConnectionContext.getRequest();
                    response = sRTConnectionContext.getResponse();
                    WebAppDispatcherContext webAppDispatcherContext = request.getWebAppDispatcherContext();
                    String string2 = iRequest.getRequestURI();
                    String string3 = null;
                    string3 = decodePlusSign ? URLDecoder.decode(string2, WebContainer.getWebContainer().getURIEncoding()) : WSURLDecoder.decode(string2, WebContainer.getWebContainer().getURIEncoding());
                    request.getWebAppDispatcherContext().setDecodedReqUri(string3);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("webcontainer.handleRequest request uri --> (not decoded=" + string2 + "), (decoded=" + string3 + "), (encoding=" + this.encoding + ")"));
                    }
                    if (this.decode) {
                        object = new String(string2.getBytes(this.getURIEncoding()), ISO);
                        request.setAttribute("com.ibm.websphere.servlet.uri_non_decoded", object);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("webcontainer.handleRequest uri_non_decoded --> " + (String)object));
                        }
                    }
                    stringBuffer.append(stringBuffer2);
                    object = this.removeExtraPathInfo(string2);
                    String string4 = null;
                    String string5 = null;
                    if (object != null) {
                        string4 = ((PathInfoHelper)object).getBasePath();
                        string5 = ((PathInfoHelper)object).getExtraPathInfo();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("PathInfoHelper strippedRequestURI --> " + string4 + " extraPath --> " + string5));
                        }
                    }
                    stringBuffer.append(string4);
                    CacheServletWrapper cacheServletWrapper = (CacheServletWrapper)_cacheMap.get(stringBuffer.toString());
                    if (cacheServletWrapper != null) {
                        block42: {
                            WebApp webApp = cacheServletWrapper.getWebApp();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Found CacheServletWrapper with key --> " + stringBuffer.toString()));
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Check if webApp is being destroyed --> " + webApp.getDestroyed() + ", webApp=" + webApp));
                            }
                            if (!webApp.getDestroyed().booleanValue()) break block42;
                            cacheServletWrapper.invalidate();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("sending sendUnavailableException for servlet from: " + cacheServletWrapper.getServletPath()));
                            }
                            this.sendUnavailableException(iRequest, iResponse);
                            Object var22_31 = null;
                            stringBuffer.setLength(0);
                            sRTConnectionContext.finishConnection();
                            this.releaseConnectionContext(sRTConnectionContext);
                            return;
                        }
                        try {
                            webAppDispatcherContext.setWebApp(cacheServletWrapper.getWebApp());
                            sRTConnectionContext.start();
                            String string6 = cacheServletWrapper.getWebApp().getContextPath();
                            if (string6 == null || string6.equals("/")) {
                                string6 = "";
                            }
                            String string7 = cacheServletWrapper.getServletPath();
                            int n = string6.length() + string7.length();
                            String string8 = string3.substring(n);
                            webAppDispatcherContext.setRequestURI(string2);
                            webAppDispatcherContext.setPathElements(cacheServletWrapper.getServletPath(), string8.equals("") ? null : string8);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CachedServletWrapper servletPath --> " + webAppDispatcherContext.getServletPath()));
                                Tr.debug((TraceComponent)tc, (String)("CachedServletWrapper pathInfo --> " + webAppDispatcherContext.getPathInfo()));
                            }
                            webAppDispatcherContext.setQueryString(((SRTServletRequest)request).getQueryString());
                            cacheServletWrapper.handleRequest(request, response);
                            break block43;
                        }
                        catch (InvalidCacheTargetException invalidCacheTargetException) {
                            RequestProcessor requestProcessor2;
                            cacheServletWrapper = null;
                            if (this.isVHostCompatFlag()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Looking for vhost with key --> " + stringBuffer2.toString()));
                                }
                                requestProcessor2 = this.requestMapper.map(stringBuffer2.toString());
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Looking for vhost with key --> " + stringBuffer2.toString() + string3));
                                }
                                requestProcessor2 = this.requestMapper.map(stringBuffer2.toString() + string3);
                            }
                            if (requestProcessor2 == null) {
                                throw new WebGroupVHostNotFoundException(stringBuffer2.toString());
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("request processor handling request --> " + requestProcessor2));
                            }
                            requestProcessor2.handleRequest(request, response);
                        }
                        catch (Throwable throwable) {
                            cacheServletWrapper.invalidate();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"removing cache wrapper because exception was thrown and rethrowing the exception.");
                            }
                            throw throwable;
                        }
                    }
                    webAppDispatcherContext.setRequestURI(string2);
                    webAppDispatcherContext.setQueryString(iRequest.getQueryString());
                    if (this.isVHostCompatFlag()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Looking for vhost with key --> " + stringBuffer2.toString()));
                        }
                        requestProcessor = this.requestMapper.map(stringBuffer2.toString());
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Looking for vhost with key --> " + stringBuffer2.toString() + string3));
                        }
                        requestProcessor = this.requestMapper.map(stringBuffer2.toString() + string3);
                    }
                    if (requestProcessor == null) {
                        throw new WebGroupVHostNotFoundException(stringBuffer2.toString());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("request processor handling request --> " + requestProcessor));
                    }
                    requestProcessor.handleRequest(request, response);
                }
                Object var22_32 = null;
                stringBuffer.setLength(0);
                sRTConnectionContext.finishConnection();
                this.releaseConnectionContext(sRTConnectionContext);
                return;
            }
            catch (WebGroupVHostNotFoundException webGroupVHostNotFoundException) {
                iResponse.setStatusCode(404);
                string = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.webgroupvhostnotfound");
                byte[] byArray = null;
                if (string == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WebGroup/VHost not found, webGroupVHostNotFound custom property is either not set by user or has null value--> " + string));
                    }
                    iResponse.addHeader("Content-Type", "text/html");
                    String string9 = "<H1>" + MessageFormat.format(nls.getString("Web.Group.VHost.Not.Found", "WebGroup Not Found"), ResponseUtils.encodeDataString(iRequest.getRequestURI())) + "</H1><BR><H3>" + webGroupVHostNotFoundException.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    byArray = string9.getBytes();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WebGroup/VHost not found, webGroupVHostNotFound custom property is set to value--> " + string));
                    }
                    iResponse.addHeader("Content-Type", "text/html;charset=UTF-8");
                    String string10 = string;
                    byArray = string10.getBytes("UTF-8");
                }
                iResponse.getOutputStream().write(byArray, 0, byArray.length);
                Tr.error((TraceComponent)tc, (String)"Web.Group.VHost.Not.Found", (Object)new Object[]{this.truncateURI(iRequest.getRequestURI())});
                Object var22_33 = null;
                stringBuffer.setLength(0);
                sRTConnectionContext.finishConnection();
                this.releaseConnectionContext(sRTConnectionContext);
                return;
            }
            catch (WebContainerException webContainerException) {
                FFDCFilter.processException((Throwable)webContainerException, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"134", (Object)this);
                iResponse.addHeader("Content-Type", "text/html");
                iResponse.setStatusCode(500);
                string = "<H1>" + nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{webContainerException.getMessage()}, "Internal Server Error. <br> Exception Message: " + webContainerException.getMessage()) + "</H1><BR><H3>" + webContainerException.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                byte[] byArray = string.getBytes();
                iResponse.getOutputStream().write(byArray, 0, byArray.length);
                Object[] objectArray = new Object[]{webContainerException};
                Tr.error((TraceComponent)tc, (String)"Engine.Exception.[{0}]", (Object)objectArray);
                Object var22_34 = null;
                stringBuffer.setLength(0);
                sRTConnectionContext.finishConnection();
                this.releaseConnectionContext(sRTConnectionContext);
                return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"162", (Object)this);
                iResponse.addHeader("Content-Type", "text/html");
                iResponse.setStatusCode(500);
                string = "<H1>" + nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{throwable.getMessage()}, "Engine Exception") + "</H1><BR><H3>" + throwable.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                byte[] byArray = string.getBytes();
                iResponse.getOutputStream().write(byArray, 0, byArray.length);
                Object[] objectArray = new Object[]{throwable};
                Tr.error((TraceComponent)tc, (String)"Engine.Exception.[{0}]", (Object)objectArray);
                Object var22_35 = null;
                stringBuffer.setLength(0);
                sRTConnectionContext.finishConnection();
                this.releaseConnectionContext(sRTConnectionContext);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var22_36 = null;
            stringBuffer.setLength(0);
            sRTConnectionContext.finishConnection();
            this.releaseConnectionContext(sRTConnectionContext);
            sRTConnectionContext = null;
            throw throwable;
        }
    }

    public static Properties getWebContainerProperties() {
        return webConProperties;
    }

    protected abstract SRTConnectionContext getConnectionContext();

    protected abstract void releaseConnectionContext(SRTConnectionContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCache(HttpServletRequest httpServletRequest, RequestProcessor requestProcessor, WebApp webApp) {
        if (_cacheIsFull) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebContainer - cache is full");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addTocache WebApp=" + webApp));
        }
        RequestProcessor requestProcessor2 = requestProcessor;
        synchronized (requestProcessor2) {
            if (webApp != null && webApp.getDestroyed().booleanValue()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"In Sync: Not caching as the webapp is destroyed");
                }
                return;
            }
            StringBuffer stringBuffer = (StringBuffer)cacheKeyStringBuffer.get();
            String string = stringBuffer.toString();
            if (_cacheMap.containsKey(string)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Already cached cacheKey --> " + stringBuffer));
                }
                return;
            }
            if (_cacheMap.size() < invocationCacheSize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding to cache cacheKey --> " + stringBuffer + " uri -->" + httpServletRequest.getRequestURI() + " servletWrapper -->" + ((IServletWrapper)requestProcessor).getServletName()));
                }
                CacheServletWrapper cacheServletWrapper = new CacheServletWrapper((IServletWrapper)requestProcessor, httpServletRequest, _cacheMap, stringBuffer, webApp);
            } else {
                _cacheIsFull = true;
            }
        }
    }

    public static CacheServletWrapper getFromCache(StringBuffer stringBuffer) {
        return (CacheServletWrapper)_cacheMap.get(stringBuffer.toString());
    }

    public Integer getKeySize(String string) {
        String string2 = (String)this._cipherToBit.get(string);
        if (string2 == null || string2.equals("") || string2.equals("-1")) {
            return null;
        }
        return new Integer(string2);
    }

    public void registerVirtualHostExtensionFactory(ExtensionFactory extensionFactory) {
        try {
            ExtensionProcessor extensionProcessor = extensionFactory.createExtensionProcessor(null);
            Iterator iterator = extensionFactory.getPatternList().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.requestMapper.addMapping(string, extensionProcessor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addExtensionFactory(ExtensionFactory extensionFactory) {
        List list = extensionFactory.getPatternList();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer(32);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        Tr.info((TraceComponent)tc, (String)"ExtensionFactory.[{0}].registered.successfully", (Object)new Object[]{extensionFactory.getClass().toString()});
        Tr.info((TraceComponent)tc, (String)"ExtensionFactory.[{0}].associated.with.patterns.[{1}]", (Object)new Object[]{extensionFactory.getClass().toString(), stringBuffer.toString()});
        extensionFactories.add(extensionFactory);
    }

    public static void addHttpServletResponseListener(IHttpServletResponseListener iHttpServletResponseListener) {
        if (iHttpServletResponseListener != null) {
            httpResponseListeners.add(iHttpServletResponseListener);
        }
    }

    public static void notifyHttpServletResponseListenersPreHeaderCommit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!httpResponseListeners.isEmpty()) {
            Iterator iterator = httpResponseListeners.iterator();
            while (iterator.hasNext()) {
                IHttpServletResponseListener iHttpServletResponseListener = (IHttpServletResponseListener)iterator.next();
                iHttpServletResponseListener.preHeaderCommit(httpServletRequest, httpServletResponse);
            }
        }
    }

    public static List getApplicationListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return applicationListeners;
    }

    public static List getServletErrorListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletErrorListeners;
    }

    public static List getServletInvocationListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletInvocationListeners;
    }

    public static List getFilterInvocationListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterInvocationListeners;
    }

    public static List getFilterListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterListeners;
    }

    public static List getFilterErrorListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterErrorListeners;
    }

    public static List getServletContextAttributeListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextAttributeListeners;
    }

    public static List getServletContextListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextListeners;
    }

    public static List getServletRequestAttributeListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestAttributeListeners;
    }

    public static List getServletRequestListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestListeners;
    }

    public static List getSessionListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionListeners;
    }

    public static List getSessionAttributeListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionAttributeListeners;
    }

    public static List getServletListeners(boolean bl) {
        if (!listenersInitialized && !bl) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletListeners;
    }

    public static List getExtensionFactories() {
        return extensionFactories;
    }

    protected String truncateURI(String string) {
        if (string.length() > 128) {
            string = string.substring(0, 127);
        }
        return string;
    }

    public String getURIEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        this.encoding = "UTF-8";
        Properties properties = WebContainer.getWebContainerProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase("DecodeUrlAsUTF8") || !(string = properties.getProperty(string2, "true")).equalsIgnoreCase("false")) continue;
            this.encoding = ISO;
            this.decode = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getURIEncoding(): encoding -->" + this.encoding + " decode -->" + this.decode));
        }
        return this.encoding;
    }

    public boolean isEnableSecurityAtWARBoundary() {
        return false;
    }

    public boolean isEnableSecurityAtEARBoundary() {
        return false;
    }

    private PathInfoHelper removeExtraPathInfo(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            return new PathInfoHelper(string2, string3);
        }
        return new PathInfoHelper(string, null);
    }

    public static Iterator getCachedServletWrapperNames() {
        Set set = _cacheMap.keySet();
        ArrayList arrayList = new ArrayList(set);
        return arrayList.listIterator();
    }

    protected boolean isVHostCompatFlag() {
        return this.vHostCompatFlag;
    }

    protected void setVHostCompatFlag(boolean bl) {
        this.vHostCompatFlag = bl;
    }

    public Iterator getVirtualHosts() {
        return this.getTargetMappings();
    }

    protected void sendUnavailableException(IRequest iRequest, IResponse iResponse) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Inside sendUnavailableException");
        }
        iResponse.addHeader("Content-Type", "text/html");
        iResponse.setStatusCode(503);
        String string = "<H1>" + nls.getFormattedMessage("Servlet.has.become.temporarily.unavailable.for.service.{0}", new Object[]{this.truncateURI(iRequest.getRequestURI())}, "Servlet has become temporarily unavailable for service") + "</H1><BR><H3>" + "</H3><BR><I>IBM WebSphere Application Server</I>";
        byte[] byArray = string.getBytes();
        iResponse.getOutputStream().write(byArray, 0, byArray.length);
        Tr.error((TraceComponent)tc, (String)"Servlet.has.become.temporarily.unavailable.for.service", (Object)new Object[]{this.truncateURI(iRequest.getRequestURI())});
    }

    public synchronized void setWebContainerStopping(boolean bl) {
        this.isStopped = bl;
    }

    static {
        String string = System.getProperty("invocationCacheSize");
        if (string != null) {
            try {
                invocationCacheSize = Integer.parseInt(string) * 10;
            }
            catch (NumberFormatException numberFormatException) {
                invocationCacheSize = 500;
            }
        }
        decodePlusSign = true;
        _cacheMap = new URIToServletWrapperCache(invocationCacheSize);
        _cacheIsFull = false;
    }

    private class PathInfoHelper {
        private String basePath = null;
        private String extraPathInfo = null;

        private PathInfoHelper(String string, String string2) {
            this.basePath = string;
            this.extraPathInfo = string2;
        }

        private String getExtraPathInfo() {
            return this.extraPathInfo;
        }

        private String getBasePath() {
            return this.basePath;
        }
    }
}

