/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.PropertyVetoException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.metadata.MetaDataFactory;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.component.ComponentUtil;
import com.ibm.ws.webcontainer.diag.WebcontainerDiagnosticProviderMBean;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.metadata.WebMetaDataFactory;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.ws.webcontainer.spi.servlet.http.IHttpServletResponseListener;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInitializationCollaborator;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.ws.wswebcontainer.ServletContextFacadeRegistryItem;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.runtime.component.WsContainer;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.osgi.framework.Bundle;

public class WebContainerImpl
extends WsContainer
implements DeployedObjectHandler,
VetoableChangeListener,
WebContainerService {
    protected com.ibm.ws.wswebcontainer.WebContainer _webContainer = null;
    protected com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer _webContainerConfig = null;
    protected boolean startTransports = false;
    protected boolean startChannels = false;
    protected ArrayList webAppInitializationCollaboratorList;
    protected ArrayList webAppInvocationCollaboratorList;
    private WebMetaDataFactory metaDataFactory;
    private boolean isDefaultTempDir = true;
    public static String WEBCONTAINER_STATE = null;
    protected static TraceComponent tc = Tr.register((Class)WebContainerImpl.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static String PLUGIN_ID = "com.ibm.wsspi.extension.webcontainer-startup";
    SessionRegistry _sessRegistry = null;

    public WebContainerImpl() {
        super(PLUGIN_ID);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl <init>");
        }
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.initialize entry");
        }
        WEBCONTAINER_STATE = "INITIALIZING";
        ContainerConfig containerConfig = (ContainerConfig)object;
        com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer webContainer = (com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer)containerConfig.getConfig();
        com.ibm.websphere.models.config.applicationserver.ApplicationServer applicationServer = (com.ibm.websphere.models.config.applicationserver.ApplicationServer)webContainer.getParentComponent();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            if (AdminHelper.getPlatformHelper().isCRAJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WebContainer is disabled in z/OS CRA.");
                }
                throw new ComponentDisabledException();
            }
            boolean bl = applicationServer.getServer().getServerInstance().isEnableMultipleServerInstances();
            int n = applicationServer.getServer().getServerInstance().getMaximumNumberOfInstances();
            Tr.debug((TraceComponent)tc, (String)("isEnabledMultipleServerInstances=" + bl + ", maximumNumberOfInstances=" + n + ", minimumNumberOfInstances" + applicationServer.getServer().getServerInstance().getMinimumNumOfInstances()));
            if (bl && n > 1) {
                this.isDefaultTempDir = false;
            }
        }
        if (webContainer.getStateManagement() != null && webContainer.getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this._webContainerConfig = (com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer)etoolsCopyUtility.copy((EObject)webContainer);
        ApplicationServer applicationServer2 = (ApplicationServer)ComponentUtil.getService(this, ApplicationServer.class);
        applicationServer2.addVetoableChangeListener("state", (VetoableChangeListener)this);
        try {
            WsServiceRegistry.addService((Object)this, (Class)WebContainerService.class);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Failed to add WebContainerService \n{0}", (Object)exception);
        }
        MetaDataFactoryMgr metaDataFactoryMgr = (MetaDataFactoryMgr)ComponentUtil.getService(this, MetaDataFactoryMgr.class);
        WebMetaDataFactory.init(metaDataFactoryMgr);
        this.metaDataFactory = new WebMetaDataFactory();
        metaDataFactoryMgr.addMetaDataFactory((MetaDataFactory)this.metaDataFactory);
        super.initialize(object);
        WEBCONTAINER_STATE = "INITIALIZED";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.initialize exit");
        }
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.destroy");
        }
        WEBCONTAINER_STATE = "DESTROYING";
        super.destroy();
        WEBCONTAINER_STATE = "DESTROYED";
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.start entry");
        }
        WEBCONTAINER_STATE = "STARTING";
        super.start();
        ApplicationMgr applicationMgr = (ApplicationMgr)ComponentUtil.getService(this, ApplicationMgr.class);
        applicationMgr.addDeployedObjectHandler((DeployedObjectHandler)this);
        this.loadServletContextFacadeRegistry();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating WebcontainerDiagnosticMBean");
        }
        WebcontainerDiagnosticProviderMBean webcontainerDiagnosticProviderMBean = WebcontainerDiagnosticProviderMBean.getWebcontainerDiagnosicProviderMBean("WebContainerDP");
        Properties properties = new Properties();
        properties.setProperty("diagnosticProvider", "true");
        ObjectName objectName = this.locRegisterMBean("WebcontainerDiagnosticProvider", webcontainerDiagnosticProviderMBean, "WebcontainerDiagnosticProvider", null, properties);
        DiagnosticProviderHelper.registerMBeanWithDiagnosticService((String)"WebContainerDP", (ObjectName)objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.start exit");
        }
    }

    private void loadServletContextFacadeRegistry() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.loadServletContextFacadeRegistry");
        }
        try {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("com.ibm.wsspi.extension.servlet-context-facade-registry-xml");
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IExtension iExtension = iExtensionArray[i];
                Bundle bundle = Platform.getBundle((String)iExtensionArray[i].getNamespace());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("scfBundle location -->" + bundle.getLocation()));
                }
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                    String string = iConfigurationElementArray[j].getName();
                    if (string == null || !string.equals("ServletContextFactoryRegistration")) continue;
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[j].getChildren("ServletContext");
                    for (int k = 0; iConfigurationElementArray2 != null && k < iConfigurationElementArray2.length; ++k) {
                        String string2 = iConfigurationElementArray2[k].getAttribute("classname");
                        String string3 = iConfigurationElementArray2[k].getAttribute("feature");
                        String string4 = iConfigurationElementArray2[k].getAttribute("priority");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ServletContextFacadeRegistryItem classname --> [" + string2 + "] feature--> [" + string3 + "] priority -->[" + string4 + "]"));
                        }
                        ServletContextFacadeRegistryItem servletContextFacadeRegistryItem = new ServletContextFacadeRegistryItem();
                        servletContextFacadeRegistryItem.setClassloader(new BundleClassLoader(bundle));
                        if (string2 != null) {
                            servletContextFacadeRegistryItem.setClassname(string2);
                        }
                        if (string3 != null) {
                            servletContextFacadeRegistryItem.setFeature(string3);
                        }
                        if (string4 != null) {
                            servletContextFacadeRegistryItem.setPriority(string4);
                        }
                        com.ibm.ws.wswebcontainer.WebContainer.addServletContextFacadeRegistryItem(servletContextFacadeRegistryItem);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"Failed to register ServletContextFacadeRegistryItem \n{0}", (Object)throwable);
            WEBCONTAINER_STATE = "ERROR";
        }
    }

    protected List loadComponents(String string) throws ConfigurationError {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebContainerImpl.loadComponents -->" + string));
        }
        return super.loadComponents(string);
    }

    public void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.stop entry");
        }
        WEBCONTAINER_STATE = "STOPPING";
        if (this._webContainer != null) {
            this._webContainer.shutdown();
        }
        super.stopComponents();
        WEBCONTAINER_STATE = "STOPPED";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.stop exit");
        }
    }

    public synchronized void install(DeployedObject deployedObject) throws RuntimeError, RuntimeWarning {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.install entry");
        }
        this.init();
        boolean bl = false;
        try {
            com.ibm.ws.wscontainer.DeployedModule deployedModule = new com.ibm.ws.wscontainer.DeployedModule((DeployedModule)deployedObject);
            this._webContainer.addWebApplication(deployedModule, bl);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.install", (String)"124", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.install exit");
        }
    }

    public synchronized void uninstall(DeployedObject deployedObject) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.uninstall");
        }
        if (this._webContainer != null) {
            try {
                com.ibm.ws.wscontainer.DeployedModule deployedModule = new com.ibm.ws.wscontainer.DeployedModule((DeployedModule)deployedObject);
                this._webContainer.removeWebApplication(deployedModule);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)("Could not remove webmodule " + deployedObject.getModuleFile().getURI() + "\n{0}"), (Object)exception);
            }
        }
    }

    public void addVirtualHostExtensionFactory(ExtensionFactory extensionFactory) {
        com.ibm.ws.wswebcontainer.WebContainer.addVirtualHostExtensionFactory(extensionFactory);
    }

    public void addExtensionFactory(ExtensionFactory extensionFactory) {
        WebContainer.addExtensionFactory(extensionFactory);
    }

    public void addHttpServletResponseListener(IHttpServletResponseListener iHttpServletResponseListener) {
        WebContainer.addHttpServletResponseListener(iHttpServletResponseListener);
    }

    public void addWebAppCollaborator(WebAppCollaborator webAppCollaborator) {
        if (this._webContainer != null) {
            throw new IllegalStateException("Web container already initialized");
        }
        if (webAppCollaborator != null) {
            if (webAppCollaborator instanceof IInvocationCollaborator) {
                if (this.webAppInvocationCollaboratorList == null) {
                    this.webAppInvocationCollaboratorList = new ArrayList();
                }
                this.webAppInvocationCollaboratorList.add(webAppCollaborator);
            }
            if (webAppCollaborator instanceof IInitializationCollaborator) {
                if (this.webAppInitializationCollaboratorList == null) {
                    this.webAppInitializationCollaboratorList = new ArrayList();
                }
                this.webAppInitializationCollaboratorList.add(webAppCollaborator);
            }
        }
    }

    protected void init() throws RuntimeError {
        if (this._webContainer != null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.init");
        }
        if (this._sessRegistry == null) {
            Tr.error((TraceComponent)tc, (String)"The Session registry is NULL possibly because the SessionManager did not start up correctly. Web applications WILL fail.");
        }
        this._webContainer = (com.ibm.ws.wswebcontainer.WebContainer)com.ibm.ws.wswebcontainer.WebContainer.getWebContainer();
        this._webContainer.setSessionRegistry(this._sessRegistry);
        com.ibm.ws.wswebcontainer.WebContainer.setIsDefaultTempDir(this.isDefaultTempDir);
        IInitializationCollaborator[] iInitializationCollaboratorArray = null;
        if (this.webAppInitializationCollaboratorList != null) {
            iInitializationCollaboratorArray = new IInitializationCollaborator[this.webAppInitializationCollaboratorList.size()];
            iInitializationCollaboratorArray = this.webAppInitializationCollaboratorList.toArray(iInitializationCollaboratorArray);
        } else {
            iInitializationCollaboratorArray = new IInitializationCollaborator[]{};
        }
        IInvocationCollaborator[] iInvocationCollaboratorArray = null;
        if (this.webAppInvocationCollaboratorList != null) {
            iInvocationCollaboratorArray = new IInvocationCollaborator[this.webAppInvocationCollaboratorList.size()];
            iInvocationCollaboratorArray = this.webAppInvocationCollaboratorList.toArray(iInvocationCollaboratorArray);
        } else {
            iInvocationCollaboratorArray = new IInvocationCollaborator[]{};
        }
        this._webContainer.initialize(this._webContainerConfig, iInitializationCollaboratorArray, iInvocationCollaboratorArray);
        this.startTransports();
        this.registerMBean();
        this._webContainerConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransports() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.startTransports");
        }
        if (this._webContainer != null && this.startTransports) {
            VariableMap variableMap = null;
            ThreadPoolMgr threadPoolMgr = null;
            variableMap = (VariableMap)ComponentUtil.getService(this, VariableMap.class);
            threadPoolMgr = (ThreadPoolMgr)ComponentUtil.getService(this, ThreadPoolMgr.class);
            this._webContainer.startTransports(variableMap, threadPoolMgr);
        }
    }

    protected void startChannels() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.startChannels");
        }
        if (this._webContainer == null) {
            try {
                this.init();
            }
            catch (RuntimeError runtimeError) {
                Tr.error((TraceComponent)tc, (String)"failed to initialize webcontainer required to start chains", (Object)((Object)runtimeError));
                return;
            }
        }
        this._webContainer.startChains();
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.vetoableChange");
        }
        if (propertyChangeEvent.getNewValue().equals("STARTED")) {
            WEBCONTAINER_STATE = "STARTED";
            this.startTransports = true;
            this.startTransports();
            this.startChannels = true;
            this.startChannels();
        }
    }

    public boolean start(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObject.getModuleFile().isWARFile()) {
            this.install(deployedObject);
            return true;
        }
        return false;
    }

    public void stop(DeployedObjectEvent deployedObjectEvent) {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObject.getModuleFile().isWARFile()) {
            this.uninstall(deployedObject);
        }
    }

    public synchronized void reload(DeployedObject deployedObject) throws RuntimeWarning {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebContainerImpl.reload");
        }
        try {
            if (deployedObject.getModuleFile().isWARFile()) {
                this._webContainer.reload((com.ibm.ws.wscontainer.DeployedModule)deployedObject);
            }
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.reload", (String)"379", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    public synchronized void restart(DeployedObject deployedObject) throws RuntimeWarning {
        try {
            if (deployedObject.getModuleFile().isWARFile()) {
                this._webContainer.restartWebApplication((com.ibm.ws.wscontainer.DeployedModule)deployedObject);
            }
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.restart", (String)"398", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    protected void registerMBean() {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator((Object)this._webContainer, "WebContainer");
            String string = mBeanFactory.getConfigId((Object)this._webContainerConfig);
            mBeanFactory.activateMBean("WebContainer", (RuntimeCollaborator)defaultRuntimeCollaborator, string, null);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.component.WebContainerImpl.registerMBean", (String)"419", (Object)this);
        }
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this._sessRegistry = sessionRegistry;
    }

    public ClassLoader getClassLoader(J2EEName j2EEName) {
        Iterator iterator = this.metaDataFactory.moduleMetaDatas();
        while (iterator.hasNext()) {
            WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)iterator.next();
            J2EEName j2EEName2 = webModuleMetaDataImpl.getJ2EEName();
            String string = j2EEName2.getModule();
            String string2 = j2EEName2.getApplication();
            String string3 = j2EEName.getModule();
            String string4 = j2EEName.getApplication();
            if (!(string == null ? string3 == null : string.equals(string3)) || !(string2 == null ? string4 == null : string2.equals(string4))) continue;
            return webModuleMetaDataImpl.getWebAppConfig().getWebApp().getClassLoader();
        }
        return null;
    }

    public String getName() {
        return "WebContainer_COMPONENT";
    }

    public String getState() {
        return WEBCONTAINER_STATE;
    }

    private ObjectName locRegisterMBean(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        ObjectName objectName = null;
        if (mBeanFactory != null) {
            try {
                properties.setProperty("name", string2);
                objectName = mBeanFactory.activateMBean(string, runtimeCollaborator, string3, null, properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectName;
    }

    public class BundleClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public BundleClassLoader(Bundle bundle) {
            this.bundle = bundle;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            return this.bundle.loadClass(string);
        }

        protected URL findResource(String string) {
            return this.bundle.getResource(string);
        }

        protected Enumeration findResources(String string) throws IOException {
            return this.bundle.getResources(string);
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            return this.bundle.loadClass(string);
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.bundle.loadClass(string);
        }
    }
}

