/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.core;

import com.ibm.ws.container.AbstractContainer;
import com.ibm.ws.container.Container;
import com.ibm.ws.webcontainer.core.Command;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.RequestMapper;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class BaseContainer
extends AbstractContainer
implements RequestProcessor {
    protected ArrayList commands;
    protected RequestMapper requestMapper;
    protected Container parent;

    public BaseContainer(String string, Container container) {
        this.name = string;
        this.parent = container;
        if (container != null) {
            container.addSubContainer(this);
        }
        this.commands = new ArrayList(3);
        this.start();
    }

    public RequestMapper getRequestMapper() {
        return this.requestMapper;
    }

    public void setRequestMapper(RequestMapper requestMapper) {
        this.requestMapper = requestMapper;
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        throw new Exception("Super class implementation called...Subclass must override this method.");
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public void removeCommand(Command command) {
        this.commands.remove(command);
    }

    public void execute(Request request, Response response) {
        for (int i = 0; i < this.commands.size(); ++i) {
            ((Command)this.commands.get(i)).execute(request, response);
        }
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    public Iterator getTargetMappings() {
        return this.requestMapper.targetMappings();
    }
}

