/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.diag;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.ws.webcontainer.diag.DumpHelper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws.wswebcontainer.VirtualHost;
import com.ibm.ws.wswebcontainer.WebContainer;
import com.ibm.ws.wswebcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.wswebcontainer.webapp.WebGroupConfiguration;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;

public class ConfigDumpHelper
extends DumpHelper {
    private boolean isPopulated = false;
    protected static TraceComponent tc = Tr.register((Class)ConfigDumpHelper.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public ConfigDumpHelper(String string, String string2, String string3) {
        super(string, string2, string3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConfigDumpHelper.initialize  localID -> " + string + " dpID -> " + string2 + " className -> " + string3));
        }
    }

    public DiagnosticEvent[] getDump() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConfigDumpHelper.getDump");
        }
        DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[1];
        if (!this.isPopulated && webcontainer != null) {
            this.populate();
            this.isPopulated = true;
        }
        diagnosticEventArray[0] = DiagnosticEventFactory.createConfigDump((String)this.dpID, (String)this.className, (String)"configDump", (HashMap)this.nestedHashMap);
        return diagnosticEventArray;
    }

    protected void populate() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConfigDumpHelper populate webcontainer data");
        }
        if (webcontainerConfig != null) {
            this.addInfo("startup-defaultVirtualHostName", "default_host");
            this.addInfo("startup-jvmProps", webcontainerConfig.getConverterProps());
            this.addInfo("startup-localeProps", webcontainerConfig.getLocaleProps());
            this.addInfo("startup-servletCachingEnabled", webcontainerConfig.isEnableServletCaching());
            this.addInfo("startup-poolingDisabled", webcontainerConfig.isPoolingDisabled());
            this.addInfo("startup-customProperties", WebContainer.getWebContainerProperties());
        } else {
            Tr.error((TraceComponent)tc, (String)"Null webcontainer config object");
        }
        this.populateVirtualHosts();
    }

    protected void populateVirtualHosts() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConfigDumpHelper populate virtual host data");
        }
        VirtualHost virtualHost = null;
        VirtualHostConfiguration virtualHostConfiguration = null;
        String string = null;
        Iterator iterator = null;
        iterator = webcontainer.getVirtualHosts();
        while (iterator.hasNext()) {
            RequestProcessor requestProcessor = (RequestProcessor)iterator.next();
            if (!(requestProcessor instanceof VirtualHost)) continue;
            virtualHost = (VirtualHost)requestProcessor;
            virtualHostConfiguration = virtualHost.getVirtualHostConfig();
            string = "startup-vhosts-" + virtualHost.getName();
            if (virtualHostConfiguration != null) {
                this.addInfo(string + "-aliases", virtualHostConfiguration.getAliases());
                this.addInfo(string + "-mimeEntries", virtualHostConfiguration.getMimeEntries());
            } else {
                Tr.error((TraceComponent)tc, (String)"Null virtual host config object");
            }
            this.addInfo(string + "-name", virtualHost.getName());
            this.populateWebApps(virtualHost);
        }
    }

    protected void populateWebApps(VirtualHost virtualHost) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConfigDumpHelper populate webApp data virtualhost -> " + virtualHost.getName()));
        }
        WebGroup webGroup = null;
        WebApp webApp = null;
        Iterator iterator = null;
        WebGroupConfiguration webGroupConfiguration = null;
        WebAppConfiguration webAppConfiguration = null;
        String string = null;
        String string2 = null;
        string = virtualHost.getName();
        iterator = virtualHost.getTargetMappings();
        while (iterator.hasNext()) {
            webGroup = (WebGroup)iterator.next();
            webGroupConfiguration = (WebGroupConfiguration)webGroup.getConfiguration();
            ListIterator listIterator = webGroup.getWebApps().listIterator();
            while (listIterator.hasNext()) {
                webApp = (WebApp)listIterator.next();
                if (webApp != null) {
                    string2 = webApp.getName();
                    String string3 = "startup-vhosts-" + string + "-webapps-" + string2;
                    webAppConfiguration = (WebAppConfiguration)webApp.getConfiguration();
                    this.addInfo(string3 + "-applicationName", webApp.getApplicationName());
                    if (webAppConfiguration != null) {
                        this.addInfo(string3 + "-additionalClasspath", webAppConfiguration.getAdditionalClassPath());
                        this.addInfo(string3 + "-applicationStartupWeight", webAppConfiguration.getAppStartupWeight());
                        this.addInfo(string3 + "-autoLoadFiltersEnabled", webAppConfiguration.isAutoLoadFilters());
                        this.addInfo(string3 + "-autoRequestEncoding", webAppConfiguration.isAutoRequestEncoding());
                        this.addInfo(string3 + "-autoResponseEncoding", webAppConfiguration.isAutoResponseEncoding());
                        this.addInfo(string3 + "-codeErrorPages", webAppConfiguration.getCodeErrorPages());
                        this.addInfo(string3 + "-contextParams", webAppConfiguration.getContextParams());
                        this.addInfo(string3 + "-contextRoot", webAppConfiguration.getContextRoot());
                        this.addInfo(string3 + "-defaultErrorPage", webAppConfiguration.getDefaultErrorPage());
                        this.addInfo(string3 + "-defaultErrorPageDescription", webAppConfiguration.getDescription());
                        this.addInfo(string3 + "-directoryBrowingEnabled", webAppConfiguration.isDirectoryBrowsingEnabled());
                        this.addInfo(string3 + "-displayName", webAppConfiguration.getDisplayName());
                        this.addInfo(string3 + "-documentRoot", webApp.getDocumentRoot());
                        this.addInfo(string3 + "-exceptionErrorPages", webAppConfiguration.getExceptionErrorPages());
                        this.addInfo(string3 + "-fileServingAttributes", webAppConfiguration.getFileServingAttributes());
                        this.addInfo(string3 + "-fileServingEnabled", webAppConfiguration.isFileServingEnabled());
                        this.addInfo(string3 + "-invokerAttributes", webAppConfiguration.getInvokerAttributes());
                        this.addInfo(string3 + "-mimeMappings", webAppConfiguration.getMimeMappings());
                        this.addInfo(string3 + "-mimeFilteringEnabled", webAppConfiguration.isMimeFilteringEnabled());
                        this.addInfo(string3 + "-moduleID", webAppConfiguration.getModuleId());
                        this.addInfo(string3 + "-moduleName", webAppConfiguration.getModuleName());
                        this.addInfo(string3 + "-moduleStartupWeight", webAppConfiguration.getModuleStartupWeight());
                        this.addInfo(string3 + "-reloadingEnabled", webAppConfiguration.isReloadingEnabled());
                        this.addInfo(string3 + "-reloadInterval", webAppConfiguration.getReloadInterval());
                        this.addInfo(string3 + "-servletServingByClassnameEnabled", webAppConfiguration.isServeServletsByClassnameEnabled());
                        this.addInfo(string3 + "-syncToThreadEnabled", webAppConfiguration.isSyncToThreadEnabled());
                        this.addInfo(string3 + "-version", webAppConfiguration.getVersion());
                        this.addInfo(string3 + "-welcomeFiles", webAppConfiguration.getWelcomeFileList());
                        continue;
                    }
                    Tr.error((TraceComponent)tc, (String)"Null webApp configuration object");
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"Null webApp object");
            }
        }
    }
}

