/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.diag;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.diag.DumpHelper;
import com.ibm.ws.webcontainer.filter.FilterMapping;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws.wswebcontainer.VirtualHost;
import com.ibm.ws.wswebcontainer.WebContainer;
import com.ibm.ws.wswebcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;

public class StateDumpHelper
extends DumpHelper {
    protected static TraceComponent tc = Tr.register((Class)StateDumpHelper.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public StateDumpHelper(String string, String string2, String string3) {
        super(string, string2, string3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("StateDumpHelper.initialize localID -> " + string + " dpID -> " + string2 + " className -> " + string3));
        }
    }

    public DiagnosticEvent[] getDump() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"StateDumpHelper.getDump");
        }
        DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[1];
        this.populate();
        diagnosticEventArray[0] = DiagnosticEventFactory.createStateDump((String)this.dpID, (String)this.className, (String)"stateDump", (HashMap)this.nestedHashMap);
        return diagnosticEventArray;
    }

    protected void populate() {
        Object object;
        Object object2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"StateDumpHelper populate web container data");
        }
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object object3 = WebContainer.getCachedServletWrapperNames();
        while (object3.hasNext()) {
            object2 = WebContainer.getFromCache(new StringBuffer((String)object3.next()));
            if (object2 != null) {
                ++n;
                string3 = ((CacheServletWrapper)object2).getCacheKeyString();
                this.populateCachedServlet((CacheServletWrapper)object2, "cachedServlets-" + string3);
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"Null cachedServlet object");
        }
        this.addInfo("cachedServlets-numberCachedServlets", n);
        object3 = WebContainer.getExtensionFactories();
        object2 = object3.listIterator();
        while (object2.hasNext()) {
            object = (ExtensionFactory)object2.next();
            this.addInfo("extensionFactory-classname-" + object.getClass().getName() + "-globalPatternList", object.getPatternList());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"StateDumpHelper populate virtual host data");
        }
        object2 = webcontainer.getVirtualHosts();
        while (object2.hasNext()) {
            object = (RequestProcessor)object2.next();
            if (!(object instanceof VirtualHost)) continue;
            VirtualHost virtualHost = (VirtualHost)object;
            string = virtualHost.getName();
            Iterator iterator = virtualHost.getTargetMappings();
            while (iterator.hasNext()) {
                WebGroup webGroup = (WebGroup)iterator.next();
                ListIterator listIterator = webGroup.getWebApps().listIterator();
                while (listIterator.hasNext()) {
                    WebApp webApp = (WebApp)listIterator.next();
                    string2 = webApp.getName();
                    String string4 = "vhosts-" + string + "-webapps-" + string2;
                    this.populateWebapp(webApp, string4);
                }
            }
        }
    }

    protected void populateCachedServlet(CacheServletWrapper cacheServletWrapper, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("StateDumpHelper populate cached servlet data cachedServlet -> " + cacheServletWrapper.getCacheKeyString()));
        }
        this.addInfo(string + "-pathInfo", cacheServletWrapper.getPathInfo());
        this.addInfo(string + "-requestURI", cacheServletWrapper.getRequestUri());
        this.addInfo(string + "-servletPath", cacheServletWrapper.getServletPath());
        this.addInfo(string + "-contextPath", cacheServletWrapper.getWebApp().getContextPath());
    }

    protected void populateWebapp(WebApp webApp, String string) {
        Object object;
        Object object2;
        Object object3;
        WebAppConfiguration webAppConfiguration;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("StateDumpHelper populate webApp data webApp -> " + webApp.getName()));
        }
        if ((webAppConfiguration = (WebAppConfiguration)webApp.getConfiguration()) != null) {
            this.addInfo(string + "-listeners" + "-requestAttributeListeners", webAppConfiguration.getRequestAttributeListeners());
            this.addInfo(string + "-listeners" + "-requestListeners", webAppConfiguration.getRequestListeners());
            this.addInfo(string + "-listeners" + "-sessionListeners", webAppConfiguration.getSessionListeners());
            object3 = webApp.getServletContextEventSource();
            if (object3 instanceof WebAppEventSource) {
                object2 = (WebAppEventSource)object3;
                this.addInfo(string + "-listeners" + "-applicationListeners", ((WebAppEventSource)object2).getApplicationListeners());
                this.addInfo(string + "-listeners" + "-filterListeners", ((WebAppEventSource)object2).getFilterListeners());
                this.addInfo(string + "-listeners" + "-filterErrorListeners", ((WebAppEventSource)object2).getFilterErrorListeners());
                this.addInfo(string + "-listeners" + "-filterInvocationListeners", ((WebAppEventSource)object2).getFilterInvocationListeners());
                this.addInfo(string + "-listeners" + "-servletListeners", ((WebAppEventSource)object2).getServletListeners());
                this.addInfo(string + "-listeners" + "-servletInvocationListeners", ((WebAppEventSource)object2).getInvocationListeners());
            }
            this.addInfo(string + "-listeners" + "-servletContextListeners", webApp.getServletContextListeners());
            this.addInfo(string + "-listeners" + "-servletContextAttributeListeners", webApp.getServletContextAttrListeners());
            this.addInfo(string + "-listeners" + "-servletRequestListeners", webApp.getServletRequestListeners());
            this.addInfo(string + "-listeners" + "-servletRequestAttributeListeners", webApp.getServletRequestAttrListeners());
            object2 = webAppConfiguration.getFilterMappings().listIterator();
            while (object2.hasNext()) {
                object = (FilterMapping)object2.next();
                this.populateFilterMapping((FilterMapping)object, string + "-filters-" + ((FilterMapping)object).getFilterConfig().getFilterName());
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"Null webApp config object");
        }
        object3 = webApp.getTargetMappings();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (object2 instanceof ExtensionProcessor) {
                object = (ExtensionProcessor)object2;
                object.getPatternList();
                this.addInfo(string + "-extensionProcessor-classname-" + object.getClass().getName() + "-additionalPatternList", object.getPatternList());
                continue;
            }
            if (!(object2 instanceof IServletWrapper)) continue;
            object = (IServletWrapper)object2;
            IServletConfig iServletConfig = (IServletConfig)object.getServletConfig();
            if (object.getServletName().equals("Static File wrapper")) continue;
            if (iServletConfig != null) {
                this.populateServlet((IServletWrapper)object, iServletConfig, string + "-servlets-" + iServletConfig.getServletName());
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"Null servlet config object");
        }
    }

    protected void populateFilterMapping(FilterMapping filterMapping, String string) {
        IFilterConfig iFilterConfig;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("StateDumpHelper populate filter mapping data data filterMapping -> " + filterMapping.getFilterConfig().getFilterName()));
        }
        if ((iFilterConfig = filterMapping.getFilterConfig()) != null) {
            this.addInfo(string + "-filterClassName", iFilterConfig.getFilterClassName());
        } else {
            Tr.error((TraceComponent)tc, (String)"Null filter config object");
        }
        this.addInfo(string + "-filterMapping-" + filterMapping.hashCode() + "-dispatchMode", this.getDispatchModesAsString(filterMapping.getDispatchMode()));
        this.addInfo(string + "-filterMapping-" + filterMapping.hashCode() + "-urlPattern", filterMapping.getUrlPattern());
        IServletConfig iServletConfig = filterMapping.getServletConfig();
        if (iServletConfig != null) {
            this.addInfo(string + "-filterMapping-" + filterMapping.hashCode() + "-servletName", iServletConfig.getServletName());
        } else {
            this.addInfo(string + "-filterMapping-" + filterMapping.hashCode() + "-servletName", (String)null);
        }
    }

    protected void populateServlet(IServletWrapper iServletWrapper, IServletConfig iServletConfig, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("StateDumpHelper populate servlet data servletConfig -> " + iServletConfig.getServletName()));
        }
        this.addInfo(string + "-cachingEnabled", iServletConfig.isCachingEnabled());
        this.addInfo(string + "-servletClassName", iServletConfig.getClassName());
        this.addInfo(string + "-initParams", this.getInitParamsAsString(iServletConfig));
        this.addInfo(string + "-loadOnStartup", iServletConfig.isLoadOnStartup());
        this.addInfo(string + "-servletMappings", iServletConfig.getMappings());
        this.addInfo(string + "-fileName", iServletConfig.getFileName());
        this.addInfo(string + "-lastAccessTime", new Date(iServletWrapper.getLastAccessTime()));
        this.addInfo(string + "-classloader", iServletWrapper.getTargetClassLoader());
    }

    protected String getDispatchModesAsString(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(IFilterConfig.DISPATCH_MODES[nArray[i]] + " ");
        }
        return stringBuffer.toString().trim();
    }

    private String getInitParamsAsString(IServletConfig iServletConfig) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = iServletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = iServletConfig.getInitParameter(string);
            stringBuffer.append(string + "=" + string2);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(';');
        }
        return stringBuffer.toString().trim();
    }
}

