/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.event.FilterErrorEvent;
import com.ibm.websphere.servlet.event.FilterEvent;
import com.ibm.websphere.servlet.event.FilterInvocationEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import java.text.MessageFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterInstanceWrapper {
    public static final int FILTER_STATE_UNINITIALIZED = 0;
    public static final int FILTER_STATE_INITIALIZING = 1;
    public static final int FILTER_STATE_AVAILABLE = 2;
    public static final int FILTER_STATE_DESTROYING = 3;
    public static final int FILTER_STATE_DESTROYED = 4;
    public static final int FILTER_STATE_UNAVAILABLE = 5;
    private String _filterName;
    private Filter _filterInstance;
    private int _filterState = 0;
    private volatile int nServicing = 0;
    private static TraceComponent tc = Tr.register((Class)FilterInstanceWrapper.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private FilterEvent _filterEvent;
    private IFilterConfig _filterConfig;
    private WebAppEventSource _eventSource;

    public FilterInstanceWrapper(String string, Filter filter, WebAppEventSource webAppEventSource) {
        this._filterName = string;
        this._filterInstance = filter;
        this._eventSource = webAppEventSource;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public Filter getFilterInstance() {
        return this._filterInstance;
    }

    public int getFilterState() {
        return this._filterState;
    }

    public void init(IFilterConfig iFilterConfig) throws ServletException {
        try {
            this._filterState = 1;
            this._filterConfig = iFilterConfig;
            if (this._eventSource != null && this._eventSource.hasFilterListeners()) {
                this._eventSource.onFilterStartInit(this.getFilterEvent());
                this._filterInstance.init((FilterConfig)iFilterConfig);
                this._eventSource.onFilterFinishInit(this.getFilterEvent());
            } else {
                this._filterInstance.init((FilterConfig)iFilterConfig);
            }
            this._filterState = 2;
        }
        catch (Throwable throwable) {
            if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                FilterErrorEvent filterErrorEvent = this.getFilterErrorEvent(throwable);
                this._eventSource.onFilterInitError(filterErrorEvent);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.init", (String)"111", (Object)this);
            this._filterState = 5;
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be initialized", this._filterName), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException {
        try {
            FilterInstanceWrapper filterInstanceWrapper;
            if (this._filterState != 2) {
                throw new ServletException(MessageFormat.format("Filter [{0}]: filter is unavailable.", this._filterName));
            }
            Object object = this;
            synchronized (object) {
                ++this.nServicing;
            }
            try {
                try {
                    if (this._eventSource != null && this._eventSource.hasFilterInvocationListeners()) {
                        object = this.getFilterInvocationEvent(servletRequest);
                        this._eventSource.onFilterStartDoFilter((FilterInvocationEvent)object);
                        this._filterInstance.doFilter(servletRequest, servletResponse, filterChain);
                        this._eventSource.onFilterFinishDoFilter((FilterInvocationEvent)object);
                    }
                    this._filterInstance.doFilter(servletRequest, servletResponse, filterChain);
                }
                catch (ServletException servletException) {
                    throw servletException;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                Object var7_9 = null;
                filterInstanceWrapper = this;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                FilterInstanceWrapper filterInstanceWrapper2 = this;
                synchronized (filterInstanceWrapper2) {
                    --this.nServicing;
                    throw throwable;
                }
            }
            synchronized (filterInstanceWrapper) {
                --this.nServicing;
                return;
            }
        }
        catch (ServletException servletException) {
            if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                FilterErrorEvent filterErrorEvent = this.getFilterErrorEvent(servletException);
                this._eventSource.onFilterDoFilterError(filterErrorEvent);
            }
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.doFilter", (String)"144", (Object)this);
            throw servletException;
        }
        catch (Throwable throwable) {
            if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                FilterErrorEvent filterErrorEvent = this.getFilterErrorEvent(throwable);
                this._eventSource.onFilterDoFilterError(filterErrorEvent);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.doFilter", (String)"149", (Object)this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: filter is unavailable.", this._filterName), throwable);
        }
    }

    public void destroy() throws ServletException {
        try {
            this._filterState = 3;
            for (int i = 0; this.nServicing > 0 && i < 60; ++i) {
                try {
                    if (i == 0) {
                        Tr.audit((TraceComponent)tc, (String)"waiting.to.destroy.filter.[{0}]", (Object)this._filterName);
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", (String)"377", (Object)this);
                }
            }
            if (this._eventSource != null && this._eventSource.hasFilterListeners()) {
                this._eventSource.onFilterStartDestroy(this.getFilterEvent());
                this._filterInstance.destroy();
                this._eventSource.onFilterFinishDestroy(this.getFilterEvent());
            } else {
                this._filterInstance.destroy();
            }
            this._filterState = 4;
        }
        catch (Throwable throwable) {
            if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                FilterErrorEvent filterErrorEvent = this.getFilterErrorEvent(throwable);
                this._eventSource.onFilterDestroyError(filterErrorEvent);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.destroy", (String)"173", (Object)this);
            this._filterState = 5;
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be destroyed", this._filterName), throwable);
        }
    }

    private FilterEvent getFilterEvent() {
        if (this._filterEvent != null) {
            return this._filterEvent;
        }
        this._filterEvent = new FilterEvent(this, this._filterConfig);
        return this._filterEvent;
    }

    private FilterInvocationEvent getFilterInvocationEvent(ServletRequest servletRequest) {
        return new FilterInvocationEvent(this, this._filterConfig, servletRequest);
    }

    private FilterErrorEvent getFilterErrorEvent(Throwable throwable) {
        return new FilterErrorEvent(this, this._filterConfig, throwable);
    }
}

