/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaDataImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.httpsession.DBPortability;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionData;
import com.ibm.ws.webcontainer.httpsession.HttpSessionSystemProperties;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import com.ibm.ws.webcontainer.httpsession.SessionSimpleLRUHashMap;
import com.ibm.ws.webcontainer.util.SimpleHashtable;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class BackedHashtable
extends SessionSimpleLRUHashMap {
    static final String varList = "id, propid, appname, listenercnt, lastaccess, creationtime, maxinactivetime, username, small, medium, large";
    static final String TABLE_NAME = "sessions";
    String tableName = "sessions";
    String dburl;
    String dbid;
    String dbpwd;
    String delPropall;
    boolean initialized = false;
    boolean tryingToInitialize = false;
    boolean firstInitialize = true;
    Hashtable asyncUps;
    static final String idCol = "id";
    static final String propCol = "propid";
    static final String appCol = "appname";
    static final String listenCol = "listenercnt";
    static final String lastAccCol = "lastaccess";
    static final String userCol = "username";
    static final String maxInactCol = "maxinactivetime";
    static final String comma = " , ";
    static final String equals = " = ? ";
    static final String smallCol = "small";
    static final String medCol = "medium";
    static final String lgCol = "large";
    static final String upId = " where id = ? and propid = ? and appname = ? ";
    static final String setSmallNull = "small = NULL";
    static final String setMediumNull = "medium = NULL";
    static final String setLargeNull = "large = NULL";
    private final String THREE_ZEROS = "000";
    private final String TWO_ZEROS = "00";
    private final String ONE_ZERO = "0";
    String insNoProp;
    String insSm;
    String insMed;
    String insLg;
    String getOneNoUpdate;
    String getOneNoUpdateNonDB2;
    String upBase;
    String asyncUpdate;
    String getProp;
    String getPropNotDB2;
    String delProp;
    String insSmProp;
    String insMedProp;
    String insLgProp;
    String selMed;
    String selLg;
    String dropIt;
    String readLastAccess;
    String selectForUpdate;
    String insForInval;
    String delPrimaryRowInval;
    String findAllKeys;
    String readPrimitiveData;
    String readPrimitiveDataDb2;
    String delOne;
    String selDelNoListener;
    String selNukerString;
    String optUpdate;
    String optUpdatePrimRow;
    String remoteInvalAll;
    SessionContextParameters bhSessionContextParams = null;
    DatabaseSessionContext bhSessionContext = null;
    javax.sql.DataSource dataSource;
    String as400_collection = null;
    String collectionName = null;
    boolean usingAS400DB2 = false;
    boolean usingSybase = false;
    boolean usingDB2 = false;
    boolean usingDB2Connect = false;
    int dbConnectVersion = 5;
    boolean usingSQLServer = false;
    boolean usingInformix = false;
    boolean usingCloudScape = false;
    boolean usingDB2zOS = false;
    private boolean errorAccessDataSource = false;
    private SimpleHashtable suspendedTransactions = null;
    static TraceComponent tc = SessionContext.tc;
    private static final long serialVersionUID = -4653089886686024589L;
    private static final ComponentMetaDataAccessorImpl cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    Map recentInvalidIds = null;
    static boolean checkRecentlyInvalidList = true;

    public BackedHashtable(DatabaseSessionContext databaseSessionContext, SessionContextParameters sessionContextParameters) {
        super(databaseSessionContext.tableSize);
        this.bhSessionContext = databaseSessionContext;
        this.bhSessionContextParams = sessionContextParameters;
        this.suspendedTransactions = new SimpleHashtable();
        this.asyncUps = new Hashtable(this.bhSessionContext.tableSize);
        this.getDataSource();
        this.initConnPool(sessionContextParameters);
        this.setRecentInvalTable();
    }

    void setUserInfo(SessionContextParameters sessionContextParameters) {
        if (this.dburl == null) {
            if (sessionContextParameters.sessionDBID != null && sessionContextParameters.sessionDBID.indexOf("::") != -1) {
                try {
                    this.dbid = sessionContextParameters.sessionDBID.substring(0, sessionContextParameters.sessionDBID.indexOf("::"));
                    this.collectionName = sessionContextParameters.sessionDBID.substring(sessionContextParameters.sessionDBID.indexOf("::") + 2);
                    if (this.collectionName.indexOf("$V") > 0) {
                        this.collectionName = this.collectionName.substring(0, this.collectionName.indexOf("$V"));
                        String string = sessionContextParameters.sessionDBID.substring(sessionContextParameters.sessionDBID.indexOf("$V") + 2);
                        this.dbConnectVersion = (int)new Double(string).doubleValue();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.setUserInfo", (String)"183", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
                }
            } else {
                this.dbid = sessionContextParameters.sessionDBID;
            }
            this.dbpwd = sessionContextParameters.sessionDBPWD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initConnPool(SessionContextParameters sessionContextParameters) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.initConnPool.");
        }
        BackedHashtable backedHashtable = this;
        synchronized (backedHashtable) {
            Connection connection = null;
            String string = null;
            try {
                int n;
                this.setUserInfo(sessionContextParameters);
                connection = this.getConnection(true);
                if (connection == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"BackedHashtable.initConnPool. Connection is null.");
                    }
                    return;
                }
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (tc.isDebugEnabled()) {
                    String string2 = databaseMetaData.getDatabaseProductName();
                    String string3 = databaseMetaData.getDatabaseProductVersion();
                    Tr.debug((TraceComponent)tc, (String)("dbProductName: " + string2));
                    Tr.debug((TraceComponent)tc, (String)("dbProductVersion: " + string3));
                }
                if ((n = DBPortability.getDBCode(databaseMetaData)) == DBPortability.ORACLE) {
                    this.bhSessionContext.smallColSize = 2000;
                    this.bhSessionContext.mediumColSize = 0x200000;
                    this.bhSessionContext.largeColSize = 1;
                    this.bhSessionContext.usingOracle = true;
                } else if (n == DBPortability.SYBASE) {
                    this.bhSessionContext.smallColSize = 0xA00000;
                    this.bhSessionContext.mediumColSize = 1;
                    this.bhSessionContext.largeColSize = 1;
                    this.usingSybase = true;
                } else if (n == DBPortability.MICROSOFT_SQLSERVER) {
                    this.bhSessionContext.smallColSize = 0xA00000;
                    this.bhSessionContext.mediumColSize = 1;
                    this.bhSessionContext.largeColSize = 1;
                    this.usingSQLServer = true;
                } else if (n == DBPortability.INFORMIX) {
                    this.bhSessionContext.smallColSize = 0xA00000;
                    this.bhSessionContext.mediumColSize = 1;
                    this.bhSessionContext.largeColSize = 1;
                    this.usingInformix = true;
                } else if (n == DBPortability.CLOUDSCAPE) {
                    this.bhSessionContext.smallColSize = 0xA00000;
                    this.bhSessionContext.mediumColSize = 1;
                    this.bhSessionContext.largeColSize = 1;
                    this.usingCloudScape = true;
                } else {
                    if (this.bhSessionContext.rowsizeK == 4) {
                        this.bhSessionContext.smallColSize = 3122;
                    } else if (this.bhSessionContext.rowsizeK == 8) {
                        this.bhSessionContext.smallColSize = 7218;
                    } else if (this.bhSessionContext.rowsizeK == 16) {
                        this.bhSessionContext.smallColSize = 15410;
                    } else if (this.bhSessionContext.rowsizeK == 32) {
                        this.bhSessionContext.smallColSize = 31794;
                    }
                    this.bhSessionContext.mediumColSize = 32700;
                    this.bhSessionContext.largeColSize = 0x200000;
                    this.usingDB2 = true;
                    if (n == DBPortability.DB2_CONNECT) {
                        this.bhSessionContext.smallColSize = 3122;
                        this.usingDB2Connect = true;
                    } else if (n == DBPortability.DB2_zOS) {
                        this.bhSessionContext.smallColSize = 3122;
                        this.bhSessionContext.mediumColSize = 28869;
                        this.usingDB2Connect = true;
                        this.usingDB2zOS = true;
                    } else if (n == DBPortability.DB2_AS400) {
                        this.bhSessionContext.smallColSize = 3122;
                        this.bhSessionContext.mediumColSize = 28898;
                        this.usingAS400DB2 = true;
                        string = databaseMetaData.getURL();
                    }
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.initConnPool", (String)"263", (Object)this);
                Tr.error((TraceComponent)tc, (String)"BackedHashtable.createTableError");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sQLException);
            }
            finally {
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            if (this.usingAS400DB2 && this.firstInitialize) {
                if (this.collectionName == null) {
                    this.collectionName = this.getCollectionName(string);
                }
                this.tableName = this.collectionName + "." + this.tableName;
                this.firstInitialize = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"AS400DB2 Table Name value = ", (Object)this.tableName);
                }
            } else if (this.usingDB2zOS) {
                this.tableName = this.bhSessionContextParams.getTableNameValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"DB2 Table Name value = ", (Object)this.tableName);
                }
            } else if (this.usingDB2Connect && this.firstInitialize) {
                this.tableName = this.collectionName + "." + this.tableName;
                this.firstInitialize = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"DB2Connect Table Name value = ", (Object)this.tableName);
                }
            }
            this.initializeSQL_Strings();
            if (!DatabaseSessionContext.is_zOS) {
                this.createTable(sessionContextParameters);
            }
        }
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BackedHashtable.initConnPool.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getTableDefinition(Connection connection) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.usingInformix) {
            return false;
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = this.tableName;
        String string2 = null;
        if (this.usingAS400DB2 || this.usingDB2Connect) {
            string = TABLE_NAME.toUpperCase();
            if (this.collectionName != null) {
                string2 = this.collectionName;
            }
        } else if (this.usingDB2 || this.bhSessionContext.usingOracle) {
            string = string.toUpperCase();
            if (this.dbid != null) {
                string2 = this.dbid.toUpperCase();
            }
        }
        ResultSet resultSet = databaseMetaData.getColumns(null, string2, string, "%");
        try {
            while (resultSet.next()) {
                String string3 = resultSet.getString("COLUMN_NAME");
                int n = resultSet.getInt("COLUMN_SIZE");
                if (string3.equalsIgnoreCase("SMALL")) {
                    this.bhSessionContext.smallColSize = n;
                    bl2 = true;
                }
                if (string3.equalsIgnoreCase("MEDIUM")) {
                    if (!this.bhSessionContext.usingOracle) {
                        this.bhSessionContext.mediumColSize = n;
                    }
                    bl3 = true;
                }
                if (string3.equalsIgnoreCase("LARGE")) {
                    this.bhSessionContext.largeColSize = n;
                    bl4 = true;
                }
                bl = true;
            }
            if (bl) {
                if (bl2 && bl3 && bl4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Table exists with all the required columns");
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"Table exists, but with wrong definition, please drop the table manually");
                }
            }
        }
        finally {
            BackedHashtable.closeResultSet(resultSet);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTable(SessionContextParameters sessionContextParameters) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.createTable");
        }
        Connection connection = null;
        Statement statement = null;
        connection = this.getConnection(true);
        if (connection == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"BackedHashtable.createTable. Connection is null");
            }
            return;
        }
        try {
            block46: {
                try {
                    statement = connection.createStatement();
                    if (this.getTableDefinition(connection)) break block46;
                    if (this.bhSessionContext.usingOracle) {
                        if (DatabaseSessionContext.useOracleBLOB) {
                            statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess integer, creationtime integer, maxinactivetime integer, username varchar(256), small raw(" + 2000 + "), medium BLOB, large raw(1))");
                        } else {
                            statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess integer, creationtime integer, maxinactivetime integer, username varchar(256), small raw(" + 2000 + "), medium long raw, large raw(1))");
                        }
                        break block46;
                    }
                    if (this.usingAS400DB2) {
                        try {
                            statement.executeUpdate("CREATE COLLECTION " + this.collectionName);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.createTable", (String)"366", (Object)connection);
                        }
                        statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(256), small varchar(" + 3122 + ") for bit data, medium long varchar for bit data, large BLOB(2M))");
                        break block46;
                    }
                    if (this.usingSybase) {
                        statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint null, lastaccess numeric(21,0) null, creationtime numeric(21,0) null, maxinactivetime numeric(10,0) null, username varchar(255) null, small image null, medium image null, large image null)");
                    } else if (this.usingSQLServer) {
                        statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint null, lastaccess decimal(21,0) null, creationtime decimal(21,0) null, maxinactivetime integer null, username varchar(255) null, small image null, medium image null, large image null)");
                    } else if (this.usingInformix) {
                        statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess int8, creationtime int8, maxinactivetime integer, username varchar(255), small BYTE, medium BYTE, large BYTE)");
                    } else if (this.usingCloudScape) {
                        statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(255), small LONG VARBINARY , medium char(1) , large char(1))");
                    } else if (!this.usingDB2Connect && !this.usingDB2zOS) {
                        String string = " ";
                        if (this.bhSessionContext.tableSpaceName != null && !this.bhSessionContext.tableSpaceName.equals("") && this.bhSessionContext.tableSpaceName.length() != 0) {
                            string = " in " + this.bhSessionContext.tableSpaceName;
                        }
                        statement.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(256), small varchar(" + this.bhSessionContext.smallColSize + ") for bit data, medium long varchar for bit data, large BLOB(2M)) " + string);
                    }
                }
                catch (TableAlreadyExistsException tableAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)tableAlreadyExistsException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.createTable", (String)"387", (Object)this);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.createTable", (String)"407", (Object)this);
                    if (!this.usingCloudScape) {
                        Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sQLException);
                    }
                    if (sQLException.getErrorCode() == 30000) break block46;
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sQLException);
                }
            }
            try {
                if (statement == null) {
                    statement = connection.createStatement();
                }
                if (this.usingSybase) {
                    statement.executeUpdate("create unique index sess_index on sessions (id, propid, appname)");
                    statement.executeUpdate("alter table sessions lock datarows");
                } else if (this.usingAS400DB2) {
                    this.bhSessionContext.mediumColSize -= 2;
                    if (!this.doesIndexExists(connection, "sess_index")) {
                        statement.executeUpdate("create unique index " + this.collectionName + ".sess_index on " + this.collectionName + ".sessions (id,propid,appname)");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Skip index creation");
                    }
                } else if (!this.usingDB2Connect && !this.usingDB2zOS) {
                    if (!this.doesIndexExists(connection, "sess_index")) {
                        statement.executeUpdate("create unique index sess_index on " + this.tableName + " (id, propid, appname)");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Skip index creation");
                    }
                    if (this.usingDB2 && !this.isTableMarkedVolatile(connection)) {
                        statement.executeUpdate("alter table " + this.tableName + " volatile");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Skip marking table volatile");
                    }
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.createTable", (String)"407", (Object)connection);
            }
        }
        finally {
            if (statement != null) {
                BackedHashtable.closeStatement(statement);
            }
            if (connection != null) {
                this.closeConnection(connection);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BackedHashtable.createTable");
        }
    }

    javax.sql.DataSource getDataSource() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtablegetDataSource");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
            InitialContext initialContext = new InitialContext(properties);
            this.beginDBContext();
            this.dataSource = (javax.sql.DataSource)initialContext.lookup(this.bhSessionContextParams.getJNDIDataSourceName());
            this.endDBContext();
            return this.dataSource;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.getDataSource", (String)"448", (Object)this);
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.dataSrcErr");
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
            this.dataSource = null;
            this.errorAccessDataSource = true;
            return null;
        }
    }

    public synchronized Object remove(Object object) {
        Object object2 = this.superGet(object);
        if (object2 != null) {
            this.superRemove(object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSessions(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.removeSessions");
        }
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        String string = databaseSessionData.getId();
        if (!databaseSessionData.isValid()) {
            return;
        }
        Connection connection = this.getConnection(false);
        if (connection == null) {
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BackedHashtable:removeSession - before upd " + string));
            }
            preparedStatement = connection.prepareStatement(this.delOne);
            preparedStatement.setString(2, databaseSessionData.appName);
            preparedStatement.setString(1, databaseSessionData.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BackedHashtable:removeSession - after upd " + string));
            }
            this.addToRecentlyInvalidatedList(databaseSessionData.getId());
        }
        catch (StaleConnectionException staleConnectionException) {
            FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.removeSessions", (String)"529", (Object)databaseSessionData);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.removeSessions", (String)"532", (Object)databaseSessionData);
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.removeSessionsError");
            Tr.error((TraceComponent)tc, (String)"SessionContext.object", (Object)databaseSessionData.toString());
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sQLException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.removeSessions", (String)"538", (Object)databaseSessionData);
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.removeSessionsError");
            Tr.error((TraceComponent)tc, (String)"SessionContext.object", (Object)databaseSessionData.toString());
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
        }
        finally {
            if (!bl && preparedStatement != null) {
                BackedHashtable.closeStatement(preparedStatement);
            }
            this.closeConnection(connection);
        }
        if (databaseSessionData.appDataChanges != null) {
            databaseSessionData.appDataChanges.clear();
        }
        if (databaseSessionData.appDataRemovals != null) {
            databaseSessionData.appDataRemovals.clear();
        }
        databaseSessionData.syncFromServlet = false;
        databaseSessionData.update = null;
        databaseSessionData.userWriteHit = false;
        databaseSessionData.maxInactWriteHit = false;
        databaseSessionData.listenCntHit = false;
        databaseSessionData.cached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doInvalidations(Connection connection) throws StaleConnectionException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        PreparedStatement preparedStatement2;
        Statement statement;
        block36: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"BackedHashtable.doInvalidations");
            }
            String string = null;
            long l = 0L;
            long l2 = 0L;
            ResultSet resultSet2 = null;
            PreparedStatement preparedStatement3 = null;
            statement = null;
            preparedStatement2 = null;
            preparedStatement = null;
            resultSet = null;
            boolean bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
            try {
                try {
                    int n = 0;
                    long l3 = System.currentTimeMillis();
                    String string2 = this.bhSessionContext.getAppName();
                    String string3 = this.selDelNoListener;
                    if (this.usingDB2) {
                        string3 = string3 + " for read only";
                        n = connection.getTransactionIsolation();
                        connection.setTransactionIsolation(1);
                    }
                    preparedStatement3 = connection.prepareStatement(string3);
                    preparedStatement3.setString(1, string2);
                    this.setPSLong(preparedStatement3, 2, l3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BackedHashtable:doInvalidations - executing read/uncom scan");
                    }
                    resultSet2 = preparedStatement3.executeQuery();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BackedHashtable:doInvalidations - after uncom query ");
                    }
                    Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
                    Hashtable<String, Long> hashtable2 = new Hashtable<String, Long>();
                    while (resultSet2.next()) {
                        string = resultSet2.getString(1);
                        l = resultSet2.getLong(2);
                        l2 = resultSet2.getLong(3);
                        hashtable.put(string, new Long(l));
                        hashtable2.put(string, new Long(l2));
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - executing read/uncom scan, recording " + string));
                        }
                        if (l3 + this.bhSessionContext.mInvalidationCheckPollInterval * 1000L > System.currentTimeMillis()) continue;
                    }
                    resultSet2.close();
                    preparedStatement3.close();
                    bl4 = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BackedHashtable:doInvalidations - before read of ucom scan results ");
                    }
                    Enumeration enumeration = hashtable.keys();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BackedHashtable:doInvalidations - after read of ucom scan results, befor commit ");
                    }
                    if (this.usingDB2) {
                        connection.setTransactionIsolation(n);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - delete primary row vector " + hashtable));
                        if (hashtable != null) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations -  with size reported " + hashtable.size()));
                        }
                    }
                    enumeration = hashtable.keys();
                    int n2 = 0;
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - current index into delete primary row vector " + string));
                        }
                        l3 = System.currentTimeMillis();
                        long l4 = (Long)hashtable.get(string);
                        preparedStatement2 = connection.prepareStatement(this.delPrimaryRowInval);
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setString(2, string2);
                        this.setPSLong(preparedStatement2, 3, l4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - delete for " + string));
                        }
                        int n3 = preparedStatement2.executeUpdate();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - after del of  " + string));
                        }
                        preparedStatement2.close();
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - num of rows deleted " + n3));
                        }
                        if (n3 > 0 && this.bhSessionContext.usingMultirow) {
                            preparedStatement = connection.prepareStatement(this.delPropall);
                            preparedStatement.setString(1, string);
                            preparedStatement.setString(2, string2);
                            int n4 = preparedStatement.executeUpdate();
                            preparedStatement.close();
                            bl2 = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("BackedHashtable:doInvalidations - for session: " + string + " appName: " + string2 + "returned Code: " + n4));
                            }
                        }
                        this.superRemove(string);
                        l2 = (Long)hashtable2.get(string);
                        this.bhSessionContext.scPmiData.incInvalidatedSessions(l2);
                        this.bhSessionContext.scPmiData.incInvalidatedByTimeout();
                        ++n2;
                    }
                    Object var31_29 = null;
                    if (bl4 || preparedStatement3 == null) break block36;
                }
                catch (StaleConnectionException staleConnectionException) {
                    FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.doInvalidations", (String)"780", (Object)this);
                    if (!tc.isDebugEnabled()) throw staleConnectionException;
                    Tr.debug((TraceComponent)tc, (String)"BackedHashtable.StaleConnectionException");
                    throw staleConnectionException;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.doInvalidations", (String)"785", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"BackedHashtable.doInvalidationsError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.sessionid", string);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sQLException);
                    Object var31_30 = null;
                    if (!bl4 && preparedStatement3 != null) {
                        BackedHashtable.closeResultSet(resultSet2);
                        BackedHashtable.closeStatement(preparedStatement3);
                    }
                    if (!bl3 && statement != null) {
                        BackedHashtable.closeResultSet(resultSet);
                        BackedHashtable.closeStatement(statement);
                    }
                    if (!bl && preparedStatement2 != null) {
                        BackedHashtable.closeStatement(preparedStatement2);
                    }
                    if (bl2) return;
                    if (preparedStatement == null) return;
                    BackedHashtable.closeStatement(preparedStatement);
                    return;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.doInvalidations", (String)"790", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"BackedHashtable.doInvalidationsError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
                    Object var31_31 = null;
                    if (!bl4 && preparedStatement3 != null) {
                        BackedHashtable.closeResultSet(resultSet2);
                        BackedHashtable.closeStatement(preparedStatement3);
                    }
                    if (!bl3 && statement != null) {
                        BackedHashtable.closeResultSet(resultSet);
                        BackedHashtable.closeStatement(statement);
                    }
                    if (!bl && preparedStatement2 != null) {
                        BackedHashtable.closeStatement(preparedStatement2);
                    }
                    if (bl2) return;
                    if (preparedStatement == null) return;
                    BackedHashtable.closeStatement(preparedStatement);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var31_32 = null;
                if (!bl4 && preparedStatement3 != null) {
                    BackedHashtable.closeResultSet(resultSet2);
                    BackedHashtable.closeStatement(preparedStatement3);
                }
                if (!bl3 && statement != null) {
                    BackedHashtable.closeResultSet(resultSet);
                    BackedHashtable.closeStatement(statement);
                }
                if (!bl && preparedStatement2 != null) {
                    BackedHashtable.closeStatement(preparedStatement2);
                }
                if (bl2) throw throwable;
                if (preparedStatement == null) throw throwable;
                BackedHashtable.closeStatement(preparedStatement);
                throw throwable;
            }
            BackedHashtable.closeResultSet(resultSet2);
            BackedHashtable.closeStatement(preparedStatement3);
        }
        if (!bl3 && statement != null) {
            BackedHashtable.closeResultSet(resultSet);
            BackedHashtable.closeStatement(statement);
        }
        if (!bl && preparedStatement2 != null) {
            BackedHashtable.closeStatement(preparedStatement2);
        }
        if (bl2) return;
        if (preparedStatement == null) return;
        BackedHashtable.closeStatement(preparedStatement);
    }

    /*
     * Exception decompiling
     */
    Enumeration pollForInvalids(Connection var1_1) throws StaleConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void closeResultSet(ResultSet resultSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("BackedHashtable:closeResultSet - closing " + resultSet));
        }
        try {
            resultSet.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.closeResultSet", (String)"955");
        }
    }

    static void closeStatement(Statement statement) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("BackedHashtable:closeStatement - closing " + statement));
        }
        try {
            statement.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.closeStatement", (String)"969");
        }
    }

    void closeConnection(Connection connection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("BackedHashtable:closeConnection - closing " + connection));
        }
        try {
            connection.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.closeConnection", (String)"994", (Object)connection);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        this.endDBContext();
        this.resumeTransaction();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("BackedHashtable:closeConnection - closed " + connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.getConnection");
        }
        Connection connection = null;
        boolean bl2 = false;
        if (this.dataSource == null) {
            this.getDataSource();
        }
        if (this.dataSource != null) {
            int n = 0;
            this.suspendTransaction();
            this.beginDBContext();
            while (n < 3) {
                try {
                    ++n;
                    bl2 = false;
                    connection = !DatabaseSessionContext.is_zOS ? this.dataSource.getConnection(this.dbid, this.dbpwd) : this.dataSource.getConnection();
                    connection.setAutoCommit(true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Connection-isolation-level" + connection.getTransactionIsolation()));
                    }
                    if (!(this.initialized || bl || this.tryingToInitialize)) {
                        BackedHashtable backedHashtable = this;
                        synchronized (backedHashtable) {
                            this.tryingToInitialize = true;
                            if (!this.initialized) {
                                this.initConnPool(this.bhSessionContextParams);
                            }
                            this.tryingToInitialize = false;
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"BackedHashtable.getConnection");
                    }
                    return connection;
                }
                catch (StaleConnectionException staleConnectionException) {
                    bl2 = true;
                    FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.getConnection", (String)"1032", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"BackedHashtable.StaleConnectionException");
                }
                catch (Throwable throwable) {
                    bl2 = true;
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                    break;
                }
            }
        } else if (this.errorAccessDataSource) {
            Tr.warning((TraceComponent)tc, (String)"BackedHashtable.getConnectionError");
        }
        if (bl2) {
            this.endDBContext();
            this.resumeTransaction();
        }
        return null;
    }

    protected void suspendTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Suspend transaction");
        }
        LocalTransactionCoordinator localTransactionCoordinator = null;
        UOWCurrent uOWCurrent = TransactionManagerFactory.getUOWCurrent();
        UOWCoordinator uOWCoordinator = uOWCurrent.getUOWCoord();
        LocalTransactionCurrent localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
        if (uOWCoordinator == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Global or Local Transaction exists");
            }
        } else if (!uOWCoordinator.isGlobal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LocalTransaction is active so suspend");
            }
            localTransactionCoordinator = localTransactionCurrent.suspend();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Global Transaction is Active");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Global Transaction is Active so suspend");
            }
            try {
                localTransactionCoordinator = TransactionManagerFactory.getTransactionManager().suspend();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (localTransactionCoordinator != null) {
            this.suspendedTransactions.put(Thread.currentThread(), localTransactionCoordinator);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Starting a Local Transaction");
            }
            localTransactionCurrent.begin();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Unable to start LTC");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Suspend transaction");
        }
    }

    protected void resumeTransaction() {
        Object object;
        LocalTransactionCurrent localTransactionCurrent;
        LocalTransactionCoordinator localTransactionCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Resume transaction");
        }
        if ((localTransactionCoordinator = (localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent()).getLocalTranCoord()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Complete the Local Transaction");
            }
            try {
                localTransactionCoordinator.cleanup();
            }
            catch (InconsistentLocalTranException inconsistentLocalTranException) {
                Tr.error((TraceComponent)tc, (String)"InconsistentLocalTranException", (Object)((Object)inconsistentLocalTranException));
            }
            catch (RolledbackException rolledbackException) {
                Tr.error((TraceComponent)tc, (String)"LocalTransaction rolled-back due to setRollbackOnly", (Object)((Object)rolledbackException));
            }
        }
        if ((object = this.suspendedTransactions.remove(Thread.currentThread())) != null) {
            if (object instanceof Transaction) {
                Transaction transaction;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Resume the suspended Global Transaction");
                }
                if ((transaction = (Transaction)object) != null) {
                    try {
                        TransactionManagerFactory.getTransactionManager().resume(transaction);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.resumeGlobalTransaction", (String)"1087", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                    }
                }
            } else if (object instanceof LocalTransactionCoordinator) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Resume the suspended Local Transaction");
                }
                try {
                    localTransactionCoordinator = (LocalTransactionCoordinator)object;
                    localTransactionCurrent.resume(localTransactionCoordinator);
                }
                catch (IllegalStateException illegalStateException) {
                    Tr.error((TraceComponent)tc, (String)"IllegalStateException", (Object)illegalStateException);
                    try {
                        localTransactionCoordinator.cleanup();
                    }
                    catch (InconsistentLocalTranException inconsistentLocalTranException) {
                        Tr.error((TraceComponent)tc, (String)"InconsistentLocalTranException", (Object)((Object)inconsistentLocalTranException));
                    }
                    catch (RolledbackException rolledbackException) {
                        Tr.error((TraceComponent)tc, (String)"LocalTransaction rolled-back due to setRollbackOnly", (Object)((Object)rolledbackException));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Resume transaction");
        }
    }

    /*
     * Exception decompiling
     */
    Object getValue(String var1_1, DatabaseSessionData var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 32[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    DatabaseSessionData getSessionWrapper(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.getSessionWrapper");
        }
        DatabaseSessionData databaseSessionData = null;
        IHttpSession iHttpSession = this.bhSessionContext.createSessionData(string);
        databaseSessionData = (DatabaseSessionData)iHttpSession;
        databaseSessionData.setValidity(true);
        return databaseSessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseSessionData getSession(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.getSession");
        }
        DatabaseSessionData databaseSessionData = null;
        String string2 = null;
        String string3 = string;
        if (!this.bhSessionContext.useSSLId && string.length() != this.bhSessionContext.cacheIdPlusIdlength) {
            return null;
        }
        int n = this.bhSessionContext.getCacheIdLengthInUse();
        string2 = string.substring(0, n);
        string = string.substring(n);
        databaseSessionData = (DatabaseSessionData)this.accessObject(string);
        if (tc.isDebugEnabled()) {
            if (databaseSessionData == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BackedHashtable. session not found in cache " + string));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cache id got in the request " + string2));
                Tr.debug((TraceComponent)tc, (String)("cache id of session object  " + databaseSessionData.cacheId));
            }
        }
        if (databaseSessionData != null) {
            long l = System.currentTimeMillis();
            boolean bl = this.isValidCopy(databaseSessionData, l, string2);
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("valid cache copy " + string));
                }
                if (!this.bhSessionContext.asyncUpd && !this.bhSessionContext.invalSpecifiedTime) {
                    int n2 = this.overQualLastAccessTimeUpdate(databaseSessionData, l);
                    if (n2 == 0 && !databaseSessionData.insertSession) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:getSession(id) - session may be invalid in cache " + string));
                        }
                        DatabaseSessionData databaseSessionData2 = databaseSessionData;
                        synchronized (databaseSessionData2) {
                            DatabaseSessionData databaseSessionData3 = (DatabaseSessionData)this.accessObject(string);
                            if (databaseSessionData == databaseSessionData3) {
                                this.superRemove(string);
                            }
                        }
                        databaseSessionData = null;
                    }
                } else {
                    DatabaseSessionData databaseSessionData4 = databaseSessionData;
                    synchronized (databaseSessionData4) {
                        databaseSessionData.setActive(true, l - databaseSessionData.getLastAccTime());
                        databaseSessionData.setLastAccessedTime(l);
                    }
                }
                if (databaseSessionData != null) {
                    databaseSessionData.cacheIdUpdated = false;
                    return databaseSessionData;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("Cache copy is out of date or invalid " + string));
                }
                DatabaseSessionData databaseSessionData5 = databaseSessionData;
                synchronized (databaseSessionData5) {
                    DatabaseSessionData databaseSessionData6 = (DatabaseSessionData)this.accessObject(databaseSessionData.getId());
                    if (databaseSessionData == databaseSessionData6) {
                        this.superRemove(databaseSessionData.getId());
                    }
                }
            }
        }
        databaseSessionData = this.retrieveSession(string, string2, databaseSessionData);
        return databaseSessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidCopy(DatabaseSessionData databaseSessionData, long l, String string) {
        DatabaseSessionData databaseSessionData2 = databaseSessionData;
        synchronized (databaseSessionData2) {
            if (!databaseSessionData.isValid()) {
                return false;
            }
            int n = databaseSessionData.getMaxInactiveInterval();
            boolean bl = databaseSessionData.getLastAccTime() >= l - 1000L * (long)n;
            boolean bl2 = true;
            bl2 = databaseSessionData.cacheId.equals(string) || databaseSessionData.cacheId.compareTo(string) > 0;
            if (DatabaseSessionContext.verifyTimeStamp && !this.checkCacheHit(databaseSessionData)) {
                return false;
            }
            return bl2 && (n == -1 || bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseSessionData retrieveSession(String string, String string2, SessionData sessionData) {
        long l;
        DatabaseSessionData databaseSessionData;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.retrieveSession");
        }
        long l2 = 0L;
        DatabaseSessionData databaseSessionData2 = null;
        databaseSessionData2 = (DatabaseSessionData)this.superGet(string);
        if (databaseSessionData2 != null) {
            return databaseSessionData2;
        }
        if (this.isPresentInRecentlyInvalidatedList(string)) {
            return null;
        }
        databaseSessionData2 = this.readFromExternal(string);
        boolean bl = false;
        if (databaseSessionData2 != null) {
            databaseSessionData = null;
            BackedHashtable backedHashtable = this;
            synchronized (backedHashtable) {
                DatabaseSessionData databaseSessionData3 = (DatabaseSessionData)this.superGet(string);
                if (databaseSessionData3 == null) {
                    databaseSessionData2.readIntoCache = true;
                    l2 = databaseSessionData2.getLastAccTime();
                    l = 0L;
                    if (sessionData != null) {
                        l = sessionData.getLastAccTime();
                    }
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Access times " + l2 + ", " + l));
                    }
                    if ((!this.bhSessionContext.asyncUpd || this.bhSessionContext.optimizeCacheIdIncrements) && (l == l2 || l > l2 && this.bhSessionContext.optimizeCacheIdIncrements)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Using in-memory session instead of retrieved session " + databaseSessionData2.hashCode() + ", " + sessionData.hashCode()));
                        }
                        databaseSessionData2 = (DatabaseSessionData)sessionData;
                        bl = false;
                    }
                    databaseSessionData = (DatabaseSessionData)this.superPut(string, databaseSessionData2);
                    databaseSessionData2.cacheId = string2;
                    databaseSessionData2.setNew(false);
                } else {
                    databaseSessionData2 = databaseSessionData3;
                }
            }
            if (databaseSessionData != null) {
                this.passivateSession(databaseSessionData);
            }
        } else {
            return null;
        }
        databaseSessionData = databaseSessionData2;
        synchronized (databaseSessionData) {
            long l3 = System.currentTimeMillis();
            l = databaseSessionData2.getLastAccTime();
            int n = -1;
            if (l < l3) {
                n = this.updateLastAccessTime(databaseSessionData2, l3);
            } else {
                l3 = l;
            }
            if (n == 0) {
                this.superRemove(databaseSessionData2.getId());
                databaseSessionData2 = null;
                return databaseSessionData2;
            }
            databaseSessionData2.setLastAccessedTime(l3);
            databaseSessionData2.setLastWriteLastAccessTime(l3);
            databaseSessionData2.initSession(this.bhSessionContext);
            databaseSessionData2.setActive(true, l3 - l);
        }
        int n = DatabaseSessionContext.establishAffinity(databaseSessionData2);
        if (n != 0) {
            Tr.error((TraceComponent)tc, (String)("BackedHashtable:retrieveSession - call to establishAffinity for id " + databaseSessionData2.getId() + " failed with rc " + n));
            return null;
        }
        if (bl) {
            this.updateCacheId(databaseSessionData2);
        }
        return databaseSessionData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateLastAccessTime(DatabaseSessionData databaseSessionData, long l) {
        Connection connection;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.updateLastAccessTime");
        }
        if ((connection = this.getConnection(false)) == null) {
            return 1;
        }
        PreparedStatement preparedStatement = null;
        String string = databaseSessionData.getId();
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(this.asyncUpdate);
            preparedStatement.setString(4, this.bhSessionContext.getAppName());
            this.setPSLong(preparedStatement, 1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("BackedHashtable:updateLastAccessTime(id) - before lastacc upd for " + string));
            }
            if ((n = preparedStatement.executeUpdate()) > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("BackedHashtable:updateLastAccessTime(id) - after upd (row changed " + string));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("BackedHashtable:updateLastAccessTime(id) - row does not exist for " + string));
            }
        }
        catch (StaleConnectionException staleConnectionException) {
            FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.selectAndLock", (String)"1604", (Object)databaseSessionData);
            Tr.debug((TraceComponent)tc, (String)"BackedHashtable.StaleConnectionException");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.selectAndLock", (String)"1620", (Object)databaseSessionData);
            Tr.error((TraceComponent)tc, (String)"SessionContext.sessionid", (Object)string);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        finally {
            if (preparedStatement != null) {
                BackedHashtable.closeStatement(preparedStatement);
            }
            if (connection != null) {
                this.closeConnection(connection);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int overQualLastAccessTimeUpdate(DatabaseSessionData databaseSessionData, long l) {
        int n;
        Connection connection;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"BackedHashtable.updateLastAccessTime");
            }
            if ((connection = this.getConnection(false)) == null) {
                return 1;
            }
            PreparedStatement preparedStatement = null;
            String string = databaseSessionData.getId();
            n = 1;
            try {
                DatabaseSessionData databaseSessionData2 = databaseSessionData;
                synchronized (databaseSessionData2) {
                    preparedStatement = connection.prepareStatement(this.optUpdatePrimRow);
                    this.setPSLong(preparedStatement, 1, l);
                    preparedStatement.setString(2, string);
                    preparedStatement.setString(3, string);
                    this.setPSLong(preparedStatement, 4, databaseSessionData.getLastAccTime());
                    n = preparedStatement.executeUpdate();
                    if (n > 0) {
                        databaseSessionData.setActive(true, l - databaseSessionData.getLastAccTime());
                        databaseSessionData.setLastAccessedTime(l);
                    }
                }
                if (n > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("BackedHashtable:updateLastAccessTime(id) - after upd (row changed " + string));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("BackedHashtable:updateLastAccessTime(id) - It might be either cache hit or session is not in cache for  " + string));
                }
                if (preparedStatement == null) break block21;
            }
            catch (StaleConnectionException staleConnectionException) {
                block22: {
                    FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.selectAndLock", (String)"1604", (Object)databaseSessionData);
                    Tr.debug((TraceComponent)tc, (String)"BackedHashtable.StaleConnectionException");
                    if (preparedStatement == null) break block22;
                    BackedHashtable.closeStatement(preparedStatement);
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Throwable throwable) {
                block23: {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.selectAndLock", (String)"1620", (Object)databaseSessionData);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.sessionid", (Object)string);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                    if (preparedStatement == null) break block23;
                    {
                        catch (Throwable throwable2) {
                            if (preparedStatement != null) {
                                BackedHashtable.closeStatement(preparedStatement);
                            }
                            if (connection != null) {
                                this.closeConnection(connection);
                            }
                            throw throwable2;
                        }
                    }
                    BackedHashtable.closeStatement(preparedStatement);
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            BackedHashtable.closeStatement(preparedStatement);
        }
        if (connection != null) {
            this.closeConnection(connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseSessionData readFromExternal(String string) {
        Statement statement = null;
        boolean bl = false;
        String string2 = this.bhSessionContext.getAppName();
        Connection connection = this.getConnection(false);
        if (connection == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BackedHashtable:getValue - unable to get con when processing session " + string));
            }
            return null;
        }
        DatabaseSessionData databaseSessionData = null;
        try {
            databaseSessionData = this.readPrimitives(string, string2, connection);
        }
        catch (StaleConnectionException staleConnectionException) {
            FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.selectAndLock", (String)"1604", (Object)databaseSessionData);
            Tr.warning((TraceComponent)tc, (String)"BackedHashtable.StaleConnectionException");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.selectAndLock", (String)"1620", (Object)databaseSessionData);
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.selectAndLockError");
            Tr.error((TraceComponent)tc, (String)"SessionContext.sessionid", (Object)string);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        finally {
            if (statement != null) {
                BackedHashtable.closeStatement(statement);
            }
            if (connection != null) {
                this.closeConnection(connection);
            }
        }
        return databaseSessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseSessionData readPrimitives(String string, String string2, Connection connection) throws SQLException {
        DatabaseSessionData databaseSessionData;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            ResultSet resultSet = null;
            databaseSessionData = null;
            try {
                preparedStatement = this.usingDB2 ? connection.prepareStatement(this.readPrimitiveDataDb2) : connection.prepareStatement(this.readPrimitiveData);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    databaseSessionData = this.getSessionWrapper(string);
                    long l = resultSet.getLong(1);
                    long l2 = resultSet.getLong(2);
                    int n = resultSet.getInt(3);
                    String string3 = resultSet.getString(4);
                    short s = resultSet.getShort(5);
                    databaseSessionData.setLastAccessedTime(l);
                    databaseSessionData.setCreationTime(l2);
                    databaseSessionData.setMaxInactInterval(n);
                    databaseSessionData.setUserId(string3);
                    databaseSessionData.setListenerCount(s);
                }
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    BackedHashtable.closeResultSet(resultSet);
                }
                if (preparedStatement != null) {
                    BackedHashtable.closeStatement(preparedStatement);
                }
                throw throwable;
            }
            BackedHashtable.closeResultSet(resultSet);
        }
        if (preparedStatement != null) {
            BackedHashtable.closeStatement(preparedStatement);
        }
        return databaseSessionData;
    }

    /*
     * Exception decompiling
     */
    boolean isPresent(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object get(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.get");
        }
        String string = (String)object;
        DatabaseSessionData databaseSessionData = this.getSession(string);
        return databaseSessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] commonSetup(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.commonSetup");
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = null;
        try {
            Hashtable hashtable = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BackedHashtable:commonSetup - getting data and clearing appData*");
            }
            DatabaseSessionData databaseSessionData2 = databaseSessionData;
            synchronized (databaseSessionData2) {
                hashtable = databaseSessionData.getSwappableData();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("BackedHashtable.appDataSz " + byArray.length));
            }
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Tr.info((TraceComponent)SessionContext.tc, (String)("BackedHashtable.commonSetup: Defer write until next time since session is in the service method " + databaseSessionData.deferWriteUntilNextTick + " " + databaseSessionData.getId()));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.commonSetup", (String)"1877", (Object)databaseSessionData);
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.commonSetupError");
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
        }
        return byArray;
    }

    void storeSession(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.storeSession");
        }
        boolean bl = false;
        if (this.bhSessionContext.WriteAllProperties) {
            bl = true;
        }
        if (!bl && databaseSessionData.appDataChanges != null) {
            boolean bl2 = bl = !databaseSessionData.appDataChanges.isEmpty();
        }
        if (!bl && databaseSessionData.appDataRemovals != null) {
            boolean bl3 = bl = !databaseSessionData.appDataRemovals.isEmpty();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BackedHashtable:storeSession propHit is: " + bl));
        }
        this.ejbStore(databaseSessionData, bl);
    }

    void insertSession(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.insertSession");
        }
        this.ejbCreate(databaseSessionData);
    }

    boolean cacheAndReturn(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.cacheAndReturn");
        }
        String string = databaseSessionData.getId();
        if (!databaseSessionData.syncFromServlet) {
            if (!this.bhSessionContext.timeBasedWrite) {
                this.asyncUps.put(string, new Long(databaseSessionData.getLastAccTime()));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BackedHashtable.cacheAndReturn !!!!!!!!!  Don't cache LastAccess at EOS  !!!!!!!!!");
            }
            return true;
        }
        if (!this.bhSessionContext.timeBasedWrite) {
            this.asyncUps.remove(string);
        }
        return false;
    }

    boolean handlePropertyHits(DatabaseSessionData databaseSessionData, Thread thread, byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.handlePropertyHits");
        }
        if (n <= this.bhSessionContext.smallColSize) {
            databaseSessionData.update.append(smallCol).append(equals).append(comma).append(setMediumNull).append(comma).append(setLargeNull);
        } else if (n <= this.bhSessionContext.mediumColSize) {
            databaseSessionData.update.append(setSmallNull).append(comma).append(medCol).append(equals).append(comma).append(setLargeNull);
        } else if (n <= this.bhSessionContext.largeColSize) {
            databaseSessionData.update.append(setSmallNull).append(comma).append(setMediumNull).append(comma).append(lgCol).append(equals);
        } else {
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.db2LongVarCharErr");
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    protected boolean persistSession(DatabaseSessionData var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 55[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ejbStore(DatabaseSessionData databaseSessionData, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.ejbStore");
        }
        if (!databaseSessionData.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BackedHashtable:ejbStore - session " + databaseSessionData.getId() + " has been invalidated since last access, clean up and return "));
            }
            if (databaseSessionData.appDataChanges != null) {
                databaseSessionData.appDataChanges.clear();
            }
            if (databaseSessionData.appDataRemovals != null) {
                databaseSessionData.appDataRemovals.clear();
            }
            return;
        }
        if (this.bhSessionContext.asyncUpd && this.cacheAndReturn(databaseSessionData)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BackedHashtable.ejbStore cacheAndReturn returned TRUE exitting ejbStore at EOS");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"BackedHashtable.ejbStore cacheAndReturn returned False, Go ahead and do the write!");
        }
        if (bl) {
            if (SessionContext.passivateAtWrite) {
                if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"BackedHashtable:ejbStore - check for Passivation Listener for existing session");
                }
                databaseSessionData.checkPassivationListeners();
            }
            if (tc.isDebugEnabled()) {
                String string = "BackedHashtable:ejbStore - prop hit " + bl + ", app changes: ";
                string = databaseSessionData.appDataChanges != null ? string + databaseSessionData.appDataChanges.keySet() : string + "null";
                string = string + ", app removals: ";
                string = databaseSessionData.appDataRemovals != null ? string + databaseSessionData.appDataRemovals.keySet() : string + "null";
                Tr.debug((TraceComponent)tc, (String)string);
            }
        }
        boolean bl2 = this.persistSession(databaseSessionData, bl);
        databaseSessionData.syncFromServlet = false;
        databaseSessionData.update = null;
        if (bl2) {
            databaseSessionData.userWriteHit = false;
            databaseSessionData.maxInactWriteHit = false;
            databaseSessionData.listenCntHit = false;
            if (!this.bhSessionContext.usingMultirow) {
                if (databaseSessionData.appDataChanges != null) {
                    databaseSessionData.appDataChanges.clear();
                }
                if (databaseSessionData.appDataRemovals != null) {
                    databaseSessionData.appDataRemovals.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAsyncUpdates(Connection connection) throws StaleConnectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.handleAsyncUpdates");
        }
        Hashtable hashtable = (Hashtable)this.asyncUps.clone();
        this.asyncUps.clear();
        Enumeration enumeration = hashtable.keys();
        String string = null;
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Long l = (Long)hashtable.get(string);
            long l2 = l;
            try {
                preparedStatement = connection.prepareStatement(this.asyncUpdate);
                this.setPSLong(preparedStatement, 1, l2);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string);
                preparedStatement.setString(4, this.bhSessionContext.scAppParms.getAppName());
                preparedStatement.executeUpdate();
                preparedStatement.close();
                bl = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("BackedHashtable.handleAsyncUpdates - Updating LastAccess for " + string));
            }
            catch (StaleConnectionException staleConnectionException) {
                FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.handleAsyncUpdates", (String)"2297", (Object)string);
                Tr.debug((TraceComponent)tc, (String)"BackedHashtable.StaleConnectionException");
                throw staleConnectionException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.handleAsyncUpdates", (String)"2304", (Object)string);
                Tr.error((TraceComponent)tc, (String)"BackedHashtable.handleAsyncError");
                Tr.error((TraceComponent)tc, (String)"SessionContext.sessionid", (Object)string);
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
            }
            finally {
                if (bl || preparedStatement == null) continue;
                BackedHashtable.closeStatement(preparedStatement);
            }
        }
    }

    void updateCacheId(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.updateCacheId");
        }
        if (!databaseSessionData.cached) {
            databaseSessionData.cacheIdUpdated = true;
            if (databaseSessionData.cacheId == null) {
                databaseSessionData.cacheId = "0001";
            } else {
                int n = Integer.parseInt(databaseSessionData.cacheId);
                if (n == 9999) {
                    databaseSessionData.cacheId = "0001";
                    n = 0;
                } else {
                    databaseSessionData.cacheId = Integer.toString(++n);
                    int n2 = databaseSessionData.cacheId.length();
                    if (n2 == 1) {
                        databaseSessionData.cacheId = "000" + databaseSessionData.cacheId;
                    }
                    if (n2 == 2) {
                        databaseSessionData.cacheId = "00" + databaseSessionData.cacheId;
                    }
                    if (n2 == 3) {
                        databaseSessionData.cacheId = "0" + databaseSessionData.cacheId;
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    void ejbCreate(DatabaseSessionData var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void listenerCntAppend(DatabaseSessionData databaseSessionData) {
        if (this.bhSessionContext.sessionListener) {
            switch (databaseSessionData.listenerCnt) {
                case 0: {
                    databaseSessionData.listenerCnt = 1;
                    break;
                }
                case 2: {
                    databaseSessionData.listenerCnt = (short)3;
                }
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.put");
        }
        String string = (String)object;
        DatabaseSessionData databaseSessionData = (DatabaseSessionData)object2;
        if (!databaseSessionData.isValid()) {
            return null;
        }
        if (!databaseSessionData.insertSession) {
            this.storeSession(databaseSessionData);
        } else {
            this.insertSession(databaseSessionData);
            if (databaseSessionData.isNew()) {
                if (!databaseSessionData.removingSessionFromCache && !databaseSessionData.duplicateIdDetected) {
                    DatabaseSessionData databaseSessionData2 = (DatabaseSessionData)this.superPut(string, databaseSessionData);
                    if (databaseSessionData2 != null) {
                        this.passivateSession(databaseSessionData2);
                    }
                    databaseSessionData.cached = true;
                }
            } else {
                this.storeSession(databaseSessionData);
            }
        }
        return null;
    }

    Object superRemove(Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.superRemoveBH");
        }
        if ((object2 = super.remove(object)) != null) {
            this.bhSessionContext.scPmiData.decMemoryCount();
            this.removeFromRecentlyInvalidatedList((String)object);
            DatabaseSessionContext.removeAffinity((SessionData)object2);
        }
        return object2;
    }

    Object superGet(Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.superGetBH");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("!!!superGet input : " + object));
        }
        if ((object2 = super.get(object)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"!!!superGet returned NULL");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"!!!superGet returned a SESSION: ");
        }
        return object2;
    }

    Object superPut(Object object, Object object2) {
        DatabaseSessionData databaseSessionData;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.superPutBH");
        }
        if ((databaseSessionData = (DatabaseSessionData)super.put(object, object2)) != null) {
            SessionContext.removeAffinity(databaseSessionData);
            this.bhSessionContext.scPmiData.incCacheDiscards();
        } else {
            this.bhSessionContext.scPmiData.incMemoryCount();
        }
        return databaseSessionData;
    }

    boolean superContainsKey(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BackedHashtable.superContainsKeyBH");
        }
        return super.containsKey(object);
    }

    String getCollectionName(String string) {
        String string2;
        Object var3_2 = null;
        Object var4_3 = null;
        Object var5_4 = null;
        int n = -1;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCollectionName url: " + string));
        }
        if (string != null && string.indexOf("jdbc:db2") != -1) {
            string2 = string;
            n = string2.indexOf(";");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf("//")) != -1) {
                string2 = string2.substring(n + 2);
            }
            if ((n = string2.indexOf("/")) != -1 && (string2 = string2.substring(n + 1).trim()).length() != 0) {
                this.as400_collection = string2;
            }
        } else {
            try {
                string2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
                if (string2 == null) {
                    throw new Exception("Unable to acquire a reference to the repository.");
                }
                String string3 = this.bhSessionContextParams.getJNDIDataSourceName();
                this.as400_collection = this.retrieveDBSessionCollection((Repository)string2, 4, string3);
                if (this.as400_collection == null && (this.as400_collection = this.retrieveDBSessionCollection((Repository)string2, 3, string3)) == null && (this.as400_collection = this.retrieveDBSessionCollection((Repository)string2, 0, string3)) == null && (this.as400_collection = this.retrieveDBSessionCollection((Repository)string2, 2, string3)) == null) {
                    throw new Exception("DataSource not configured with JNDI name: " + string3);
                }
            }
            catch (Exception exception) {
                Tr.warning((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
            }
        }
        if (this.as400_collection == null) {
            string2 = System.getProperty("was.install.library");
            if (string2 == null) {
                Tr.warning((TraceComponent)tc, (String)"SessionContext.miscData", (Object)"was.install.library not set.  Using collection QEJBASSN for session persistance.");
                this.as400_collection = "QEJBASSN";
            } else {
                Tr.warning((TraceComponent)tc, (String)"SessionContext.miscData", (Object)"using was.install.library to derive collection name for session persistance.");
                this.as400_collection = string2 + "SN";
                if (this.as400_collection.length() > 10) {
                    this.as400_collection = this.as400_collection.substring(0, 10);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Session Persistance will use the collection: " + this.as400_collection));
        }
        return this.as400_collection;
    }

    private String retrieveDBSessionCollection(Repository repository, int n, String string) throws Exception {
        String string2 = null;
        String string3 = null;
        Resource resource = null;
        try {
            resource = repository.getConfigRoot().getResource(n, "resources.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource == null) {
            return null;
        }
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e = eList.get(i);
            if (!(e instanceof JDBCProvider)) continue;
            JDBCProvider jDBCProvider = (JDBCProvider)e;
            EList eList2 = jDBCProvider.getFactories();
            for (int j = 0; j < eList2.size(); ++j) {
                DataSource dataSource;
                Object e2 = eList2.get(j);
                if (!(e2 instanceof DataSource) || (string3 = (dataSource = (DataSource)e2).getJndiName()) == null || !string3.equals(string)) continue;
                J2EEResourcePropertySet j2EEResourcePropertySet = dataSource.getPropertySet();
                EList eList3 = j2EEResourcePropertySet.getResourceProperties();
                for (int k = 0; k < eList3.size(); ++k) {
                    int n2;
                    String string4;
                    J2EEResourceProperty j2EEResourceProperty;
                    Object e3 = eList3.get(k);
                    if (!(e3 instanceof J2EEResourceProperty) || !(j2EEResourceProperty = (J2EEResourceProperty)e3).getName().equals("libraries")) continue;
                    string2 = j2EEResourceProperty.getValue().trim();
                    if (!(string2 == null || string2.equals("") || (string4 = string2.substring(0, (n2 = string2.indexOf(",")) == -1 ? string2.length() : n2).trim()) == null || string4.equals("") || string4.equalsIgnoreCase("*LIBL"))) {
                        return string4;
                    }
                    throw new Exception("Invalid or missing libraries property specified on datasource.");
                }
            }
        }
        return null;
    }

    private Object oracleGetValue(ResultSet resultSet, DatabaseSessionData databaseSessionData) {
        Object object;
        block10: {
            object = null;
            try {
                Object object2;
                long l = System.currentTimeMillis();
                long l2 = 0L;
                BufferedInputStream bufferedInputStream = null;
                ByteArrayInputStream byteArrayInputStream = null;
                byte[] byArray = resultSet.getBytes(smallCol);
                if (byArray == null) {
                    if (!DatabaseSessionContext.useOracleBLOB) {
                        byArray = resultSet.getBytes(medCol);
                    } else {
                        object2 = resultSet.getBlob(medCol);
                        if (object2 != null) {
                            bufferedInputStream = new BufferedInputStream(object2.getBinaryStream());
                            l2 = object2.length();
                        }
                    }
                }
                if (byArray != null && byArray.length > 0) {
                    l2 = byArray.length;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                }
                if (bufferedInputStream == null) break block10;
                object2 = this.bhSessionContext.scAppParms.getAppClassLoader().getObjectInputStream(bufferedInputStream);
                try {
                    object = ((ObjectInputStream)object2).readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.oracleGetValue", (String)"2728", (Object)databaseSessionData);
                    Tr.error((TraceComponent)tc, (String)"BackedHashtable.classNotFoundError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.sessionid", (Object)databaseSessionData.getId());
                    classNotFoundException.printStackTrace();
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)classNotFoundException);
                }
                ((ObjectInputStream)object2).close();
                bufferedInputStream.close();
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                this.bhSessionContext.scPmiData.readTimes(l2, System.currentTimeMillis() - l);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.oracleGetValue", (String)"2744", (Object)databaseSessionData);
                Tr.error((TraceComponent)tc, (String)"BackedHashtable.oracleGetValueError");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
            }
        }
        return object;
    }

    protected void initializeSQL_Strings() {
        String string = "update " + this.tableName + " set " + lastAccCol + equals;
        this.remoteInvalAll = "update " + this.tableName + " set maxinactivetime = 0 where id = ? and propid = ? and appname = ? and maxinactivetime != 0";
        this.getOneNoUpdate = "select maxinactivetime,lastaccess, appname from " + this.tableName + " where id = ? and propid = ? for read only";
        this.getOneNoUpdateNonDB2 = "select maxinactivetime,lastaccess, appname from " + this.tableName + " where id = ? and propid = ?";
        this.upBase = "update " + this.tableName + " set ";
        this.asyncUpdate = string + " where id = ? and propid = ?  and appname = ?";
        this.optUpdate = string + " where id = ? and propid = ?  and appname = ? and " + lastAccCol + equals;
        this.optUpdatePrimRow = string + " where id = ? and propid = ?  and " + lastAccCol + equals;
        this.insNoProp = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, NULL)";
        this.insForInval = "insert into " + this.tableName + " (" + idCol + "," + propCol + "," + appCol + "," + lastAccCol + "," + maxInactCol + ") values (?, ?, ?, ?, ?)";
        this.insSm = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL)";
        this.insMed = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, NULL, ?, NULL)";
        this.insLg = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?)";
        this.getProp = "select small, medium, large from  " + this.tableName + "  where id = ? and propid = ? and appname = ? for read only";
        this.delPropall = "delete from  " + this.tableName + " where id = ? and propid <> id and appname = ?";
        this.getPropNotDB2 = "select small, medium, large from  " + this.tableName + "  where id = ? and propid = ? and appname = ?";
        this.delProp = "delete from " + this.tableName + " where id = ? and propid = ? and appname = ?";
        this.insSmProp = "insert into " + this.tableName + " (id, propid, small, appname) values (?, ?, ?, ?)";
        this.insMedProp = "insert into " + this.tableName + " (id, propid, medium, appname) values (?, ?, ?, ?)";
        this.insLgProp = "insert into " + this.tableName + " (id, propid, large, appname) values (?, ?, ?, ?)";
        this.selMed = "select medium from " + this.tableName;
        this.selLg = "select large from " + this.tableName;
        this.readLastAccess = "select lastaccess from " + this.tableName + " where id = ? and propid = ? and appname = ?";
        this.selectForUpdate = "select lastaccess from " + this.tableName + " where id = ? and propid = ? and appname = ? for update of lastaccess";
        this.delPrimaryRowInval = "delete from  " + this.tableName + " where id = ? and propid = id  and appname = ? and lastaccess = ?";
        this.readPrimitiveData = "select lastaccess, creationtime ,maxinactivetime,username,listenercnt from " + this.tableName + " where id = ? and propid = ? and appname = ?";
        this.readPrimitiveDataDb2 = this.readPrimitiveData + " for read only";
        this.delOne = "delete from " + this.tableName + " where id = ?  and appname = ?";
        this.selDelNoListener = "select id,lastaccess, creationtime from  " + this.tableName + " where (appname = ? " + " and (listenercnt = 0 OR listenercnt = 2 ) and maxinactivetime >= 0 and (maxinactivetime < ((? - lastaccess) / 1000.0)))";
        this.selNukerString = "select id,lastaccess, creationtime,maxinactivetime,username,listenercnt from  " + this.tableName + " where ( appname = ? " + " and (listenercnt = 1 OR listenercnt = 3 ) and maxinactivetime >= 0 and (maxinactivetime < ((? - lastaccess) / 1000.0)))";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setMaxInactToZero(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("BackedHashtable:setMaxInactToZero for " + string + " and app " + string2));
        }
        int n = 0;
        PreparedStatement preparedStatement = null;
        Connection connection = this.getConnection(false);
        if (connection == null) {
            Tr.error((TraceComponent)tc, (String)"BackedHashtable.setMaxInactToZero got null connection.");
            return 0;
        }
        try {
            preparedStatement = connection.prepareStatement(this.remoteInvalAll);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.setMaxInactToZero", (String)"3101", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        finally {
            if (preparedStatement != null) {
                BackedHashtable.closeStatement(preparedStatement);
            }
            this.closeConnection(connection);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("BackedHashtable:setMaxInactToZero for " + string + " returning " + n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performInvalidation() {
        Connection connection;
        boolean bl;
        boolean bl2;
        PreparedStatement preparedStatement;
        PreparedStatement preparedStatement2;
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"BackedHashtable:performInvalidations");
            }
            long l = System.currentTimeMillis();
            preparedStatement2 = null;
            ResultSet resultSet = null;
            preparedStatement = null;
            bl2 = false;
            bl = false;
            connection = null;
            String string = this.bhSessionContext.getAppName();
            boolean bl3 = false;
            boolean bl4 = this.bhSessionContext.doInval();
            connection = this.getConnection(false);
            if (connection == null) {
                return;
            }
            try {
                if (this.bhSessionContext.asyncUpd) {
                    this.handleAsyncUpdates(connection);
                }
                if (bl4) {
                    block24: {
                        preparedStatement2 = connection.prepareStatement(this.readLastAccess);
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setString(2, string);
                        preparedStatement2.setString(3, string);
                        resultSet = preparedStatement2.executeQuery();
                        boolean bl5 = false;
                        long l2 = 0L;
                        if (resultSet.next()) {
                            bl5 = true;
                            l2 = resultSet.getLong(1);
                        }
                        resultSet.close();
                        preparedStatement2.close();
                        bl2 = true;
                        if (bl5) {
                            long l3 = l - this.bhSessionContext.mInvalidationCheckPollInterval * 1000L;
                            if (l3 > l2 || l2 > l) {
                                preparedStatement = connection.prepareStatement(this.optUpdate);
                                this.setPSLong(preparedStatement, 1, l);
                                this.setPSLong(preparedStatement, 5, l2);
                                preparedStatement.setString(2, string);
                                preparedStatement.setString(3, string);
                                preparedStatement.setString(4, string);
                                int n = preparedStatement.executeUpdate();
                                if (n > 0) {
                                    bl3 = true;
                                }
                            }
                        } else {
                            preparedStatement = connection.prepareStatement(this.insForInval);
                            preparedStatement.setString(1, string);
                            preparedStatement.setString(2, string);
                            preparedStatement.setString(3, string);
                            this.setPSLong(preparedStatement, 4, l);
                            preparedStatement.setInt(5, -1);
                            try {
                                preparedStatement.executeUpdate();
                                bl3 = true;
                            }
                            catch (DuplicateKeyException duplicateKeyException) {
                                if (!tc.isDebugEnabled()) break block24;
                                Tr.debug((TraceComponent)tc, (String)"BackedHashtable:performInvalidations: Duplicate key inserted");
                            }
                        }
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    bl = true;
                    if (bl3) {
                        this.doInvalidations(connection);
                        Enumeration enumeration = this.pollForInvalids(connection);
                        this.processInvalidList(enumeration, connection);
                    }
                }
                if (bl2 || resultSet == null) break block25;
            }
            catch (Throwable throwable) {
                block26: {
                    try {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.performInvalidation", (String)"2956", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"DatabaseSessionContext.performInvalidationError");
                        Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                        if (bl2 || resultSet == null) break block26;
                    }
                    catch (Throwable throwable2) {
                        if (!bl2 && resultSet != null) {
                            BackedHashtable.closeResultSet(resultSet);
                        }
                        if (!bl2 && preparedStatement2 != null) {
                            BackedHashtable.closeStatement(preparedStatement2);
                        }
                        if (!bl && preparedStatement != null) {
                            BackedHashtable.closeStatement(preparedStatement);
                        }
                        this.closeConnection(connection);
                        throw throwable2;
                    }
                    BackedHashtable.closeResultSet(resultSet);
                }
                if (!bl2 && preparedStatement2 != null) {
                    BackedHashtable.closeStatement(preparedStatement2);
                }
                if (!bl && preparedStatement != null) {
                    BackedHashtable.closeStatement(preparedStatement);
                }
                this.closeConnection(connection);
            }
            BackedHashtable.closeResultSet(resultSet);
        }
        if (!bl2 && preparedStatement2 != null) {
            BackedHashtable.closeStatement(preparedStatement2);
        }
        if (!bl && preparedStatement != null) {
            BackedHashtable.closeStatement(preparedStatement);
        }
        this.closeConnection(connection);
    }

    /*
     * Exception decompiling
     */
    void processInvalidList(Enumeration var1_1, Connection var2_2) throws StaleConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proceedWithInvalidation(Connection connection, String string, long l) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        boolean bl;
        block4: {
            Tr.entry((TraceComponent)tc, (String)("proceedWithInvalidation:" + string));
            bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.readLastAccess);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    long l2 = l - this.bhSessionContext.mInvalidationCheckPollInterval * 1000L;
                    long l3 = resultSet.getLong(1);
                    if (l2 > l3) {
                        bl = true;
                    }
                    break block4;
                }
                bl = true;
            }
            catch (Throwable throwable) {
                BackedHashtable.closeStatement(preparedStatement);
                BackedHashtable.closeResultSet(resultSet);
                throw throwable;
            }
        }
        BackedHashtable.closeStatement(preparedStatement);
        BackedHashtable.closeResultSet(resultSet);
        Tr.exit((TraceComponent)tc, (String)("proceedWithInvalidation:" + string + " " + bl));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNukerTimeStamp(Connection connection, String string) throws SQLException {
        Tr.entry((TraceComponent)tc, (String)("updateNukerTimeStamp: " + string));
        PreparedStatement preparedStatement = null;
        long l = System.currentTimeMillis();
        try {
            preparedStatement = connection.prepareStatement(this.asyncUpdate);
            this.setPSLong(preparedStatement, 1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            BackedHashtable.closeStatement(preparedStatement);
            throw throwable;
        }
        BackedHashtable.closeStatement(preparedStatement);
        Tr.exit((TraceComponent)tc, (String)("updateNukerTimeStamp:  " + string));
    }

    Object getAllValues(DatabaseSessionData databaseSessionData) {
        return this.getValue(databaseSessionData.getId(), databaseSessionData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected long readLastAccessForCheckCacheHit(SessionData sessionData) {
        long l;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("readLastAccessForCheckCacheHit " + sessionData.getId()));
            }
            l = 0L;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Connection connection = this.getConnection(false);
            if (connection == null) {
                return 0L;
            }
            try {
                preparedStatement = connection.prepareStatement(this.readLastAccess);
                preparedStatement.setString(1, sessionData.getId());
                preparedStatement.setString(2, sessionData.getId());
                preparedStatement.setString(3, this.bhSessionContext.getAppName());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    l = resultSet.getLong(1);
                }
                BackedHashtable.closeResultSet(resultSet);
            }
            catch (SQLException sQLException) {
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sQLException);
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.checkCacheHit", (String)"3634", (Object)sessionData);
                break block10;
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.BackedHashtable.checkCacheHit", (String)"3638", (Object)sessionData);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                BackedHashtable.closeResultSet(resultSet);
                BackedHashtable.closeStatement(preparedStatement);
                this.closeConnection(connection);
            }
            BackedHashtable.closeStatement(preparedStatement);
            this.closeConnection(connection);
        }
        return l;
    }

    protected boolean checkCacheHit(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkCacheHit:" + databaseSessionData.getId()));
        }
        if (this.bhSessionContext.asyncUpd && this.bhSessionContext.invalSpecifiedTime) {
            long l = this.readLastAccessForCheckCacheHit(databaseSessionData);
            if (l == 0L) {
                return false;
            }
            if (l == databaseSessionData.getLastAccTime()) {
                return true;
            }
        }
        return false;
    }

    final void setPSLong(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        if (this.usingDB2Connect || this.usingSQLServer || this.usingDB2zOS) {
            preparedStatement.setBigDecimal(n, BigDecimal.valueOf(l));
        } else {
            preparedStatement.setLong(n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToRecentlyInvalidatedList(String string) {
        if (!checkRecentlyInvalidList) {
            return;
        }
        Map map = this.recentInvalidIds;
        synchronized (map) {
            this.recentInvalidIds.put(string, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromRecentlyInvalidatedList(String string) {
        if (!checkRecentlyInvalidList) {
            return;
        }
        Map map = this.recentInvalidIds;
        synchronized (map) {
            this.recentInvalidIds.remove(string);
        }
    }

    boolean isPresentInRecentlyInvalidatedList(String string) {
        if (!checkRecentlyInvalidList) {
            return false;
        }
        return this.recentInvalidIds.containsKey(string);
    }

    void setRecentInvalTable() {
        if (this.bhSessionContext.tableSize > 1) {
            this.recentInvalidIds = new SessionSimpleLRUHashMap(this.bhSessionContext.mParams.inMemorySize / 2);
        } else {
            checkRecentlyInvalidList = false;
        }
    }

    boolean available(InputStream inputStream) throws IOException {
        if (this.usingSQLServer) {
            return true;
        }
        return inputStream.available() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateSession(DatabaseSessionData databaseSessionData) {
        DatabaseSessionData databaseSessionData2 = databaseSessionData;
        synchronized (databaseSessionData2) {
            databaseSessionData.cached = false;
            if (SessionContext.passivateUsingCache) {
                if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"BackedHashtable:replaceLRU - check for Passivation Listener for session");
                }
                if (databaseSessionData != null) {
                    databaseSessionData.checkPassivationListeners();
                }
            }
            if (this.bhSessionContext.mIBMSessionListenerImplemented) {
                this.bhSessionContext.notifySessionRemovedFromCache(databaseSessionData.getId());
            }
            if (this.bhSessionContext.timeBasedWrite) {
                if (tc.isDebugEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("BackedHashtable.superPut !!!!Aging out old entry from Cache.. Write it to database before using a new session! " + databaseSessionData.getId()));
                }
                databaseSessionData.removingSessionFromCache = true;
                databaseSessionData.sync();
                databaseSessionData.removingSessionFromCache = false;
            }
        }
    }

    protected void beginDBContext() {
        if (cmda == null) {
            Tr.warning((TraceComponent)tc, (String)"BackedHashtable.beginDBContext: cmda is null");
            return;
        }
        CustomContainerComponentMetaDataImpl customContainerComponentMetaDataImpl = null;
        ComponentMetaData componentMetaData = cmda.getComponentMetaData();
        customContainerComponentMetaDataImpl = componentMetaData != null ? new CustomContainerComponentMetaDataImpl(componentMetaData) : new CustomContainerComponentMetaDataImpl();
        CustomContainerComponentMetaData.CustomLocalTranCfg customLocalTranCfg = customContainerComponentMetaDataImpl.getCustomLocalTranConfigData();
        customLocalTranCfg.setValueBoundary(0);
        customLocalTranCfg.setValueResolver(0);
        customLocalTranCfg.setValueUnresolvedAction(0);
        CustomContainerComponentMetaData.CustomResRefList customResRefList = customContainerComponentMetaDataImpl.getCustomResourceRefList();
        customResRefList.addResRef("Session Persistance Custom JDBC Res-Ref", this.bhSessionContextParams.getJNDIDataSourceName(), this.bhSessionContextParams.getJNDIDataSourceName(), "javax.resource.cci.ConnectionFactory", 1, 0, 2);
        cmda.beginContext((ComponentMetaData)customContainerComponentMetaDataImpl);
    }

    protected void endDBContext() {
        if (cmda != null) {
            cmda.endContext();
        }
    }

    private boolean doesIndexExists(Connection connection, String string) {
        if (this.usingDB2) {
            if (this.usingAS400DB2) {
                return this.doesIndexExistsiSeries(connection, string);
            }
            return this.doesIndexExistsDistributed(connection, string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doesIndexExistsDistributed(Connection var1_1, String var2_2) {
        block23: {
            if (BackedHashtable.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)BackedHashtable.tc, (String)"doesIndexExistsDistributed ");
            }
            var3_3 = false;
            var4_4 = false;
            var5_5 = this.tableName;
            var6_6 = null;
            var7_7 = null;
            var8_8 = null;
            var9_9 = null;
            var10_10 = null;
            var11_11 = null;
            var5_5 = var5_5.toUpperCase();
            if (this.dbid != null) {
                var6_6 = this.dbid.toUpperCase();
            }
            var8_8 = "select ColNames from syscat.indexes where IndName = '" + var2_2.toUpperCase() + "' and " + "TabName = '" + var5_5 + "' and UniqueRule = 'U'";
            if (var6_6 != null) {
                var8_8 = var8_8 + " and tabschema = '" + var6_6 + "'";
            }
            var8_8 = var8_8 + " for read only";
            if (BackedHashtable.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)BackedHashtable.tc, (String)("Sql: " + var8_8));
            }
            try {
                var10_10 = var1_1.prepareStatement(var8_8);
                var11_11 = var10_10.executeQuery();
                if (var11_11.next()) {
                    var7_7 = var11_11.getString(1);
                    var3_3 = true;
                    if (var7_7 != null) {
                        if (BackedHashtable.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)BackedHashtable.tc, (String)var7_7);
                        }
                        if (var7_7.indexOf("id".toUpperCase()) != -1) {
                            if (BackedHashtable.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)BackedHashtable.tc, (String)"id exists");
                            }
                            if (var7_7.indexOf("propid".toUpperCase()) != -1) {
                                if (BackedHashtable.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)BackedHashtable.tc, (String)"propid exists");
                                }
                                if (var7_7.indexOf("appname".toUpperCase()) != -1) {
                                    if (BackedHashtable.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)BackedHashtable.tc, (String)"appname exists");
                                    }
                                    var4_4 = true;
                                }
                            }
                        }
                        if (!var4_4) {
                            Tr.warning((TraceComponent)BackedHashtable.tc, (String)"It appears that the session index in your table was created outside of websphere.  If the index is dropped and server restarted websphere application server will recreate the index");
                        }
                    }
                }
                if (var11_11 == null) break block23;
            }
            catch (Throwable var12_12) {
                block24: {
                    try {
                        Tr.error((TraceComponent)BackedHashtable.tc, (String)"SessionContext.exception", (Object)var12_12);
                        if (var11_11 == null) break block24;
                    }
                    catch (Throwable var13_13) {
                        if (var11_11 != null) {
                            BackedHashtable.closeResultSet(var11_11);
                        }
                        if (var10_10 != null) {
                            BackedHashtable.closeStatement(var10_10);
                        }
                        throw var13_13;
                    }
                    BackedHashtable.closeResultSet(var11_11);
                }
                if (var10_10 != null) {
                    BackedHashtable.closeStatement(var10_10);
                } else {
                    ** GOTO lbl63
                }
            }
            BackedHashtable.closeResultSet(var11_11);
        }
        if (var10_10 != null) {
            BackedHashtable.closeStatement(var10_10);
        }
        if (BackedHashtable.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)BackedHashtable.tc, (String)("doesIndexExistsDistributed " + var3_3));
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doesIndexExistsiSeries(Connection var1_1, String var2_2) {
        block33: {
            if (BackedHashtable.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)BackedHashtable.tc, (String)"doesIndexExistsiSeries ");
            }
            var3_3 = false;
            var4_4 = null;
            var5_5 = null;
            var6_6 = "SESSIONS";
            var7_7 = null;
            var8_8 = null;
            var9_9 = null;
            var10_10 = null;
            var11_11 = null;
            var12_12 = ".";
            var13_13 = null;
            var14_14 = null;
            var15_15 = null;
            var16_16 = null;
            var17_17 = 0;
            var4_4 = "QSYS2".concat(var12_12).concat("sysindexes");
            var5_5 = "QSYS2".concat(var12_12).concat("syskeys");
            var8_8 = "select index_name from " + var4_4 + " where Index_Name = '" + var2_2.toUpperCase() + "' and " + "Table_Name = '" + var6_6 + "' and IS_UNIQUE = 'U'";
            var9_9 = "select COLUMN_NAME from " + var5_5 + " where INDEX_NAME = '" + var2_2.toUpperCase() + "'";
            if (this.collectionName != null) {
                var8_8 = var8_8 + " and table_schema = '" + this.collectionName.toUpperCase() + "'";
                var9_9 = var9_9 + " and index_schema = '" + this.collectionName.toUpperCase() + "'";
            }
            var8_8 = var8_8 + " for read only";
            var9_9 = var9_9 + " for read only";
            if (BackedHashtable.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)BackedHashtable.tc, (String)("sqlQueryIndex: " + var8_8));
                Tr.debug((TraceComponent)BackedHashtable.tc, (String)("sqlQueryCol: " + var9_9));
            }
            try {
                var13_13 = var1_1.prepareStatement(var8_8);
                var15_15 = var13_13.executeQuery();
                if (var15_15.next()) {
                    var10_10 = var15_15.getString(1);
                    if (var10_10 != null) {
                        if (BackedHashtable.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)BackedHashtable.tc, (String)("returnIndexName: " + var10_10));
                        }
                        if (var10_10.indexOf(var2_2.toUpperCase()) != -1) {
                            if (BackedHashtable.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)BackedHashtable.tc, (String)("index: " + var10_10 + " exists"));
                            }
                            var3_3 = true;
                        } else if (BackedHashtable.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)BackedHashtable.tc, (String)("index: " + var10_10 + " does not exist"));
                        }
                    }
                } else {
                    Tr.debug((TraceComponent)BackedHashtable.tc, (String)"ResultSet is null");
                }
                if (var15_15 == null) break block33;
            }
            catch (Throwable var18_18) {
                block34: {
                    try {
                        Tr.error((TraceComponent)BackedHashtable.tc, (String)"SessionContext.exception", (Object)var18_18);
                        if (var15_15 == null) break block34;
                    }
                    catch (Throwable var19_21) {
                        if (var15_15 != null) {
                            BackedHashtable.closeResultSet(var15_15);
                        }
                        if (var13_13 != null) {
                            BackedHashtable.closeStatement(var13_13);
                        }
                        throw var19_21;
                    }
                    BackedHashtable.closeResultSet(var15_15);
                }
                if (var13_13 != null) {
                    BackedHashtable.closeStatement(var13_13);
                } else {
                    ** GOTO lbl68
                }
            }
            BackedHashtable.closeResultSet(var15_15);
        }
        if (var13_13 != null) {
            BackedHashtable.closeStatement(var13_13);
        }
        if (var3_3) {
            block35: {
                try {
                    var14_14 = var1_1.prepareStatement(var9_9);
                    var16_16 = var14_14.executeQuery();
                    while (var16_16.next()) {
                        var18_19 = var16_16.getString(1);
                        if (var18_19 == null) continue;
                        if (BackedHashtable.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)BackedHashtable.tc, (String)("extractedColumn : " + var18_19));
                        }
                        if (var18_19.indexOf("id".toUpperCase()) == -1 && var18_19.indexOf("propid".toUpperCase()) == -1 && var18_19.indexOf("appname".toUpperCase()) == -1) continue;
                        if (BackedHashtable.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)BackedHashtable.tc, (String)("column is found : " + var18_19));
                        }
                        ++var17_17;
                    }
                    if (var17_17 < 3) {
                        Tr.warning((TraceComponent)BackedHashtable.tc, (String)"It appears that the session index in your table was created outside of websphere.  If the index is dropped and server restarted websphere application server will recreate the index");
                    }
                    if (var16_16 == null) break block35;
                }
                catch (Throwable var18_20) {
                    block36: {
                        try {
                            Tr.error((TraceComponent)BackedHashtable.tc, (String)"SessionContext.exception", (Object)var18_20);
                            if (var16_16 == null) break block36;
                        }
                        catch (Throwable var20_22) {
                            if (var16_16 != null) {
                                BackedHashtable.closeResultSet(var16_16);
                            }
                            if (var14_14 != null) {
                                BackedHashtable.closeStatement(var14_14);
                            }
                            throw var20_22;
                        }
                        BackedHashtable.closeResultSet(var16_16);
                    }
                    if (var14_14 != null) {
                        BackedHashtable.closeStatement(var14_14);
                    } else {
                        ** GOTO lbl106
                    }
                }
                BackedHashtable.closeResultSet(var16_16);
            }
            if (var14_14 != null) {
                BackedHashtable.closeStatement(var14_14);
            }
        }
        if (BackedHashtable.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)BackedHashtable.tc, (String)("doesIndexExists_iSeries " + var3_3));
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean isTableMarkedVolatile(Connection var1_1) {
        block14: {
            if (BackedHashtable.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)BackedHashtable.tc, (String)"isTableMarkedVolatile ");
            }
            var2_2 = false;
            var3_3 = this.tableName;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            var3_3 = var3_3.toUpperCase();
            if (this.dbid != null) {
                var4_4 = this.dbid.toUpperCase();
            }
            var5_5 = "select 1 from syscat.tables where TabName = '" + var3_3 + "' and Volatile = 'C' ";
            if (var4_4 != null) {
                var5_5 = var5_5 + " and tabschema = '" + var4_4 + "'";
            }
            var5_5 = var5_5 + " for read only";
            if (BackedHashtable.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)BackedHashtable.tc, (String)("Sql: " + var5_5));
            }
            try {
                var6_6 = var1_1.prepareStatement(var5_5);
                var7_7 = var6_6.executeQuery();
                if (var7_7.next()) {
                    var2_2 = true;
                }
                if (var7_7 == null) break block14;
            }
            catch (Throwable var8_8) {
                block15: {
                    try {
                        Tr.error((TraceComponent)BackedHashtable.tc, (String)"SessionContext.exception", (Object)var8_8);
                        if (var7_7 == null) break block15;
                    }
                    catch (Throwable var9_9) {
                        if (var7_7 != null) {
                            BackedHashtable.closeResultSet(var7_7);
                        }
                        if (var6_6 != null) {
                            BackedHashtable.closeStatement(var6_6);
                        }
                        throw var9_9;
                    }
                    BackedHashtable.closeResultSet(var7_7);
                }
                if (var6_6 != null) {
                    BackedHashtable.closeStatement(var6_6);
                } else {
                    ** GOTO lbl44
                }
            }
            BackedHashtable.closeResultSet(var7_7);
        }
        if (var6_6 != null) {
            BackedHashtable.closeStatement(var6_6);
        }
        if (BackedHashtable.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)BackedHashtable.tc, (String)("isTableMarkedVolatile " + var2_2));
        }
        return var2_2;
    }

    static {
        checkRecentlyInvalidList = HttpSessionSystemProperties.isUseRecentInvalidId();
    }
}

