/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DBPortability {
    public static int UNKNOWN = 0;
    public static int DB2_NT = 1;
    public static int DB2_AS400 = 2;
    public static int INSTANTDB = 3;
    public static int DB2_AIX = 1;
    public static int DB2_SUN = 1;
    public static int DB2_HPUX = 1;
    public static int ORACLE = 4;
    public static int SYBASE = 5;
    public static int DB2_CONNECT = 6;
    public static int MICROSOFT_SQLSERVER = 7;
    public static int INFORMIX = 8;
    public static int CLOUDSCAPE = 9;
    public static int DB2_zOS = 10;

    public static int getDBCode(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getDatabaseProductName();
        if (string.toUpperCase().indexOf("INSTANTDB") != -1) {
            return INSTANTDB;
        }
        if (string.toUpperCase().indexOf("DB2/NT") != -1) {
            return DB2_NT;
        }
        if (string.toUpperCase().indexOf("DB2/SUN") != -1) {
            return DB2_SUN;
        }
        if (string.toUpperCase().indexOf("DB2/6000") != -1) {
            return DB2_AIX;
        }
        if (string.toUpperCase().indexOf("DB2/HPUX") != -1) {
            return DB2_HPUX;
        }
        if (string.toUpperCase().indexOf("DB2 UDB FOR AS/400") != -1 || string.toUpperCase().indexOf("DB2/400 SQL") != -1 || string.toUpperCase().indexOf("DB2 UDB for eServer iSeries") != -1) {
            return DB2_AS400;
        }
        if (string.toUpperCase().indexOf("DB2/LINUX") != -1) {
            return DB2_SUN;
        }
        if (string.toUpperCase().indexOf("ORACLE") != -1) {
            return ORACLE;
        }
        if (string.toUpperCase().indexOf("SYBASE SQL SERVER") != -1 || string.toUpperCase().indexOf("ADAPTIVE SERVER ENTERPRISE") != -1) {
            return SYBASE;
        }
        if (string.toUpperCase().trim().equals("DB2")) {
            String string2 = databaseMetaData.getDatabaseProductVersion();
            if (string2.toUpperCase().indexOf("DSN") != -1) {
                return DB2_zOS;
            }
            return DB2_CONNECT;
        }
        if (string.toUpperCase().indexOf("MICROSOFT") != -1) {
            return MICROSOFT_SQLSERVER;
        }
        if (string.toUpperCase().indexOf("INFORMIX") != -1) {
            return INFORMIX;
        }
        if (string.toUpperCase().indexOf("CLOUDSCAPE") != -1 || string.toUpperCase().indexOf("DB2J") != -1) {
            return CLOUDSCAPE;
        }
        if (string.toUpperCase().indexOf("DSN") != -1) {
            return DB2_zOS;
        }
        return DB2_NT;
    }

    public static void processCreateTableException(SQLException sQLException, String string, int n) throws SQLException {
        String string2 = null;
        if ((n == DB2_NT || n == DB2_AS400 || n == DB2_CONNECT) && sQLException.getErrorCode() == -601) {
            string2 = "Table " + string + " already exists";
        } else if (n == ORACLE && sQLException.getErrorCode() == 955) {
            string2 = "Table " + string + " already exists";
        } else if (n == ORACLE && sQLException.getErrorCode() == 2260) {
            string2 = "Table " + string + " already exists";
        } else if (n == INSTANTDB && sQLException.toString().indexOf("Table already exists") >= 0) {
            string2 = "Table " + string + " already exists";
        } else if (n == SYBASE && sQLException.getErrorCode() == 2714) {
            string2 = "Table " + string + " already exists";
        }
        throw sQLException;
    }

    public static boolean isTableAlreadyExistsException(SQLException sQLException, int n) {
        return n == CLOUDSCAPE && sQLException.getMessage().toUpperCase().indexOf("ALREADY EXISTS IN SCHEMA") != -1;
    }
}

