/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.httpsession.BackedHashtable;
import com.ibm.ws.webcontainer.httpsession.DRSSessionContext;
import com.ibm.ws.webcontainer.httpsession.DRSSessionData;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionData;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSBuffWrapper;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSDataXfer;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.DataSource;

public class DRSBackedHashtable
extends BackedHashtable {
    String drsCacheInstKey = null;
    HttpSessDRSDataXfer ddx = null;
    private static final long serialVersionUID = -566141849357848187L;

    DRSBackedHashtable(DRSSessionContext dRSSessionContext, SessionContextParameters sessionContextParameters) {
        super(dRSSessionContext, sessionContextParameters);
        this.drsCacheInstKey = dRSSessionContext.drsCacheInstKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseSessionData readFromExternal(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:readFromExternal");
        }
        DatabaseSessionData databaseSessionData = null;
        long l = System.currentTimeMillis();
        Object object2 = this.ddx.getEntry(string + this.bhSessionContext.getAppName());
        if (object2 != null) {
            this.ddx.removeLocalEntry(string + this.bhSessionContext.getAppName());
            this.ddx.createEntry(string + this.bhSessionContext.getAppName(), object2);
        }
        if (this.ddx.shouldConvBytes2Obj(object2)) {
            object = HttpSessDRSBuffWrapper.getByteStream(object2);
            this.bhSessionContext.scPmiData.readTimes(((ByteArrayInputStream)object).available(), System.currentTimeMillis() - l);
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream((InputStream)object);
                object2 = HttpSessDRSBuffWrapper.convBytes2Obj(objectInputStream, this.bhSessionContext);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DRSBackedHashtable.selectAndLock", (String)"91", (Object)this);
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (object != null) {
                        ((ByteArrayInputStream)object).close();
                    }
                }
                catch (Throwable throwable) {}
            }
        } else {
            this.bhSessionContext.scPmiData.readTimes(-1L, System.currentTimeMillis() - l);
        }
        databaseSessionData = (DatabaseSessionData)object2;
        if (databaseSessionData != null) {
            object = (DRSSessionData)databaseSessionData;
            ((DRSSessionData)object).ddx = this.ddx;
            ((DRSSessionData)object).mManager = this.bhSessionContext;
            ((DRSSessionData)object).mManagerDB = this.bhSessionContext;
        }
        return databaseSessionData;
    }

    int overQualLastAccessTimeUpdate(DatabaseSessionData databaseSessionData, long l) {
        databaseSessionData.setLastAccessedTime(l);
        databaseSessionData.setActive(true, l - databaseSessionData.getLastAccTime());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DRSBackedHashtable.overQualLastAccessTimeUpdate: updated lastaccesstime in m2m mode");
        }
        return 1;
    }

    int updateLastAccessTime(DatabaseSessionData databaseSessionData, long l) {
        this.ddx.updateEntryProp(databaseSessionData.getId() + databaseSessionData.appName, new Long(l), null);
        return 1;
    }

    void initConnPool(SessionContextParameters sessionContextParameters) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:initConnPool");
        }
    }

    DataSource getDataSource() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:getDataSource");
        }
        return null;
    }

    boolean isPresent(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:isPresent(String)");
        }
        boolean bl = false;
        if (this.isPresentInRecentlyInvalidatedList(string)) {
            bl = true;
        }
        if (!bl && this.ddx.entryIDExists(string, true)) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DRSBackedHashtable.isPresent --- session id exists : " + bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSBackedHashtable:isPresent(String)");
        }
        return bl;
    }

    void handleAsyncUpdates(Connection connection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:handleAsyncUpdates");
        }
        Hashtable hashtable = (Hashtable)this.asyncUps.clone();
        this.asyncUps.clear();
        Enumeration enumeration = hashtable.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            SessionData sessionData = (SessionData)this.superGet(string);
            if (sessionData == null) continue;
            this.ddx.updateEntryProp(sessionData.getId() + sessionData.appName, new Long(sessionData.getLastAccTime()), null);
        }
    }

    DatabaseSessionData updateCachedLastAccess(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:updateCacheLastAccess");
        }
        return databaseSessionData;
    }

    void removeSessions(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:removeSessions");
        }
        String string = databaseSessionData.getId();
        this.ddx.removeEntry(string + databaseSessionData.appName);
        this.addToRecentlyInvalidatedList(databaseSessionData.getId());
    }

    byte[] commonSetup(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:commonSetup");
        }
        return null;
    }

    void handlePropertyHits(DatabaseSessionData databaseSessionData, Thread thread) {
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:handlePropertyHits");
        }
        String string = "DRSBackedHashtable:handlePropertyHits: ";
        boolean bl = false;
        Hashtable hashtable2 = null;
        if (this.bhSessionContext.WriteAllProperties) {
            hashtable2 = new Hashtable(databaseSessionData.getSwappableData());
        } else if (databaseSessionData.appDataChanges != null && !databaseSessionData.appDataChanges.isEmpty()) {
            hashtable2 = this.bhSessionContext.usingMultirow ? (hashtable = (Hashtable)databaseSessionData.appDataChanges.get(thread)) : databaseSessionData.appDataChanges;
        }
        if (hashtable2 != null) {
            long l = System.currentTimeMillis();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable2.get(k);
                if (v instanceof byte[]) continue;
                HttpSessDRSBuffWrapper httpSessDRSBuffWrapper = null;
                try {
                    httpSessDRSBuffWrapper = new HttpSessDRSBuffWrapper();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                boolean bl2 = httpSessDRSBuffWrapper.storeObject(v);
                if (bl2) {
                    hashtable2.put(k, httpSessDRSBuffWrapper);
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)(string + "Failed to replicate attribute " + k + ":" + v));
                hashtable2.remove(k);
            }
            this.ddx.updateEntryProp(databaseSessionData.getId() + databaseSessionData.appName, new Long(databaseSessionData.getLastAccTime()), hashtable2);
            bl = true;
            this.bhSessionContext.scPmiData.writeTimes(-1L, System.currentTimeMillis() - l);
        }
        hashtable2 = null;
        if (databaseSessionData.appDataRemovals != null && !databaseSessionData.appDataRemovals.isEmpty() && (hashtable2 = this.bhSessionContext.usingMultirow ? (hashtable = (Hashtable)databaseSessionData.appDataRemovals.get(thread)) : databaseSessionData.appDataRemovals) != null) {
            long l = System.currentTimeMillis();
            this.ddx.removeEntryProp(databaseSessionData.getId() + databaseSessionData.appName, new Long(databaseSessionData.getLastAccTime()), hashtable2);
            bl = true;
            this.bhSessionContext.scPmiData.writeTimes(-1L, System.currentTimeMillis() - l);
        }
        if (!bl) {
            this.ddx.updateEntryProp(databaseSessionData.getId() + databaseSessionData.appName, new Long(databaseSessionData.getLastAccTime()), null);
        }
    }

    protected boolean persistSession(DatabaseSessionData databaseSessionData, boolean bl) {
        Object object;
        if (databaseSessionData.listenCntHit || databaseSessionData.maxInactWriteHit || databaseSessionData.userWriteHit) {
            object = new Hashtable();
            if (databaseSessionData.listenCntHit) {
                ((Hashtable)object).put("JMSSD-List", new Short(databaseSessionData.listenerCnt));
            }
            if (databaseSessionData.maxInactWriteHit) {
                ((Hashtable)object).put("JMSSD-MaxInact", new Integer(databaseSessionData.getMaxInactiveInterval()));
            }
            if (databaseSessionData.userWriteHit) {
                ((Hashtable)object).put("JMSSD-User", databaseSessionData.getUserName());
            }
            long l = System.currentTimeMillis();
            this.ddx.updateEntry(databaseSessionData.getId() + databaseSessionData.appName, object);
            this.bhSessionContext.scPmiData.writeTimes(databaseSessionData.getUserName().length() + 6, System.currentTimeMillis() - l);
        }
        object = Thread.currentThread();
        this.handlePropertyHits(databaseSessionData, (Thread)object);
        return true;
    }

    public void ejbCreate(DatabaseSessionData databaseSessionData, boolean bl) {
        this.ejbCreate(databaseSessionData);
    }

    public void ejbCreate(DatabaseSessionData databaseSessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:ejbCreate");
        }
        String string = databaseSessionData.getId() + databaseSessionData.appName;
        this.listenerCntAppend(databaseSessionData);
        this.ddx.createEntry(string, databaseSessionData);
        databaseSessionData.insertSession = false;
        databaseSessionData.syncFromServlet = false;
        databaseSessionData.userWriteHit = false;
        databaseSessionData.maxInactWriteHit = false;
        databaseSessionData.listenCntHit = false;
        if (databaseSessionData.appDataChanges != null) {
            databaseSessionData.appDataChanges.clear();
        }
        if (databaseSessionData.appDataRemovals != null) {
            databaseSessionData.appDataRemovals.clear();
        }
        this.removeFromRecentlyInvalidatedList(databaseSessionData.getId());
    }

    void reload(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSBackedHashtable:reload");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("hashCode : ").append(this.hashCode());
        return stringBuffer.toString();
    }

    protected boolean checkCacheHit(DatabaseSessionData databaseSessionData) {
        Long l = (Long)this.ddx.getEntryProp(databaseSessionData.getId() + this.bhSessionContext.getAppName(), "gla");
        if (l != null) {
            return l.longValue() == databaseSessionData.getLastAccTime();
        }
        return true;
    }

    Object superRemove(Object object) {
        Object object2 = super.superRemove(object);
        if (object2 != null) {
            this.ddx.removeLocalSession(object2);
        }
        return object2;
    }

    Object superPut(Object object, Object object2) {
        Object object3 = super.superPut(object, object2);
        if (object3 != null) {
            this.ddx.removeLocalSession(object3);
        }
        return object3;
    }
}

