/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.multibroker.drsclient.DRSRuntimeMode;
import com.ibm.ws.drs.DRSDataXferImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.httpsession.BackedHashtable;
import com.ibm.ws.webcontainer.httpsession.DRSBackedHashtable;
import com.ibm.ws.webcontainer.httpsession.DRSListenerScan;
import com.ibm.ws.webcontainer.httpsession.DRSSessionData;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionData;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSBootstrap;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSCacheMsgListener;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSDataXfer;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSVars;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistry;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import com.ibm.ws.webcontainer.httpsession.ws390.HttpSessionPlatformHelper;
import com.ibm.ws.webcontainer.httpsession.ws390.SessionContextGroupInstanceFactoryImpl;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class DRSSessionContext
extends DatabaseSessionContext
implements HAGroupCallback {
    String drsCacheInstKey = null;
    HttpSessDRSDataXfer ddx = null;
    HttpSessDRSVars hsdv = null;
    boolean isPrimaryInval = false;
    private static HashMap HAGroupTable = new HashMap();
    int drsMode = -1;
    String drsModeString = "Undefined";

    public DRSSessionContext(SessionContextParameters sessionContextParameters, SessionApplicationParameters sessionApplicationParameters, String string, DRSSettings dRSSettings, SessionMgrComponentImpl sessionMgrComponentImpl) {
        super(sessionContextParameters, sessionApplicationParameters);
        this.drsCacheInstKey = string;
        HttpSessDRSVars httpSessDRSVars = new HttpSessDRSVars();
        HttpSessDRSCacheMsgListener httpSessDRSCacheMsgListener = new HttpSessDRSCacheMsgListener(httpSessDRSVars);
        httpSessDRSVars.dcml = httpSessDRSCacheMsgListener;
        HttpSessDRSBootstrap httpSessDRSBootstrap = new HttpSessDRSBootstrap(httpSessDRSVars);
        httpSessDRSVars.ddx = this.ddx = new HttpSessDRSDataXfer(httpSessDRSVars);
        httpSessDRSVars.drss = dRSSettings;
        this.hsdv = httpSessDRSVars;
        DRSDataXfer dRSDataXfer = sessionMgrComponentImpl.getDRSDataXfer(dRSSettings.getMessageBrokerDomainName(), string, httpSessDRSCacheMsgListener, httpSessDRSBootstrap, dRSSettings);
        this.ddx.setBaseDataXfer(dRSDataXfer);
        this.setDRSMode();
    }

    public DRSSessionContext(SessionContextParameters sessionContextParameters, SessionApplicationParameters sessionApplicationParameters, String string, Object object) {
        super(sessionContextParameters, sessionApplicationParameters);
        this.drsCacheInstKey = string;
        this.hsdv = (HttpSessDRSVars)object;
        this.ddx = this.hsdv.ddx;
        this.setDRSMode();
    }

    public DRSSessionContext(String string, Object object) {
        super(null, null);
        this.drsCacheInstKey = string;
        this.hsdv = (HttpSessDRSVars)object;
        this.ddx = this.hsdv.ddx;
    }

    private void setDRSMode() {
        DRSSettings dRSSettings = this.hsdv.drss;
        DRSRuntimeMode dRSRuntimeMode = dRSSettings.getDataReplicationMode();
        this.drsMode = dRSRuntimeMode.getValue();
        if (this.drsMode == 0) {
            this.drsModeString = "BOTH";
        }
        if (this.drsMode == 2) {
            this.drsModeString = "SERVER";
        }
        if (this.drsMode == 1) {
            this.drsModeString = "CLIENT";
        }
        Tr.info((TraceComponent)tc, (String)("DRSSessionContext for application " + this.getAppName() + " running in mode " + this.drsModeString));
    }

    private HAGroup joinGroup(SessionMgrComponentImpl sessionMgrComponentImpl, HashMap hashMap, HAGroupCallback hAGroupCallback) {
        HAGroup hAGroup = null;
        hAGroup = HttpSessionPlatformHelper.isZOS() ? SessionContextGroupInstanceFactoryImpl.createInstance(sessionMgrComponentImpl).createSessionContextGroup(hashMap, hAGroupCallback) : sessionMgrComponentImpl.joinHAGroup(hashMap, hAGroupCallback);
        return hAGroup;
    }

    protected void joinHAMGroup(SessionMgrComponentImpl sessionMgrComponentImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:joinHAMGroup");
        }
        DRSSettings dRSSettings = this.hsdv.drss;
        DRSRuntimeMode dRSRuntimeMode = dRSSettings.getDataReplicationMode();
        int n = dRSRuntimeMode.getValue();
        String string = this.getAppName();
        if (n != 2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = dRSSettings.getMessageBrokerDomainName();
            hashMap.put("RepDomainName", string2);
            hashMap.put("WMContextRoot", string);
            hashMap.put("policy", "DefaultNoQuorumOneOfNPolicy");
            HAGroup hAGroup = this.joinGroup(sessionMgrComponentImpl, hashMap, this);
            if (hAGroup != null) {
                HAGroupTable.put(string, hAGroup);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebModule " + string + " not joining the group since it is running in server-only mode"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext:joinHAMGroup");
        }
    }

    BackedHashtable createBackedHashtable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:createBackedHashtable");
        }
        DRSBackedHashtable dRSBackedHashtable = new DRSBackedHashtable(this, this.mParams);
        dRSBackedHashtable.ddx = this.ddx;
        return dRSBackedHashtable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    IHttpSession createSessionData(String string) {
        return new DRSSessionData(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performInvalidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:performInvalidation");
        }
        if (this.asyncUpd) {
            ((DRSBackedHashtable)this.mSessions).handleAsyncUpdates(null);
        }
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.cleanUpCache(l);
        if (!this.doInval()) {
            return;
        }
        if (this.isPrimaryInval) {
            Serializable serializable;
            ArrayList arrayList;
            String string = this.getAppName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.performInvalidation: primary invalidator for " + string));
            }
            if ((arrayList = (ArrayList)this.hsdv.localDeletes.get(string)) == null) {
                arrayList = new ArrayList();
                serializable = this.hsdv.localDeletes;
                synchronized (serializable) {
                    this.hsdv.localDeletes.put(string, arrayList);
                }
            }
            serializable = arrayList;
            synchronized (serializable) {
                arrayList.clear();
            }
            if (this.drsMode == 0) {
                this.invalSessBackup(l, arrayList);
            }
            serializable = new DRSListenerScan();
            ((DRSListenerScan)serializable).appname = string;
            ((DRSListenerScan)serializable).lastaccess = l;
            this.ddx.broadcast(serializable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext:performInvalidation");
        }
    }

    public boolean isAlive(GroupName groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:isAlive.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DRSSessionContext has been called for the isAlive operation for " + groupName.getGroupProperties()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext:isAlive.");
        }
        return true;
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:memberDeactivate.");
        }
        this.isPrimaryInval = false;
        Tr.info((TraceComponent)tc, (String)("DRSSessionContext:memberDeactivate - no longer primary invalidator for " + this.getAppName()));
        if (!HttpSessionPlatformHelper.isZOS()) {
            try {
                asynchOperationComplete.success(object, null);
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                hAParameterRejectedException.printStackTrace();
                FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContextRegistry.remove", (String)"226", null);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DRSSessionContext has been deactivated for " + groupName.getGroupProperties()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext:memberDeactivate.");
        }
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:memberIsActivated.");
        }
        this.isPrimaryInval = true;
        Tr.info((TraceComponent)tc, (String)("DRSSessionContext:memberIsActivated - elected primary invalidator for " + this.getAppName()));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebModule " + this.getAppName() + " has been selected for performing the listener invalidation."));
        }
        if (!HttpSessionPlatformHelper.isZOS()) {
            try {
                asynchOperationComplete.success(object, null);
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                hAParameterRejectedException.printStackTrace();
                FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContextRegistry.remove", (String)"286", null);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DRSSessionContext has been activated for " + groupName.getGroupProperties()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext:memberIsActivated.");
        }
    }

    public void memberMayActivate(GroupName groupName) {
    }

    public void memberMayActivateCancelled(GroupName groupName) {
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalSessBackup(long l, ArrayList arrayList) {
        DRSListenerScan dRSListenerScan;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DRSSessionContext:invalSessBackup cache size is " + this.hsdv.cache.size()));
        }
        String string = this.getAppName();
        Iterator iterator = null;
        HashMap<DRSListenerScan, DRSListenerScan> hashMap = null;
        HashMap hashMap2 = (HashMap)this.hsdv.invalidationMap.get(string);
        if (hashMap2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("DRSSessionContext.invalSessBackup - no sessions for webapp " + string));
            }
            return;
        }
        Cloneable cloneable = hashMap2;
        synchronized (cloneable) {
            iterator = hashMap2.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                dRSListenerScan = (DRSListenerScan)object.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.invalSessBackup checking webapp " + string + " and sess " + dRSListenerScan.id));
                }
                if (dRSListenerScan.timeout == -1 || dRSListenerScan.lastaccess >= l - 1000L * (long)dRSListenerScan.timeout) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.invalSessBackup found timed out session for webapp " + string + " and sess " + dRSListenerScan.id));
                }
                if (hashMap == null) {
                    hashMap = new HashMap<DRSListenerScan, DRSListenerScan>();
                }
                hashMap.put(dRSListenerScan, dRSListenerScan);
            }
        }
        if (hashMap == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("DRSSessionContext.invalSessBackup - no timed out sessions for webapp " + string));
            }
            return;
        }
        cloneable = null;
        object = null;
        dRSListenerScan = null;
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                dRSListenerScan = (DRSListenerScan)((Object)iterator.next());
                object = (DRSSessionData)this.hsdv.cache.get(dRSListenerScan.id + dRSListenerScan.appname);
                if (arrayList.contains(dRSListenerScan.id) || object == null || ((SessionData)object).getLastAccTime() != dRSListenerScan.lastaccess) continue;
                if (dRSListenerScan.listener) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.invalSessBackups invalidating listener sess " + dRSListenerScan.id + " for webapp " + string));
                    }
                    ((DRSSessionData)object).initSession(this);
                    ((DRSSessionData)object).internalInvalidate();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.invalSessBackups invalidating non-listener sess " + dRSListenerScan.id + " for webapp " + string));
                    }
                    this.hsdv.ddx.removeLocalEntry(dRSListenerScan.id + dRSListenerScan.appname);
                    if (cloneable == null) {
                        cloneable = new ArrayList();
                    }
                    ((ArrayList)cloneable).add(dRSListenerScan.id + dRSListenerScan.appname);
                    this.incInvalidatedByTimeout();
                }
                arrayList.add(dRSListenerScan.id);
            }
        }
        if (cloneable != null) {
            this.hsdv.ddx.renounceEntries((ArrayList)cloneable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DRSSessionContext:invalSessBackup cache size is " + this.hsdv.cache.size()));
        }
    }

    void stopSessionContext(String string) {
        HAGroup hAGroup;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext:stopSessionContext.");
        }
        super.stopSessionContext(string);
        SessionContextParameters sessionContextParameters = this.getSessionContextParameters();
        if (!sessionContextParameters.usingWebContainerSM && this._refCount <= 0) {
            if (is_zOS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Shutting down zinstance " + this.getAppName()));
                }
                this.ddx.baseDDX.shutdownInstance();
            } else {
                string2 = (DRSDataXferImpl)this.ddx.baseDDX;
                hAGroup = string2.getInstance();
                if (hAGroup != null && !hAGroup.isInstanceShuttingDown()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Shutting down instance : " + this.getAppName() + ", " + string2.getInstanceName() + ", " + string2.getInstanceId()));
                    }
                    string2.shutdownInstance();
                }
            }
        }
        string2 = this.getAppName();
        hAGroup = (HAGroup)HAGroupTable.remove(string2);
        try {
            if (hAGroup != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WebModule " + string2 + " is leaving the group"));
                }
                hAGroup.leave();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContextRegistry.remove", (String)"389", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext:stopSessionContext.");
        }
    }

    public void remoteInvalidate(String string, boolean bl) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DRSSessionContext.remoteInvalidate for app " + this.getAppName() + " id " + string + " drsMode " + this.drsModeString));
        }
        this.remoteInvalReceived = true;
        String string2 = string + this.getAppName();
        if (this.drsMode == 1 || this.drsMode == 0) {
            serializable = new Vector<String>(1);
            ((Vector)serializable).add(string);
            this.handleDiscardedCacheItems(((Vector)serializable).elements());
            this.hsdv.localSessions.remove(string2);
        }
        if (this.drsMode == 2 || this.drsMode == 0) {
            serializable = (DRSSessionData)this.hsdv.cache.get(string2);
            if (serializable != null) {
                ((DatabaseSessionData)serializable).setMaxInactiveInterval(0);
                ((HttpSessDRSCacheMsgListener)this.hsdv.dcml).updateListMap((DRSSessionData)serializable);
            }
            this.hsdv.localSessions.remove(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DRSSessionContext.remoteInvalidate for app " + this.getAppName() + " id " + string + " drsMode " + this.drsModeString));
        }
    }

    void processDRSServerOnly(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DRSSessionContext.processDRSServerOnly for session id " + string));
        }
        HttpSessDRSVars httpSessDRSVars = (HttpSessDRSVars)SessionContextRegistry.getServerDRSInstance();
        Set set = httpSessDRSVars.invalidationMap.keySet();
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            HashMap hashMap;
            Object v;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.processDRSServerOnly checking app " + objectArray[i]));
            }
            if ((v = (hashMap = (HashMap)httpSessDRSVars.invalidationMap.get((String)objectArray[i])).get(string)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.processDRSServerOnly found dls object for session " + string + " and app " + objectArray[i]));
            }
            ((DRSListenerScan)v).timeout = 0;
            DRSSessionData dRSSessionData = (DRSSessionData)httpSessDRSVars.cache.get(string + objectArray[i]);
            if (dRSSessionData != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DRSSessionContext.processDRSServerOnly found session object for session " + string + " and app " + objectArray[i]));
                }
                dRSSessionData.setMaxInactiveInterval(0);
            }
            httpSessDRSVars.localSessions.remove(string + objectArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DRSSessionContext.processDRSServerOnly for session id " + string));
        }
    }

    void updateCloneInfo(SessionData sessionData, String string, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DRSSessionContext.updateCloneInfo");
        }
        DRSSettings dRSSettings = this.hsdv.drss;
        DRSRuntimeMode dRSRuntimeMode = dRSSettings.getDataReplicationMode();
        if (tc.isDebugEnabled()) {
            if (this.mParams.isUsingWebContainerSM()) {
                Tr.debug((TraceComponent)tc, (String)"Using m2m at server level");
            } else {
                Tr.debug((TraceComponent)tc, (String)"Using m2m at app level");
            }
            Tr.debug((TraceComponent)tc, (String)("Id: " + sessionData.getId() + ", CloneInfo: " + string + ", newSession: " + bl));
        }
        if (dRSRuntimeMode.getValue() == 0 && !cloneIdPropertySet && this.mParams.isUsingWebContainerSM() && !is_zOS) {
            long l;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using partition id");
            }
            if ((l = this.ddx.getPartition(sessionData.getId() + this.getAppName())) == -1L) {
                super.updateCloneInfo(sessionData, string, bl, bl2);
                return;
            }
            String string2 = EncodeCloneID.encodeLong(l).toUpperCase();
            string2 = this.getCloneSeparator() + string2;
            if (string == null) {
                sessionData.setPreviousClones(string2);
                sessionData.setCloneIdUpdated(true);
            } else {
                int n = string.indexOf(string2);
                if (n == -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string2);
                    stringBuffer.append(string);
                    sessionData.setPreviousClones(stringBuffer.toString());
                    sessionData.setCloneIdUpdated(true);
                } else {
                    sessionData.setPreviousClones(string);
                }
            }
        } else {
            super.updateCloneInfo(sessionData, string, bl, bl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DRSSessionContext.updateCloneInfo");
        }
    }

    public String toHTML() {
        DRSSettings dRSSettings = this.hsdv.drss;
        DRSRuntimeMode dRSRuntimeMode = dRSSettings.getDataReplicationMode();
        int n = dRSRuntimeMode.getValue();
        if (n != 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toHTML()).append("<b> No of Replicated Sessions in the backup table(for this server) <b> : ").append(this.hsdv.cache.size()).append("<BR>");
            return stringBuffer.toString();
        }
        return super.toHTML();
    }
}

