/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.httpsession.BackedHashtable;
import com.ibm.ws.webcontainer.httpsession.DRSSessionContext;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionData;
import com.ibm.ws.webcontainer.httpsession.HttpSessDRSDataXfer;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionDataList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class DRSSessionData
extends DatabaseSessionData {
    public static final String timestamp = "DSD-ts";
    public static final String updMaxInact = "JMSSD-MaxInact";
    public static final String updList = "JMSSD-List";
    public static final String updUser = "JMSSD-User";
    public static final String updBasics = "JMSSD-Basics";
    public static final String getLastAcc = "gla";
    protected boolean sessRep = false;
    private static final long serialVersionUID = 547575527526612427L;
    protected Map drsProps = null;
    String dhInstKey = null;
    HttpSessDRSDataXfer ddx = null;

    public DRSSessionData(DRSSessionContext dRSSessionContext, String string) {
        super(dRSSessionContext, string);
        this.dhInstKey = ((DRSSessionContext)this.mManager).drsCacheInstKey;
        this.mValidList = new SessionDataList(this);
        this.drsProps = new HashMap();
        this.ddx = dRSSessionContext.ddx;
        this.usingMultirow = false;
    }

    public DRSSessionData() {
        this.mValidList = new SessionDataList(this);
        this.drsProps = new HashMap();
        this.usingMultirow = false;
    }

    public Object clone() {
        DRSSessionData dRSSessionData = new DRSSessionData();
        dRSSessionData.mManager = (DRSSessionContext)this.mManager;
        dRSSessionData.setId(this.getId());
        dRSSessionData.setSwappableData(new Hashtable(this.getSerializableData()));
        dRSSessionData.setCreationTime(this.getCreationTime());
        dRSSessionData.setLastAccessedTime(this.getLastAccTime());
        dRSSessionData.setMaxInactInterval(this.getMaxInactiveInterval());
        dRSSessionData.setUserId(this.getUserName());
        dRSSessionData.setValidity(this.isValid());
        dRSSessionData.setNew(this.isNew());
        dRSSessionData.listenerCnt = this.listenerCnt;
        dRSSessionData.appName = this.appName;
        dRSSessionData.drsProps = new HashMap(this.drsProps);
        return dRSSessionData;
    }

    void fillAppData() {
    }

    Hashtable getSerializableData() {
        return super.getSwappableData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getSwappableData() {
        Hashtable hashtable = super.getSwappableData();
        if (!this.drsProps.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("swappable data before byte switch " + this.drsProps));
            }
            DRSSessionData dRSSessionData = this;
            synchronized (dRSSessionData) {
                Iterator iterator = this.drsProps.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    Object object = this.drsProps.get(k);
                    if (!(object instanceof byte[])) {
                        this.ddx = ((DRSSessionContext)this.mManager).ddx;
                        ByteArrayInputStream byteArrayInputStream = this.ddx.getByteStream(object);
                        ObjectInputStream objectInputStream = null;
                        try {
                            objectInputStream = this.mManager.scAppParms.getAppClassLoader().getObjectInputStream(byteArrayInputStream);
                            object = this.ddx.convBytes2Obj(objectInputStream, this.mManager);
                            if (object != null) {
                                hashtable.put(k, object);
                            } else {
                                Tr.debug((TraceComponent)tc, (String)("DRSSessionData.getSwappableData:null value for key " + k));
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DRSSessionData.getSwappableData", (String)"186", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                            throwable.printStackTrace();
                        }
                        finally {
                            try {
                                objectInputStream.close();
                                byteArrayInputStream.close();
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DRSSessionData.getSwappableData", (String)"200", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                                throwable.printStackTrace();
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        boolean bl = false;
                        if (this.mManagerDB != null) {
                            bl = DatabaseSessionContext.hideSessionValues;
                        }
                        if (!bl) {
                            Tr.debug((TraceComponent)tc, (String)("getSwappableData:  converted " + k + " from bytes to " + object));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("getSwappableData:  converted " + k));
                        continue;
                    }
                    hashtable.put(k, object);
                }
                this.drsProps.clear();
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) {
        super.removeAttribute(string);
        DRSSessionData dRSSessionData = this;
        synchronized (dRSSessionData) {
            this.drsProps.remove(string);
        }
    }

    synchronized short getListenerCount() {
        return this.listenerCnt;
    }

    boolean getSessionAttributeListenerBoolean() {
        if (this.mManager != null) {
            return super.getSessionAttributeListenerBoolean();
        }
        return false;
    }

    boolean getSessionListenerBoolean() {
        if (this.mManager != null) {
            return super.getSessionListenerBoolean();
        }
        return false;
    }

    protected boolean getDistributableFlag() {
        if (this.mManager != null) {
            return super.getDistributableFlag();
        }
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.listenerCnt = objectInput.readShort();
        this.appName = (String)objectInput.readObject();
        this.drsProps = (HashMap)objectInput.readObject();
        this.usingMultirow = false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeShort(this.listenerCnt);
        objectOutput.writeObject(this.appName);
        objectOutput.writeObject(this.drsProps);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("\n").append("drs props table : ").append(this.drsProps);
        return stringBuffer.toString();
    }

    void internalInvalidate() {
        super.internalInvalidate();
        if (this.bht != null) {
            this.bht.removeFromRecentlyInvalidatedList(this.getId());
        }
    }

    void initSession(SessionContext sessionContext) {
        super.initSession(sessionContext);
        this.bht = (BackedHashtable)sessionContext.mSessions;
    }
}

