/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.httpsession.BackedHashtable;
import com.ibm.ws.webcontainer.httpsession.BackedHashtableMR;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionData;
import com.ibm.ws.webcontainer.httpsession.HttpSessionSystemProperties;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.SessionAlarmListener;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class DatabaseSessionContext
extends SessionContext {
    String db2id = null;
    String db2pwd = null;
    boolean usingMultirow = false;
    boolean mCacheEnabled = true;
    int smallColSize = 0x200B20;
    int mediumColSize;
    int largeColSize;
    int rowsizeK = 4;
    String tableSpaceName = null;
    boolean usingOracle = false;
    boolean asyncUpd = false;
    boolean timeBasedWrite = false;
    boolean WriteAllProperties = false;
    boolean appDataTablesPerThread = false;
    boolean appDataTablesPerSession = false;
    private DatabaseSessionContext self = this;
    Alarm timeBasedWriteAlarm;
    private int mPropertyWriterExecuted = 0;
    long mPropertyWriterCheckInterval = 10L;
    long mPropertyWriterInterval = 120L;
    boolean invalSpecifiedTime = false;
    int invalHour1 = 0;
    int invalHour2 = 0;
    static boolean verifyTimeStamp;
    boolean remoteInvalReceived = false;

    public DatabaseSessionContext(SessionContextParameters sessionContextParameters, SessionApplicationParameters sessionApplicationParameters) {
        super(sessionContextParameters, sessionApplicationParameters);
    }

    boolean insertSessionOnCreation(String string, SessionData sessionData) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.insertSessionOnCreation");
        }
        if (bl = this.checkForDuplicateId(sessionData)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionContext:insertSessionOnCreation: Detected duplicate id.  Try Again");
            }
        } else {
            ((BackedHashtable)this.mSessions).updateCacheId((DatabaseSessionData)sessionData);
        }
        return bl;
    }

    IHttpSession createSessionData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.createSessionData");
        }
        DatabaseSessionData databaseSessionData = new DatabaseSessionData(this, string);
        return databaseSessionData;
    }

    public String toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toHTML()).append("<b>  using multirow</b> : ").append(this.usingMultirow).append("<BR>").append("<b>  using writeAllProperties</b> : ").append(this.WriteAllProperties).append("<BR>").append("<b>  using cache</b> : ").append(this.mCacheEnabled).append("<BR>").append("<b>  using timeBasedWrite</b> : ").append(this.timeBasedWrite).append("<BR>").append("<b>  How often time based write alarm runs(ms)</b> : ").append(this.mPropertyWriterInterval).append("<BR>").append("<b>  using async update </b> : ").append(this.asyncUpd).append("<BR>").append("<b>  rowsizeK </b> : ").append(this.rowsizeK).append("<BR>").append("<b>  tableSpaceName </b> : ").append(this.tableSpaceName).append("<BR>").append("<b>  invalSpecifiedTime </b> : ").append(this.invalSpecifiedTime).append("<BR>").append("<b>  invalHour1 </b> : ").append(this.invalHour1).append("<BR>").append("<b>  invalHour2 </b> : ").append(this.invalHour2).append("<BR>");
        return stringBuffer.toString();
    }

    public void sync(HttpSession httpSession) {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.sync");
        }
        this.mSessions.put(httpSession.getId(), httpSession);
        super.sync(httpSession);
    }

    boolean checkForDuplicateId(SessionData sessionData) {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:checkForDuplicateId");
        }
        DatabaseSessionData databaseSessionData = (DatabaseSessionData)sessionData;
        databaseSessionData.duplicateIdDetected = false;
        databaseSessionData.insertSession = true;
        databaseSessionData.sync();
        return databaseSessionData.duplicateIdDetected;
    }

    boolean isCacheEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.isCacheEnabled");
        }
        return true;
    }

    void initializeParameters() {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.initializeParameters");
        }
        super.initializeParameters();
        try {
            this.usingMultirow = this.mParams.usingMultirow();
            this.mCacheEnabled = true;
            this.timeBasedWrite = this.mParams.getEnableTimeBasedWrite();
            this.WriteAllProperties = this.mParams.writeAllProperties();
            this.mPropertyWriterInterval = this.mParams.getPropertyWriterInterval();
            boolean bl = this.asyncUpd = this.mParams.getEnableAsyncUpd() || this.timeBasedWrite;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SessionContext.tc, (String)" ");
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - timeBasedWrite is : " + this.timeBasedWrite));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - WriteAllProperties is : " + this.WriteAllProperties));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - usingMultirow is : " + this.usingMultirow));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - asyncUpd is : " + this.asyncUpd));
            }
            if (this.usingMultirow && !this.WriteAllProperties && !this.timeBasedWrite && !this.timedOutAffinityEnabled) {
                this.appDataTablesPerThread = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:initializeParameters - appDataTablesPerThread is true");
                }
            } else {
                this.appDataTablesPerSession = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:initializeParameters - appDataTablesPerSession is true");
                }
            }
            this.db2id = this.mParams.getSessionDBID();
            this.db2pwd = this.mParams.getSessionDBPWD();
            this.invalSpecifiedTime = this.mParams.getInvalSpecifiedTime();
            if (this.invalSpecifiedTime) {
                this.invalHour1 = this.mParams.getInvalTime1();
                this.invalHour2 = this.mParams.getInvalTime2();
            }
            this.rowsizeK = this.mParams.getRowSize();
            this.tableSpaceName = this.mParams.getTableSpaceName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - rowsizeK is : " + this.rowsizeK));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - tableSpaceName is : " + this.tableSpaceName));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - invalSpecifiedTime is : " + this.invalSpecifiedTime));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - invalHour1 " + this.invalHour1));
                Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:initializeParameters - invalHour2 " + this.invalHour2));
            }
            verifyTimeStamp = HttpSessionSystemProperties.isVerifyTimeStamp();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext.initializeParameters", (String)"276", (Object)this);
            Tr.error((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.paramError");
            Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContext.exception", (Object)throwable);
        }
    }

    BackedHashtable createBackedHashtable() {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.createBackedHashtable");
        }
        if (HttpSessionSystemProperties.isDevelopmentMode()) {
            this.tableSize = 0;
            Tr.warning((TraceComponent)tc, (String)"Cache size less than or equal to zero may result in unexpected behavior of SessionManager in a  concurrent session access environment");
        }
        if (this.usingMultirow) {
            return new BackedHashtableMR(this, this.mParams);
        }
        return new BackedHashtable(this, this.mParams);
    }

    HashMap createSessionTable() {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.createSessionTable");
        }
        return this.createBackedHashtable();
    }

    boolean doOverflow() {
        return false;
    }

    void handleDiscardedCacheItems(Enumeration enumeration) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:handleDiscardedCacheItems");
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = ((BackedHashtable)this.mSessions).superRemove(string);
            if (object != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionContext:handleDiscardedCacheItems removed session " + string + " for app " + this.getAppName()));
            }
            if (object == null || !this.mIBMSessionListenerImplemented) continue;
            this.notifySessionRemovedFromCache(string);
        }
    }

    boolean hasTimedOut(DatabaseSessionData databaseSessionData, long l) {
        int n = databaseSessionData.getMaxInact();
        if (n == 0) {
            return false;
        }
        return n != -1 && databaseSessionData.getLastAccTime() <= l - 1000L * (long)n;
    }

    Enumeration cleanUpCache(long l) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:cleanUpCache");
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.tableKeys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            DatabaseSessionData databaseSessionData = (DatabaseSessionData)((BackedHashtable)this.mSessions).superGet(object);
            if (databaseSessionData == null) continue;
            try {
                if (!this.hasTimedOut(databaseSessionData, l)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext:cleanUpCache - adding to inval list " + databaseSessionData.getId()));
                }
                vector.addElement(databaseSessionData.getId());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext.cleanUpCache", (String)"371", (Object)databaseSessionData);
                vector.addElement(databaseSessionData.getId());
            }
        }
        object = vector.elements();
        this.handleDiscardedCacheItems((Enumeration)object);
        return vector.elements();
    }

    void performInvalidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:performInvalidations");
        }
        this.cleanUpCache(System.currentTimeMillis());
        ((BackedHashtable)this.mSessions).performInvalidation();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext:performInvalidations");
        }
    }

    public void remoteInvalidate(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DatabaseSessionContext.remoteInvalidate for app " + this.getAppName() + " id " + string + " backendUpdate " + bl));
        }
        this.remoteInvalReceived = true;
        if (bl) {
            ((BackedHashtable)this.mSessions).setMaxInactToZero(string, this.getAppName());
        }
        Vector<String> vector = new Vector<String>(1);
        vector.add(string);
        this.handleDiscardedCacheItems(vector.elements());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DatabaseSessionContext.remoteInvalidate for app " + this.getAppName() + " id " + string));
        }
    }

    void removeSessionFromTable(SessionData sessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.removeSessionFromTable");
        }
        super.removeSessionFromTable(sessionData);
        if (((DatabaseSessionData)sessionData).nukedByInvalidator) {
            return;
        }
        ((BackedHashtable)this.mSessions).removeSessions((DatabaseSessionData)sessionData);
    }

    void resetmSessions() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext:resetmSessions");
        }
        super.resetmSessions();
    }

    public synchronized void reload(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext:reload");
        }
        if (this.timeBasedWrite) {
            this.checkForSessionWrites(true);
        }
        if (passivateUsingCache) {
            Enumeration enumeration = this.tableKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                DatabaseSessionData databaseSessionData = (DatabaseSessionData)((BackedHashtable)this.mSessions).superGet(string2);
                databaseSessionData.checkPassivationListeners();
            }
        }
        super.reload(string);
    }

    public synchronized void stop(String string) {
        Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext:stop");
        if (this.timeBasedWrite) {
            this.checkForSessionWrites(true);
        }
        if (passivateUsingCache) {
            Enumeration enumeration = this.tableKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                DatabaseSessionData databaseSessionData = (DatabaseSessionData)((BackedHashtable)this.mSessions).superGet(string2);
                databaseSessionData.checkPassivationListeners();
            }
        }
        super.stop(string);
        Tr.exit((TraceComponent)tc, (String)"DatabaseSessionContext:stop");
    }

    void startAlarms() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext.startAlarms");
        }
        super.startAlarms();
        if (this.timeBasedWrite) {
            this.timeBasedWriteAlarm = SessionAlarmListener.startTimeBasedWriteAlarm(this, this.mPropertyWriterCheckInterval * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncExternalWrite() {
        try {
            this.setThreadContext();
            if (debugSessionCrossover) {
                currentThreadSessionId.set((Object)"WAS-SYSTEM-THREAD");
            }
            this.checkForSessionWrites(false);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext.asyncExternalWrite", (String)"505", (Object)this);
            throwable.printStackTrace();
        }
        finally {
            this.unsetThreadContext();
            if (debugSessionCrossover) {
                currentThreadSessionId.set(null);
            }
        }
        this.timeBasedWriteAlarm = SessionAlarmListener.startTimeBasedWriteAlarm(this, this.mPropertyWriterCheckInterval * 1000L);
    }

    void stopAlarms() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext.stopAlarms");
        }
        super.stopAlarms();
        if (this.timeBasedWrite) {
            SessionAlarmListener.stopListening(this.timeBasedWriteAlarm);
        }
    }

    long getPropertyWriterInterval() {
        return this.mPropertyWriterInterval;
    }

    void setPropertyWriterInterval(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:setPropertyWriterInterval");
        }
        this.mPropertyWriterInterval = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForSessionWrites(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext.checkForSessionWrites");
        }
        if (bl && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.checkForSessionWrites  Entered for forceWrite request");
        }
        long l = System.currentTimeMillis();
        long l2 = this.getPropertyWriterInterval() * 1000L;
        if (this.mSessions != null) {
            Enumeration enumeration = this.tableKeys();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.checkForSessionWrites !!!!!!!!!!PropertyWriteThread Loop STARTS Here!!!!!!!!!!!!! ");
            }
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                DatabaseSessionData databaseSessionData = (DatabaseSessionData)((BackedHashtable)this.mSessions).superGet(e);
                if (databaseSessionData != null) {
                    long l3 = databaseSessionData.getLastWriteTime();
                    long l4 = databaseSessionData.getLastAccTime();
                    if (l3 != -1L && (l - l3 <= l2 && !bl || l4 <= l3)) continue;
                    DatabaseSessionData databaseSessionData2 = databaseSessionData;
                    synchronized (databaseSessionData2) {
                        if (databaseSessionData != null && databaseSessionData.isValid()) {
                            String string = databaseSessionData.getId();
                            if (databaseSessionData.getInServiceMethodCount() != 0) {
                                ++databaseSessionData.deferWriteUntilNextTick;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext.checkForSessionWrites  Defer write until next time since session is in the service method " + databaseSessionData.deferWriteUntilNextTick + " " + string));
                                }
                                if (databaseSessionData.deferWriteUntilNextTick > 5) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext.checkForSessionWrites  Failed to write on 5 tries. Force the write to database!!  " + string));
                                    }
                                    databaseSessionData.setLastWriteTime(l);
                                    databaseSessionData.sync();
                                    databaseSessionData.deferWriteUntilNextTick = 0;
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SessionContext.tc, (String)("DatabaseSessionContext.checkForSessionWrites Do the session Write and update lastWriteTime " + string));
                                }
                                databaseSessionData.setLastWriteTime(l);
                                databaseSessionData.sync();
                                databaseSessionData.deferWriteUntilNextTick = 0;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.checkForSessionWrites Session no longer in Cache!");
                        }
                        continue;
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.checkForSessionWrites The Cache element is NULL");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.checkForSessionWrites !!!!!!!!!! PropertyWriteThread Loop ENDS Here!!!!!!!!!!!!!");
                Tr.debug((TraceComponent)SessionContext.tc, (String)" ");
            }
        }
        if (!bl) {
            ++this.mPropertyWriterExecuted;
        }
    }

    long checkMinimumInvalidation(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionContext:checkMinimumInvalidation");
        }
        long l2 = l;
        try {
            long l3;
            if (l != -1L && this.mParams.getEnableTimeBasedWrite() && l < 3L * (l3 = this.mParams.getPropertyWriterInterval())) {
                l2 = 3L * l3;
                Tr.error((TraceComponent)tc, (String)"DatabaseSessionContext.checkMinimumInvalidationError");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DatabaseSessionContext:checkMinimumInvalidation - Invalidation Time too small  writeInterval " + l3 + " invalTime was " + l + " Invalidation Time updated to " + l2));
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext.checkMinimumInvalidation", (String)"725", (Object)this);
            Tr.error((TraceComponent)SessionContext.tc, (String)"DatabaseSessionContext.checkMinimumInvalidationError2");
            Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContext.exception", (Object)throwable);
        }
        return l2;
    }

    Object getFromMemory(Object object) {
        return ((BackedHashtable)this.mSessions).superGet(object);
    }

    boolean isPresentInExternalStore(Object object) {
        return ((BackedHashtable)this.mSessions).isPresent((String)object);
    }

    boolean isPresentInRecentlyInvalidatedList(Object object) {
        boolean bl = ((BackedHashtable)this.mSessions).isPresentInRecentlyInvalidatedList((String)object);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isPresentInRecentlyInvalidatedList: " + bl));
        }
        return bl;
    }

    int getCacheIdLengthInUse() {
        return this.cacheIdLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("").append("db id : ").append(this.db2id).append("\n").append("\n").append("\n").append("using multirow : ").append(this.usingMultirow).append("\n").append("timeBasedWrite : ").append(this.timeBasedWrite).append("\n").append("mPropertyWriterInterval : ").append(this.mPropertyWriterInterval).append("\n").append("asyncUpd : ").append(this.asyncUpd).append("\n").append("using WriteAllProperties : ").append(this.WriteAllProperties).append("\n").append("using cache : ").append(this.mCacheEnabled).append("\n").append("last invalidate list : ").append("\n").append("rowsizeK : ").append(this.rowsizeK).append("\n").append("tableSpaceName : ").append(this.tableSpaceName).append("\n").append("invalSpecifiedTime : ").append(this.invalSpecifiedTime).append("\n").append("invalHour1 : ").append(this.invalHour1).append("\n").append("invalHour2 : ").append(this.invalHour2).append("\n");
        return stringBuffer.toString();
    }

    boolean doInval() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doInval() scheduled inval is " + this.invalSpecifiedTime + " remoteInvalReceived is " + this.remoteInvalReceived));
        }
        if (!this.invalSpecifiedTime || this.remoteInvalReceived && doRemoteInvalidations) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInval():returning true");
            }
            this.remoteInvalReceived = false;
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(11);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doInval():currentTime: " + calendar + " hour1: " + this.invalHour1 + " hour2: " + this.invalHour2));
        }
        if (n == this.invalHour1 || n == this.invalHour2) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInval():returning true because of hour match");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doInval():returning false");
        }
        return false;
    }

    boolean isMaxAllowedReached() {
        return false;
    }

    void incMemoryCount() {
    }

    void decMemoryCount() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tableRemoveRefresh(Object object) {
        DatabaseSessionData databaseSessionData;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DatabaseSessionContext.tableRemoveRefresh " + object));
        }
        if ((databaseSessionData = (DatabaseSessionData)((BackedHashtable)this.mSessions).superGet(object)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remove from memory");
            }
            DatabaseSessionData databaseSessionData2 = databaseSessionData;
            synchronized (databaseSessionData2) {
                Object object2;
                DatabaseSessionData databaseSessionData3 = (DatabaseSessionData)((BackedHashtable)this.mSessions).accessObject(object);
                if (databaseSessionData == databaseSessionData3 && (object2 = ((BackedHashtable)this.mSessions).superRemove(object)) != null && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"successfully remove from memory");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DatabaseSessionContext.tableRemoveRefresh");
        }
    }
}

