/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.session.UserTransactionWrapper;
import com.ibm.ws.Transaction.UtxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.java.javaURLContext;
import com.ibm.ws.util.EJBLocalSerializer;
import com.ibm.ws.webcontainer.httpsession.BackedHashtable;
import com.ibm.ws.webcontainer.httpsession.BackedHashtableMR;
import com.ibm.ws.webcontainer.httpsession.ContextWrapper;
import com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.J2EEObjectWrapper;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameterException;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.transaction.UserTransaction;

public class DatabaseSessionData
extends SessionData {
    static TraceComponent tc = Tr.register((String)"com.ibm.ws.webcontainer.httpsession.SessionContext", (String)"IBM HttpSession", (String)"com.ibm.servlet.resources.personalization");
    boolean listenCntHit;
    boolean userWriteHit;
    boolean maxInactWriteHit;
    boolean activationListenHit;
    Hashtable appDataChanges;
    Hashtable appDataRemovals;
    StringBuffer update;
    boolean calledFillAppData;
    short listenerCnt;
    boolean cached;
    boolean cacheIdUpdated;
    static final String initialCacheId = "0001";
    boolean syncFromServlet;
    boolean nukedByInvalidator;
    private long mLastWriteTime;
    int deferWriteUntilNextTick;
    boolean removingSessionFromCache;
    DatabaseSessionContext mManagerDB;
    boolean duplicateIdDetected;
    boolean insertSession;
    BackedHashtable bht = null;
    static final short HTTP_SESSION_NO_LISTENER = 0;
    static final short HTTP_SESSION_BINDING_LISTENER = 1;
    static final short HTTP_SESSION_ACTIVATION_LISTENER = 2;
    static final short HTTP_SESSION_BINDING_AND_ACTIVATION_LISTENER = 3;
    private static final String USER_TRANSACTION_J2EE = "COM_IBM_WS_J2EE_USER_TRANSACTION";
    boolean appDataTablesPerThread;
    boolean usingMultirow;
    boolean distributableWebApp;
    boolean sessionAttributeListener;
    private long lastWriteLastaccessTime;
    private EJBLocalSerializer ejbLocalSerializer = null;
    static final short EJB_LOCAL_OBJECT = 1;
    static final short EJB_LOCAL_HOME = 2;
    private static final long serialVersionUID = -6456396236183348328L;

    public DatabaseSessionData(DatabaseSessionContext databaseSessionContext, String string) {
        super(databaseSessionContext, string);
        this.cacheId = initialCacheId;
        this.mManagerDB = (DatabaseSessionContext)this.mManager;
        this.appDataTablesPerThread = this.mManagerDB.appDataTablesPerThread;
        this.usingMultirow = this.mManagerDB.usingMultirow;
        try {
            this.distributableWebApp = this.mManagerDB.scAppParms.getDistributableWebApp();
        }
        catch (SessionApplicationParameterException sessionApplicationParameterException) {
            FFDCFilter.processException((Throwable)sessionApplicationParameterException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.constructor", (String)"442", (Object)this);
        }
        this.sessionAttributeListener = this.mManagerDB.sessionAttributeListener;
        this.bht = (BackedHashtable)this.mManager.mSessions;
        this.listenerCnt = 0;
        this.nukedByInvalidator = false;
        this.deferWriteUntilNextTick = 0;
        this.mLastWriteTime = -1L;
        this.removingSessionFromCache = false;
        this.insertSession = false;
    }

    public DatabaseSessionData() {
        this.listenerCnt = 0;
        this.nukedByInvalidator = false;
        this.deferWriteUntilNextTick = 0;
        this.mLastWriteTime = -1L;
        this.removingSessionFromCache = false;
        this.insertSession = false;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.appDataTablesPerThread = objectInput.readBoolean();
        this.usingMultirow = objectInput.readBoolean();
        this.distributableWebApp = objectInput.readBoolean();
        this.sessionAttributeListener = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.appDataTablesPerThread);
        objectOutput.writeBoolean(this.usingMultirow);
        objectOutput.writeBoolean(this.distributableWebApp);
        objectOutput.writeBoolean(this.sessionAttributeListener);
    }

    void updateAccessTimeToNowOnAccess() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.updateAccessTimeToNowOnAccess");
        }
    }

    int getMaxInact() {
        return super.getMaxInactiveInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUser(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionConstants.setUser");
        }
        super.setUser(string);
        DatabaseSessionData databaseSessionData = this;
        synchronized (databaseSessionData) {
            this.userWriteHit = true;
        }
    }

    void setUserId(String string) {
        super.setUser(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaxInactiveInterval(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.setMaxInactiveInterval");
        }
        super.setMaxInactiveInterval(n);
        DatabaseSessionData databaseSessionData = this;
        synchronized (databaseSessionData) {
            this.maxInactWriteHit = true;
        }
    }

    synchronized void removeValueGuts(String string, boolean bl) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DatabaseSessionData:removeValueGuts - session " + this.getId() + " prop id " + string));
        }
        if (string.equals("com_ibm_ejs_security_httpsession_info") && !bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DatabaseSessionData:removeValueGuts - attempt to remove Security Info failed");
            }
            return;
        }
        Object object = this.getValueGuts(string, true);
        if (object == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("DatabaseSessionData:removeValueGuts - prop id " + string + " not in " + this.getId()));
            }
            return;
        }
        if (this.appDataRemovals == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:removeValue - init appDataRemovals " + this.getId()));
            }
            this.appDataRemovals = new Hashtable();
        }
        if (this.appDataTablesPerThread) {
            Thread thread;
            Hashtable<String, String> hashtable;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"appDataTablesPerThread");
            }
            if ((hashtable = (Hashtable<String, String>)this.appDataRemovals.get(thread = Thread.currentThread())) == null) {
                hashtable = new Hashtable<String, String>();
                this.appDataRemovals.put(thread, hashtable);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:removeValue - remove value for " + this.getId() + " and prop " + string + " via thread " + thread));
            }
            hashtable.put(string, string);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not appDataTablesPerThread");
            }
            this.appDataRemovals.put(string, string);
        }
        super.removeValueGuts(string, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DatabaseSessionData:removeValueGuts");
        }
    }

    Hashtable getSwappableData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.getSwappableData");
        }
        if (!(this.mSwappableData != null || this.isValid() && this.isNew() || this.usingMultirow || this.calledFillAppData)) {
            this.fillAppData();
        }
        return super.getSwappableData();
    }

    protected void checkSwappableListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:checkSwappableListeners");
        }
        this.getSwappableListeners((short)3);
        super.checkSwappableListeners();
    }

    protected void checkActivationListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:checkActivationListeners");
        }
        this.getSwappableListeners((short)2);
        Enumeration enumeration = this.getSwappableData().keys();
        while (enumeration.hasMoreElements()) {
            Object v;
            String string = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:checkActivationListeners - found element: " + string));
            }
            if (!((v = this.getSwappableData().get(string)) instanceof HttpSessionActivationListener)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:checkActivationListeners - calling sessionDidActivate() ");
            }
            ((HttpSessionActivationListener)v).sessionDidActivate(new HttpSessionEvent((HttpSession)this));
        }
    }

    protected void checkPassivationListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:checkPassivationListeners");
        }
        Enumeration enumeration = super.getSwappableData().keys();
        while (enumeration.hasMoreElements()) {
            Object v;
            String string = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:checkPassivationListeners - found element: " + string));
            }
            if (!((v = super.getSwappableData().get(string)) instanceof HttpSessionActivationListener)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:checkPassivationListeners - calling sessionWillPassivate() ");
            }
            ((HttpSessionActivationListener)v).sessionWillPassivate(new HttpSessionEvent((HttpSession)this));
        }
    }

    Object convertObject(Object object) {
        if (object instanceof J2EEObjectWrapper) {
            Object object2;
            Object object3 = ((J2EEObjectWrapper)object).getSerializableObject();
            if (object3 instanceof Handle) {
                try {
                    EJBObject eJBObject = ((Handle)object3).getEJBObject();
                    Class clazz = eJBObject.getEJBHome().getEJBMetaData().getRemoteInterfaceClass();
                    return PortableRemoteObject.narrow((Object)eJBObject, (Class)clazz);
                }
                catch (RemoteException remoteException) {
                    FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.convertObject", (String)"321", (Object)object3);
                    Tr.error((TraceComponent)tc, (String)"DatabaseSessionData.convertObjectHandleErr");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)remoteException);
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.convertObject", (String)"323", (Object)object3);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)classCastException);
                }
            }
            if (object3 instanceof HomeHandle) {
                try {
                    object2 = ((HomeHandle)object3).getEJBHome();
                    Class clazz = object2.getEJBMetaData().getHomeInterfaceClass();
                    return PortableRemoteObject.narrow((Object)object2, (Class)clazz);
                }
                catch (RemoteException remoteException) {
                    FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.convertObject", (String)"331", (Object)object3);
                    Tr.error((TraceComponent)tc, (String)"DatabaseSessionData.convertObjectHomeErr");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)remoteException);
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.convertObject", (String)"333", (Object)object3);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)classCastException);
                }
            }
            if (object3 instanceof ContextWrapper) {
                try {
                    object2 = new InitialContext(((ContextWrapper)object3).env);
                    return ((InitialContext)object2).lookup("java:comp/env");
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.convertObject", (String)"341", (Object)object3);
                    Tr.error((TraceComponent)tc, (String)"DatabaseSessionData.convertObjectContextErr");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)namingException);
                }
            }
            if (object3 instanceof String && object3.equals(USER_TRANSACTION_J2EE)) {
                return UtxFactory.createUserTransaction();
            }
            if (object3 instanceof byte[]) {
                if (this.ejbLocalSerializer == null) {
                    this.ejbLocalSerializer = EJBLocalSerializer.instance();
                }
                if (((J2EEObjectWrapper)object).getEjbLocalType() == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:convertObject - calling deserialize for EJBLocalObject");
                    }
                    return this.ejbLocalSerializer.deserialize((byte[])object3);
                }
                if (((J2EEObjectWrapper)object).getEjbLocalType() == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:convertObject - calling deserialize for EJBLocalHome");
                    }
                    return this.ejbLocalSerializer.deserializeHome((byte[])object3);
                }
            }
        }
        return object;
    }

    synchronized Object getValueGuts(String string, boolean bl) throws IllegalStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:getValueGuts");
        }
        if (string.equals("com_ibm_ejs_security_httpsession_info") && !bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DatabaseSessionData:getValueGuts - attempt to get Security Info failed");
            }
            return null;
        }
        Object object2 = super.getValueGuts(string, true);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:getValueGuts - retrieved object from in mem copy with id and value of " + string));
        }
        if (object2 != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DatabseSessionData.getValueGuts - tmp is not null");
            }
            return this.convertObject(object2);
        }
        if (!this.isNew()) {
            object = Thread.currentThread();
            if (this.appDataRemovals != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData.getValueGuts - appDataRemovals is not null");
                }
                if (this.appDataTablesPerThread ? this.appDataRemovals.get(object) != null && ((Hashtable)this.appDataRemovals.get(object)).get(string) != null : this.appDataRemovals.get(string) != null) {
                    return object2;
                }
            }
            if (this.usingMultirow && this.bht != null) {
                object2 = this.bht.getValue(string, this);
            }
            if (object2 != null) {
                object2 = this.convertObject(object2);
                this.getSwappableData().put(string, object2);
            }
        }
        if (tc.isEntryEnabled()) {
            object = object2 == null ? "null" : "not null";
            Tr.exit((TraceComponent)tc, (String)("DatabaseSessionData:getValue -retrieved object from db with id and value of  " + string + " " + (String)object));
        }
        return object2;
    }

    boolean isSwappableData(Object object) {
        if (super.isSwappableData(object)) {
            return true;
        }
        return object != null && (object instanceof EJBObject && object instanceof Stub || object instanceof EJBHome && object instanceof Stub || object instanceof EJBLocalObject || object instanceof EJBLocalHome || object instanceof UserTransaction || object instanceof Context && object instanceof javaURLContext || object instanceof UserTransactionWrapper);
    }

    protected boolean getDistributableFlag() {
        return this.distributableWebApp;
    }

    synchronized void putValueGuts(String string, Object object, boolean bl) throws IllegalStateException {
        Serializable serializable;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DatabaseSessionData:putValueGuts " + string));
        }
        if (string == null || object == null) {
            return;
        }
        if (string.equals("com_ibm_ejs_security_httpsession_info") && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:putValueGuts - attempt to put Security Info failed");
            }
            return;
        }
        if (this.getSessionAttributeListenerBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:putValueGuts  - sessionAttributeListener is: " + this.sessionAttributeListener));
            }
            object3 = this.getValueGuts(string, bl);
        }
        object3 = object;
        boolean bl2 = this.getDistributableFlag();
        boolean bl3 = this.isSwappableData(object);
        if (bl2 && !bl3) {
            Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:putValue - IllegalArgumentException");
            throw new IllegalArgumentException("Attribute with name " + string + " is not java.io.Serializable. All attributes stored in session must be Serializable when web module is marked as distributable");
        }
        if (bl3 && object instanceof EJBObject && object instanceof Stub) {
            try {
                object3 = new J2EEObjectWrapper(((EJBObject)object).getHandle());
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.putValueGuts", (String)"498", (Object)this);
                Tr.error((TraceComponent)tc, (String)"DatabaseSessionData.putValueGutsHandleErr");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)remoteException);
            }
        }
        if (bl3 && object instanceof EJBHome && object instanceof Stub) {
            try {
                object3 = new J2EEObjectWrapper(((EJBHome)object).getHomeHandle());
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.putValueGuts", (String)"513", (Object)this);
                Tr.error((TraceComponent)tc, (String)"DatabaseSessionData.putValueGutsHomeErr");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)remoteException);
            }
        }
        if (bl3 && object instanceof EJBLocalHome) {
            if (this.ejbLocalSerializer == null) {
                this.ejbLocalSerializer = EJBLocalSerializer.instance();
            }
            object2 = this.ejbLocalSerializer.serializeHome((EJBLocalHome)object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:putValueGuts - creating new J2EEObject for EJBLocalHome");
            }
            object3 = new J2EEObjectWrapper(object2, 2);
        } else if (bl3 && object instanceof EJBLocalObject) {
            if (this.ejbLocalSerializer == null) {
                this.ejbLocalSerializer = EJBLocalSerializer.instance();
            }
            object2 = this.ejbLocalSerializer.serialize((EJBLocalObject)object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:putValueGuts - creating new J2EEObject for EJBLocalObject");
            }
            object3 = new J2EEObjectWrapper(object2, 1);
        }
        if (bl3 && object instanceof Context && object instanceof javaURLContext) {
            try {
                object2 = ((Context)object).getEnvironment();
                serializable = new ContextWrapper();
                ((ContextWrapper)serializable).env = object2;
                object3 = new J2EEObjectWrapper(serializable);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webcontainer.httpsession.DatabaseSessionData.putValueGuts", (String)"531", (Object)this);
                Tr.error((TraceComponent)tc, (String)"DatabaseSessionData.putValueGutsContextErr");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)namingException);
            }
        }
        if (bl3 && object instanceof UserTransaction) {
            object3 = new J2EEObjectWrapper(USER_TRANSACTION_J2EE);
        }
        if (this.appDataChanges == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DatabaseSessionData:putValue - init appDataChanges");
            }
            this.appDataChanges = new Hashtable();
        }
        if (bl3) {
            if (this.appDataTablesPerThread) {
                object2 = Thread.currentThread();
                serializable = (Hashtable)this.appDataChanges.get(object2);
                if (serializable == null) {
                    serializable = new Hashtable();
                    this.appDataChanges.put(object2, serializable);
                }
                if (tc.isDebugEnabled()) {
                    if (DatabaseSessionContext.hideSessionValues) {
                        Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:putValue - storing for " + this.getId() + " prop " + string + " via thread " + object2));
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:putValue - storing for " + this.getId() + " prop " + string + " with value " + object + " via thread " + object2));
                    }
                }
                ((Hashtable)serializable).put(string, object);
            } else {
                this.appDataChanges.put(string, object3);
            }
            if ((object instanceof HttpSessionBindingListener || object instanceof HttpSessionActivationListener) && !this.isNew()) {
                this.listenerCnt = this.getListenerCount();
            }
            if (object instanceof HttpSessionBindingListener) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:putValueGuts - Property is a binding listener: " + string));
                }
                switch (this.listenerCnt) {
                    case 0: {
                        this.listenerCnt = 1;
                        this.listenCntHit = true;
                        break;
                    }
                    case 2: {
                        this.listenerCnt = (short)3;
                        this.listenCntHit = true;
                    }
                }
            }
            if (object instanceof HttpSessionActivationListener) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:putValueGuts - Property is an Activation listener: " + string));
                }
                switch (this.listenerCnt) {
                    case 0: {
                        this.listenerCnt = (short)2;
                        this.listenCntHit = true;
                        break;
                    }
                    case 1: {
                        this.listenerCnt = (short)3;
                        this.listenCntHit = true;
                    }
                }
            }
            if (this.appDataRemovals != null) {
                if (this.appDataTablesPerThread) {
                    object2 = Thread.currentThread();
                    serializable = (Hashtable)this.appDataRemovals.get(object2);
                    if (serializable != null) {
                        ((Hashtable)serializable).remove(string);
                        if (((Hashtable)serializable).isEmpty()) {
                            this.appDataRemovals.remove(object2);
                        }
                    }
                } else {
                    this.appDataRemovals.remove(string);
                }
            }
        }
        super.putValueGuts(string, object3, true);
    }

    void fillAppData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.fillAppData");
        }
        this.calledFillAppData = true;
        if (this.bht != null) {
            this.mSwappableData = (Hashtable)this.bht.getValue(this.getId(), this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DatabaseSessionData.fillAppData");
        }
    }

    void getSwappableListeners(short s) {
        short s2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:getSwappableListeners");
        }
        if ((s2 = this.getListenerCount()) != s && s2 != 3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:getSwappableListeners - database indicates no listener match for " + s));
            }
            return;
        }
        if (!this.usingMultirow) {
            if (!this.calledFillAppData) {
                this.fillAppData();
            }
            return;
        }
        Hashtable hashtable = super.getSwappableData();
        Hashtable hashtable2 = null;
        if (this.bht != null) {
            hashtable2 = (Hashtable)this.bht.getAllValues(this);
        }
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                hashtable.put(k, hashtable2.get(k));
            }
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("\n").append("app data changes : ");
        if (DatabaseSessionContext.hideSessionValues) {
            stringBuffer.append(this.appDataChanges == null ? null : this.appDataChanges.keySet());
        } else {
            stringBuffer.append(this.appDataChanges == null ? null : this.appDataChanges.toString());
        }
        stringBuffer.append("\n").append("app data removals : ");
        if (DatabaseSessionContext.hideSessionValues) {
            stringBuffer.append(this.appDataRemovals == null ? null : this.appDataRemovals.keySet());
        } else {
            stringBuffer.append(this.appDataRemovals == null ? null : this.appDataRemovals.toString());
        }
        stringBuffer.append("\n").append("user write hit : ").append(this.userWriteHit).append("\n").append("max inact write hit : ").append(this.maxInactWriteHit).append("\n").append("listener count hit : ").append(this.listenCntHit).append("\n").append("update : ").append(this.update != null ? this.update.toString() : null).append("\n").append("listener count : ").append(this.listenerCnt).append("\n").append("\n").append("cached : ").append(this.cached).append("\n").append("cacheId : ").append(this.cacheId).append("\n").append("cacheIdUpdated : ").append(this.cacheIdUpdated).append("\n").append("syncFromServlet : ").append(this.syncFromServlet).append("\n");
        return stringBuffer.toString();
    }

    short getListenerCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.getListenerCount");
        }
        return this.listenerCnt;
    }

    void setListenerCount(short s) {
        this.listenerCnt = s;
    }

    public synchronized void sync() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.sync");
        }
        this.syncFromServlet = true;
        super.sync();
    }

    public boolean isBrowserTokenUpdated() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData.isBrowserTokenUpdated");
        }
        if (bl = super.isBrowserTokenUpdated()) {
            return bl;
        }
        return this.cacheIdUpdated;
    }

    public synchronized String[] getValueNames() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:getValueNames");
        }
        String[] stringArray = super.getValueNames();
        if (!this.usingMultirow) {
            return stringArray;
        }
        Vector vector = null;
        if (this.bht != null) {
            vector = ((BackedHashtableMR)this.bht).getAllKeys(this);
        }
        if (vector != null) {
            int n;
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (vector.contains(stringArray[n])) continue;
                    vector.addElement(stringArray[n]);
                }
            }
            if (this.appDataRemovals != null) {
                Object object;
                if (this.appDataTablesPerThread) {
                    Enumeration enumeration = this.appDataRemovals.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (Hashtable)enumeration.nextElement();
                        Enumeration enumeration2 = ((Hashtable)object).keys();
                        while (enumeration2.hasMoreElements()) {
                            String string = (String)enumeration2.nextElement();
                            if (!vector.contains(string)) continue;
                            vector.removeElement(string);
                        }
                    }
                } else {
                    Enumeration enumeration = this.appDataRemovals.keys();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        if (!vector.contains(object)) continue;
                        vector.removeElement(object);
                    }
                }
            }
            if (vector.contains("com_ibm_ejs_security_httpsession_info")) {
                vector.removeElement("com_ibm_ejs_security_httpsession_info");
            }
            n = vector.size();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    public long getLastWriteTime() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:getLastWriteTime");
        }
        return this.mLastWriteTime;
    }

    public void setLastWriteTime(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DatabaseSessionData:setLastWriteTime");
        }
        this.mLastWriteTime = l;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    long getLastWriteLastaccessTime() {
        return this.lastWriteLastaccessTime;
    }

    void setLastWriteLastAccessTime(long l) {
        this.lastWriteLastaccessTime = l;
    }
}

