/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.Cookie;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionDatabasePersistence;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.TuningParams;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistryInitializationException;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import java.util.Properties;

public class SMSessionContextParameters
extends SessionContextParameters {
    private static final TraceComponent tc = Tr.register((Class)SMSessionContextParameters.class);

    SMSessionContextParameters() {
    }

    void init(SessionManager sessionManager) throws SessionContextRegistryInitializationException {
        SessionManager sessionManager2 = null;
        Cookie cookie = null;
        TuningParams tuningParams = null;
        SessionDatabasePersistence sessionDatabasePersistence = null;
        Object var6_6 = null;
        Object var7_7 = null;
        sessionManager2 = sessionManager;
        cookie = sessionManager2.getDefaultCookieSettings();
        tuningParams = sessionManager2.getTuningParams();
        if (tc.isEntryEnabled()) {
            this.printSessionContextParameters(sessionManager2, cookie, tuningParams, sessionDatabasePersistence);
        }
        try {
            this.enableUrlRewriting = sessionManager2.isEnableUrlRewriting();
            this.enableCookies = sessionManager2.isEnableCookies();
            this.enableUrlProtocolSwitchRewriting = sessionManager2.isEnableProtocolSwitchRewriting();
            this.sessionInvalidationTime = tuningParams.getInvalidationTimeout();
            if (this.sessionInvalidationTime != -1L) {
                this.sessionInvalidationTime *= 60L;
            }
            int n = sessionManager2.getSessionPersistenceMode().getValue();
            boolean bl = false;
            if (n > 0) {
                bl = true;
            }
            this.sessionCookieName = cookie.getName();
            this.sessionCookieDomain = cookie.getDomain();
            this.sessionCookieMaxAge = cookie.getMaximumAge();
            this.sessionCookiePath = cookie.getPath();
            this.sessionCookieSecure = cookie.isSecure();
            this.inMemorySize = tuningParams.getMaxInMemorySessionCount();
            this.enableOverflow = tuningParams.isAllowOverflow();
            if (!SessionMgrComponentImpl.is_zOS()) {
                serverId = SessionMgrComponentImpl.getServerId();
            }
            this.enableSSLTracking = sessionManager.isEnableSSLTracking();
            this.integrateSec = sessionManager.isEnableSecurityIntegration();
            this.enableAffinityTimeout = false;
            this.mAffinityTimeoutInterval = 0L;
            this.allowSerializedSessionAccess = sessionManager.isAllowSerializedSessionAccess();
            this.accessSessionOnTimeout = sessionManager.isAccessSessionOnTimeout();
            this.serializedSessionAccessMaxWaitTime = sessionManager.getMaxWaitTime();
            if (bl) {
                int n2;
                int n3 = sessionManager.getSessionPersistenceMode().getValue();
                if (n3 == 1) {
                    this.usingDatabase = true;
                    sessionDatabasePersistence = sessionManager2.getSessionDatabasePersistence();
                    this.sessionDBID = sessionDatabasePersistence.getUserId();
                    this.sessionDBPWD = sessionDatabasePersistence.getPassword();
                    this.JNDIDataSourceName = sessionDatabasePersistence.getDatasourceJNDIName();
                    n2 = sessionDatabasePersistence.getDb2RowSize().getValue();
                    if (n2 == 0) {
                        this.rowSize = 4;
                    } else if (n2 == 1) {
                        this.rowSize = 8;
                    } else if (n2 == 2) {
                        this.rowSize = 16;
                    } else if (n2 == 3) {
                        this.rowSize = 32;
                    }
                    this.tableSpaceName = sessionDatabasePersistence.getTableSpaceName();
                    this.usingMultirow = tuningParams.isUsingMultiRowSchema();
                } else {
                    this.usingMemToMem = true;
                    this.usingMultirow = false;
                }
                this.invalSpecfiedTime = tuningParams.isScheduleInvalidation();
                if (this.invalSpecfiedTime) {
                    this.invalTime1 = tuningParams.getInvalidationSchedule().getFirstHour();
                    this.invalTime2 = tuningParams.getInvalidationSchedule().getSecondHour();
                }
                if ((n2 = tuningParams.getWriteFrequency().getValue()) == 2) {
                    this.enableTimeBasedWrite = true;
                }
                if (n2 == 1) {
                    this.enableAsyncUpd = true;
                }
                if (this.enableTimeBasedWrite) {
                    this.mPropertyWriterInterval = tuningParams.getWriteInterval();
                }
                this.writeAllProperties = (n2 = tuningParams.getWriteContents().getValue()) != 0;
            } else {
                this.usingMemory = true;
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"{0}", (Object)exception);
        }
    }

    public String getTableNameValue() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTableNameValue");
        }
        String string = null;
        Properties properties = WebContainer.getWebContainerProperties();
        if (properties != null) {
            string = properties.getProperty("sessiontablename");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTableNameValue:" + string));
        }
        return string;
    }

    private void printSessionContextParameters(SessionManager sessionManager, Cookie cookie, TuningParams tuningParams, SessionDatabasePersistence sessionDatabasePersistence) {
        Tr.entry((TraceComponent)tc, (String)"printSessionContextParameters");
        Tr.debug((TraceComponent)tc, (String)(" isEnableUrlRewriteing=" + sessionManager.isEnableUrlRewriting()));
        Tr.debug((TraceComponent)tc, (String)(" isEnableCookies=" + sessionManager.isEnableCookies()));
        Tr.debug((TraceComponent)tc, (String)(" isEnableProtocolSwitchRewriting()=" + sessionManager.isEnableProtocolSwitchRewriting()));
        Tr.debug((TraceComponent)tc, (String)(" getInvalidationTimeout()=" + tuningParams.getInvalidationTimeout()));
        Tr.debug((TraceComponent)tc, (String)(" getSessionPersistenceMode()=" + sessionManager.getSessionPersistenceMode()));
        Tr.debug((TraceComponent)tc, (String)(" _cookie.getName()=" + cookie.getName()));
        Tr.debug((TraceComponent)tc, (String)(" _cookie.getDomain()=" + cookie.getDomain()));
        Tr.debug((TraceComponent)tc, (String)(" _cookie.getMaximumAge()=" + cookie.getMaximumAge()));
        Tr.debug((TraceComponent)tc, (String)(" _cookie.getPath()=" + cookie.getPath()));
        Tr.debug((TraceComponent)tc, (String)(" _cookie.isSecure()=" + cookie.isSecure()));
        Tr.debug((TraceComponent)tc, (String)(" _tuning.getBaseMemorySize()=" + tuningParams.getMaxInMemorySessionCount()));
        Tr.debug((TraceComponent)tc, (String)(" _tuning.isAllowOverflow()=" + tuningParams.isAllowOverflow()));
        Tr.exit((TraceComponent)tc, (String)"printSessionContextParameters");
    }
}

