/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.webcontainer.httpsession.SessionContext;

class SessionAlarmListener
implements AlarmListener {
    private short mode;
    public static final short INVALIDATION = 1;
    public static final short TIME_BASED_WRITE = 2;
    private static SessionAlarmListener invalList = new SessionAlarmListener(1);
    private static SessionAlarmListener timeBased = new SessionAlarmListener(2);

    private SessionAlarmListener(short s) {
        this.mode = s;
    }

    public void alarm(Object object) {
        if (SessionContext.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"SessionAlarmListener.alarm");
        }
        SessionContext sessionContext = (SessionContext)object;
        if (this.mode == 1) {
            sessionContext.pollInvalidations();
        } else if (this.mode == 2) {
            sessionContext.asyncExternalWrite();
        }
        if (SessionContext.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SessionContext.tc, (String)"SessionAlarmListener.alarm");
        }
    }

    static Alarm startInvalidationAlarm(SessionContext sessionContext, long l) {
        if (SessionContext.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SessionContext.tc, (String)("SessionAlarmListener.registerForInvalidation  for application " + sessionContext.getAppName() + " with alarm interval of " + l + "ms"));
        }
        return AlarmManager.createNonDeferrable((long)l, (AlarmListener)invalList, (Object)sessionContext);
    }

    static Alarm startTimeBasedWriteAlarm(SessionContext sessionContext, long l) {
        if (SessionContext.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SessionContext.tc, (String)("SessionAlarmListener.registerForSessionWrites  for application " + sessionContext.getAppName() + " with alarm interval of " + l + "ms"));
        }
        return AlarmManager.createNonDeferrable((long)l, (AlarmListener)timeBased, (Object)sessionContext);
    }

    static void stopListening(Alarm alarm) {
        alarm.cancel();
    }
}

