/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.servlet.session.IBMSessionListener;
import com.ibm.websphere.servlet.session.UnauthorizedSessionRequestException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.httpsession.BaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.HttpSessionSystemProperties;
import com.ibm.ws.webcontainer.httpsession.IBMApplicationSessionExt;
import com.ibm.ws.webcontainer.httpsession.IDFactory;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.SessionAlarmListener;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameterException;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextMBeanAdapter;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameterException;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistry;
import com.ibm.ws.webcontainer.httpsession.SessionCrossoverStackTrace;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import com.ibm.ws.webcontainer.httpsession.SessionIDGen;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import com.ibm.ws.webcontainer.httpsession.SessionSimpleHashMap;
import com.ibm.ws.webcontainer.httpsession.SessionTrackingPMIApplicationData;
import com.ibm.ws.webcontainer.httpsession.TooManySessionsException;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.IExtendedRequest;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import com.ibm.ws390.rt.HTTPSessionAffinity;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public abstract class SessionContext
extends BaseSessionContext
implements IHttpSessionContext {
    private SessionContext self;
    static NLS rb;
    public static int BASE32;
    public static int BASE64;
    int tableSize = 1000;
    private boolean allowInfinite = true;
    private static final String overflowId = "overflowed-session";
    private SessionData overflowData = null;
    private static boolean pinSR;
    private boolean securityEnabled;
    protected long mInvalidationCheckPollInterval = -1L;
    private long mSessionInvalidationTime = 1800L;
    private boolean mSessionTrackingActive = true;
    private boolean mUsingCookies = true;
    private boolean mUsingURL = false;
    private boolean mURLProtocolSwitchRewritingActive = false;
    private String mSessionCookieName = "JSESSION";
    private String mSessionCookieComment = "Session id";
    private String mSessionCookieDomain;
    private int mSessionCookieMaxAge = -1;
    private String mSessionCookiePath = "/";
    private boolean mSessionCookieSecure = false;
    private Object counterSyncher = new Object();
    protected HashMap mSessions = null;
    private int mSessionIdCounter = 0;
    private static Random randIdGen;
    private static InetAddress mLocalHost;
    private static byte[] mSessionIdTemplate;
    private static final char[] sBitChars;
    private static final int[] sSecondByteMasks;
    protected SessionContextParameters mParams = null;
    private boolean completedStartup;
    protected SessionApplicationParameters scAppParms = null;
    protected SessionTrackingPMIApplicationData scPmiData = null;
    private boolean scEnablePmi = true;
    private boolean stopSession = false;
    static String cloneId;
    static boolean cloneIdPropertySet;
    static String zAffinityCloneId;
    static int cloneIdLength;
    private static IDFactory sessionIDFactory;
    private boolean integrateWASSec = false;
    protected boolean useSSLId = false;
    static char cloneSeparator;
    private static final String timeoutSeparator = "*";
    protected boolean sessionAttributeListener = false;
    protected boolean sessionListener = false;
    protected ArrayList mHttpSessionAttributeListeners = new ArrayList();
    protected ArrayList mHttpSessionListeners = new ArrayList();
    protected ServletContext mServletContext = null;
    private static boolean useJCE;
    protected static boolean passivateUsingCache;
    protected static boolean passivateAtWrite;
    protected boolean timedOutAffinityEnabled = true;
    private long affinityTimeOut = 30L;
    private boolean allowSerializedSessionAccess = false;
    private int serializedSessionAccessMaxWaitTime = 0;
    private boolean accessSessionOnTimeout = false;
    private Alarm invalidaterAlarm;
    private SessionContextMBeanAdapter mbeanAdapter = null;
    private static String sessUrlRewritePrefix;
    private static final String dcookieName = "SSLJSESSION";
    protected int cacheIdLength = 4;
    protected static int sessionIDLength;
    protected int cacheIdPlusIdlength = this.cacheIdLength + sessionIDLength;
    private static boolean trackGCCount;
    private static boolean idReuse;
    static Hashtable sessionIdsUsedMoreThanOnce;
    private static boolean noSwitchOver;
    static boolean useOracleBLOB;
    static boolean turnOffCacheId;
    static boolean turnOffCloneId;
    static String defaultCacheId;
    HashMap createSync = new HashMap();
    static boolean useBase32;
    static boolean is_zOS;
    boolean mIBMSessionListenerImplemented = false;
    static WSThreadLocal currentThreadSessionId;
    static boolean debugSessionCrossover;
    boolean crossoverUserThreadWarningIssued = false;
    static boolean firstTime;
    static boolean hideSessionValuesPropertySet;
    static boolean hideSessionValues;
    static boolean doRemoteInvalidations;
    private boolean onlyCheckInCacheDuringPreInvoke = false;
    protected int forceSessionInvalidationMultiple = 1;
    private boolean checkCookiesOnDispatch = false;
    protected boolean optimizeCacheIdIncrements = false;
    protected boolean isSIPApplication = false;
    protected String sipSessionCookieName = "ibmappid";
    private boolean forceSessionIdLengthCheck = false;
    private static String cloneSep;
    private String cloneIdWithSep = null;
    static final String[] unSecStrs;
    protected int _refCount = 1;
    protected int maxSessionIdentifierLength = 1024;

    SessionContext(SessionContextParameters sessionContextParameters, SessionApplicationParameters sessionApplicationParameters) {
        this.mParams = sessionContextParameters;
        this.scAppParms = sessionApplicationParameters;
        if (this.mParams == null && this.scAppParms == null) {
            return;
        }
        if (randIdGen == null) {
            randIdGen = new Random(System.currentTimeMillis());
        }
        this.self = this;
        this.mbeanAdapter = new SessionContextMBeanAdapter(this);
        this.scPmiData = new SessionTrackingPMIApplicationData(sessionApplicationParameters, this.mbeanAdapter);
        try {
            this.setServletContext(this.scAppParms.getServletContext());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.moreInit", (String)"294", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
        }
        this.detectIfSIPApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        try {
            is_zOS = SessionMgrComponentImpl.is_zOS();
            this.setProperties(SessionMgrComponentImpl.getWebContainerProperties());
            this.setThreadContext();
            this.initializeParameters();
            this.moreInit();
        }
        finally {
            this.unsetThreadContext();
        }
    }

    void moreInit() {
        this.mSessions = this.createSessionTable();
        if (!this.allowInfinite && this.overflowData == null) {
            this.overflowData = (SessionData)this.createSessionData(overflowId);
            this.overflowData.setValidity(false);
            this.overflowData.overflowed = true;
            this.overflowData.setSessionContext(this);
        }
        if (sessionIdsUsedMoreThanOnce == null) {
            sessionIdsUsedMoreThanOnce = new Hashtable();
        }
        if (useJCE && sessionIDFactory == null) {
            try {
                sessionIDFactory = useBase32 ? new SessionIDGen(sessionIDLength, BASE32) : new SessionIDGen(sessionIDLength, BASE64);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.moreInit", (String)"264", (Object)this);
                Tr.error((TraceComponent)tc, (String)"SessionContext.loadJCEFail");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                sessionIDFactory = null;
            }
        }
        this.startSessionContext();
        if (debugSessionCrossover) {
            currentThreadSessionId = new WSThreadLocal();
        }
        this.completedStartup = true;
    }

    static String getXString(String string, String string2) {
        if (rb == null) {
            rb = new NLS("com.ibm.servlet.resources.personalization");
        }
        if (rb != null) {
            return rb.getString(string, string2);
        }
        return string2;
    }

    void startAlarms() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.startAlarms");
        }
        this.invalidaterAlarm = SessionAlarmListener.startInvalidationAlarm(this, this.mInvalidationCheckPollInterval * 1000L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.startAlarms");
        }
    }

    void stopAlarms() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.stopAlarms");
        }
        SessionAlarmListener.stopListening(this.invalidaterAlarm);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopAlarms");
        }
    }

    HashMap createSessionTable() {
        return new SessionSimpleHashMap(this.tableSize, this.allowInfinite);
    }

    void startSessionContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.startSessionContext");
        }
        if (sessionIDFactory == null) {
            this.initializeSessionIdTemplate();
        }
        this.startAlarms();
        this.stopSession = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.startSessionContext");
        }
    }

    void stopSessionContext(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.stopSessionContext");
        }
        if (this.getAppName() == "GLOBAL_HTTP_SESSION_CONTEXT") {
            this.stopListeners(string);
        }
        this.decrementRefCount();
        if (this._refCount > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.stopSessionContext: Reference count is not zero, so returning without stopping");
            }
            return;
        }
        this.invalidateAllMemorySessions();
        this.stopSession = true;
        this.tableClear();
        try {
            SessionContextRegistry.remove(this.scAppParms.getAppName());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.stop", (String)"2237", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        this.scPmiData.unregister();
        this.mbeanAdapter.unregisterMBean();
        this.mSessionIdCounter = 0;
        this.stopAlarms();
        this.completedStartup = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopSessionContext");
        }
    }

    void stopListeners(String string) {
        ArrayList arrayList;
        int n;
        if (string == null) {
            Tr.warning((TraceComponent)tc, (String)"SessionContext.stopListeners: j2eename is null");
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.stopListeners for " + string));
        }
        for (n = this.mHttpSessionListeners.size() - 1; n >= 0; --n) {
            arrayList = (ArrayList)this.mHttpSessionListeners.get(n);
            if (!string.equals((String)arrayList.get(0))) continue;
            this.mHttpSessionListeners.remove(n);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("SessionContext.stopListeners: stopping http session listener for: " + string));
        }
        if (this.mHttpSessionListeners.size() == 0) {
            this.sessionListener = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext.stopListeners: stopped all http session listeners");
            }
        }
        for (n = this.mHttpSessionAttributeListeners.size() - 1; n >= 0; --n) {
            arrayList = (ArrayList)this.mHttpSessionAttributeListeners.get(n);
            if (!string.equals((String)arrayList.get(0))) continue;
            this.mHttpSessionAttributeListeners.remove(n);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("SessionContext.stopListeners: stopping http session attribute listener for: " + string));
        }
        if (this.mHttpSessionAttributeListeners.size() == 0) {
            this.sessionAttributeListener = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext.stopListeners: stopped all http session attribute listeners");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopListeners");
        }
    }

    void resetmSessions() {
        this.mSessions = null;
    }

    private void setSessionContextParameters(SessionContextParameters sessionContextParameters) {
        this.mParams = sessionContextParameters;
        this.initializeParameters();
    }

    SessionContextParameters getSessionContextParameters() {
        return this.mParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getLocalHost() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getLocalHost");
        }
        if (mLocalHost == null) {
            SessionContext sessionContext = this;
            synchronized (sessionContext) {
                try {
                    mLocalHost = is_zOS ? AdminHelper.getInstance().getLocalHost() : (InetAddress)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getLocalHost();
                        }
                    });
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:getLocalHost: InetAddress = " + mLocalHost));
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.getLocalHost", (String)"423", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.getLocalHostError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)privilegedActionException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.getLocalHost", (String)"427", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.getLocalHostError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
                }
            }
        }
        return mLocalHost;
    }

    void initializeSessionIdTemplate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.initializeSessionIdTemplate");
        }
        int n = 14;
        n = useBase32 ? sessionIDLength * 5 / 8 + 1 : sessionIDLength * 6 / 8 + 1;
        mSessionIdTemplate = new byte[n];
        int n2 = 8;
        byte[] byArray = this.getLocalHost().getAddress();
        System.arraycopy(byArray, 0, mSessionIdTemplate, n2, 4);
        n2 += 4;
        int n3 = randIdGen.nextInt();
        SessionContext.mSessionIdTemplate[n2++] = (byte)(n3 >> 8 & 0xFF);
        SessionContext.mSessionIdTemplate[n2++] = (byte)(n3 & 0xFF);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.initializeSessionIdTemplate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateSessionIdCount() {
        int n = 0;
        Object object = this.counterSyncher;
        synchronized (object) {
            n = this.mSessionIdCounter++;
        }
        return n;
    }

    String generateSessionId() {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.generateSessionId");
        }
        if (sessionIDFactory != null) {
            return sessionIDFactory.getNextID();
        }
        byte[] byArray = new byte[mSessionIdTemplate.length];
        System.arraycopy(mSessionIdTemplate, 0, byArray, 0, mSessionIdTemplate.length);
        int n2 = 0;
        int n3 = n = this.generateSessionIdCount();
        long l = System.currentTimeMillis();
        n3 = n3 * 39 + (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        n3 = n3 * 39 + (int)(l & 0xFFFFFFFFFFFFFFFFL);
        byArray[n2++] = (byte)(n3 >> 24 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 16 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n3 & 0xFF);
        byArray[n2++] = (byte)(n >> 24 & 0xFF);
        byArray[n2++] = (byte)(n >> 16 & 0xFF);
        byArray[n2++] = (byte)(n >> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        return SessionContext.convertSessionIdBytesToSessionId(byArray);
    }

    static String convertSessionIdBytesToSessionId(byte[] byArray) {
        if (useBase32) {
            return SessionContext.convertSessionIdBytesToSessionIdBase32(byArray);
        }
        return SessionContext.convertSessionIdBytesToSessionIdBase64(byArray);
    }

    static String convertSessionIdBytesToSessionIdBase32(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.convertSessionIdBytesToSessionIdBase32");
        }
        int n = byArray.length * 8;
        char[] cArray = new char[sessionIDLength];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < byArray.length && n4 < sessionIDLength) {
            int n5 = 0;
            if (n3 <= 3) {
                n5 = byArray[n2] >> 3 - n3 & 0x1F;
            } else {
                n5 = byArray[n2] << 5 - (8 - n3);
                if (n2 + 1 < byArray.length) {
                    int n6 = (byArray[n2 + 1] & 0xFF) >> 8 - (5 - (8 - n3));
                    n5 |= (n6 &= sSecondByteMasks[5 - (8 - n3)]);
                }
                n5 &= 0x1F;
            }
            cArray[n4++] = sBitChars[n5];
            if ((n3 += 5) < 8) continue;
            ++n2;
            n3 -= 8;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.convertSessionIdBytesToSessionIdBase32");
        }
        return new String(cArray);
    }

    static String convertSessionIdBytesToSessionIdBase64(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.convertSessionIdBytesToSessionIdBase64");
        }
        int n = byArray.length * 8;
        char[] cArray = new char[sessionIDLength];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < byArray.length && n4 < sessionIDLength) {
            int n5 = 0;
            if (n3 < 3) {
                n5 = byArray[n2] >> 2 - n3 & 0x3F;
            } else {
                n5 = byArray[n2] << 6 - (8 - n3);
                if (n2 + 1 < byArray.length) {
                    int n6 = (byArray[n2 + 1] & 0xFF) >> 8 - (6 - (8 - n3));
                    n5 |= (n6 &= sSecondByteMasks[6 - (8 - n3)]);
                }
                n5 &= 0x3F;
            }
            cArray[n4++] = sBitChars[n5];
            if ((n3 += 6) < 8) continue;
            ++n2;
            n3 -= 8;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.convertSessionIdBytesToSessionIdBase64");
        }
        return new String(cArray);
    }

    boolean insertSessionOnCreation(String string, SessionData sessionData) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.insertSessionOnCreation" + string));
        }
        if ((object = this.tableGet(string)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext:insertSessionOnCreation: Detected duplicate id.  Return true.");
            }
            return true;
        }
        this.tablePut(string, sessionData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext:insertSessionOnCreation: Return false.");
        }
        return false;
    }

    private String getAuthenticatedUser() {
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getAuthenticatedUser");
        }
        if ((string = SecurityContext.getUser()) == null) {
            return "anonymous";
        }
        return string;
    }

    public Enumeration getIds() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getIds");
        }
        return new Hashtable().keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IHttpSession createSession(HttpServletRequest httpServletRequest, String string, boolean bl, boolean bl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.createSession");
        }
        String string2 = null;
        boolean bl3 = false;
        if (this.stopSession) {
            String string3 = SessionContext.getXString("SessionContext.createWhenStop", "SESN0006E: SessionContext: an attempt to create a session while WebSphere Session Manager was turned off was made");
            RuntimeException runtimeException = new RuntimeException(string3);
            throw runtimeException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext:createSession entered with long id = " + string));
        }
        String string4 = string;
        String string5 = null;
        String string6 = null;
        if (string != null) {
            string6 = string.substring(0, this.cacheIdLength);
            string6 = this.resetCacheIdHigherAsNeeded(string, httpServletRequest, string6);
            int n = string.indexOf(cloneSeparator);
            if (n == -1) {
                string = string.substring(this.cacheIdLength);
            } else if (this.colonInSessionIdCheck(string)) {
                string = string.substring(this.cacheIdLength, n);
                string5 = string4.substring(n);
            } else {
                Tr.warning((TraceComponent)tc, (String)"SessionContext.miscData", (Object)"Warning, symbol(:) exception caught: setting id = null");
                string = null;
                string6 = null;
            }
            string = this.checkSessionIdIsRightLength(string);
            if (string == null) {
                string6 = null;
                string4 = null;
                string5 = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext:createSession id without cacheId and clone info is now = " + string));
        }
        IHttpSession iHttpSession = null;
        SessionData sessionData = null;
        int n = 0;
        do {
            ++n;
            if (string == null || bl3) {
                string = this.generateSessionId();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:createSession: generated new sessionid = " + string));
                }
            }
            if (this.allowInfinite) {
                iHttpSession = this.createSessionData(string);
                sessionData = (SessionData)iHttpSession;
            } else {
                if (this.isMaxAllowedReached()) {
                    sessionData = this.overflowData;
                    this.scPmiData.incNoRoomForNewSession();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"SessionContext:createSession: overflow session ");
                    }
                    return sessionData;
                }
                iHttpSession = this.createSessionData(string);
                sessionData = (SessionData)iHttpSession;
            }
            sessionData.initSession(this);
            sessionData.setValidity(true);
            long l = System.currentTimeMillis();
            sessionData.setCreationTime(l);
            sessionData.setLastAccessedTime(l);
            this.updateCloneInfo(sessionData, string5, true, bl2);
            if (string6 != null && this.cacheIdLength > 0) {
                sessionData.setCacheId(string6);
            }
            if (this.integrateWASSec) {
                string2 = this.securityEnabled ? this.getAuthenticatedUser() : httpServletRequest.getRemoteUser();
            }
            if (string2 == null) {
                string2 = "anonymous";
            }
            sessionData.setUser(string2);
            sessionData.setMaxInactInterval((int)this.mSessionInvalidationTime);
            if (bl) {
                sessionData.setUsingSSL(bl);
            }
            if (string4 != null) {
                String string7 = null;
                IHttpSession iHttpSession2 = null;
                Object object = this;
                synchronized (object) {
                    string7 = (String)this.createSync.get(string);
                    if (string7 == null) {
                        string7 = string;
                        this.createSync.put(string, string7);
                    }
                }
                object = string7;
                synchronized (object) {
                    iHttpSession2 = (IHttpSession)this.getFromMemory(string);
                    if (iHttpSession2 != null) {
                        this.createSync.remove(string);
                        return iHttpSession2;
                    }
                    bl3 = this.processSessionOnCreation(string, sessionData);
                    this.createSync.remove(string);
                }
            }
            bl3 = this.processSessionOnCreation(string, sessionData);
        } while (bl3 && n < 10);
        if (n == 10 && bl3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:createSession: Almost stuck in createLoop");
            }
            Tr.warning((TraceComponent)tc, (String)"SessionManager unable to generate unique session id in 10 tries, so gave up");
            return null;
        }
        int n2 = SessionContext.establishAffinity(sessionData);
        if (n2 != 0) {
            Tr.error((TraceComponent)tc, (String)("SessionContext:createSession - call to establishAffinity for id " + string + " failed with rc " + n2));
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"!!!!!SessionContext:createSession: about to increment inServiceMethodCount!!!!!!");
        }
        this.bumpCreateCount();
        sessionData.incrementInServiceMethodCount();
        sessionData.setActive(true, -1L);
        this.updateCurrentThreadSessionId(sessionData);
        if (this.sessionListener) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)sessionData);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:createSession: calling sessionCreatedEvent()");
            }
            this.sessionCreatedEvent(httpSessionEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.createSession");
        }
        return sessionData;
    }

    private final boolean processSessionOnCreation(String string, SessionData sessionData) {
        return this.insertSessionOnCreation(string, sessionData);
    }

    boolean isMaxAllowedReached() {
        return this.mSessions.size() == this.tableSize;
    }

    abstract IHttpSession createSessionData(String var1);

    abstract void performInvalidation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollInvalidations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.pollInvalidations " + this.getAppName()));
        }
        try {
            this.setThreadContext();
            if (debugSessionCrossover) {
                currentThreadSessionId.set((Object)"WAS-SYSTEM-THREAD");
            }
            this.performInvalidation();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.pollInvalidations", (String)"818", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        finally {
            this.unsetThreadContext();
            if (debugSessionCrossover) {
                currentThreadSessionId.set(null);
            }
        }
        this.scPmiData.incInvalidatorExecutedCount();
        this.invalidaterAlarm = SessionAlarmListener.startInvalidationAlarm(this, this.mInvalidationCheckPollInterval * 1000L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.pollInvalidations " + this.getAppName()));
        }
    }

    void asyncExternalWrite() {
    }

    boolean isIBMSessionListenerImplemented() {
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            HttpSessionListener httpSessionListener = (HttpSessionListener)((ArrayList)arrayList.get(i)).get(1);
            if (httpSessionListener == null || !(httpSessionListener instanceof IBMSessionListener)) continue;
            return true;
        }
        return false;
    }

    void notifySessionRemovedFromCache(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.notifySessionRemovedFromCache for " + string));
        }
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            HttpSessionListener httpSessionListener = (HttpSessionListener)((ArrayList)arrayList.get(i)).get(1);
            if (httpSessionListener == null || !(httpSessionListener instanceof IBMSessionListener)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionListener + ".sessionremovedFromCache(" + string + ")"));
            }
            ((IBMSessionListener)httpSessionListener).sessionRemovedFromCache(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.notifySessionRemovedFromCache");
        }
    }

    public void notifySessionInvalidated(SessionData sessionData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.notifySessionInvalidated");
        }
        SessionContext.removeAffinity(sessionData);
        try {
            sessionData.sessionUnbound(this);
            this.removeSessionFromTable(sessionData);
            sessionData.setValidity(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.notifySessionInvalidated");
        }
    }

    void removeSessionFromTable(SessionData sessionData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.removeSessionFromTable");
        }
        this.tableRemove(sessionData.getId());
    }

    public void notifySessionAccessed(SessionData sessionData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.notifySessionAccessed");
        }
        if (sessionData.isValid()) {
            this.scPmiData.incSessionAccessCount();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.notifySessionAccessed");
        }
    }

    long getSessionInvalidationTime() {
        return this.mSessionInvalidationTime;
    }

    public void setSessionInvalidationTime(long l) {
        this.mSessionInvalidationTime = l;
    }

    boolean isSessionTrackingActive() {
        return this.mSessionTrackingActive;
    }

    public boolean isUsingCookies() {
        return this.mUsingCookies;
    }

    public void setUsingCookies(boolean bl) {
        this.mUsingCookies = bl;
    }

    public boolean isUsingURL() {
        return this.mUsingURL;
    }

    public void setUsingURL(boolean bl) {
        this.mUsingURL = bl;
    }

    public boolean isURLProtocolSwitchRewritingActive() {
        return this.mURLProtocolSwitchRewritingActive;
    }

    public void setURLProtocolSwitchRewritingActive(boolean bl) {
        this.mURLProtocolSwitchRewritingActive = bl;
    }

    String getSessionCookieName() {
        return this.mSessionCookieName;
    }

    public void setSessionCookieName(String string) {
        this.mSessionCookieName = string;
    }

    String getSessionCookieComment() {
        return this.mSessionCookieComment;
    }

    public void setSessionCookieComment(String string) {
        this.mSessionCookieComment = string;
    }

    String getSessionCookieDomain() {
        return this.mSessionCookieDomain;
    }

    public void setSessionCookieDomain(String string) {
        this.mSessionCookieDomain = string != null && string.length() > 0 ? string : null;
    }

    int getSessionCookieMaxAge() {
        return this.mSessionCookieMaxAge;
    }

    public void setSessionCookieMaxAge(int n) {
        this.mSessionCookieMaxAge = n;
    }

    String getSessionCookiePath() {
        return this.mSessionCookiePath;
    }

    public void setSessionCookiePath(String string) {
        this.mSessionCookiePath = string;
    }

    boolean getSessionCookieSecure() {
        return this.mSessionCookieSecure;
    }

    public void setSessionCookieSecure(boolean bl) {
        this.mSessionCookieSecure = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCloneInfo(SessionData sessionData, String string, boolean bl, boolean bl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.updateCloneInfo - input cloneInfo=" + string + " newSession=" + bl));
        }
        String string2 = this.getCloneIdWithSeparator();
        if (string != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (!sessionData.isCloneIdUpdated()) {
                    sessionData.setPreviousClones(string);
                    int n = string.indexOf(string2);
                    if (n == -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (!noSwitchOver) {
                            stringBuffer.append(string);
                            stringBuffer.append(string2);
                        } else {
                            stringBuffer.append(string2);
                            stringBuffer.append(string);
                        }
                        sessionData.setPreviousClones(stringBuffer.toString());
                        sessionData.setCloneIdUpdated(true);
                        this.scPmiData.incAffinityBreaks();
                        if (this.cacheIdLength + sessionIDLength + sessionData.getPreviousClones().length() > this.maxSessionIdentifierLength) {
                            String[] stringArray = new String[]{sessionData.getBrowserToken(sessionData.usingSSL()), new Integer(this.maxSessionIdentifierLength).toString()};
                            Tr.warning((TraceComponent)tc, (String)"SessionContext.maxSessionIdLengthExceeded", (Object)stringArray);
                        }
                    } else if (this.checkCookiesOnDispatch && bl2 && bl) {
                        sessionData.setCloneIdUpdated(true);
                    }
                }
            }
        } else if (bl) {
            sessionData.setPreviousClones(string2);
            sessionData.setCloneIdUpdated(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.updateCloneInfo");
        }
    }

    SessionData findSession(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.findSession id=" + string));
        }
        SessionData sessionData = null;
        String string2 = null;
        Object var4_4 = null;
        String string3 = null;
        if (string.length() <= this.cacheIdLength) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.findSession return null because length is too short");
            }
            return null;
        }
        int n = string.indexOf(cloneSeparator);
        if (n == -1) {
            string2 = string.substring(this.cacheIdLength - this.getCacheIdLengthInUse());
        } else if (this.colonInSessionIdCheck(string)) {
            string2 = string.substring(this.cacheIdLength - this.getCacheIdLengthInUse(), n);
            string3 = string.substring(n);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext.miscData", (Object)"Warning, symbol(:) exception caught in findSession: returning null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.findSession");
            }
            return null;
        }
        string = this.checkSessionIdIsRightLength(this.getSessionIDOnly(string));
        if (string == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.findSession nulled id");
            }
            return null;
        }
        sessionData = (SessionData)this.tableGet(string2);
        if (sessionData != null) {
            if (sessionData.isValid() && sessionData.getMaxInactiveInterval() == 0) {
                sessionData.invalidate();
                sessionData = null;
            } else {
                this.updateCloneInfo(sessionData, string3, false, false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.findSession");
        }
        return sessionData;
    }

    int getCacheIdLengthInUse() {
        return 0;
    }

    IHttpSession getIHttpSession(String string, HttpServletRequest httpServletRequest) {
        return this.getIHttpSession(string, httpServletRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IHttpSession getIHttpSession(String string, HttpServletRequest httpServletRequest, boolean bl) {
        boolean bl2 = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.getIHttpSession:  " + string + "  isSSL " + bl));
        }
        if (this.stopSession) {
            String string2 = SessionContext.getXString("SessionContext.accessWhenStop", "SESN0007E: SessionContext: an attempt to access a session while WebSphere Session Manager was turned off was made");
            RuntimeException runtimeException = new RuntimeException(string2);
            throw runtimeException;
        }
        SessionData sessionData = null;
        sessionData = this.findSession(string);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (!sessionData.isValid()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:getIHttpSession - session invalidated since  initial retrival;  id - " + string + " session - " + sessionData));
                    }
                    return null;
                }
                sessionData.initSession(this);
                if (this.integrateWASSec) {
                    this.checkSecurity(sessionData, httpServletRequest);
                }
                long l = sessionData.getLastAccTime();
                sessionData.accessSessionData();
                sessionData.setActive(true, sessionData.getLastAccTime() - l);
                sessionData.incrementInServiceMethodCount();
                sessionData.setNew(false);
                if (bl) {
                    sessionData.setUsingSSL(true);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    String string3 = "SessionContext: found the session for the id " + string;
                    Tr.exit((TraceComponent)tc, (String)string3);
                }
                sessionData.notifyActivateListeners();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string4 = "SessionContext: no valid session for the id " + string;
            Tr.debug((TraceComponent)tc, (String)string4);
        }
        if (sessionData == null) {
            this.scPmiData.IncAttemptToActivateNonExistent();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext:getIHttpSession - leaving and returning session of  " + sessionData));
        }
        return sessionData;
    }

    private String getSessionIDOnly(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getSessionIDOnly - remove the cloneids");
        }
        String string2 = string;
        int n = string.indexOf(cloneSeparator);
        string2 = n == -1 ? string.substring(this.cacheIdLength) : string.substring(this.cacheIdLength, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.getSessionIDOnly returning " + string2));
        }
        return string2;
    }

    public HttpSession getSession(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getSession");
        }
        return null;
    }

    ArrayList getHttpSessionAttributeListeners() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:getHttpSessionAttributeListeners");
        }
        return this.mHttpSessionAttributeListeners;
    }

    ArrayList getHttpSessionListeners() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:getHttpSessionListeners");
        }
        return this.mHttpSessionListeners;
    }

    private void setServletContext(ServletContext servletContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:setServletContext");
        }
        this.mServletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:getServletContext");
        }
        return this.mServletContext == null ? null : ((IServletContext)this.mServletContext).getFacade();
    }

    synchronized void initializeParameters() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.initializeParameters");
        }
        try {
            this.securityEnabled = WSSecurityHelper.isServerSecurityEnabled();
            if (!hideSessionValuesPropertySet) {
                hideSessionValues = this.securityEnabled;
            }
            this.setSessionTimeoutInfo();
            this.tableSize = this.mParams.getInMemorySize();
            if (this.tableSize <= 0) {
                throw new RuntimeException("In memory session size cannot be less than or equal to 0");
            }
            this.allowInfinite = this.mParams.getEnableOverflow();
            this.setUsingCookies(this.mParams.getEnableCookies());
            this.setUsingURL(this.mParams.getEnableUrlRewriting());
            this.setURLProtocolSwitchRewritingActive(this.mParams.getEnableUrlProtocolSwitchRewriting());
            this.setSessionCookieName(this.mParams.getSessionCookieName());
            this.setSessionCookieComment(this.mParams.getSessionCookieComment());
            String string = this.mParams.getSessionCookieDomain();
            if (string != null && string.length() > 0) {
                this.setSessionCookieDomain(string);
            } else {
                this.setSessionCookieDomain(null);
            }
            this.setSessionCookieMaxAge(this.mParams.getSessionCookieMaxAge());
            this.setSessionCookiePath(this.mParams.getSessionCookiePath());
            this.setSessionCookieSecure(this.mParams.getSessionCookieSecure());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - cloneId for this JVM is " + cloneId));
            }
            if (cloneId != null) {
                cloneIdLength = cloneId.length();
            }
            if (this.mParams.usingDatabase() && !this.mParams.getEnableTimeBasedWrite()) {
                pinSR = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - pinSR set to " + pinSR));
            }
            this.useSSLId = this.mParams.useSSLId();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.initializeParameters : UseSSLId = " + this.useSSLId));
            }
            this.integrateWASSec = this.mParams.getIntegrateSecurity();
            this.timedOutAffinityEnabled = this.mParams.getEnableAffinityTimeout();
            if (this.timedOutAffinityEnabled) {
                this.affinityTimeOut = this.mParams.getAffinityTimeoutInterval();
            }
            this.allowSerializedSessionAccess = this.mParams.getAllowSerializedSessionAccess();
            this.serializedSessionAccessMaxWaitTime = this.mParams.getSerializedSessionAccessMaxWaitTime();
            this.accessSessionOnTimeout = this.mParams.getAccessSessionOnTimeout();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" ");
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - timedOutAffinityEnabled is : " + this.timedOutAffinityEnabled));
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - affinityTimeOut is : " + this.affinityTimeOut));
            }
            zAffinityCloneId = cloneId;
            if (turnOffCloneId && (SessionMgrComponentImpl.getServerId().equals("-1") || is_zOS && !SessionMgrComponentImpl.getClusterServerMode())) {
                cloneId = "";
                cloneIdLength = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SessionContext:initializeParameters - Remove CloneID because NoAdditionalSessionInfo=true.");
                }
            }
            cloneSeparator = cloneSep.charAt(0);
            this.cloneIdWithSep = cloneId != null && cloneId.length() > 0 ? cloneSep + cloneId : "";
            this.cacheIdPlusIdlength = this.cacheIdLength + sessionIDLength;
        }
        catch (SessionContextParameterException sessionContextParameterException) {
            FFDCFilter.processException((Throwable)sessionContextParameterException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.initializeParameters", (String)"1555", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sessionContextParameterException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.initializeParameters");
        }
    }

    void setSessionTimeoutInfo() {
        this.setSessionTimeoutInfo(0);
    }

    synchronized void setSessionTimeoutInfo(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.setSessionTimeoutInfo");
        }
        long l = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (n == 0) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:setSessionTimeoutInfo --  Normal Update");
            } else {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo -- Dynamic Global Update.. input parm = " + n));
            }
        }
        try {
            long l2;
            long l3 = l2 = this.scAppParms.getSessionTimeout();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo timeout value in WebApp is" + l3));
            }
            if (l2 == 0L) {
                l = n != 0 ? (long)n : this.mParams.getSessionInvalidationTime();
                l3 = l;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo Global timeout is: " + l3));
                }
            }
            if (n == 0 || l2 == 0L) {
                l3 = this.checkMinimumInvalidation(l3);
                this.setSessionInvalidationTime(l3);
                int n2 = randIdGen.nextInt() % 30;
                if (n2 < 0) {
                    n2 *= -1;
                }
                if (this.mInvalidationCheckPollInterval <= 0L) {
                    if (l3 < 120L) {
                        this.mInvalidationCheckPollInterval = 60 - n2;
                    }
                    if (l3 >= 120L && l3 < 900L) {
                        this.mInvalidationCheckPollInterval = 60 + n2;
                    }
                    if (l3 >= 900L) {
                        this.mInvalidationCheckPollInterval = 300 + 2 * n2;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo -- Updating timeout value to: " + l3));
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo -- mInvalidationCheckPollInterval is now: " + this.mInvalidationCheckPollInterval));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:setSessionTimeoutInfo -- Timeout Value NOT Updated");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.setSessionTimeoutInfo", (String)"1646", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.setSessionTimeoutInfo");
        }
    }

    long checkMinimumInvalidation(long l) {
        return l;
    }

    public boolean shouldEncodeURL(String string, HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.shouldEncodeURL");
        }
        if (!this.isUsingURL()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeOff");
            }
            return false;
        }
        if (!this.isProtocolSwitch(string, httpServletRequest)) {
            return true;
        }
        if (this.isURLProtocolSwitchRewritingActive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeProtocolSwitchon");
            }
            return true;
        }
        return false;
    }

    public boolean shouldEncodeRedirectURL(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.shouldEncodeRedirectURL");
        }
        if (!this.isUsingURL()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeOff");
            }
            return false;
        }
        return true;
    }

    private boolean isProtocolSwitch(String string, HttpServletRequest httpServletRequest) {
        InetAddress inetAddress;
        int n;
        char c;
        int n2;
        int n3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.isProtocolSwitch");
        }
        if ((n3 = string.indexOf("://")) < 0) {
            return false;
        }
        String string2 = string.substring(0, n3);
        if (!(string2.equalsIgnoreCase("http") && httpServletRequest.getScheme().equalsIgnoreCase("https") || string2.equalsIgnoreCase("https") && httpServletRequest.getScheme().equalsIgnoreCase("http"))) {
            return false;
        }
        int n4 = string.length();
        for (n2 = n = n3 + 3; n2 < n4 && (c = string.charAt(n2)) != ':' && c != '/'; ++n2) {
        }
        String string3 = string.substring(n, n2);
        try {
            inetAddress = InetAddress.getByName(string3);
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.isProtocolSwitch", (String)"1760", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)unknownHostException);
            return false;
        }
        return inetAddress.equals(this.getLocalHost());
    }

    public void sync(HttpSession httpSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.sync");
        }
    }

    public void reload(String string) {
        this.stopSessionContext(string);
    }

    public String toHTML() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toHTML");
        }
        String string = this.scAppParms.getJ2EEName();
        String string2 = "<b> (for this webapp) : </b> ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<center><h3>J2EE NAME(AppName#WebModuleName):: " + string + " </h3></center>" + "<UL>\n").append("<b>  cloneId</b> : ").append(cloneId).append("<BR>").append("<BR>").append("<b>  Number of sessions in memory: </b>").append(string2).append(this.mSessions != null ? this.mSessions.size() : 0).append("<BR>").append("<b>  use overflow</b> : ").append(this.allowInfinite).append("<BR>").append("<b>  overflow size</b> ").append(string2).append("<BR>").append("<b>  Invalidation alarm poll interval (for this webapp) </b> : ").append(this.mInvalidationCheckPollInterval).append("<BR>").append("<b> Max invalidation timeout (for this webapp) </b> : ").append(this.mSessionInvalidationTime).append("<BR>").append("<b> Using Cookies </b> : ").append(this.mUsingCookies).append("<BR>").append("<b> Using URL Rewriting </b> : ").append(this.mUsingURL).append("<BR>").append("<b> use SSLId </b> : ").append(this.useSSLId).append("<BR>").append("<b> URL Protocol Switch Rewriting </b> : ").append(this.mURLProtocolSwitchRewritingActive).append("<BR>").append("<b> Session Cookie Name </b> : ").append(this.mSessionCookieName).append("<BR>").append("<b> Session Cookie Comment </b> : ").append(this.mSessionCookieComment).append("<BR>").append("<b> Session Cookie Domain </b> : ").append(this.mSessionCookieDomain).append("<BR>").append("<b> Session Cookie Path </b> : ").append(this.mSessionCookiePath).append("<BR>").append("<b> Session Cookie MaxAge </b> : ").append(this.mSessionCookieMaxAge).append("<BR>").append("<b> Session Cookie Secure </b> : ").append(this.mSessionCookieSecure).append("<BR>").append("<b> Maximum in memory table size </b> : ").append(this.tableSize).append("<BR>").append("<b> current time </b> : ").append(new Date(System.currentTimeMillis()).toString()).append("<BR>").append("<b>  integrateWASSec</b> :").append(this.integrateWASSec).append("<BR><b>Session locking </b>: ").append(this.allowSerializedSessionAccess).append("<BR><b>Session locking timeout</b>: ").append(this.serializedSessionAccessMaxWaitTime).append("<BR><b>Allow access on lock timeout</b>:").append(this.accessSessionOnTimeout).append(this.scPmiData.toHTML()).append(this.mbeanAdapter.toHTML());
        return stringBuffer.toString();
    }

    public String toHTML2() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toHTML");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<center><h3>Session Tracking Internals</h3></center><UL>\n").append("<b>  mSessions </b> : ").append(this.mSessions != null ? this.mSessions.toString() : null).append("<BR>");
        return stringBuffer.toString();
    }

    public String toString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nSession Tracking Internals for webapp " + this.scAppParms.getJ2EEName() + ": \n").append("\n").append("  mSessions size : ").append(this.mSessions != null ? this.mSessions.size() : 0).append("\n").append("  use overflow : ").append(this.allowInfinite).append("\n").append("  overflow size : ").append("\n").append("mInvalidationCheckPollInterval : ").append(this.mInvalidationCheckPollInterval).append("\n").append("mSessionInvalidationTime  : ").append(this.getSessionInvalidationTime()).append("\n").append("mSessionTrackingActive  : ").append(this.isSessionTrackingActive()).append("\n").append("mUsingCookies  : ").append(this.isUsingCookies()).append("\n").append("mUsingURL  : ").append(this.isUsingURL()).append("\n").append("useSSLId  : ").append(this.useSSLId).append("\n").append("mURLProtocolSwitchRewritingActive  : ").append(this.isURLProtocolSwitchRewritingActive()).append("\n").append("mSessionCookieName  : ").append(this.getSessionCookieName()).append("\n").append("mSessionCookieComment  : ").append(this.getSessionCookieComment()).append("\n").append("mSessionCookieDomain  : ").append(this.getSessionCookieDomain()).append("\n").append("mSessionCookiePath  : ").append(this.getSessionCookiePath()).append("\n").append("mSessionCookieSecure  : ").append(this.getSessionCookieSecure()).append("\n").append("mSessionCookieMaxAge  : ").append(this.getSessionCookieMaxAge()).append("\n").append("in memory table size : ").append(this.tableSize).append("\n").append("current time : ").append(new Date(System.currentTimeMillis()).toString()).append("\n").append("integrateWASSec :").append(this.integrateWASSec).append("\n").append("\nSession serialization: ").append(this.allowSerializedSessionAccess).append("\nSession serialization timeout: ").append(this.serializedSessionAccessMaxWaitTime).append("Allow access on serialization timeout:").append(this.accessSessionOnTimeout);
        return stringBuffer.toString();
    }

    String toString2() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toString2");
        }
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        stringBuffer.append("mSessions : ").append(this.mSessions != null ? this.mSessions.toString() : null).append("\n");
        return stringBuffer.toString();
    }

    void tablePut(Object object, Object object2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tablePut");
        }
        try {
            this.mSessions.put(object, object2);
            this.incMemoryCount();
        }
        catch (TooManySessionsException tooManySessionsException) {
            FFDCFilter.processException((Throwable)tooManySessionsException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.tablePut", (String)"2008", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)tooManySessionsException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.tablePut");
        }
    }

    void incMemoryCount() {
        this.scPmiData.incMemoryCount();
    }

    void decMemoryCount() {
        this.scPmiData.decMemoryCount();
    }

    Object tableGet(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tableGet");
        }
        return this.mSessions.get(object);
    }

    void tableRemove(Object object) {
        Object v;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.tableRemove " + object));
        }
        if ((v = this.mSessions.remove(object)) != null) {
            this.decMemoryCount();
            if (this.mIBMSessionListenerImplemented) {
                this.notifySessionRemovedFromCache((String)object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.tableRemove");
        }
    }

    void tableRemoveRefresh(Object object) {
    }

    void tableClear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tableClear");
        }
        HashSet hashSet = new HashSet(this.mSessions.keySet());
        this.mSessions.clear();
        if (this.mIBMSessionListenerImplemented) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.notifySessionRemovedFromCache((String)iterator.next());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.tableClear");
        }
    }

    HashMap getHashMap() {
        return this.mSessions;
    }

    boolean isSessionIdInUse(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.IsSessionIdInUse: entered with " + string));
        }
        boolean bl = false;
        Enumeration enumeration = SessionContextRegistry.getScrSessionContexts();
        while (enumeration.hasMoreElements() && !bl) {
            Object object;
            SessionContext sessionContext = (SessionContext)enumeration.nextElement();
            if (sessionContext == this || (object = sessionContext.getFromMemory(string)) == null) continue;
            bl = true;
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.IsSessionIdInUse Found in Cache/Mem");
            }
            return bl;
        }
        bl = this.isPresentInExternalStore(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext:isSessionIdInUse: after persistent store scan returning: " + bl));
        }
        return bl;
    }

    Object getFromMemory(Object object) {
        return this.mSessions.get(object);
    }

    boolean isPresentInExternalStore(Object object) {
        return false;
    }

    Enumeration tableKeys() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tableKeys");
        }
        Set set = this.mSessions != null ? this.mSessions.keySet() : new HashMap(1).keySet();
        final Iterator iterator = set.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    int getCloneIdLength() {
        return cloneIdLength;
    }

    String getCloneId() {
        return cloneId;
    }

    String getIDFromBytes(byte[] byArray) {
        return SessionContext.convertSessionIdBytesToSessionId(byArray);
    }

    public boolean isSSLSessions() {
        return this.useSSLId;
    }

    boolean getAllowSerializedSessionAccess() {
        return this.allowSerializedSessionAccess;
    }

    int getSerializedSessionAccessMaxWaitTime() {
        return this.serializedSessionAccessMaxWaitTime;
    }

    boolean getAccessSessionOnTimeout() {
        return this.accessSessionOnTimeout;
    }

    void invalidateAllMemorySessions() {
    }

    public synchronized void stop(String string) {
        this.stopSessionContext(string);
    }

    public String getCloneSeparator() {
        return cloneSep;
    }

    String getCloneIdWithSeparator() {
        return this.cloneIdWithSep;
    }

    String getAppName() {
        try {
            return this.scAppParms.getAppName();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.getAppName", (String)"2256", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
            return null;
        }
    }

    public HttpSession getIHttpSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        return this.getIHttpSession(httpServletRequest, httpServletResponse, bl, false);
    }

    private HttpSession getIHttpSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, boolean bl2) {
        int n;
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.getIHttpSession(req,res,create,cacheOnly): create = " + bl + " cacheOnly= " + bl2));
        }
        boolean bl3 = false;
        boolean bl4 = false;
        IHttpSession iHttpSession = null;
        String string = null;
        String string2 = ((IExtendedRequest)httpServletRequest).getUpdatedSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext.getIHttpSession: id from request object is " + string2));
        }
        if (string2 != null) {
            string = string2;
        }
        if (string == null) {
            string = this.getFullSessionId(httpServletRequest);
            if (!this.useSSLId && string != null) {
                bl4 = true;
                if (string.length() < this.cacheIdPlusIdlength) {
                    Tr.warning((TraceComponent)tc, (String)("SessionContext.getIHttpSession: id " + string + " failed length check against " + this.cacheIdPlusIdlength));
                    string = null;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext.getIHttpSession : UseSSLId = " + this.useSSLId));
        }
        if (this.useSSLId && ((IExtendedRequest)httpServletRequest).getSSLId() != null) {
            bl3 = true;
        }
        if (string != null && Boolean.valueOf(httpServletRequest.getHeader("$WSFO")).booleanValue()) {
            this.tableRemoveRefresh(this.getSessionIDOnly(string));
            iHttpSession = null;
        }
        if (!(string == null || bl2 && this.getFromMemory(this.getSessionIDOnly(string)) == null)) {
            iHttpSession = this.getIHttpSession(string, httpServletRequest, bl3);
        }
        if (iHttpSession == null && (bl4 || this.checkCookiesOnDispatch)) {
            object = this.getAllRequestedSessionIdsFromCookies(httpServletRequest);
            int n2 = n = !this.checkCookiesOnDispatch || string2 == null;
            if (object != null && object.size() > n && (iHttpSession = this.checkAllCookies((List)object, n, httpServletRequest, bl3)) != null) {
                string = ((SessionData)iHttpSession).getCacheId() + iHttpSession.getId();
            }
        }
        if (iHttpSession != null) {
            object = this.getSessionIDOnly(string);
            if (!((String)object).equals(iHttpSession.getId())) {
                Object[] objectArray = new Object[]{this.getAppName(), iHttpSession.getId(), object, new SessionCrossoverStackTrace()};
                Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnRetrieve", (Object)objectArray);
                iHttpSession = null;
            } else if (this.crossoverCheck(httpServletRequest, iHttpSession.getId())) {
                Object[] objectArray = new Object[]{this.getAppName(), iHttpSession.getId(), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
                Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnRetrieve", (Object)objectArray);
                iHttpSession = null;
            }
        }
        if (iHttpSession == null && bl) {
            if (string != null) {
                if (bl3) {
                    iHttpSession = this.createSession(httpServletRequest, string, true, string2 != null);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext.getIHttpSession : sslReq path so create session with Id = " + string));
                    }
                } else {
                    object = null;
                    if (!idReuse && string.length() >= this.cacheIdPlusIdlength) {
                        object = string.substring(this.cacheIdLength, this.cacheIdPlusIdlength);
                    }
                    iHttpSession = idReuse || string2 != null || this.isSessionIdInUse((String)object) ? this.createSession(httpServletRequest, string, false, string2 != null) : this.createSession(httpServletRequest, null, false, string2 != null);
                }
            } else {
                iHttpSession = this.createSession(httpServletRequest, null, false, string2 != null);
            }
        }
        if (iHttpSession != null) {
            ((SessionData)iHttpSession).setPathInfo(httpServletRequest.getPathInfo());
            object = null;
            n = iHttpSession.usingSSL();
            if (this.mUsingCookies && iHttpSession.isBrowserTokenUpdated() && (object = iHttpSession.testAndGetBrowserToken(n != 0)) != null) {
                this.setCookie(httpServletRequest, httpServletResponse, (String)object, n != 0);
            }
            if (this.isSIPApplication) {
                ((SessionData)iHttpSession).setSIPCookieInfo(httpServletRequest);
                if (!httpServletResponse.isCommitted()) {
                    this.setSIPCookieIfApplicable(httpServletRequest, httpServletResponse, (SessionData)iHttpSession);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling req.setSessionid  " + iHttpSession.getBrowserToken(n != 0)));
            }
            ((IExtendedRequest)httpServletRequest).setSessionId(iHttpSession.getBrowserToken(n != 0));
        } else if (idReuse && string != null && string2 == null) {
            ((IExtendedRequest)httpServletRequest).setSessionId(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.getIHttpSession(req,res,create,cacheOnly)");
        }
        return iHttpSession;
    }

    private IHttpSession checkAllCookies(List list, int n, HttpServletRequest httpServletRequest, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.checkAllCookies got this many cookies: " + list.size()));
        }
        IHttpSession iHttpSession = null;
        for (int i = n; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string == null || string.length() < this.cacheIdPlusIdlength || (iHttpSession = this.getIHttpSession(string, httpServletRequest, bl)) == null) continue;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("SessionContext.checkAllCookies found session using cookie index " + i + " with id " + string));
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String string = iHttpSession == null ? "null" : "non-null";
            Tr.exit((TraceComponent)tc, (String)("SessionContext.checkAllCookies returning " + string));
        }
        return iHttpSession;
    }

    private String getFullSessionId(HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getFullSessionId");
        }
        String string = null;
        if (this.useSSLId) {
            string = this.getRequestedSessionIdFromSSL(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.getFullSessionId: SSL Id = " + string));
            }
            if (string != null) {
                return string;
            }
        }
        if (this.mUsingCookies) {
            string = this.getRequestedSessionIdFromCookie(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.getFullSessionId: Cookie Id = " + string));
            }
            if (string != null) {
                return string;
            }
        }
        if (this.mUsingURL) {
            string = this.getRequestedSessionIdFromURL(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.getFullSessionId: URL Id = " + string));
            }
            if (string != null) {
                return string;
            }
        }
        return null;
    }

    public String getRequestedSessionId(HttpServletRequest httpServletRequest) {
        List list;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getRequestedSessionId");
        }
        String string = null;
        if (this.useSSLId && (string = this.getRequestedSessionIdFromSSL(httpServletRequest)) != null) {
            return this.getSessionIDOnly(string);
        }
        if (this.mUsingCookies && (list = this.getAllRequestedSessionIdsFromCookies(httpServletRequest)) != null) {
            IHttpSession iHttpSession;
            if (list.size() > 1 && (iHttpSession = this.checkAllCookies(list, 0, httpServletRequest, false)) != null) {
                return iHttpSession.getId();
            }
            if (list.size() > 0 && (string = (String)list.get(0)) != null && this.colonInSessionIdCheck(string)) {
                return this.getSessionIDOnly(string);
            }
        }
        if (this.mUsingURL && (string = this.getRequestedSessionIdFromURL(httpServletRequest)) != null && this.colonInSessionIdCheck(string)) {
            return this.getSessionIDOnly(string);
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie(HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.isRequestedSessionIdFromCookie");
        }
        String string = null;
        if (this.useSSLId) {
            string = this.getRequestedSessionIdFromSSL(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.isRequestedSessionIdFromCookie: SSL Id = " + string));
            }
            if (string != null) {
                return false;
            }
        }
        if (this.mUsingCookies) {
            string = this.getRequestedSessionIdFromCookie(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.isRequestedSessionIdFromCookie: Cookie Id = " + string));
            }
            if (string != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl(HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.isRequestedSessionIdFromUrl");
        }
        String string = null;
        if (this.useSSLId) {
            string = this.getRequestedSessionIdFromSSL(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.isRequestedSessionIdFromURL: SSL Id = " + string));
            }
            if (string != null) {
                return false;
            }
        }
        if (this.mUsingCookies) {
            string = this.getRequestedSessionIdFromCookie(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.isRequestedSessionIdFromURL: Cookie Id = " + string));
            }
            if (string != null) {
                return false;
            }
        }
        if (this.mUsingURL) {
            string = this.getRequestedSessionIdFromURL(httpServletRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.isRequestedSessionIdFromURL: URL Id = " + string));
            }
            if (string != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isRequestedSessionIdValid(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.isRequestedSessionIdValid");
        }
        if ((string = this.getFullSessionId(httpServletRequest)) == null) {
            return false;
        }
        if (httpSession == null) {
            return false;
        }
        if (httpSession.isNew()) {
            return false;
        }
        if ((string = this.getSessionIDOnly(string)).equals(httpSession.getId())) {
            return true;
        }
        List list = this.getAllRequestedSessionIdsFromCookies(httpServletRequest);
        if (list != null && list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                if (string2 == null || string2.length() <= this.cacheIdLength || !this.colonInSessionIdCheck(string2) || !(string = this.getSessionIDOnly(string2)).equals(httpSession.getId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession sessionPreInvoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        String string2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.sessionPreInvoke");
        }
        if (debugSessionCrossover) {
            string2 = ((IExtendedRequest)httpServletRequest).getUpdatedSessionId();
            if (string2 == null) {
                string2 = this.getFullSessionId(httpServletRequest);
            }
            if (string2 != null) {
                string = this.getSessionIDOnly(string2);
                currentThreadSessionId.set((Object)string);
            } else {
                string = new String("NONE");
                currentThreadSessionId.set((Object)string);
            }
        }
        if (this.integrateWASSec && httpServletRequest instanceof IExtendedRequest) {
            ((IExtendedRequest)httpServletRequest).setRunningCollaborators(true);
        }
        string2 = this.getIHttpSession(httpServletRequest, httpServletResponse, false, this.onlyCheckInCacheDuringPreInvoke);
        if (this.integrateWASSec && httpServletRequest instanceof IExtendedRequest) {
            ((IExtendedRequest)httpServletRequest).setRunningCollaborators(false);
        }
        if (!this.allowSerializedSessionAccess) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.sessionPreInvoke");
            }
            return string2;
        }
        string = (String)httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested");
        if (string == null || string != null && string.equalsIgnoreCase("false")) {
            try {
                int n = this.serializedSessionAccessMaxWaitTime * 1000;
                if (string2 != null) {
                    LinkedList linkedList;
                    Object object;
                    String string3 = string2;
                    synchronized (string3) {
                        if (((SessionData)((Object)string2)).lockList == null || ((SessionData)((Object)string2)).lockPool == null) {
                            ((SessionData)((Object)string2)).initSerialAccessLocks();
                            object = ((IHttpSession)((Object)string2)).getLockObj();
                            linkedList = ((IHttpSession)((Object)string2)).getLockList();
                        } else {
                            object = ((IHttpSession)((Object)string2)).getLockObj();
                            linkedList = ((IHttpSession)((Object)string2)).getLockList();
                        }
                    }
                    int n2 = 0;
                    LinkedList linkedList2 = linkedList;
                    synchronized (linkedList2) {
                        Object object2 = object;
                        synchronized (object2) {
                            linkedList.addLast(object);
                            n2 = linkedList.size();
                            ((SessionData)((Object)string2)).setSessionLock(Thread.currentThread(), object);
                        }
                    }
                    if (n2 != 1) {
                        long l = System.currentTimeMillis();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"waiting...");
                        }
                        Object object3 = object;
                        synchronized (object3) {
                            object.wait(n);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"done waiting.");
                        }
                        long l2 = System.currentTimeMillis();
                        LinkedList linkedList3 = linkedList;
                        synchronized (linkedList3) {
                            if (l2 - (long)n >= l) {
                                while (linkedList.size() > 0 && object != linkedList.getFirst()) {
                                    Object e;
                                    Object e2 = e = linkedList.removeFirst();
                                    synchronized (e2) {
                                        try {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"notify after wait timed out");
                                            }
                                            e.notify();
                                        }
                                        catch (Throwable throwable) {
                                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.sessionPreInvoke", (String)"2454", (Object)string2);
                                            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                                        }
                                    }
                                    ((IHttpSession)((Object)string2)).retLockObj(e);
                                }
                                if (!this.accessSessionOnTimeout) {
                                    linkedList.remove(object);
                                    Tr.error((TraceComponent)tc, (String)"HttpSession transaction timed out - configured to not allow access.  Check  for hung applications, possibly by dumping the threads of the application server");
                                    throw new RuntimeException("Session Lock time outException");
                                }
                            }
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"SessionContext.sessionPreInvoke", (Object)string2);
                }
                return string2;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.sessionPreInvoke", (String)"2495", (Object)this);
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)interruptedException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.sessionPreInvoke", (Object)"null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionPostInvoke(HttpSession httpSession) {
        Object object;
        IHttpSession iHttpSession;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.sessionPostInvoke");
        }
        if (this.allowSerializedSessionAccess) {
            iHttpSession = (IHttpSession)httpSession;
            object = ((SessionData)httpSession).getSessionLock(Thread.currentThread());
            if (object != null) {
                LinkedList linkedList;
                LinkedList linkedList2 = linkedList = iHttpSession.getLockList();
                synchronized (linkedList2) {
                    block18: {
                        try {
                            linkedList.remove(object);
                            if (linkedList.size() > 0) {
                                Object e = linkedList.getFirst();
                                if (e == null) break block18;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"notify after postInvoke");
                                }
                                Object e2 = e;
                                synchronized (e2) {
                                    e.notify();
                                    break block18;
                                }
                            }
                            ((SessionData)httpSession).clearSessionLocks();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                iHttpSession.retLockObj(object);
            }
        }
        if ((iHttpSession = (SessionData)httpSession) != null) {
            object = iHttpSession;
            synchronized (object) {
                ((SessionData)iHttpSession).releaseSession();
                ((SessionData)iHttpSession).decrementInServiceMethodCount();
                ((SessionData)iHttpSession).setActive(false, -2L);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.sessionPostInvoke");
        }
    }

    private String getRequestedSessionIdFromSSL(HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromSSL");
        }
        String string = null;
        IExtendedRequest iExtendedRequest = (IExtendedRequest)httpServletRequest;
        if (this.useSSLId) {
            string = this.getSSLId(iExtendedRequest);
            if (string != null) {
                String string2 = "0001";
                String string3 = "";
                String string4 = null;
                byte[] byArray = iExtendedRequest.getCookieValueAsBytes(dcookieName);
                if (byArray != null) {
                    string4 = new String(byArray);
                }
                if (string4 == null) {
                    string4 = this.getRequestedSessionIdFromURL(httpServletRequest);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getRequestedSessionId - encoded URL contains: " + string4));
                    }
                }
                if (string4 != null) {
                    string2 = string4.substring(0, 4);
                    int n = string4.indexOf(this.getCloneSeparator());
                    if (n != -1) {
                        String string5 = string4.substring(4, n);
                        string3 = string4.substring(n);
                    }
                }
                string = string2 + string + string3;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRequestedSessionId - massaged long SSL id is now: " + string));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromSSL");
        }
        return string;
    }

    private String getRequestedSessionIdFromCookie(HttpServletRequest httpServletRequest) {
        IExtendedRequest iExtendedRequest;
        byte[] byArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromCookie");
        }
        String string = null;
        if (this.mUsingCookies && (byArray = (iExtendedRequest = (IExtendedRequest)httpServletRequest).getCookieValueAsBytes(this.mSessionCookieName)) != null) {
            string = new String(byArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.getRequestedSessionIdFromCookie returning " + string));
        }
        return string;
    }

    private List getAllRequestedSessionIdsFromCookies(HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.getAllRequestedSessionIdsFromCookies: usingCookies is " + this.mUsingCookies));
        }
        List list = null;
        if (this.mUsingCookies) {
            list = ((IExtendedRequest)httpServletRequest).getAllCookieValues(this.mSessionCookieName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.getAllRequestedSessionIdsFromCookies returning " + list));
        }
        return list;
    }

    private String getRequestedSessionIdFromURL(HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromURL");
        }
        String string = null;
        if (this.mUsingURL) {
            int n;
            String string2 = ((IExtendedRequest)httpServletRequest).getEncodedRequestURI();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("request uri:" + string2));
            }
            if ((n = string2.indexOf(sessUrlRewritePrefix)) != -1) {
                string = string2.substring(n + sessUrlRewritePrefix.length());
            }
        }
        return string;
    }

    private String getSSLId(IExtendedRequest iExtendedRequest) {
        byte[] byArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getSSLId");
        }
        if ((byArray = iExtendedRequest.getSSLId()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.getSSLId : SSL Id from Request = " + this.getIDFromBytes(byArray)));
            }
            return this.getIDFromBytes(byArray);
        }
        return null;
    }

    protected void setCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
        Object[] objectArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext.setCookie :" + string));
        }
        if (httpServletResponse.isCommitted()) {
            boolean bl2 = new Boolean((String)httpServletRequest.getAttribute("com.ibm.portal.cookie.already.set"));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("req.getAttribute(com.ibm.portal.cookie.already.set): " + httpServletRequest.getAttribute("com.ibm.portal.cookie.already.set")));
            }
            if (!bl2) {
                Tr.warning((TraceComponent)tc, (String)"SessionContext.responseAlreadyCommitted");
                httpServletRequest.setAttribute("com.ibm.portal.cookie.already.set", (Object)"true");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set request attribute com.ibm.portal.cookie.already.set to true");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SessionContext.responseAlreadyCommitted already logged");
                }
                return;
            }
        }
        Cookie cookie = null;
        String string2 = null;
        if (!bl) {
            string2 = this.mSessionCookieName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.setCookie: non sslRequest value = " + bl + "   CookieName = " + string2));
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getSession - sending Dummy Cookie");
            }
            string2 = dcookieName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.setCookie: sslRequest value = " + bl + "   CookieName = " + string2));
            }
        }
        if (this.crossoverCheck(httpServletRequest, this.getSessionIDOnly(string))) {
            objectArray = new Object[]{this.getAppName(), this.getSessionIDOnly(string), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
            Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnReturn", (Object)objectArray);
        }
        cookie = new Cookie(string2, string);
        cookie.setComment(this.mSessionCookieComment);
        cookie.setPath(this.mSessionCookiePath);
        cookie.setMaxAge(this.mSessionCookieMaxAge);
        objectArray = this.mSessionCookieDomain;
        if (objectArray != null) {
            cookie.setDomain((String)objectArray);
        }
        cookie.setSecure(this.mSessionCookieSecure);
        ((IExtendedResponse)httpServletResponse).addSessionCookie(cookie);
        httpServletRequest.setAttribute("com.ibm.session.setcookie.values", (Object)string);
    }

    public String encodeURL(HttpSession httpSession, HttpServletRequest httpServletRequest, String string) {
        int n;
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            object = string;
            if (hideSessionValues && object != null && (n = ((String)object).indexOf("?")) != -1) {
                object = ((String)object).substring(0, n);
            }
            Tr.entry((TraceComponent)tc, (String)"SessionContext.encodeURL", (Object)object);
        }
        if (httpSession == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeURL returning null");
            }
            return null;
        }
        object = (IHttpSession)httpSession;
        if (this.shouldEncodeURL(string, httpServletRequest)) {
            n = object.usingSSL() ? 1 : 0;
            String string2 = null;
            string2 = n != 0 ? object.getBrowserToken(true) : object.getBrowserToken(false);
            if (string2 != null) {
                SessionData sessionData;
                if (!(!this.crossoverCheck(httpServletRequest, this.getSessionIDOnly(string2)) || (sessionData = (SessionData)object).internalIsNew() && sessionData.isCreatedOnUserThread())) {
                    Object[] objectArray = new Object[]{this.getAppName(), httpSession.getId(), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
                    Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnReturn", (Object)objectArray);
                }
                if (!SessionContext.isSafe(string2)) {
                    return string;
                }
                int n2 = -1;
                int n3 = string.indexOf(sessUrlRewritePrefix);
                if (n3 != -1) {
                    n2 = string.indexOf(";", n3 + 1);
                }
                if (n2 == -1) {
                    int n4 = string.indexOf("?");
                    int n5 = string.indexOf("#");
                    if (n4 != -1 && n5 != -1 && n5 < n4) {
                        n4 = n5;
                    }
                    if (n4 == -1 && n5 != -1) {
                        n4 = n5;
                    }
                    n2 = n4;
                }
                if (n3 == -1) {
                    n3 = n2;
                }
                String string3 = null;
                String string4 = null;
                StringBuffer stringBuffer = null;
                if (n3 != -1) {
                    string3 = string.substring(0, n3);
                    stringBuffer = new StringBuffer(string3);
                    if (n2 != -1) {
                        string4 = string.substring(n2, string.length());
                    }
                } else {
                    stringBuffer = new StringBuffer(string);
                }
                stringBuffer.append(sessUrlRewritePrefix);
                stringBuffer.append(string2);
                if (n2 != -1) {
                    stringBuffer.append(string4);
                }
                string = stringBuffer.toString();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            int n6;
            String string5 = string;
            if (hideSessionValues && string5 != null && (n6 = string5.indexOf("?")) != -1) {
                string5 = string5.substring(0, n6);
            }
            Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeURL, new url is ", (Object)string5);
        }
        return string;
    }

    public boolean isValid(HttpSession httpSession, HttpServletRequest httpServletRequest) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.isValid");
        }
        if (bl = ((IHttpSession)httpSession).isValid()) {
            if (this.integrateWASSec) {
                this.checkSecurity((SessionData)httpSession, httpServletRequest);
            }
            if (this.crossoverCheck(httpServletRequest, httpSession.getId())) {
                Object[] objectArray = new Object[]{this.getAppName(), httpSession.getId(), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
                Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnRetrieve", (Object)objectArray);
            }
        }
        if (!bl) {
            ((IExtendedRequest)httpServletRequest).setSessionId(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.isValid returning " + bl));
        }
        return bl;
    }

    boolean crossoverCheck(String string) {
        return this.crossoverCheck(null, string);
    }

    boolean crossoverCheck(HttpServletRequest httpServletRequest, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"crossoverCheck");
        }
        if (debugSessionCrossover) {
            boolean bl = false;
            if (httpServletRequest != null) {
                bl = ((IExtendedRequest)httpServletRequest).getRunningCollaborators();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("collab:" + bl));
                }
            }
            if (!bl) {
                String string2 = (String)currentThreadSessionId.get();
                if (string2 == null) {
                    if (!this.crossoverUserThreadWarningIssued) {
                        Tr.warning((TraceComponent)tc, (String)"SessionContext.UserThreadDetected", (Object)this.getAppName());
                        this.crossoverUserThreadWarningIssued = true;
                    }
                } else if (!string2.equals("WAS-SYSTEM-THREAD") && !string2.equals(string)) {
                    return true;
                }
            }
        }
        return false;
    }

    void updateCurrentThreadSessionId(SessionData sessionData) {
        if (debugSessionCrossover) {
            String string = (String)currentThreadSessionId.get();
            if (string != null) {
                currentThreadSessionId.set((Object)sessionData.getId());
            } else if (sessionData.internalIsNew()) {
                sessionData.setCreatedOnUserThread(true);
            }
        }
    }

    private static boolean isSafe(String string) {
        for (int i = 0; i < unSecStrs.length; ++i) {
            if (string.indexOf(unSecStrs[i]) == -1) continue;
            return false;
        }
        return true;
    }

    void incrementActiveSessionCount(long l) {
        this.scPmiData.incActiveSessions(l);
    }

    void decrementActiveSessionCount() {
        this.scPmiData.decActiveSessions();
    }

    void bumpCreateCount() {
        this.scPmiData.incSessionsCreated();
    }

    void incInvalidatedByTimeout() {
        this.scPmiData.incInvalidatedByTimeout();
    }

    void incInvalidatedSessions(long l) {
        this.scPmiData.incInvalidatedSessions(l);
    }

    void incSessionGarbageCollected(long l) {
        this.scPmiData.incSessionGarbageCollected(System.currentTimeMillis());
    }

    static final boolean trackGCCount() {
        return trackGCCount;
    }

    public void addHttpSessionListener(HttpSessionListener httpSessionListener, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SesonContext.addHttpSessionListener");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, string);
        arrayList.add(1, (String)httpSessionListener);
        this.mHttpSessionListeners.add(arrayList);
        this.sessionListener = true;
        this.mIBMSessionListenerImplemented = this.isIBMSessionListenerImplemented();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SesonContext.addHttpSessionListener");
        }
    }

    public void addHttpSessionAttributeListener(HttpSessionAttributeListener httpSessionAttributeListener, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SesonContext.addHttpSessionAttributeListener", (Object)httpSessionAttributeListener);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, string);
        arrayList.add(1, (String)httpSessionAttributeListener);
        this.mHttpSessionAttributeListeners.add(arrayList);
        this.sessionAttributeListener = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SesonContext.addHttpSessionAttributeListener");
        }
    }

    void addHttpSessionAttributeListener(ArrayList arrayList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addHttpSessionAttributeListener:" + arrayList));
        }
        this.mHttpSessionAttributeListeners.addAll(arrayList);
        if (this.mHttpSessionAttributeListeners.size() > 0) {
            this.sessionAttributeListener = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addHttpSessionAttributeListener:" + arrayList));
        }
    }

    void addHttpSessionListener(ArrayList arrayList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addHttpSessionListener:" + arrayList));
        }
        this.mHttpSessionListeners.addAll(arrayList);
        if (this.mHttpSessionListeners.size() > 0) {
            this.sessionListener = true;
        }
        this.mIBMSessionListenerImplemented = this.isIBMSessionListenerImplemented();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addHttpSessionListener:" + arrayList));
        }
    }

    void setThreadContext() {
        IServletContext iServletContext = (IServletContext)this.mServletContext;
        try {
            iServletContext.startEnvSetup(true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.setThreadContext", (String)"3129", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
        }
    }

    void unsetThreadContext() {
        IServletContext iServletContext = (IServletContext)this.mServletContext;
        try {
            iServletContext.finishEnvSetup(true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.unsetThreadContext", (String)"3141", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
        }
    }

    public void sessionAttributeAddedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionAttributedAddedEvent:" + httpSessionBindingEvent));
        }
        ArrayList arrayList = this.getHttpSessionAttributeListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)arrayList2.get(1);
            if (httpSessionAttributeListener == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionAttributeListener + ".attributeAdded()"));
            }
            httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionAttributedAddedEvent:" + httpSessionBindingEvent));
        }
    }

    public void sessionAttributeReplacedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionAttributeReplacedEvent:" + httpSessionBindingEvent));
        }
        ArrayList arrayList = this.getHttpSessionAttributeListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)arrayList2.get(1);
            if (httpSessionAttributeListener == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionAttributeListener + ".attributeReplaced()"));
            }
            httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionAttributeReplacedEvent:" + httpSessionBindingEvent));
        }
    }

    public void sessionAttributeRemovedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionAttributeRemovedEvent:" + httpSessionBindingEvent));
        }
        ArrayList arrayList = this.getHttpSessionAttributeListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)arrayList2.get(1);
            if (httpSessionAttributeListener == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionAttributeListener + ".attributeRemoved()"));
            }
            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionAttributeRemovedEvent:" + httpSessionBindingEvent));
        }
    }

    public void sessionCreatedEvent(HttpSessionEvent httpSessionEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionCreatedEvent:" + httpSessionEvent));
        }
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionListener httpSessionListener = (HttpSessionListener)arrayList2.get(1);
            if (httpSessionListener == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionListener + ".sessionCreated()"));
            }
            httpSessionListener.sessionCreated(httpSessionEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionCreatedEvent:" + httpSessionEvent));
        }
    }

    public void sessionDestroyedEvent(HttpSessionEvent httpSessionEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionDestroyedEvent:" + httpSessionEvent));
        }
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionListener httpSessionListener = (HttpSessionListener)arrayList2.get(1);
            if (httpSessionListener == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionListener + ".sessionDestroyed()"));
            }
            httpSessionListener.sessionDestroyed(httpSessionEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionDestroyedEvent:" + httpSessionEvent));
        }
    }

    public int getSessionTimeOut() {
        return (int)this.getSessionInvalidationTime();
    }

    public boolean isSessionTimeoutSet() {
        try {
            return this.scAppParms.getSessionTimeout() != 0L;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.moreInit", (String)"2777", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
            return false;
        }
    }

    private void checkSecurity(SessionData sessionData, HttpServletRequest httpServletRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.checkSecurity");
        }
        String string = null;
        String string2 = sessionData.getUserName();
        if (this.securityEnabled) {
            string = this.getAuthenticatedUser();
        } else {
            string = httpServletRequest.getRemoteUser();
            if (string == null) {
                string = "anonymous";
            }
        }
        if (string != null && string2 != null && !string.equals(string2)) {
            if (string2.equals("anonymous")) {
                sessionData.setUser(string);
            } else if (!((IExtendedRequest)httpServletRequest).getRunningCollaborators()) {
                String[] stringArray = new String[]{string, string2};
                String string3 = "SESN0008E: SessionContext: a user authenticated as {0} has attempted to access a session owned by {1}(" + string + "," + string2 + ")";
                UnauthorizedSessionRequestException unauthorizedSessionRequestException = new UnauthorizedSessionRequestException(string3);
                throw unauthorizedSessionRequestException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.checkSecurity");
        }
    }

    public boolean getIntegrateWASSecurity() {
        return this.integrateWASSec;
    }

    boolean isUsingWebContainerSM() {
        return this.mParams.isUsingWebContainerSM();
    }

    public boolean isValid() {
        return this._refCount > 0;
    }

    synchronized void incrementRefCount() {
        ++this._refCount;
    }

    synchronized void decrementRefCount() {
        --this._refCount;
    }

    public void setProperties(Properties properties) {
        turnOffCacheId = HttpSessionSystemProperties.useCacheIdIfNecessary();
        turnOffCloneId = HttpSessionSystemProperties.useCloneIdIfNeccessary();
        useJCE = HttpSessionSystemProperties.isUseJCE();
        passivateAtWrite = HttpSessionSystemProperties.isPassivateAtWrite();
        passivateUsingCache = HttpSessionSystemProperties.isPassivateUsingCache();
        cloneSep = HttpSessionSystemProperties.getCloneSeperator();
        sessionIDLength = HttpSessionSystemProperties.getIdLength();
        idReuse = HttpSessionSystemProperties.isIdReuse();
        trackGCCount = HttpSessionSystemProperties.isTrackGC();
        noSwitchOver = HttpSessionSystemProperties.isDontSwitchOver();
        useBase32 = HttpSessionSystemProperties.getBase32Encoding();
        cloneId = EncodeCloneID.encodeString(this.mParams.getServerId());
        if (HttpSessionSystemProperties.getReaperPollInterval() > 0L) {
            this.mInvalidationCheckPollInterval = HttpSessionSystemProperties.getReaperPollInterval();
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            block68: {
                string2 = (String)enumeration.nextElement();
                string = (String)properties.get(string2);
                if (string2.equals("HttpSessionIdLength")) {
                    try {
                        sessionIDLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!firstTime) continue;
                        Tr.warning((TraceComponent)tc, (String)"SessionContext.invalidPropertyFound", (Object)new Object[]{string2, string});
                        continue;
                    }
                    if (sessionIDLength < 8 || sessionIDLength > 128) {
                        if (sessionIDLength < 8) {
                            sessionIDLength = 8;
                        }
                        if (sessionIDLength > 128) {
                            sessionIDLength = 128;
                        }
                        if (!firstTime) continue;
                        Tr.warning((TraceComponent)tc, (String)"SessionContext.valueOutOfRange", (Object)new Object[]{string2, string, new Integer(sessionIDLength)});
                        continue;
                    }
                } else if (string2.equals("SessionRewriteIdentifier")) {
                    sessUrlRewritePrefix = ";" + string + "=";
                } else if (string2.equals("HttpSessionCloneId")) {
                    cloneId = string;
                    cloneIdPropertySet = true;
                } else if (string2.equals("NoAdditionalSessionInfo") && string.compareToIgnoreCase("true") == 0) {
                    turnOffCacheId = true;
                    turnOffCloneId = true;
                } else {
                    if (string2.equals("SessionIdentifierMaxLength")) {
                        try {
                            this.maxSessionIdentifierLength = Integer.parseInt(string);
                            break block68;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!firstTime) continue;
                            Tr.warning((TraceComponent)tc, (String)"SessionContext.invalidPropertyFound", (Object)new Object[]{string2, string});
                            continue;
                        }
                    }
                    if (string2.equals("CloneSeperator")) {
                        cloneSep = string;
                    } else if (string2.equals("CloneSeparatorChange") && string.compareToIgnoreCase("true") == 0) {
                        cloneSep = "+";
                    } else {
                        if (string2.equals("HttpSessionReaperPollInterval")) {
                            try {
                                this.mInvalidationCheckPollInterval = new Long(string);
                                break block68;
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!firstTime) continue;
                                Tr.warning((TraceComponent)tc, (String)"SessionContext.invalidPropertyFound", (Object)new Object[]{string2, string});
                                continue;
                            }
                        }
                        if (string2.equals("NoAffinitySwitchBack")) {
                            noSwitchOver = Boolean.valueOf(string);
                        } else if (string2.equals("HttpSessionIdReuse")) {
                            idReuse = new Boolean(string);
                        } else if (string2.equals("UseOracleBLOB") && string.compareToIgnoreCase("true") == 0) {
                            useOracleBLOB = true;
                        } else if (string2.equals("DebugSessionCrossover") && string.compareToIgnoreCase("true") == 0) {
                            if (!debugSessionCrossover) {
                                debugSessionCrossover = true;
                                Tr.warning((TraceComponent)tc, (String)"SessionContext.DebugCrossoverEnabled");
                            }
                        } else if (string2.equals("HideSessionValues")) {
                            hideSessionValuesPropertySet = true;
                            if (string.compareToIgnoreCase("true") == 0) {
                                hideSessionValues = true;
                            }
                        } else if (string2.equals("DoRemoteInvalidations")) {
                            if (string.compareToIgnoreCase("false") == 0) {
                                doRemoteInvalidations = false;
                            }
                        } else if (string2.equals("OnlyCheckInCacheDuringPreInvoke")) {
                            if (string.compareToIgnoreCase("true") == 0) {
                                this.onlyCheckInCacheDuringPreInvoke = true;
                            }
                        } else if (string2.equals("ForceSessionInvalidationMultiple")) {
                            if (string != null) {
                                try {
                                    this.forceSessionInvalidationMultiple = new Integer(string);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"NumberFormatException in forceSessionInvalidationMultiple, using default");
                                    }
                                }
                            }
                        } else if (string2.equals("CheckCookiesOnDispatch")) {
                            if (string.compareToIgnoreCase("true") == 0) {
                                this.checkCookiesOnDispatch = true;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"checkCookiesOnDispatch set to true");
                                }
                            }
                        } else if (string2.equals("OptimizeCacheIdIncrements") && string.compareToIgnoreCase("true") == 0) {
                            this.optimizeCacheIdIncrements = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"optimizeCacheIdIncrements is turned on");
                            }
                        } else if (string2.equals("SIPCookieName")) {
                            if (string != null) {
                                this.sipSessionCookieName = string;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("SIPCookieName is " + this.sipSessionCookieName));
                            }
                        } else if (string2.equals("ForceSessionIdLengthCheck") && string.compareToIgnoreCase("true") == 0) {
                            this.forceSessionIdLengthCheck = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"forceSessionIdLengthCheck is turned on");
                            }
                        } else if (string2.equals("CloneSeparator") && string != null) {
                            if (string.length() == 1 && string.trim().length() == 1) {
                                cloneSep = string;
                                if (firstTime && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Property CloneSeparator is found " + cloneSep));
                                }
                            } else if (firstTime) {
                                Tr.warning((TraceComponent)tc, (String)("Property CloneSeparator should be exactly one char and it cannot be space. The current value of CloneSeparator specified is \"" + string + "\""));
                            }
                        }
                    }
                }
            }
            if (!firstTime) continue;
            Tr.info((TraceComponent)tc, (String)"SessionContext.propertyFound", (Object)new Object[]{string2, string});
        }
        firstTime = false;
    }

    static synchronized void removeAffinity(SessionData sessionData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.removeAffinity");
        }
        if (!is_zOS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.removeAffinity - return because not zOS");
            }
            return;
        }
        if (sessionData.isAffinityEstablished()) {
            String string = sessionData.getId();
            int n = 0;
            Integer n2 = (Integer)sessionIdsUsedMoreThanOnce.get(string);
            if (n2 != null) {
                int n3 = n2 - 1;
                if (n3 == 0) {
                    sessionIdsUsedMoreThanOnce.remove(string);
                    n = HTTPSessionAffinity.unregisterSession(zAffinityCloneId + string, pinSR);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:removeAffinity-count decremented to zero, unregister for id " + string + " returned rc " + n));
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:removeAffinity-decrement count for id " + string + " to " + n3));
                    }
                    sessionIdsUsedMoreThanOnce.put(string, new Integer(n3));
                }
            } else {
                n = HTTPSessionAffinity.unregisterSession(zAffinityCloneId + string, pinSR);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:removeAffinity-no count-unregister for id " + string + " returned rc " + n));
                }
            }
            if (n != 0) {
                Tr.error((TraceComponent)tc, (String)("SessionContext:removeAffinity-unregister for id " + string + " failed with rc " + n));
            }
            sessionData.setAffinityEstablished(false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.removeAffinity");
        }
    }

    static synchronized int establishAffinity(SessionData sessionData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.establishAffinity");
        }
        if (!is_zOS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.establishAffinity - return 0 because not zOS");
            }
            return 0;
        }
        int n = 0;
        if (!sessionData.isAffinityEstablished()) {
            String string = sessionData.getId();
            n = HTTPSessionAffinity.registerSession(zAffinityCloneId + string, pinSR);
            if (n == 8) {
                Integer n2 = (Integer)sessionIdsUsedMoreThanOnce.get(string);
                if (n2 != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:establishAffinity-increment count for id " + string + " to " + (n2 + 1)));
                    }
                    sessionIdsUsedMoreThanOnce.put(string, new Integer(n2 + 1));
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:establishAffinity-initialize count for id " + string + " to 2"));
                    }
                    sessionIdsUsedMoreThanOnce.put(string, new Integer(2));
                }
                n = 0;
            }
            if (n != 0) {
                Tr.error((TraceComponent)tc, (String)("SessionContext:establishAffinity-call to registerSession() for id " + string + " failed with return code " + n));
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:establishAffinity succeeded for id " + string));
                }
                sessionData.setAffinityEstablished(true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.establishAffinity returning " + n));
        }
        return n;
    }

    protected void joinHAMGroup(SessionMgrComponentImpl sessionMgrComponentImpl) {
    }

    void processDRSServerOnly(String string) {
    }

    public static void invalidateAll(String string, String string2, SessionData sessionData, boolean bl, boolean bl2) {
        SessionContext sessionContext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.invalidateAll for app " + string2 + " id " + string + " goRemote " + bl + " fromRemote " + bl2));
        }
        boolean bl3 = true;
        if (string.startsWith(timeoutSeparator)) {
            bl3 = false;
            string = string.substring(1);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.invalidateAll - setting backendUpdate to false and removed flag - sessionId: " + string));
            }
        }
        if (SessionContextRegistry.getDrsServerOnlyContext() != null && bl2) {
            SessionContextRegistry.getDrsServerOnlyContext().processDRSServerOnly(string);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.invalidateAll processed on DRS SERVER for " + string));
            }
        }
        if (sessionData != null && !sessionData.isInvalInProgress()) {
            sessionData.invalidate();
        }
        Enumeration enumeration = SessionContextRegistry.getScrSessionContexts();
        while (enumeration.hasMoreElements()) {
            sessionContext = (SessionContext)enumeration.nextElement();
            if (bl2) {
                sessionContext.remoteInvalidate(string, bl3);
                continue;
            }
            if (sessionData.mManager == sessionContext) continue;
            sessionContext.invalidate(string);
        }
        if (bl && (sessionContext = SessionMgrComponentImpl.getRemoteInvalHAMGroup()) != null) {
            byte[] byArray;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext.invalidateAll - about to sendMessage for remote invalidation for " + string));
            }
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            try {
                sessionContext.sendMessage(MsgQoS.NORMAL_NOSELF, byArray);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.invalidateAll for app " + string2 + " id " + string + " goRemote " + bl + " fromRemote " + bl2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String string) {
        SessionData sessionData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.invalidate for app " + this.getAppName() + " id " + string));
        }
        if ((sessionData = this.findSession(defaultCacheId + string)) != null) {
            try {
                this.setThreadContext();
                sessionData.invalidate();
            }
            finally {
                this.unsetThreadContext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.invalidate for app " + this.getAppName() + " id " + string));
        }
    }

    public void remoteInvalidate(String string, boolean bl) {
        SessionData sessionData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.remoteInvalidate for app " + this.getAppName() + " id " + string));
        }
        if ((sessionData = (SessionData)this.mSessions.get(string)) != null) {
            sessionData.setMaxInactiveInterval(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSessionById(String string) {
        SessionData sessionData;
        block13: {
            sessionData = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("SessionContext.getHttpSessionById for app " + this.getAppName() + " id " + string));
            }
            this.setThreadContext();
            try {
                sessionData = this.findSession(defaultCacheId + string);
                if (sessionData == null) break block13;
                SessionData sessionData2 = sessionData;
                synchronized (sessionData2) {
                    block14: {
                        if (sessionData.isValid()) break block14;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("SessionContext.getHttpSessionById: session is invalid;  id - " + string + " session - " + sessionData));
                        }
                        HttpSession httpSession = null;
                        return httpSession;
                    }
                    sessionData.initSession(this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        String string2 = "SessionContext.getHttpSessionById: found the session for the id " + string;
                    }
                    sessionData.notifyActivateListeners();
                }
            }
            finally {
                this.unsetThreadContext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.getHttpSessionById returning" + sessionData));
        }
        if (sessionData != null) {
            return (HttpSession)sessionData.getFacade();
        }
        return null;
    }

    public boolean isSIPApplication() {
        return this.isSIPApplication;
    }

    public void setSIPApplication(boolean bl) {
        this.isSIPApplication = bl;
    }

    protected void setSIPCookieIfApplicable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionData sessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setSIPCookieIfApplicable " + this.isSIPApplication));
        }
        if (this.isSIPApplication && this.isUsingCookies()) {
            IBMApplicationSessionExt iBMApplicationSessionExt;
            String string = null;
            byte[] byArray = ((IExtendedRequest)httpServletRequest).getCookieValueAsBytes(this.sipSessionCookieName);
            if (byArray != null) {
                string = new String(byArray);
            }
            if ((iBMApplicationSessionExt = (IBMApplicationSessionExt)sessionData.getIBMApplicationSession(true, string)) != null && string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"About to set sip cookie");
                }
                this.setSIPCookie((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, iBMApplicationSessionExt.getLogicalServerName());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Finished setting sip cookie");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSIPCookieIfApplicable");
        }
    }

    private void detectIfSIPApp() {
        URL uRL;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("detectIfSIPApp " + this.getAppName()));
            }
            uRL = null;
            if (System.getSecurityManager() != null) {
                uRL = (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        URL uRL;
                        block5: {
                            uRL = null;
                            try {
                                ServletContext servletContext = SessionContext.this.scAppParms.getServletContext();
                                uRL = servletContext.getResource("/WEB-INF/sip.xml");
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (BaseSessionContext.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)BaseSessionContext.tc, (String)"detectIfSIPApp Failed to get sip.xml URL.  This must not be a SIP application.");
                                }
                            }
                            catch (SessionApplicationParameterException sessionApplicationParameterException) {
                                if (!BaseSessionContext.tc.isDebugEnabled()) break block5;
                                Tr.debug((TraceComponent)BaseSessionContext.tc, (String)"Caught SessionApplicationParameterException");
                            }
                        }
                        if (BaseSessionContext.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)BaseSessionContext.tc, (String)("detectIfSIPApp secured " + uRL));
                        }
                        return uRL;
                    }
                });
            } else {
                try {
                    ServletContext servletContext = this.scAppParms.getServletContext();
                    uRL = servletContext.getResource("/WEB-INF/sip.xml");
                }
                catch (MalformedURLException malformedURLException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"detectIfSIPApp Failed to get sip.xml URL.  This must not be a SIP application.");
                    }
                }
                catch (SessionApplicationParameterException sessionApplicationParameterException) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)"Caught SessionApplicationParameterException");
                }
            }
        }
        if (uRL != null) {
            this.isSIPApplication = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("detectIfSIPApp " + uRL));
        }
    }

    public void setSIPCookie(ServletRequest servletRequest, ServletResponse servletResponse, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSIPCookie");
        }
        if (!this.isUsingCookies()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Cookies not enabled.");
            }
            return;
        }
        Cookie cookie = new Cookie(this.sipSessionCookieName, string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting cookie: " + this.sipSessionCookieName));
        }
        if (servletResponse.isCommitted()) {
            boolean bl = new Boolean((String)servletRequest.getAttribute("com.ibm.ws.session.cookie.already.set"));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("request.getAttribute(com.ibm.ws.session.cookie.already.set): " + servletRequest.getAttribute("com.ibm.ws.session.cookie.already.set")));
            }
            if (!bl) {
                Tr.warning((TraceComponent)tc, (String)"SessionContext.responseAlreadyCommitted");
                servletRequest.setAttribute("com.ibm.ws.session.cookie.already.set", (Object)"true");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set request attribute com.ibm.ws.session.cookie.already.set to true");
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"responseAlreadyCommitted already logged");
                }
                return;
            }
        }
        ((IExtendedResponse)servletResponse).addSessionCookie(cookie);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSIPCookie");
        }
    }

    private String resetCacheIdHigherAsNeeded(String string, HttpServletRequest httpServletRequest, String string2) {
        int n;
        String string3;
        int n2;
        String string4;
        String string5;
        String string6 = string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resetCacheIdHigherAsNeeded " + string6));
        }
        if ((string5 = (String)httpServletRequest.getAttribute("com.ibm.session.setcookie.values")) != null && this.isPresentInRecentlyInvalidatedList(string4 = this.getSessionIDOnly(string5)) && string4.equals(this.getSessionIDOnly(string)) && (n2 = new Integer(string3 = this.getCacheIDOnly(string5)).intValue()) > (n = new Integer(string2).intValue())) {
            string6 = string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resetCacheIdHigherAsNeeded " + string6));
        }
        return string6;
    }

    protected String getCacheIDOnly(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getCacheIDOnly ");
        }
        String string2 = string;
        string2 = string.substring(0, this.cacheIdLength);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.getCacheIDOnly " + string2));
        }
        return string2;
    }

    boolean isPresentInRecentlyInvalidatedList(Object object) {
        return false;
    }

    private String checkSessionIdIsRightLength(String string) {
        String string2 = string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkSessionIdIsRightLength " + string));
        }
        if (string == null || !this.forceSessionIdLengthCheck) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkSessionIdIsRightLength no check");
            }
            return string2;
        }
        if (string.length() != sessionIDLength) {
            Tr.warning((TraceComponent)tc, (String)("SessionContext.checkSessionIdIsRightLength: Incoming id " + string + "(" + string.length() + ")" + " failed length check against " + sessionIDLength + ". Nulling id"));
            string2 = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkSessionIdIsRightLength " + string2));
        }
        return string2;
    }

    private boolean colonInSessionIdCheck(String string) {
        int n = string.indexOf(cloneSeparator);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("colonInSessionIdCheck " + string));
        }
        if (n < this.cacheIdLength) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.colonInSessionIdCheck");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.colonInSessionIdCheck");
        }
        return true;
    }

    static {
        BASE32 = 0;
        BASE64 = 1;
        pinSR = true;
        sBitChars = new char[]{'G', '9', 'U', 'i', 'b', 'w', '-', '8', '6', 'z', 'u', 'p', 'J', 'R', 'S', 'h', 'K', '5', 'n', 'c', '4', 'C', 't', 'I', 'W', '7', 'F', 'e', 'M', 'g', 'q', '2', '3', 'V', 'Z', 'k', 'O', 'D', 'a', 'v', 'y', 'Y', 'P', 'X', 'E', 'N', '1', 'f', 'l', 'B', '0', 'L', 's', 'o', 'A', 'T', 'd', 'x', 'm', 'r', 'Q', '_', 'j', 'H'};
        sSecondByteMasks = new int[]{0, 1, 3, 7, 15, 31, 63};
        cloneId = null;
        cloneIdPropertySet = false;
        zAffinityCloneId = null;
        cloneIdLength = 0;
        sessionIDFactory = null;
        cloneSeparator = (char)58;
        useJCE = true;
        passivateUsingCache = true;
        passivateAtWrite = false;
        sessUrlRewritePrefix = ";jsessionid=";
        sessionIDLength = 23;
        trackGCCount = false;
        idReuse = false;
        noSwitchOver = false;
        useOracleBLOB = false;
        turnOffCacheId = false;
        turnOffCloneId = false;
        defaultCacheId = "0000";
        useBase32 = false;
        is_zOS = false;
        currentThreadSessionId = null;
        debugSessionCrossover = false;
        firstTime = true;
        hideSessionValuesPropertySet = false;
        hideSessionValues = false;
        doRemoteInvalidations = true;
        cloneSep = null;
        unSecStrs = new String[]{"<", ">", "&", "!"};
    }
}

