/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.webcontainer.httpsession.BaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.MemorySessionContext;
import com.ibm.ws.webcontainer.httpsession.SMSessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistryInitializationException;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import com.ibm.ws.webcontainer.httpsession.WebAppSessionSupport;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.util.SimpleHashtable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class SessionContextRegistry {
    private static SimpleHashtable scrSessionContexts = new SimpleHashtable(1);
    private static HashMap scrDRSInstances = new HashMap();
    private static boolean initialized = false;
    private static SessionContext drsServerOnlyContext = null;
    private static boolean _globalSessionContext = false;
    public static final String drsInstPrefix = "HttpSessionCache";

    public static synchronized void registerDRSInstance(String string, Object object) {
        scrDRSInstances.put(string, object);
    }

    public static Object getServerDRSInstance() {
        return scrDRSInstances.get(drsInstPrefix);
    }

    static void setupDRSServerOnlyContext() {
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.webcontainer.httpsession.DRSSessionContext");
            String string = drsInstPrefix;
            Object v = scrDRSInstances.get(string);
            Class[] classArray = new Class[]{String.class, Object.class};
            Object[] objectArray = new Object[]{string, v};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            drsServerOnlyContext = (SessionContext)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContext.exception", (Object)exception);
        }
    }

    static SessionContext getDrsServerOnlyContext() {
        return drsServerOnlyContext;
    }

    private SessionContextRegistry() {
    }

    static SMSessionContextParameters initSessionContextParametersFromWCCM(SessionManager sessionManager) {
        SMSessionContextParameters sMSessionContextParameters = null;
        sMSessionContextParameters = new SMSessionContextParameters();
        sMSessionContextParameters.init(sessionManager);
        return sMSessionContextParameters;
    }

    private static synchronized IHttpSessionContext createSessionContext(String string, boolean bl, int n, boolean bl2, ArrayList arrayList, ArrayList arrayList2, ServletContext servletContext, WebAppSessionSupport webAppSessionSupport, SessionContextParameters sessionContextParameters, DRSSettings dRSSettings, String string2, boolean bl3, SessionMgrComponentImpl sessionMgrComponentImpl) throws Throwable {
        try {
            IHttpSessionContext iHttpSessionContext = (IHttpSessionContext)scrSessionContexts.get(string);
            if (iHttpSessionContext != null) {
                return iHttpSessionContext;
            }
            if (sessionMgrComponentImpl.is_zOS()) {
                if (!sessionMgrComponentImpl.isServerIdInitialized()) {
                    Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry: Error: server id is not initialized.");
                    throw new SessionContextRegistryInitializationException("ServerID must be set to valid value and not -1");
                }
                sessionContextParameters.setServerId(sessionMgrComponentImpl.getServerId());
                if (!sessionMgrComponentImpl.isCloneIdInitialized()) {
                    Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry: Error: clone id is not initialized.");
                    throw new SessionContextRegistryInitializationException("CloneID must be set to valid value and not -1");
                }
                sessionContextParameters.setCloneId(sessionMgrComponentImpl.getCloneId());
                if (sessionMgrComponentImpl.isUUIDInitialized()) {
                    sessionContextParameters.set390UUID(sessionMgrComponentImpl.getUUID());
                } else {
                    Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry: Error: unique id is not initialized.");
                    throw new SessionContextRegistryInitializationException("UUID must be set to valid value and not -1");
                }
            }
            SessionApplicationParameters sessionApplicationParameters = new SessionApplicationParameters(string, bl, n, bl2, servletContext, webAppSessionSupport, string2);
            SessionContext sessionContext = null;
            if (sessionContextParameters.usingMemory()) {
                sessionContext = new MemorySessionContext(sessionContextParameters, sessionApplicationParameters);
            } else if (sessionContextParameters.usingDatabase()) {
                Class<?> clazz = Class.forName("com.ibm.ws.webcontainer.httpsession.DatabaseSessionContext");
                Class[] classArray = new Class[]{SessionContextParameters.class, sessionApplicationParameters.getClass()};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                Object[] objectArray = new Object[]{sessionContextParameters, sessionApplicationParameters};
                sessionContext = (SessionContext)constructor.newInstance(objectArray);
            } else if (sessionContextParameters.isUsingMemtoMem()) {
                boolean bl4 = false;
                Object var17_20 = null;
                Object var18_22 = null;
                Object var19_24 = null;
                String string3 = null;
                Class<?> clazz = Class.forName("com.ibm.ws.webcontainer.httpsession.DRSSessionContext");
                if (!bl3) {
                    string3 = drsInstPrefix + string;
                    Class[] classArray = new Class[]{SessionContextParameters.class, sessionApplicationParameters.getClass(), String.class, DRSSettings.class, SessionMgrComponentImpl.class};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{sessionContextParameters, sessionApplicationParameters, string3, dRSSettings, sessionMgrComponentImpl};
                    sessionContext = (SessionContext)constructor.newInstance(objectArray);
                } else {
                    string3 = drsInstPrefix;
                    Object v = scrDRSInstances.get(string3);
                    Class[] classArray = new Class[]{SessionContextParameters.class, sessionApplicationParameters.getClass(), String.class, Object.class};
                    Object[] objectArray = new Object[]{sessionContextParameters, sessionApplicationParameters, string3, v};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    sessionContext = (SessionContext)constructor.newInstance(objectArray);
                }
                sessionContext.joinHAMGroup(sessionMgrComponentImpl);
            }
            sessionContext.init();
            sessionContext.addHttpSessionListener(arrayList);
            sessionContext.addHttpSessionAttributeListener(arrayList2);
            scrSessionContexts.put(string, sessionContext);
            return sessionContext;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContextRegistry.createSessionContext", (String)"198", (Object)("Error creating SessionContext for appname :" + string));
            Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry.CTXErr");
            Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContext.exception", (Object)throwable);
            throw throwable;
        }
    }

    static String getTrackerData() {
        Enumeration enumeration = scrSessionContexts.elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<center><h3>Session Tracking Internals</h3></center><UL>\n");
        while (enumeration.hasMoreElements()) {
            SessionContext sessionContext = (SessionContext)enumeration.nextElement();
            String string = sessionContext.toHTML();
            stringBuffer.append(string).append("</UL>\n");
        }
        return stringBuffer.toString();
    }

    static String getTrackerData2() {
        Enumeration enumeration = scrSessionContexts.elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<center><h3>Session Tracking Internals</h3></center><UL>\n");
        while (enumeration.hasMoreElements()) {
            SessionContext sessionContext = (SessionContext)enumeration.nextElement();
            String string = sessionContext.toHTML2();
            stringBuffer.append(string).append("</UL>\n");
        }
        return stringBuffer.toString();
    }

    static synchronized void remove(String string) {
        scrSessionContexts.remove(string);
    }

    static Enumeration getScrSessionContexts() {
        return scrSessionContexts.elements();
    }

    static SessionContext getSessionContextByName(String string) {
        return (SessionContext)scrSessionContexts.get(string);
    }

    static synchronized void stop() {
    }

    static synchronized void start() {
        if (BaseSessionContext.tc == null) {
            BaseSessionContext.setUpLogAndTrace();
        }
    }

    static IHttpSessionContext getSessionContext(DeployedModule deployedModule, ServletContext servletContext, String string, SessionMgrComponentImpl sessionMgrComponentImpl, ArrayList[] arrayListArray) throws Throwable {
        String[] stringArray;
        if (!initialized) {
            SessionContextRegistry.initialize(sessionMgrComponentImpl);
        }
        boolean bl = true;
        ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
        WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
        String string2 = webModule.getContextRoot();
        if (sessionMgrComponentImpl.is_zOS() && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        String string3 = null;
        boolean bl2 = false;
        if (((ApplicationExtension)deployedModule.getDeployedApplication().getExtension()).isSharedSessionContext()) {
            string3 = string + SessionContextRegistry.getApplicationName(deployedModule);
            bl2 = true;
        } else {
            string3 = string + string2;
        }
        SessionContextParameters sessionContextParameters = null;
        WebAppSessionSupport webAppSessionSupport = new WebAppSessionSupport(deployedModule.getClassLoader());
        SessionManager sessionManager = SessionContextRegistry.getSessionMgrConfig(deployedModule);
        DRSSettings dRSSettings = null;
        if (sessionManager == null) {
            sessionContextParameters = sessionMgrComponentImpl.getSessionManagerConfig();
            dRSSettings = sessionMgrComponentImpl.getWebcontainerDRSSettings();
        } else {
            bl = false;
            sessionContextParameters = SessionContextRegistry.initSessionContextParametersFromWCCM(sessionManager);
            sessionContextParameters.setUsingWebContainerSM(bl);
            dRSSettings = sessionManager.getSessionDRSPersistence();
        }
        if (_globalSessionContext && bl) {
            string3 = "GLOBAL_HTTP_SESSION_CONTEXT";
            bl2 = true;
        } else if (_globalSessionContext) {
            stringArray = new String[]{string3};
            Tr.info((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry.SessionNotGlobalForWebApp", (Object)stringArray);
        }
        stringArray = arrayListArray[0];
        ArrayList arrayList = arrayListArray[1];
        String string4 = SessionContextRegistry.getJ2EEName(deployedModule);
        ArrayList arrayList2 = SessionContextRegistry.addJ2eeNameToListeners((ArrayList)stringArray, string4);
        ArrayList arrayList3 = SessionContextRegistry.addJ2eeNameToListeners(arrayList, string4);
        IHttpSessionContext iHttpSessionContext = (IHttpSessionContext)scrSessionContexts.get(string3);
        if (iHttpSessionContext != null) {
            SessionContext sessionContext = (SessionContext)iHttpSessionContext;
            sessionContext.addHttpSessionListener(arrayList2);
            sessionContext.addHttpSessionAttributeListener(arrayList3);
            if (bl2) {
                sessionContext.incrementRefCount();
            }
            return iHttpSessionContext;
        }
        return SessionContextRegistry.createSessionContext(string3, SessionContextRegistry.isSetSessionTimeout(deployedModule), SessionContextRegistry.getSessionTimeOut(deployedModule), SessionContextRegistry.isDistributable(deployedModule), arrayList2, arrayList3, servletContext, webAppSessionSupport, sessionContextParameters, dRSSettings, SessionContextRegistry.getJ2EEName(deployedModule), bl, sessionMgrComponentImpl);
    }

    private static ArrayList addJ2eeNameToListeners(ArrayList arrayList, String string) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(0, string);
            arrayList3.add(1, (String)arrayList.get(i));
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }

    private static String getApplicationName(DeployedModule deployedModule) {
        String string = deployedModule.getDeployedApplication().getName();
        if (string != null) {
            return string;
        }
        try {
            return ((Application)deployedModule.getDeployedApplication().getDeploymentDescriptor()).getDisplayName();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.SessionContextRegistry.getApplicationName", (String)"925", null);
            return null;
        }
    }

    private static SessionManager getSessionMgrConfig(DeployedModule deployedModule) {
        WebModuleConfig webModuleConfig = (WebModuleConfig)deployedModule.getServerConfiguration();
        if (webModuleConfig != null && webModuleConfig.getSessionManagement() != null && webModuleConfig.getSessionManagement().isEnable()) {
            return webModuleConfig.getSessionManagement();
        }
        webModuleConfig = (WebModuleConfig)deployedModule.getClusterConfiguration();
        if (webModuleConfig != null && webModuleConfig.getSessionManagement() != null && webModuleConfig.getSessionManagement().isEnable()) {
            return webModuleConfig.getSessionManagement();
        }
        if (deployedModule.getDeployedApplication().getServerConfiguration() != null && deployedModule.getDeployedApplication().getServerConfiguration().getSessionManagement() != null && deployedModule.getDeployedApplication().getServerConfiguration().getSessionManagement().isEnable()) {
            return deployedModule.getDeployedApplication().getServerConfiguration().getSessionManagement();
        }
        if (deployedModule.getDeployedApplication().getClusterConfiguration() != null && deployedModule.getDeployedApplication().getClusterConfiguration().getSessionManagement() != null && deployedModule.getDeployedApplication().getClusterConfiguration().getSessionManagement().isEnable()) {
            return deployedModule.getDeployedApplication().getClusterConfiguration().getSessionManagement();
        }
        return null;
    }

    private static boolean isSetSessionTimeout(DeployedModule deployedModule) {
        WebApp webApp = (WebApp)deployedModule.getDeploymentDescriptor();
        return webApp.getSessionConfig() == null ? false : webApp.getSessionConfig().isSetSessionTimeout();
    }

    private static int getSessionTimeOut(DeployedModule deployedModule) {
        WebApp webApp = (WebApp)deployedModule.getDeploymentDescriptor();
        return webApp.getSessionConfig() == null ? 0 : webApp.getSessionConfig().getSessionTimeout();
    }

    private static boolean isDistributable(DeployedModule deployedModule) {
        WebApp webApp = (WebApp)deployedModule.getDeploymentDescriptor();
        return webApp.isDistributable();
    }

    private static String getJ2EEName(DeployedModule deployedModule) {
        String string = deployedModule.getDeployedApplication().getMetaData().getName();
        String string2 = deployedModule.getMetaData().getName();
        return string + "#" + string2;
    }

    private static synchronized void initialize(SessionMgrComponentImpl sessionMgrComponentImpl) {
        if (initialized) {
            return;
        }
        scrSessionContexts = new SimpleHashtable();
        String string = sessionMgrComponentImpl.getWebContainerProperties().getProperty("Servlet21SessionCompatibility", "false");
        _globalSessionContext = new Boolean(string);
        if (_globalSessionContext) {
            Tr.info((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry.globalSessionsEnabled");
            SessionContextParameters sessionContextParameters = sessionMgrComponentImpl.getSessionManagerConfig();
            try {
                if (sessionContextParameters.getEnableTimeBasedWrite()) {
                    Tr.warning((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry.globalSessionTBWWarning");
                }
                if (sessionContextParameters.isUsingMemtoMem()) {
                    Tr.warning((TraceComponent)SessionContext.tc, (String)"SessionContextRegistry.globalSessionM2MWarning");
                }
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)SessionContext.tc, (String)"SessionContext.exception", (Object)exception);
            }
        }
        initialized = true;
    }

    public static HttpSession getHttpSessionById(String string, String string2, String string3) {
        String string4;
        if (SessionContext.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)("SessionContextRegistry.getHttpSessionById - virtualHost " + string + " contextRoot " + string2 + " sessionId " + string3));
        }
        HttpSession httpSession = null;
        SessionContext sessionContext = SessionContextRegistry.getSessionContextByName(string + string2);
        if (sessionContext == null) {
            string4 = string2.startsWith("/") ? string2.substring(1) : "/" + string2;
            if (SessionContext.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SessionContext.tc, (String)("SessionContextRegistry.getHttpSessionById - newContextRoot " + string4));
            }
            sessionContext = SessionContextRegistry.getSessionContextByName(string + string4);
        }
        if (sessionContext != null) {
            httpSession = sessionContext.getHttpSessionById(string3);
        }
        if (SessionContext.tc.isEntryEnabled()) {
            string4 = httpSession == null ? "null" : "non-null";
            Tr.exit((TraceComponent)SessionContext.tc, (String)("SessionContextRegistry.getHttpSessionById returning " + string4));
        }
        return httpSession;
    }
}

