/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SessionHashSet
extends AbstractSet {
    Object[] keys;
    private static SessionEmptyHashIterator sessionEmptyHashIterator = new SessionEmptyHashIterator();

    public SessionHashSet(Object[] objectArray) {
        this.keys = objectArray;
    }

    public Iterator iterator() {
        return this.getSessionHashIterator();
    }

    public int size() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.length;
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    private Iterator getSessionHashIterator() {
        if (this.size() == 0) {
            return sessionEmptyHashIterator;
        }
        return new SessionHashIterator();
    }

    private class SessionHashIterator
    implements Iterator {
        int current = 0;
        int end;

        SessionHashIterator() {
            this.end = SessionHashSet.this.keys.length;
        }

        public boolean hasNext() {
            return this.current < this.end;
        }

        public Object next() {
            if (this.current >= this.end) {
                throw new NoSuchElementException();
            }
            Object object = SessionHashSet.this.keys[this.current];
            ++this.current;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SessionEmptyHashIterator
    implements Iterator {
        SessionEmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

