/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionInspectServlet
extends HttpServlet {
    private static final long serialVersionUID = -4640044864660321141L;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpSession httpSession = httpServletRequest.getSession();
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML><BODY>");
        printWriter.println("<b>Session object details:</b>");
        printWriter.println(" <br>Creation time :" + new Date(httpSession.getCreationTime()));
        printWriter.println(" <br>Max inactive time :" + httpSession.getMaxInactiveInterval());
        Enumeration enumeration = httpSession.getAttributeNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, SerializationErrorDesc> hashMap = new HashMap<String, SerializationErrorDesc>();
        HashMap hashMap2 = new HashMap();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = httpSession.getAttribute(string);
                if (object instanceof Serializable) {
                    SerializationErrorDesc serializationErrorDesc = this.verifySerialization(string, object, hashMap2);
                    arrayList2.add(string);
                    if (serializationErrorDesc == null) continue;
                    hashMap.put(string, serializationErrorDesc);
                    continue;
                }
                arrayList.add(string);
            }
            this.displayContent(printWriter, arrayList, arrayList2, hashMap, hashMap2);
        } else {
            printWriter.println("<br><br>Currently there are no attributes present in session");
        }
        printWriter.println("</BODY></HTML>");
    }

    void displayContent(PrintWriter printWriter, ArrayList arrayList, ArrayList arrayList2, HashMap hashMap, HashMap hashMap2) {
        String string;
        printWriter.println("<br><br><b> Non Serializable attributes in session (attribute names): </b>");
        Iterator<Object> iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            printWriter.println("<br>   " + ++n + ") " + string2);
        }
        printWriter.println("<br><br><b>Serializable attributes in session (attribute names and their sizes in bytes):</b> ");
        n = 0;
        iterator = arrayList2.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            ++n;
            string = (String)iterator.next();
            if (hashMap.containsKey(string)) {
                printWriter.println("<br>" + n + ") " + string + "<A HREF=\"#" + string + "\"><font COLOR=\"#0000FF\">(Error serializing/deserializing the object, see below for details)</font></A>");
                continue;
            }
            long l2 = (Long)hashMap2.get(string);
            printWriter.println("<br> " + n + ") " + string + "----------------" + l2);
            l += l2;
        }
        if (l != 0L) {
            printWriter.println("<br> Total Size of all serializable attributes = " + l);
        }
        if (hashMap.size() > 0) {
            printWriter.println("<br><br><br><b>Errors serializing/deserializing attributes:</b>");
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                printWriter.println("<br><b><A NAME=\"" + string + "\">Attribute name= " + string + "</A></b>");
                SerializationErrorDesc serializationErrorDesc = (SerializationErrorDesc)hashMap.get(string);
                printWriter.println("<br>" + serializationErrorDesc.message + "</br>");
                serializationErrorDesc.th.printStackTrace(printWriter);
            }
        } else {
            printWriter.println("<br><br><b>No errors serializing/deserializing attributes currently present in session</b>");
        }
    }

    public SerializationErrorDesc verifySerialization(String string, Object object, HashMap hashMap) {
        Closeable closeable;
        Closeable closeable2;
        byte[] byArray = null;
        try {
            closeable2 = null;
            closeable = null;
            closeable = new ByteArrayOutputStream();
            closeable2 = new ObjectOutputStream((OutputStream)closeable);
            closeable2.writeObject(object);
            closeable2.flush();
            byArray = closeable.toByteArray();
            hashMap.put(string, new Long(byArray.length));
        }
        catch (Throwable throwable) {
            return new SerializationErrorDesc(throwable, string, "Error serializing the attribute:");
        }
        try {
            closeable2 = new ByteArrayInputStream(byArray);
            closeable = new BufferedInputStream((InputStream)closeable2);
            MyObjectInputStream myObjectInputStream = new MyObjectInputStream(Thread.currentThread().getContextClassLoader(), (InputStream)closeable);
            Object object2 = myObjectInputStream.readObject();
        }
        catch (Throwable throwable) {
            return new SerializationErrorDesc(throwable, string, "Error de-serializing the attribute:");
        }
        return null;
    }

    class SerializationErrorDesc {
        Throwable th = null;
        String attr = null;
        String message = null;

        SerializationErrorDesc(Throwable throwable, String string, String string2) {
            this.th = throwable;
            this.attr = string;
            this.message = string2;
        }
    }

    class MyObjectInputStream
    extends ObjectInputStream {
        ClassLoader cl;

        MyObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException {
            super(inputStream);
            this.cl = null;
            this.cl = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(objectStreamClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.cl.loadClass(objectStreamClass.getName());
            }
        }
    }
}

